// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "FolderChangeObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

using namespace std::literals;

namespace graphql::mapi {
namespace object {

FolderChange::FolderChange(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object { pimpl->getTypeNames(), pimpl->getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

void FolderChange::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void FolderChange::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

} // namespace object

void AddFolderChangeDetails(const std::shared_ptr<schema::UnionType>& typeFolderChange, const std::shared_ptr<schema::Schema>& schema)
{
	typeFolderChange->AddPossibleTypes({
		schema->LookupType(R"gql(FolderAdded)gql"sv),
		schema->LookupType(R"gql(FolderUpdated)gql"sv),
		schema->LookupType(R"gql(FolderRemoved)gql"sv),
		schema->LookupType(R"gql(FoldersReloaded)gql"sv)
	});
}

} // namespace graphql::mapi
