// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "MAPIObjects.h"

#include "graphqlservice/introspection/Introspection.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

Item::Item()
	: service::Object({
		"Attachment",
		"Item"
	}, {
		{ R"gql(cc)gql"sv, [this](service::ResolverParams&& params) { return resolveCc(std::move(params)); } },
		{ R"gql(id)gql"sv, [this](service::ResolverParams&& params) { return resolveId(std::move(params)); } },
		{ R"gql(to)gql"sv, [this](service::ResolverParams&& params) { return resolveTo(std::move(params)); } },
		{ R"gql(body)gql"sv, [this](service::ResolverParams&& params) { return resolveBody(std::move(params)); } },
		{ R"gql(read)gql"sv, [this](service::ResolverParams&& params) { return resolveRead(std::move(params)); } },
		{ R"gql(sender)gql"sv, [this](service::ResolverParams&& params) { return resolveSender(std::move(params)); } },
		{ R"gql(columns)gql"sv, [this](service::ResolverParams&& params) { return resolveColumns(std::move(params)); } },
		{ R"gql(preview)gql"sv, [this](service::ResolverParams&& params) { return resolvePreview(std::move(params)); } },
		{ R"gql(subject)gql"sv, [this](service::ResolverParams&& params) { return resolveSubject(std::move(params)); } },
		{ R"gql(modified)gql"sv, [this](service::ResolverParams&& params) { return resolveModified(std::move(params)); } },
		{ R"gql(received)gql"sv, [this](service::ResolverParams&& params) { return resolveReceived(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } },
		{ R"gql(attachments)gql"sv, [this](service::ResolverParams&& params) { return resolveAttachments(std::move(params)); } },
		{ R"gql(conversation)gql"sv, [this](service::ResolverParams&& params) { return resolveConversation(std::move(params)); } },
		{ R"gql(parentFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveParentFolder(std::move(params)); } }
	})
{
}

std::future<service::ResolverResult> Item::resolveId(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getId(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::IdType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveParentFolder(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getParentFolder(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<Folder>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveConversation(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getConversation(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<Conversation>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveSubject(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getSubject(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::StringType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveSender(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getSender(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::StringType>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveTo(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getTo(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::StringType>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveCc(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getCc(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::StringType>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveBody(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getBody(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::Value>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveRead(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getRead(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::BooleanType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveReceived(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getReceived(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::Value>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveModified(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getModified(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::Value>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolvePreview(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getPreview(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::StringType>::convert<service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveColumns(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getColumns(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<Property>::convert<service::TypeModifier::List, service::TypeModifier::Nullable>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolveAttachments(service::ResolverParams&& params)
{
	auto argIds = service::ModifiedArgument<response::IdType>::require<service::TypeModifier::Nullable, service::TypeModifier::List>("ids", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getAttachments(service::FieldParams(std::move(params), std::move(directives)), std::move(argIds));
	resolverLock.unlock();

	return service::ModifiedResult<service::Object>::convert<service::TypeModifier::List>(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Item::resolve_typename(service::ResolverParams&& params)
{
	return service::ModifiedResult<response::StringType>::convert(response::StringType{ R"gql(Item)gql" }, std::move(params));
}

} // namespace object

void AddItemDetails(std::shared_ptr<schema::ObjectType> typeItem, const std::shared_ptr<schema::Schema>& schema)
{
	typeItem->AddFields({
		schema::Field::Make(R"gql(id)gql"sv, R"md(ID of this item)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ID"))),
		schema::Field::Make(R"gql(parentFolder)gql"sv, R"md(Parent folder which contains this item)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Folder"))),
		schema::Field::Make(R"gql(conversation)gql"sv, R"md(Optional conversation item group, `null` if the item was created without a `conversationId`)md"sv, std::nullopt, schema->LookupType("Conversation")),
		schema::Field::Make(R"gql(subject)gql"sv, R"md(Subject field)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("String"))),
		schema::Field::Make(R"gql(sender)gql"sv, R"md(Sender name)md"sv, std::nullopt, schema->LookupType("String")),
		schema::Field::Make(R"gql(to)gql"sv, R"md(Recipients on the To: line)md"sv, std::nullopt, schema->LookupType("String")),
		schema::Field::Make(R"gql(cc)gql"sv, R"md(Recipients on the Cc: line)md"sv, std::nullopt, schema->LookupType("String")),
		schema::Field::Make(R"gql(body)gql"sv, R"md(HTML body contents)md"sv, std::nullopt, schema->LookupType("Stream")),
		schema::Field::Make(R"gql(read)gql"sv, R"md(True if the item is marked as read, false if it is unread)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean"))),
		schema::Field::Make(R"gql(received)gql"sv, R"md(Received/creation time)md"sv, std::nullopt, schema->LookupType("DateTime")),
		schema::Field::Make(R"gql(modified)gql"sv, R"md(Last modified time)md"sv, std::nullopt, schema->LookupType("DateTime")),
		schema::Field::Make(R"gql(preview)gql"sv, R"md(Body preview)md"sv, std::nullopt, schema->LookupType("String")),
		schema::Field::Make(R"gql(columns)gql"sv, R"md(Columns specified with `@columns(ids: ...)` on the `Folder.items` or `Conversation.items` field)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->WrapType(introspection::TypeKind::LIST, schema->LookupType("Property")))),
		schema::Field::Make(R"gql(attachments)gql"sv, R"md(List of attachments on this item)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->WrapType(introspection::TypeKind::LIST, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Attachment")))), {
			schema::InputValue::Make(R"gql(ids)gql"sv, R"md(Optional list of attachment IDs, return all attachments if `null`)md"sv, schema->WrapType(introspection::TypeKind::LIST, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ID"))), R"gql(null)gql"sv)
		})
	});
}

} // namespace graphql::mapi
