// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "MAPIObjects.h"

#include "graphqlservice/introspection/Introspection.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

ItemAdded::ItemAdded()
	: service::Object({
		"ItemChange",
		"ItemAdded"
	}, {
		{ R"gql(added)gql"sv, [this](service::ResolverParams&& params) { return resolveAdded(std::move(params)); } },
		{ R"gql(index)gql"sv, [this](service::ResolverParams&& params) { return resolveIndex(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } }
	})
{
}

std::future<service::ResolverResult> ItemAdded::resolveIndex(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getIndex(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::IntType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> ItemAdded::resolveAdded(service::ResolverParams&& params)
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = getAdded(service::FieldParams(std::move(params), std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<Item>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> ItemAdded::resolve_typename(service::ResolverParams&& params)
{
	return service::ModifiedResult<response::StringType>::convert(response::StringType{ R"gql(ItemAdded)gql" }, std::move(params));
}

} // namespace object

void AddItemAddedDetails(std::shared_ptr<schema::ObjectType> typeItemAdded, const std::shared_ptr<schema::Schema>& schema)
{
	typeItemAdded->AddFields({
		schema::Field::Make(R"gql(index)gql"sv, R"md(Index in the subscribed window)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Int"))),
		schema::Field::Make(R"gql(added)gql"sv, R"md(`Item` that was added)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Item")))
	});
}

} // namespace graphql::mapi
