// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef STOREOBJECT_H
#define STOREOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {

class Store
	: public service::Object
{
protected:
	explicit Store();

public:
	virtual service::FieldResult<response::IdType> getId(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<response::StringType> getName(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Property>>> getColumns(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Folder>>> getRootFolders(service::FieldParams&& params, std::optional<std::vector<response::IdType>>&& idsArg) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Folder>>> getSpecialFolders(service::FieldParams&& params, std::vector<SpecialFolder>&& idsArg) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Property>>> getFolderProperties(service::FieldParams&& params, response::IdType&& folderIdArg, std::optional<std::vector<Column>>&& idsArg) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Property>>> getItemProperties(service::FieldParams&& params, response::IdType&& itemIdArg, std::optional<std::vector<Column>>&& idsArg) const = 0;

private:
	std::future<service::ResolverResult> resolveId(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveName(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveColumns(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveRootFolders(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveSpecialFolders(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveFolderProperties(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveItemProperties(service::ResolverParams&& params);

	std::future<service::ResolverResult> resolve_typename(service::ResolverParams&& params);
};

} // namespace graphql::mapi::object

#endif // STOREOBJECT_H
