// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef CONVERSATIONOBJECT_H
#define CONVERSATIONOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {

class Conversation
	: public service::Object
{
protected:
	explicit Conversation();

public:
	virtual service::FieldResult<response::IdType> getId(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<response::StringType> getSubject(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<response::IntType> getCount(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<response::IntType> getUnread(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::Value>> getReceived(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Item>>> getItems(service::FieldParams&& params, std::optional<std::vector<response::IdType>>&& idsArg) const = 0;

private:
	std::future<service::ResolverResult> resolveId(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveSubject(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveCount(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveUnread(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveReceived(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveItems(service::ResolverParams&& params);

	std::future<service::ResolverResult> resolve_typename(service::ResolverParams&& params);
};

} // namespace graphql::mapi::object

#endif // CONVERSATIONOBJECT_H
