// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef SUBSCRIPTIONOBJECT_H
#define SUBSCRIPTIONOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {

class Subscription
	: public service::Object
{
protected:
	explicit Subscription();

public:
	virtual service::FieldResult<std::vector<std::shared_ptr<service::Object>>> getItems(service::FieldParams&& params, ObjectId&& folderIdArg) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<service::Object>>> getSubFolders(service::FieldParams&& params, ObjectId&& parentFolderIdArg) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<service::Object>>> getRootFolders(service::FieldParams&& params, response::IdType&& storeIdArg) const = 0;

private:
	std::future<service::ResolverResult> resolveItems(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveSubFolders(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveRootFolders(service::ResolverParams&& params);

	std::future<service::ResolverResult> resolve_typename(service::ResolverParams&& params);
};

} // namespace graphql::mapi::object

#endif // SUBSCRIPTIONOBJECT_H
