// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef MUTATIONOBJECT_H
#define MUTATIONOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {

class Mutation
	: public service::Object
{
protected:
	explicit Mutation();

public:
	virtual service::FieldResult<std::shared_ptr<Item>> applyCreateItem(service::FieldParams&& params, CreateItemInput&& inputArg) const = 0;
	virtual service::FieldResult<std::shared_ptr<Folder>> applyCreateSubFolder(service::FieldParams&& params, CreateSubFolderInput&& inputArg) const = 0;
	virtual service::FieldResult<std::shared_ptr<Item>> applyModifyItem(service::FieldParams&& params, ModifyItemInput&& inputArg) const = 0;
	virtual service::FieldResult<std::shared_ptr<Folder>> applyModifyFolder(service::FieldParams&& params, ModifyFolderInput&& inputArg) const = 0;
	virtual service::FieldResult<response::BooleanType> applyRemoveFolder(service::FieldParams&& params, ObjectId&& inputArg, response::BooleanType&& hardDeleteArg) const = 0;
	virtual service::FieldResult<response::BooleanType> applyMarkAsRead(service::FieldParams&& params, MultipleItemsInput&& inputArg, response::BooleanType&& readArg) const = 0;
	virtual service::FieldResult<response::BooleanType> applyCopyItems(service::FieldParams&& params, MultipleItemsInput&& inputArg, ObjectId&& destinationArg) const = 0;
	virtual service::FieldResult<response::BooleanType> applyMoveItems(service::FieldParams&& params, MultipleItemsInput&& inputArg, ObjectId&& destinationArg) const = 0;
	virtual service::FieldResult<response::BooleanType> applyDeleteItems(service::FieldParams&& params, MultipleItemsInput&& inputArg, response::BooleanType&& hardDeleteArg) const = 0;

private:
	std::future<service::ResolverResult> resolveCreateItem(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveCreateSubFolder(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveModifyItem(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveModifyFolder(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveRemoveFolder(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveMarkAsRead(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveCopyItems(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveMoveItems(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveDeleteItems(service::ResolverParams&& params);

	std::future<service::ResolverResult> resolve_typename(service::ResolverParams&& params);
};

} // namespace graphql::mapi::object

#endif // MUTATIONOBJECT_H
