// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "MAPIObjects.h"

#include "graphqlservice/introspection/Introspection.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

Mutation::Mutation()
	: service::Object({
		"Mutation"
	}, {
		{ R"gql(copyItems)gql"sv, [this](service::ResolverParams&& params) { return resolveCopyItems(std::move(params)); } },
		{ R"gql(moveItems)gql"sv, [this](service::ResolverParams&& params) { return resolveMoveItems(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } },
		{ R"gql(createItem)gql"sv, [this](service::ResolverParams&& params) { return resolveCreateItem(std::move(params)); } },
		{ R"gql(markAsRead)gql"sv, [this](service::ResolverParams&& params) { return resolveMarkAsRead(std::move(params)); } },
		{ R"gql(modifyItem)gql"sv, [this](service::ResolverParams&& params) { return resolveModifyItem(std::move(params)); } },
		{ R"gql(deleteItems)gql"sv, [this](service::ResolverParams&& params) { return resolveDeleteItems(std::move(params)); } },
		{ R"gql(modifyFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveModifyFolder(std::move(params)); } },
		{ R"gql(removeFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveRemoveFolder(std::move(params)); } },
		{ R"gql(createSubFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveCreateSubFolder(std::move(params)); } }
	})
{
}

std::future<service::ResolverResult> Mutation::resolveCreateItem(service::ResolverParams&& params)
{
	auto argInput = service::ModifiedArgument<mapi::CreateItemInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyCreateItem(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Item>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveCreateSubFolder(service::ResolverParams&& params)
{
	auto argInput = service::ModifiedArgument<mapi::CreateSubFolderInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyCreateSubFolder(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Folder>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveModifyItem(service::ResolverParams&& params)
{
	auto argInput = service::ModifiedArgument<mapi::ModifyItemInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyModifyItem(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Item>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveModifyFolder(service::ResolverParams&& params)
{
	auto argInput = service::ModifiedArgument<mapi::ModifyFolderInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyModifyFolder(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Folder>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveRemoveFolder(service::ResolverParams&& params)
{
	const auto defaultArguments = []()
	{
		response::Value values(response::Type::Map);
		response::Value entry;

		entry = response::Value(false);
		values.emplace_back("hardDelete", std::move(entry));

		return values;
	}();

	auto argInput = service::ModifiedArgument<ObjectId>::require("input", params.arguments);
	auto pairHardDelete = service::ModifiedArgument<response::BooleanType>::find("hardDelete", params.arguments);
	auto argHardDelete = (pairHardDelete.second
		? std::move(pairHardDelete.first)
		: service::ModifiedArgument<response::BooleanType>::require("hardDelete", defaultArguments));
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyRemoveFolder(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput), std::move(argHardDelete));
	resolverLock.unlock();

	return service::ModifiedResult<response::BooleanType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveMarkAsRead(service::ResolverParams&& params)
{
	const auto defaultArguments = []()
	{
		response::Value values(response::Type::Map);
		response::Value entry;

		entry = response::Value(true);
		values.emplace_back("read", std::move(entry));

		return values;
	}();

	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto pairRead = service::ModifiedArgument<response::BooleanType>::find("read", params.arguments);
	auto argRead = (pairRead.second
		? std::move(pairRead.first)
		: service::ModifiedArgument<response::BooleanType>::require("read", defaultArguments));
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyMarkAsRead(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput), std::move(argRead));
	resolverLock.unlock();

	return service::ModifiedResult<response::BooleanType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveCopyItems(service::ResolverParams&& params)
{
	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto argDestination = service::ModifiedArgument<ObjectId>::require("destination", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyCopyItems(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput), std::move(argDestination));
	resolverLock.unlock();

	return service::ModifiedResult<response::BooleanType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveMoveItems(service::ResolverParams&& params)
{
	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto argDestination = service::ModifiedArgument<ObjectId>::require("destination", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyMoveItems(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput), std::move(argDestination));
	resolverLock.unlock();

	return service::ModifiedResult<response::BooleanType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolveDeleteItems(service::ResolverParams&& params)
{
	const auto defaultArguments = []()
	{
		response::Value values(response::Type::Map);
		response::Value entry;

		entry = response::Value(false);
		values.emplace_back("hardDelete", std::move(entry));

		return values;
	}();

	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto pairHardDelete = service::ModifiedArgument<response::BooleanType>::find("hardDelete", params.arguments);
	auto argHardDelete = (pairHardDelete.second
		? std::move(pairHardDelete.first)
		: service::ModifiedArgument<response::BooleanType>::require("hardDelete", defaultArguments));
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = applyDeleteItems(service::FieldParams(std::move(params), std::move(directives)), std::move(argInput), std::move(argHardDelete));
	resolverLock.unlock();

	return service::ModifiedResult<response::BooleanType>::convert(std::move(result), std::move(params));
}

std::future<service::ResolverResult> Mutation::resolve_typename(service::ResolverParams&& params)
{
	return service::ModifiedResult<response::StringType>::convert(response::StringType{ R"gql(Mutation)gql" }, std::move(params));
}

} // namespace object

void AddMutationDetails(std::shared_ptr<schema::ObjectType> typeMutation, const std::shared_ptr<schema::Schema>& schema)
{
	typeMutation->AddFields({
		schema::Field::Make(R"gql(createItem)gql"sv, R"md(Create a new item in the target folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Item")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("CreateItemInput")), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(createSubFolder)gql"sv, R"md(Create a new sub-folder in the target folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Folder")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("CreateSubFolderInput")), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(modifyItem)gql"sv, R"md(Modify properties on an existing item)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Item")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ModifyItemInput")), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(modifyFolder)gql"sv, R"md(Modify properties on an existing folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Folder")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ModifyFolderInput")), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(removeFolder)gql"sv, R"md(Remove an entire sub-folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ObjectId")), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(hardDelete)gql"sv, R"md(false means move to `Deleted Items`)md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), R"gql(false)gql"sv)
		}),
		schema::Field::Make(R"gql(markAsRead)gql"sv, R"md(Bulk mark items as read/unread)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("MultipleItemsInput")), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(read)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), R"gql(true)gql"sv)
		}),
		schema::Field::Make(R"gql(copyItems)gql"sv, R"md(Bulk copy items from a single source folder to a single destination folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("MultipleItemsInput")), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(destination)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ObjectId")), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(moveItems)gql"sv, R"md(Bulk move items from a single source folder to a single destination folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("MultipleItemsInput")), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(destination)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("ObjectId")), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(deleteItems)gql"sv, R"md(Bulk delete items from a single source folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("MultipleItemsInput")), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(hardDelete)gql"sv, R"md(false means move to `Deleted Items`)md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType("Boolean")), R"gql(false)gql"sv)
		})
	});
}

} // namespace graphql::mapi
