// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef MAPISCHEMA_H
#define MAPISCHEMA_H

#include "graphqlservice/internal/Schema.h"

// Check if the library version is compatible with schemagen 3.6.0
static_assert(graphql::internal::MajorVersion == 3, "regenerate with schemagen: major version mismatch");
static_assert(graphql::internal::MinorVersion == 6, "regenerate with schemagen: minor version mismatch");

#include <memory>
#include <string>
#include <vector>

namespace graphql {
namespace mapi {

enum class SpecialFolder
{
	INBOX,
	CALENDAR,
	CONTACTS,
	TASKS,
	ARCHIVE,
	DELETED,
	DRAFTS,
	OUTBOX,
	SENT,
	SPAM
};

enum class PropType
{
	INT,
	BOOL,
	STRING,
	GUID,
	DATETIME,
	BINARY,
	STREAM
};

struct ObjectId
{
	response::IdType storeId;
	response::IdType objectId;
};

struct NamedPropInput
{
	response::Value propset;
	std::optional<response::IntType> id;
	std::optional<response::StringType> name;
};

struct PropValueInput
{
	std::optional<response::IntType> integer;
	std::optional<response::BooleanType> boolean;
	std::optional<response::StringType> string;
	std::optional<response::Value> guid;
	std::optional<response::Value> time;
	std::optional<response::IdType> bin;
	std::optional<response::Value> stream;
};

struct MultipleItemsInput
{
	ObjectId folderId;
	std::vector<response::IdType> itemIds;
};

struct PropIdInput
{
	std::optional<response::IntType> id;
	std::optional<NamedPropInput> named;
};

struct PropertyInput
{
	PropIdInput id;
	PropValueInput value;
};

struct Order
{
	response::BooleanType descending;
	PropIdInput property;
	PropType type;
};

struct Column
{
	PropIdInput property;
	PropType type;
};

struct CreateItemInput
{
	ObjectId folderId;
	response::StringType subject;
	std::optional<response::IdType> conversationId;
	response::BooleanType read;
	std::optional<response::Value> received;
	std::optional<response::Value> modified;
	std::optional<std::vector<PropertyInput>> properties;
};

struct CreateSubFolderInput
{
	ObjectId folderId;
	response::StringType name;
	std::optional<std::vector<PropertyInput>> properties;
};

struct ModifyItemInput
{
	ObjectId id;
	std::optional<response::StringType> subject;
	std::optional<response::BooleanType> read;
	std::optional<std::vector<PropertyInput>> properties;
	std::optional<std::vector<PropIdInput>> deleted;
};

struct ModifyFolderInput
{
	ObjectId folderId;
	std::optional<response::StringType> name;
	std::optional<std::vector<PropertyInput>> properties;
	std::optional<std::vector<PropIdInput>> deleted;
};

namespace object {

class Query;
class Mutation;
class Subscription;
class Store;
class Folder;
class Item;
class FileAttachment;
class Conversation;
class IntId;
class StringId;
class NamedId;
class IntValue;
class BoolValue;
class StringValue;
class GuidValue;
class DateTimeValue;
class BinaryValue;
class StreamValue;
class Property;
class ItemAdded;
class ItemUpdated;
class ItemRemoved;
class ItemsReloaded;
class FolderAdded;
class FolderUpdated;
class FolderRemoved;
class FoldersReloaded;

} // namespace object

class Operations
	: public service::Request
{
public:
	explicit Operations(std::shared_ptr<object::Query> query, std::shared_ptr<object::Mutation> mutation, std::shared_ptr<object::Subscription> subscription);

private:
	std::shared_ptr<object::Query> _query;
	std::shared_ptr<object::Mutation> _mutation;
	std::shared_ptr<object::Subscription> _subscription;
};

void AddQueryDetails(std::shared_ptr<schema::ObjectType> typeQuery, const std::shared_ptr<schema::Schema>& schema);
void AddMutationDetails(std::shared_ptr<schema::ObjectType> typeMutation, const std::shared_ptr<schema::Schema>& schema);
void AddSubscriptionDetails(std::shared_ptr<schema::ObjectType> typeSubscription, const std::shared_ptr<schema::Schema>& schema);
void AddStoreDetails(std::shared_ptr<schema::ObjectType> typeStore, const std::shared_ptr<schema::Schema>& schema);
void AddFolderDetails(std::shared_ptr<schema::ObjectType> typeFolder, const std::shared_ptr<schema::Schema>& schema);
void AddItemDetails(std::shared_ptr<schema::ObjectType> typeItem, const std::shared_ptr<schema::Schema>& schema);
void AddFileAttachmentDetails(std::shared_ptr<schema::ObjectType> typeFileAttachment, const std::shared_ptr<schema::Schema>& schema);
void AddConversationDetails(std::shared_ptr<schema::ObjectType> typeConversation, const std::shared_ptr<schema::Schema>& schema);
void AddIntIdDetails(std::shared_ptr<schema::ObjectType> typeIntId, const std::shared_ptr<schema::Schema>& schema);
void AddStringIdDetails(std::shared_ptr<schema::ObjectType> typeStringId, const std::shared_ptr<schema::Schema>& schema);
void AddNamedIdDetails(std::shared_ptr<schema::ObjectType> typeNamedId, const std::shared_ptr<schema::Schema>& schema);
void AddIntValueDetails(std::shared_ptr<schema::ObjectType> typeIntValue, const std::shared_ptr<schema::Schema>& schema);
void AddBoolValueDetails(std::shared_ptr<schema::ObjectType> typeBoolValue, const std::shared_ptr<schema::Schema>& schema);
void AddStringValueDetails(std::shared_ptr<schema::ObjectType> typeStringValue, const std::shared_ptr<schema::Schema>& schema);
void AddGuidValueDetails(std::shared_ptr<schema::ObjectType> typeGuidValue, const std::shared_ptr<schema::Schema>& schema);
void AddDateTimeValueDetails(std::shared_ptr<schema::ObjectType> typeDateTimeValue, const std::shared_ptr<schema::Schema>& schema);
void AddBinaryValueDetails(std::shared_ptr<schema::ObjectType> typeBinaryValue, const std::shared_ptr<schema::Schema>& schema);
void AddStreamValueDetails(std::shared_ptr<schema::ObjectType> typeStreamValue, const std::shared_ptr<schema::Schema>& schema);
void AddPropertyDetails(std::shared_ptr<schema::ObjectType> typeProperty, const std::shared_ptr<schema::Schema>& schema);
void AddItemAddedDetails(std::shared_ptr<schema::ObjectType> typeItemAdded, const std::shared_ptr<schema::Schema>& schema);
void AddItemUpdatedDetails(std::shared_ptr<schema::ObjectType> typeItemUpdated, const std::shared_ptr<schema::Schema>& schema);
void AddItemRemovedDetails(std::shared_ptr<schema::ObjectType> typeItemRemoved, const std::shared_ptr<schema::Schema>& schema);
void AddItemsReloadedDetails(std::shared_ptr<schema::ObjectType> typeItemsReloaded, const std::shared_ptr<schema::Schema>& schema);
void AddFolderAddedDetails(std::shared_ptr<schema::ObjectType> typeFolderAdded, const std::shared_ptr<schema::Schema>& schema);
void AddFolderUpdatedDetails(std::shared_ptr<schema::ObjectType> typeFolderUpdated, const std::shared_ptr<schema::Schema>& schema);
void AddFolderRemovedDetails(std::shared_ptr<schema::ObjectType> typeFolderRemoved, const std::shared_ptr<schema::Schema>& schema);
void AddFoldersReloadedDetails(std::shared_ptr<schema::ObjectType> typeFoldersReloaded, const std::shared_ptr<schema::Schema>& schema);

std::shared_ptr<schema::Schema> GetSchema();

} // namespace mapi
} // namespace graphql

#endif // MAPISCHEMA_H
