// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef ITEMOBJECT_H
#define ITEMOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {

class Item
	: public service::Object
{
protected:
	explicit Item();

public:
	virtual service::FieldResult<response::IdType> getId(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::shared_ptr<Folder>> getParentFolder(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::shared_ptr<Conversation>> getConversation(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<response::StringType> getSubject(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::StringType>> getSender(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::StringType>> getTo(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::StringType>> getCc(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::Value>> getBody(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<response::BooleanType> getRead(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::Value>> getReceived(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::Value>> getModified(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::optional<response::StringType>> getPreview(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<Property>>> getColumns(service::FieldParams&& params) const = 0;
	virtual service::FieldResult<std::vector<std::shared_ptr<service::Object>>> getAttachments(service::FieldParams&& params, std::optional<std::vector<response::IdType>>&& idsArg) const = 0;

private:
	std::future<service::ResolverResult> resolveId(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveParentFolder(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveConversation(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveSubject(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveSender(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveTo(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveCc(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveBody(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveRead(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveReceived(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveModified(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolvePreview(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveColumns(service::ResolverParams&& params);
	std::future<service::ResolverResult> resolveAttachments(service::ResolverParams&& params);

	std::future<service::ResolverResult> resolve_typename(service::ResolverParams&& params);
};

} // namespace graphql::mapi::object

#endif // ITEMOBJECT_H
