//! Main application which is responsible for operations on the terminal.

/// Application launcher.
pub mod launcher;

/// Renderer for the interface.
pub mod renderer;

/// Application state.
pub mod state;

/// Application mode.
pub mod mode;

/// Application prompt.
pub mod prompt;

/// Application commands.
pub mod command;

/// Application tabs.
pub mod tab;

/// Input and command handler.
pub mod handler;

/// Clipboard helper.
pub mod clipboard;

/// Style helper.
pub mod style;

/// Key bindings helper.
pub mod keys;

/// Application banner text.
pub mod banner;

/// Application splash screen.
pub mod splash;
