// Filename: lib.rs
// Version:	 0.9
// Date:	 14-11-2021 (DD-MM-YYYY)
// Library:  gpcas_isa
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Provides the interface between ISAs and the GPCAS simulator. It also provides basic handling of
//! ELF files.
//! In order to provide support, an ISA has to provide a public function that returns an [`Isa`]
//! object.
//! Possible ISAs are defined in [`IsaIdentifier`].
#![warn(missing_docs)]

mod elf;
mod emulator;
mod instruction;
mod isa;

pub use elf::{check_isa, ELFFileHeaderFront};
pub use emulator::{format_c_string, Emulator, InteractiveEmulator, OperandStorage};
pub use instruction::{instruction_flags, Instruction, IS_VECTOR_REGISTER, MAX_INPUTS};
pub use isa::{Isa, IsaIdentifier, MemoryAccessType};
