GPCAS isa crate
===============

This crate provides an interface to implement for ISAs (instruction set architectures) to be supported in GPCAS.
GPCAS stands for General Purpose Core Architecture Simulator, a simulator for CPUs.

Most importantly, each ISA has to provide an emulator capable of executing a program of said ISA.

## Example

To properly interface with the simulator, an ISA should provide its information as so:

```rust
extern crate gpcas_isa;
use gpcas_isa::{Isa, MemoryAccessType};

pub fn get_isa(executable_data: Vec<u8>) -> Isa {
  Isa {
    emulator: Box::new(YourEmulator::new(executable_data)),
    // example
    memory_access_type: MemoryAccessType::LoadStore,
    // example
    register_bank_size: 32,
  }
}
```

## License

`gpcas_isa` is distributed under the LGPLv3 license. See `COPYING` and `COPYING.LESSER` in the crate root.
