// Filename: legacy.rs
// Version:	 0.10
// Date:	 10-01-2022 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Old compatible versions of data structures as well as upgrade-to-current functionality.
//!
//! # Upgrade to a new version
//! To upgrade to the next version ([current version](crate::CpuModel::CURRENT_FILE_VERSION) + 1):
//! - Copy [crate::CpuModel] into a new version file of the current version.
//! - Copy any component type of the model that you wish to change to the version file before
//!   changing it.
//! - Look in all older version files for references to current types you plan to change,
//!   replace the references with references into your new version file.
//! - Change the `From` trait implementations inside the version file of the last version to target
//!   the version file types of the current version.
//! - Make all wanted changes for the next version.
//! - Implement `From` traits for all types inside the version file of the current version to the
//!   next version **inside that file**.
//! - Add an entry in the form of
//!   `({current version}, deserialize_upgrade_from::<legacy::v{current version}::CPUModel, Self>)`
//!   to [crate::CpuModel::COMPATIBLE_VERSIONS].
//! - Bump [crate::CpuModel::CURRENT_FILE_VERSION] by one.
//! - Congratulations, you created a new, backwards-compatible file version!
//!
//! # Remove support for an old version
//! To Remove a version you don't wish to support any longer:
//! - If it's the lowest still supported version, just remove the file and you're done.
//! - Otherwise, look through all older versions if they reference the version you want to remove.
//!   If so, copy referenced types into the highest file referencing it and change all references in
//!   older versions to the new location.
//! - Change the `From` trait implementations of the version before the one to be removed to the
//!   next higher version.
//! - Remove the entry of the version to be removed in [crate::CpuModel::COMPATIBLE_VERSIONS].
//! - Remove the version file.
//! - You're done!

pub mod v2;
pub mod v3;
pub mod v4;
