// Filename: scheduler.rs
// Version:	 0.4
// Date:	 10-01-2022 (DD-MM-YYYY)
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

use serde::{Deserialize, Serialize};

/// The properties of the register file.
#[derive(Clone, Default, Deserialize, Serialize)]
pub struct RegisterFile {
    /// The number of physical general purpose registers.
    ///
    /// If not set, defaults to the number of architectural general purpose registers.
    pub general_purpose_register_count: Option<usize>,
    /// The number of physical vector registers.
    ///
    /// If not set, defaults to the number of architectural vector registers.
    pub vector_register_count: Option<usize>,
}
