// Filename: load_store_unit.rs
// Version:	 0.5
// Date:	 25-01-2020 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Configuration for the load-store-unit.

use crate::config::MemoryConnection;

use serde::{Deserialize, Serialize};

/// Properties of the load-store-unit.
///
/// It is responsible for connecting the core to the memory hierarchy.
/// It manages in-flight requests.
#[derive(Clone, Default, Deserialize, Serialize)]
pub struct LoadStoreUnit {
    /// The amount of load requests that can be in-flight.
    pub load_count: usize,
    /// The amount of store requests that can be in-flight.
    pub store_count: usize,
    /// Connection to the provider of data memory.
    pub data_provider: MemoryConnection,
    /// How many parallel ports there are to memory.
    pub port_count: usize,
}
