// Filename: reorder_buffer.rs
// Version:	 0.2
// Date:	 18-11-2021 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

use serde::{Deserialize, Serialize};

/// The properties of the reorder buffer.
///
/// Every model has this, in-order designs just use it in a different manner.
#[derive(Clone, Default, Deserialize, Serialize)]
pub struct ReorderBufferConfig {
    /// The maximum amount of instructions that can be in-flight at the same time.
    pub size: usize,
    /// How many instructions can retire per clock.
    pub retire_width: usize,
    /// How many branches can retire per clock.
    pub branch_retire_width: usize,
}
