// Filename: scheduler.rs
// Version:	 0.2
// Date:	 11-10-2021 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

use serde::{Deserialize, Serialize};

/// The properties of a scheduler.
#[derive(Clone, Default, Deserialize, Serialize)]
pub struct SchedulerConfig {
    /// The identification number. Used for connecting pipelines.
    pub id: usize,
    /// The number of entries the scheduler holds.
    pub entries: usize,
}
