// Filename: memory_controller.rs
// Version:	 0.3
// Date:	 11-10-2021 (DD-MM-YYYY)
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.1

//! Configuration for the memory controller.

use serde::{Deserialize, Serialize};

/// Properties of the memory controller.
///
/// It acts as the root of memory, providing data to the CPU and its caches, if it has some.
#[derive(Clone, Deserialize, Serialize)]
pub struct MemoryControllerConfig {
    /// How many clock cycles a request takes before the response is sent.
    pub access_latency: usize,
    /// The amount of data that can be transferred per clock as power-of-two bytes.
    pub port_width: u16,
}

impl Default for MemoryControllerConfig {
    fn default() -> Self {
        MemoryControllerConfig {
            access_latency: 2,
            port_width: 4,
        }
    }
}
