// Filename: decoder.rs
// Version:	 0.2
// Date:	 11-10-2021 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Configuration for the decode stage.

use serde::{Deserialize, Serialize};

/// Properties of the decode stage.
///
/// It is responsible for decoding memory into executable instructions.
#[derive(Clone, Default, Deserialize, Serialize)]
pub struct DecodeConfig {
    /// How many instructions can be decoded in one clock cycle.
    pub width: usize,
    /// The size of the buffer between fetch and decode stage **in fetch blocks**
    pub pre_decode_buffer_size: usize,
}
