// Filename: component_config.rs
// Version:	 0.11
// Date:	 11-11-2021 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Structs that describe a configuration of a specific model component.

#[doc(hidden)]
mod cache;
#[doc(hidden)]
mod decoder;
#[doc(hidden)]
mod fetch;
#[doc(hidden)]
mod load_store_unit;
#[doc(hidden)]
mod memory_controller;
#[doc(hidden)]
mod pipeline;
#[doc(hidden)]
mod register_file;
#[doc(hidden)]
mod reorder_buffer;
#[doc(hidden)]
mod scheduler;

pub use cache::{CacheConfig, CacheType};
pub use decoder::DecodeConfig;
pub use fetch::FetchConfig;
pub use load_store_unit::LoadStoreUnitConfig;
pub use memory_controller::MemoryControllerConfig;
pub use pipeline::{AluCapabilities, PipelineConfig};
pub use register_file::RegisterFileConfig;
pub use reorder_buffer::ReorderBufferConfig;
pub use scheduler::SchedulerConfig;
