// Filename: load_store_unit.rs
// Version:	 0.1
// Date:	 24-09-2021 (DD-MM-YYYY)
// Library:  gpcas_cpu_model
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Configuration for the load-store-unit.

use serde::{Deserialize, Serialize};

/// Properties of the load-store-unit.
///
/// It is responsible for connecting the core to the memory hierarchy.
/// It manages in-flight requests.
#[derive(Default, Deserialize, Serialize)]
pub struct LoadStoreUnitConfig {
    /// The amount of load requests that can be in-flight.
    pub load_count: usize,
    /// The amount of store requests that can be in-flight.
    pub store_count: usize,
    /// The ID of the cache used to serve memory requests. If no ID is given, connects directly
    /// to the memory controller.
    pub cache_connection: Option<usize>,
}
