// Filename: fetch.rs
// Version:	 0.2
// Date:	 27-07-2021 (DD-MM-YYYY)
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Configuration for the fetch unit.

use serde::{Deserialize, Serialize};

/// Properties of the fetch stage.
///
/// It is responsible for fetching program data from memory.
#[derive(Deserialize, Serialize)]
pub struct FetchConfig {
    /// The ID of the cache used to fetch instruction data. If no ID is given, connects directly
    /// to the memory controller.
    pub cache_connection: Option<usize>,
}

impl Default for FetchConfig {
    fn default() -> Self {
        FetchConfig {
            cache_connection: None,
        }
    }
}
