// Filename: instruction_type.rs
// Version:	 0.1
// Date:	 19-06-2021 (DD-MM-YYYY)
// Library:  gpcas_base
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! Instruction type definitions.
//!
//! Each instruction type is defined as a constant with a numeric ID.
//! The IDs are guaranteed to be in a gap-less interval from 0 on, so they can be used as indices
//! for an array.

/// The amount of defined instruction types.
pub const TYPE_COUNT: usize = 14;

/// A move that can be eliminated using a physical register file.
///
/// This is technically unnecessary since it can be determined from the flags if a move only
/// uses registers.
pub const REGISTER_MOVE: u16 = 0;
/// Does nothing but pass a value in the ALU.
pub const MOVE: u16 = 1;
/// Simple operations that can execute in a single clock cycle.
pub const SIMPLE: u16 = 2;
/// Simple addition.
pub const INT_ADD: u16 = 3;
/// Typically takes multiple, but few clock cycles.
pub const INT_MUL: u16 = 4;
/// Takes many clock cycles, usually dependent on the operand size.
pub const INT_DIV: u16 = 5;
/// Combination of add- and mul-operation.
pub const INT_MUL_ADD: u16 = 6;
/// Completes fast, but needs a shifter.
pub const INT_SHIFT: u16 = 7;
/// Might take longer than floating point multiplication.
pub const FLOAT_ADD: u16 = 8;
/// Usually as fast as integer multiplication.
pub const FLOAT_MUL: u16 = 9;
/// Takes many clock cycles, usually dependent on the operand size.
pub const FLOAT_DIV: u16 = 10;
/// Might need multiple execution ports if a design has separate add- and mul-pipes.
pub const FLOAT_MUL_ADD: u16 = 11;
/// Completes fast, but needs a branch unit.
pub const BRANCH: u16 = 12;
/// Can trigger redirect directly after decoding.
pub const JUMP: u16 = 13;
