// Filename: emulator.rs
// Version:	 0.3
// Date:	 12-07-2021 (DD-MM-YYYY)
// Library:  gpcas_arschitek_zero
//
// Copyright (c) 2021 Kai Rese
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program. If not, see
// <https://www.gnu.org/licenses/>.

//! This crate contains Arschitek Zero ISA information for use within the GPCAS simulator.
//!
//! The emulator implements the Arschitek Zero V3 architecture. For more information, see
//! [the Arschitek Zero specification](https://git.h3n.eu/Kulasko/arschitek_zero).
//!
//! Although it implements the interface of the GPCAS simulator, this crate can also be used as base
//! for a standalone emulator.
#![warn(missing_docs)]

pub mod emulator;

use gpcas_isa::{Isa, MemoryAccessType};

/// Returns the Arschitek Zero ISA struct.
pub fn get_isa(executable_data: Vec<u8>) -> Isa {
    Isa {
        emulator: Box::new(emulator::ArschitekZeroEmulator::new(executable_data)),
        memory_access_type: MemoryAccessType::LoadStore,
        register_bank_size: 16,
    }
}
