use serde::{Deserialize, Serialize};
use std::fmt;
use std::slice::Iter;
use std::str::FromStr;
// https://data.iana.org/TLD/tlds-alpha-by-domain.txt
#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TopLevelDomain {
    AAA,
    AARP,
    ABARTH,
    ABB,
    ABBOTT,
    ABBVIE,
    ABC,
    ABLE,
    ABOGADO,
    ABUDHABI,
    AC,
    ACADEMY,
    ACCENTURE,
    ACCOUNTANT,
    ACCOUNTANTS,
    ACO,
    ACTOR,
    AD,
    ADAC,
    ADS,
    ADULT,
    AE,
    AEG,
    AERO,
    AETNA,
    AF,
    AFAMILYCOMPANY,
    AFL,
    AFRICA,
    AG,
    AGAKHAN,
    AGENCY,
    AI,
    AIG,
    AIRBUS,
    AIRFORCE,
    AIRTEL,
    AKDN,
    AL,
    ALFAROMEO,
    ALIBABA,
    ALIPAY,
    ALLFINANZ,
    ALLSTATE,
    ALLY,
    ALSACE,
    ALSTOM,
    AM,
    AMAZON,
    AMERICANEXPRESS,
    AMERICANFAMILY,
    AMEX,
    AMFAM,
    AMICA,
    AMSTERDAM,
    AN,
    ANALYTICS,
    ANDROID,
    ANQUAN,
    ANZ,
    AO,
    AOL,
    APARTMENTS,
    APP,
    APPLE,
    AQ,
    AQUARELLE,
    AR,
    ARAB,
    ARAMCO,
    ARCHI,
    ARMY,
    ARPA,
    ART,
    ARTE,
    AS,
    ASDA,
    ASIA,
    ASSOCIATES,
    AT,
    ATHLETA,
    ATTORNEY,
    AU,
    AUCTION,
    AUDI,
    AUDIBLE,
    AUDIO,
    AUSPOST,
    AUTHOR,
    AUTO,
    AUTOS,
    AVIANCA,
    AW,
    AWS,
    AX,
    AXA,
    AZ,
    AZURE,
    BA,
    BABY,
    BAIDU,
    BANAMEX,
    BANANAREPUBLIC,
    BAND,
    BANK,
    BAR,
    BARCELONA,
    BARCLAYCARD,
    BARCLAYS,
    BAREFOOT,
    BARGAINS,
    BASEBALL,
    BASKETBALL,
    BAUHAUS,
    BAYERN,
    BB,
    BBC,
    BBT,
    BBVA,
    BCG,
    BCN,
    BD,
    BE,
    BEATS,
    BEAUTY,
    BEER,
    BENTLEY,
    BERLIN,
    BEST,
    BESTBUY,
    BET,
    BF,
    BG,
    BH,
    BHARTI,
    BI,
    BIBLE,
    BID,
    BIKE,
    BING,
    BINGO,
    BIO,
    BIZ,
    BJ,
    BL,
    BLACK,
    BLACKFRIDAY,
    BLOCKBUSTER,
    BLOG,
    BLOOMBERG,
    BLUE,
    BM,
    BMS,
    BMW,
    BN,
    BNPPARIBAS,
    BO,
    BOATS,
    BOEHRINGER,
    BOFA,
    BOM,
    BOND,
    BOO,
    BOOK,
    BOOKING,
    BOSCH,
    BOSTIK,
    BOSTON,
    BOT,
    BOUTIQUE,
    BOX,
    BR,
    BRADESCO,
    BRIDGESTONE,
    BROADWAY,
    BROKER,
    BROTHER,
    BRUSSELS,
    BS,
    BT,
    BUDAPEST,
    BUGATTI,
    BUILD,
    BUILDERS,
    BUSINESS,
    BUY,
    BUZZ,
    BV,
    BW,
    BQ,
    BY,
    BZ,
    BZH,
    CA,
    CAB,
    CAFE,
    CAL,
    CALL,
    CALVINKLEIN,
    CAM,
    CAMERA,
    CAMP,
    CANCERRESEARCH,
    CANON,
    CAPETOWN,
    CAPITAL,
    CAPITALONE,
    CAR,
    CARAVAN,
    CARDS,
    CARE,
    CAREER,
    CAREERS,
    CARS,
    CASA,
    CASE,
    CASH,
    CASINO,
    CAT,
    CATERING,
    CATHOLIC,
    CBA,
    CBN,
    CBRE,
    CBS,
    CC,
    CD,
    CENTER,
    CEO,
    CERN,
    CF,
    CFA,
    CFD,
    CG,
    CH,
    CHANEL,
    CHANNEL,
    CHARITY,
    CHASE,
    CHAT,
    CHEAP,
    CHINTAI,
    CHRISTMAS,
    CHROME,
    CHURCH,
    CI,
    CIPRIANI,
    CIRCLE,
    CISCO,
    CITADEL,
    CITI,
    CITIC,
    CITY,
    CITYEATS,
    CK,
    CL,
    CLAIMS,
    CLEANING,
    CLICK,
    CLINIC,
    CLINIQUE,
    CLOTHING,
    CLOUD,
    CLUB,
    CLUBMED,
    CM,
    CN,
    CO,
    COACH,
    CODES,
    COFFEE,
    COLLEGE,
    COLOGNE,
    COM,
    COMCAST,
    COMMBANK,
    COMMUNITY,
    COMPANY,
    COMPARE,
    COMPUTER,
    COMSEC,
    CONDOS,
    CONSTRUCTION,
    CONSULTING,
    CONTACT,
    CONTRACTORS,
    COOKING,
    COOKINGCHANNEL,
    COOL,
    COOP,
    CORSICA,
    COUNTRY,
    COUPON,
    COUPONS,
    COURSES,
    CPA,
    CR,
    CREDIT,
    CREDITCARD,
    CREDITUNION,
    CRICKET,
    CROWN,
    CRS,
    CRUISE,
    CRUISES,
    CSC,
    CU,
    CUISINELLA,
    CV,
    CW,
    CX,
    CY,
    CYMRU,
    CYOU,
    CZ,
    DABUR,
    DAD,
    DANCE,
    DATA,
    DATE,
    DATING,
    DATSUN,
    DAY,
    DCLK,
    DDS,
    DE,
    DEAL,
    DEALER,
    DEALS,
    DEGREE,
    DELIVERY,
    DELL,
    DELOITTE,
    DELTA,
    DEMOCRAT,
    DENTAL,
    DENTIST,
    DESI,
    DESIGN,
    DEV,
    DHL,
    DIAMONDS,
    DIET,
    DIGITAL,
    DIRECT,
    DIRECTORY,
    DISCOUNT,
    DISCOVER,
    DISH,
    DIY,
    DJ,
    DK,
    DM,
    DNP,
    DO,
    DOCS,
    DOCTOR,
    DOG,
    DOMAINS,
    DOT,
    DOWNLOAD,
    DRIVE,
    DTV,
    DUBAI,
    DUCK,
    DUNLOP,
    DUPONT,
    DURBAN,
    DVAG,
    DVR,
    DZ,
    EARTH,
    EAT,
    EC,
    ECO,
    EDEKA,
    EDU,
    EDUCATION,
    EE,
    EG,
    EH,
    EMAIL,
    EMERCK,
    ENERGY,
    ENGINEER,
    ENGINEERING,
    ENTERPRISES,
    EPSON,
    EQUIPMENT,
    ER,
    ERICSSON,
    ERNI,
    ES,
    ESQ,
    ESTATE,
    ET,
    ETISALAT,
    EU,
    EUROVISION,
    EUS,
    EVENTS,
    EXCHANGE,
    EXPERT,
    EXPOSED,
    EXPRESS,
    EXTRASPACE,
    FAGE,
    FAIL,
    FAIRWINDS,
    FAITH,
    FAMILY,
    FAN,
    FANS,
    FARM,
    FARMERS,
    FASHION,
    FAST,
    FEDEX,
    FEEDBACK,
    FERRARI,
    FERRERO,
    FI,
    FIAT,
    FIDELITY,
    FIDO,
    FILM,
    FINAL,
    FINANCE,
    FINANCIAL,
    FIRE,
    FIRESTONE,
    FIRMDALE,
    FISH,
    FISHING,
    FIT,
    FITNESS,
    FJ,
    FK,
    FLICKR,
    FLIGHTS,
    FLIR,
    FLORIST,
    FLOWERS,
    FLY,
    FM,
    FO,
    FOO,
    FOOD,
    FOODNETWORK,
    FOOTBALL,
    FORD,
    FOREX,
    FORSALE,
    FORUM,
    FOUNDATION,
    FOX,
    FR,
    FREE,
    FRESENIUS,
    FRL,
    FROGANS,
    FRONTDOOR,
    FRONTIER,
    FTR,
    FUJITSU,
    FUN,
    FUND,
    FURNITURE,
    FUTBOL,
    FYI,
    GA,
    GAL,
    GALLERY,
    GALLO,
    GALLUP,
    GAME,
    GAMES,
    GAP,
    GARDEN,
    GAY,
    GB,
    GBIZ,
    GD,
    GDN,
    GE,
    GEA,
    GENT,
    GENTING,
    GEORGE,
    GF,
    GG,
    GGEE,
    GH,
    GI,
    GIFT,
    GIFTS,
    GIVES,
    GIVING,
    GL,
    GLADE,
    GLASS,
    GLE,
    GLOBAL,
    GLOBO,
    GM,
    GMAIL,
    GMBH,
    GMO,
    GMX,
    GN,
    GODADDY,
    GOLD,
    GOLDPOINT,
    GOLF,
    GOO,
    GOODYEAR,
    GOOG,
    GOOGLE,
    GOP,
    GOT,
    GOV,
    GP,
    GQ,
    GR,
    GRAINGER,
    GRAPHICS,
    GRATIS,
    GREEN,
    GRIPE,
    GROCERY,
    GROUP,
    GS,
    GT,
    GU,
    GUARDIAN,
    GUCCI,
    GUGE,
    GUIDE,
    GUITARS,
    GURU,
    GW,
    GY,
    HAIR,
    HAMBURG,
    HANGOUT,
    HAUS,
    HBO,
    HDFC,
    HDFCBANK,
    HEALTH,
    HEALTHCARE,
    HELP,
    HELSINKI,
    HERE,
    HERMES,
    HGTV,
    HIPHOP,
    HISAMITSU,
    HITACHI,
    HIV,
    HK,
    HKT,
    HM,
    HN,
    HOCKEY,
    HOLDINGS,
    HOLIDAY,
    HOMEDEPOT,
    HOMEGOODS,
    HOMES,
    HOMESENSE,
    HONDA,
    HORSE,
    HOSPITAL,
    HOST,
    HOSTING,
    HOT,
    HOTELES,
    HOTELS,
    HOTMAIL,
    HOUSE,
    HOW,
    HR,
    HSBC,
    HT,
    HU,
    HUGHES,
    HYATT,
    HYUNDAI,
    IBM,
    ICBC,
    ICE,
    ICU,
    ID,
    IE,
    IEEE,
    IFM,
    IKANO,
    IL,
    IM,
    IMAMAT,
    IMDB,
    IMMO,
    IMMOBILIEN,
    IN,
    INC,
    INDUSTRIES,
    INFINITI,
    INFO,
    ING,
    INK,
    INSTITUTE,
    INSURANCE,
    INSURE,
    INT,
    INTERNATIONAL,
    INTUIT,
    INVESTMENTS,
    IO,
    IPIRANGA,
    IQ,
    IR,
    IRISH,
    IS,
    ISMAILI,
    IST,
    ISTANBUL,
    IT,
    ITAU,
    ITV,
    JAGUAR,
    JAVA,
    JCB,
    JE,
    JEEP,
    JETZT,
    JEWELRY,
    JIO,
    JLL,
    JM,
    JMP,
    JNJ,
    JO,
    JOBS,
    JOBURG,
    JOT,
    JOY,
    JP,
    JPMORGAN,
    JPRS,
    JUEGOS,
    JUNIPER,
    KAUFEN,
    KDDI,
    KE,
    KERRYHOTELS,
    KERRYLOGISTICS,
    KERRYPROPERTIES,
    KFH,
    KG,
    KH,
    KI,
    KIA,
    KIM,
    KINDER,
    KINDLE,
    KITCHEN,
    KIWI,
    KM,
    KN,
    KOELN,
    KOMATSU,
    KOSHER,
    KP,
    KPMG,
    KPN,
    KR,
    KRD,
    KRED,
    KUOKGROUP,
    KW,
    KY,
    KYOTO,
    KZ,
    LA,
    LACAIXA,
    LAMBORGHINI,
    LAMER,
    LANCASTER,
    LANCIA,
    LAND,
    LANDROVER,
    LANXESS,
    LASALLE,
    LAT,
    LATINO,
    LATROBE,
    LAW,
    LAWYER,
    LB,
    LC,
    LDS,
    LEASE,
    LECLERC,
    LEFRAK,
    LEGAL,
    LEGO,
    LEXUS,
    LGBT,
    LI,
    LIDL,
    LIFE,
    LIFEINSURANCE,
    LIFESTYLE,
    LIGHTING,
    LIKE,
    LILLY,
    LIMITED,
    LIMO,
    LINCOLN,
    LINDE,
    LINK,
    LIPSY,
    LIVE,
    LIVING,
    LIXIL,
    LK,
    LLC,
    LLP,
    LOAN,
    LOANS,
    LOCKER,
    LOCUS,
    LOFT,
    LOL,
    LONDON,
    LOTTE,
    LOTTO,
    LOVE,
    LPL,
    LPLFINANCIAL,
    LR,
    LS,
    LT,
    LTD,
    LTDA,
    LU,
    LUNDBECK,
    LUXE,
    LUXURY,
    LV,
    LY,
    MA,
    MACYS,
    MADRID,
    MAIF,
    MAISON,
    MAKEUP,
    MAN,
    MANAGEMENT,
    MANGO,
    MAP,
    MARKET,
    MARKETING,
    MARKETS,
    MARRIOTT,
    MARSHALLS,
    MASERATI,
    MATTEL,
    MBA,
    MC,
    MCKINSEY,
    MD,
    ME,
    MED,
    MEDIA,
    MEET,
    MELBOURNE,
    MEME,
    MEMORIAL,
    MEN,
    MENU,
    MERCKMSD,
    MF,
    MG,
    MH,
    MI,
    MIAMI,
    MICROSOFT,
    MIL,
    MINI,
    MINT,
    MIT,
    MITSUBISHI,
    MK,
    ML,
    MLB,
    MLS,
    MM,
    MMA,
    MN,
    MO,
    MOBI,
    MOBILE,
    MODA,
    MOE,
    MOI,
    MOM,
    MONASH,
    MONEY,
    MONSTER,
    MORMON,
    MORTGAGE,
    MOSCOW,
    MOTO,
    MOTORCYCLES,
    MOV,
    MOVIE,
    MP,
    MQ,
    MR,
    MS,
    MSD,
    MT,
    MTN,
    MTR,
    MU,
    MUSEUM,
    MUTUAL,
    MV,
    MW,
    MX,
    MY,
    MZ,
    NA,
    NAB,
    NAGOYA,
    NAME,
    NATURA,
    NAVY,
    NBA,
    NC,
    NE,
    NEC,
    NET,
    NETBANK,
    NETFLIX,
    NETWORK,
    NEUSTAR,
    NEW,
    NEWS,
    NEXT,
    NEXTDIRECT,
    NEXUS,
    NF,
    NFL,
    NG,
    NGO,
    NHK,
    NI,
    NICO,
    NIKE,
    NIKON,
    NINJA,
    NISSAN,
    NISSAY,
    NL,
    NO,
    NOKIA,
    NORTHWESTERNMUTUAL,
    NORTON,
    NOW,
    NOWRUZ,
    NOWTV,
    NP,
    NR,
    NRA,
    NRW,
    NTT,
    NU,
    NYC,
    NZ,
    OBI,
    OBSERVER,
    OFF,
    OFFICE,
    OKINAWA,
    OLAYAN,
    OLAYANGROUP,
    OLDNAVY,
    OLLO,
    OM,
    OMEGA,
    ONE,
    ONG,
    ONL,
    ONLINE,
    OOO,
    OPEN,
    ORACLE,
    ORANGE,
    ORG,
    ORGANIC,
    ORIGINS,
    OSAKA,
    OTSUKA,
    OTT,
    OVH,
    PA,
    PAGE,
    PANASONIC,
    PARIS,
    PARS,
    PARTNERS,
    PARTS,
    PARTY,
    PASSAGENS,
    PAY,
    PCCW,
    PE,
    PET,
    PF,
    PFIZER,
    PG,
    PH,
    PHARMACY,
    PHD,
    PHILIPS,
    PHONE,
    PHOTO,
    PHOTOGRAPHY,
    PHOTOS,
    PHYSIO,
    PICS,
    PICTET,
    PICTURES,
    PID,
    PIN,
    PING,
    PINK,
    PIONEER,
    PIZZA,
    PK,
    PL,
    PLACE,
    PLAY,
    PLAYSTATION,
    PLUMBING,
    PLUS,
    PM,
    PN,
    PNC,
    POHL,
    POKER,
    POLITIE,
    PORN,
    POST,
    PR,
    PRAMERICA,
    PRAXI,
    PRESS,
    PRIME,
    PRO,
    PROD,
    PRODUCTIONS,
    PROF,
    PROGRESSIVE,
    PROMO,
    PROPERTIES,
    PROPERTY,
    PROTECTION,
    PRU,
    PRUDENTIAL,
    PS,
    PT,
    PUB,
    PW,
    PWC,
    PY,
    QA,
    QPON,
    QUEBEC,
    QUEST,
    QVC,
    RACING,
    RADIO,
    RAID,
    RE,
    READ,
    REALESTATE,
    REALTOR,
    REALTY,
    RECIPES,
    RED,
    REDSTONE,
    REDUMBRELLA,
    REHAB,
    REISE,
    REISEN,
    REIT,
    RELIANCE,
    REN,
    RENT,
    RENTALS,
    REPAIR,
    REPORT,
    REPUBLICAN,
    REST,
    RESTAURANT,
    REVIEW,
    REVIEWS,
    REXROTH,
    RICH,
    RICHARDLI,
    RICOH,
    RIL,
    RIO,
    RIP,
    RMIT,
    RO,
    ROCHER,
    ROCKS,
    RODEO,
    ROGERS,
    ROOM,
    RS,
    RSVP,
    RU,
    RUGBY,
    RUHR,
    RUN,
    RW,
    RWE,
    RYUKYU,
    SA,
    SAARLAND,
    SAFE,
    SAFETY,
    SAKURA,
    SALE,
    SALON,
    SAMSCLUB,
    SAMSUNG,
    SANDVIK,
    SANDVIKCOROMANT,
    SANOFI,
    SAP,
    SARL,
    SAS,
    SAVE,
    SAXO,
    SB,
    SBI,
    SBS,
    SC,
    SCA,
    SCB,
    SCHAEFFLER,
    SCHMIDT,
    SCHOLARSHIPS,
    SCHOOL,
    SCHULE,
    SCHWARZ,
    SCIENCE,
    SCJOHNSON,
    SCOT,
    SD,
    SE,
    SEARCH,
    SEAT,
    SECURE,
    SECURITY,
    SEEK,
    SELECT,
    SENER,
    SERVICES,
    SES,
    SEVEN,
    SEW,
    SEX,
    SEXY,
    SFR,
    SG,
    SH,
    SHANGRILA,
    SHARP,
    SHAW,
    SHELL,
    SHIA,
    SHIKSHA,
    SHOES,
    SHOP,
    SHOPPING,
    SHOUJI,
    SHOW,
    SHOWTIME,
    SI,
    SILK,
    SINA,
    SINGLES,
    SITE,
    SJ,
    SK,
    SKI,
    SKIN,
    SKY,
    SKYPE,
    SL,
    SLING,
    SM,
    SMART,
    SMILE,
    SN,
    SNCF,
    SO,
    SOCCER,
    SOCIAL,
    SOFTBANK,
    SOFTWARE,
    SOHU,
    SOLAR,
    SOLUTIONS,
    SONG,
    SONY,
    SOY,
    SPA,
    SPACE,
    SPORT,
    SPOT,
    SR,
    SRL,
    SS,
    ST,
    STADA,
    STAPLES,
    STAR,
    STATEBANK,
    STATEFARM,
    STC,
    STCGROUP,
    STOCKHOLM,
    STORAGE,
    STORE,
    STREAM,
    STUDIO,
    STUDY,
    STYLE,
    SU,
    SUCKS,
    SUPPLIES,
    SUPPLY,
    SUPPORT,
    SURF,
    SURGERY,
    SUZUKI,
    SV,
    SWATCH,
    SWIFTCOVER,
    SWISS,
    SX,
    SY,
    SYDNEY,
    SYSTEMS,
    SZ,
    TAB,
    TAIPEI,
    TALK,
    TAOBAO,
    TARGET,
    TATAMOTORS,
    TATAR,
    TATTOO,
    TAX,
    TAXI,
    TC,
    TCI,
    TD,
    TDK,
    TEAM,
    TECH,
    TECHNOLOGY,
    TEL,
    TEMASEK,
    TENNIS,
    TEVA,
    TF,
    TG,
    TH,
    THD,
    THEATER,
    THEATRE,
    TIAA,
    TICKETS,
    TIENDA,
    TIFFANY,
    TIPS,
    TIRES,
    TIROL,
    TJ,
    TJMAXX,
    TJX,
    TK,
    TKMAXX,
    TL,
    TM,
    TMALL,
    TN,
    TO,
    TODAY,
    TOKYO,
    TOOLS,
    TOP,
    TORAY,
    TOSHIBA,
    TOTAL,
    TOURS,
    TOWN,
    TOYOTA,
    TOYS,
    TR,
    TRADE,
    TRADING,
    TRAINING,
    TRAVEL,
    TRAVELCHANNEL,
    TRAVELERS,
    TRAVELERSINSURANCE,
    TRUST,
    TRV,
    TT,
    TUBE,
    TUI,
    TUNES,
    TUSHU,
    TV,
    TVS,
    TW,
    TZ,
    UA,
    UBANK,
    UBS,
    UG,
    UM,
    UK,
    UNICOM,
    UNIVERSITY,
    UNO,
    UOL,
    UPS,
    US,
    UY,
    UZ,
    VA,
    VACATIONS,
    VANA,
    VANGUARD,
    VC,
    VE,
    VEGAS,
    VENTURES,
    VERISIGN,
    VERSICHERUNG,
    VET,
    VG,
    VI,
    VIAJES,
    VIDEO,
    VIG,
    VIKING,
    VILLAS,
    VIN,
    VIP,
    VIRGIN,
    VISA,
    VISION,
    VIVA,
    VIVO,
    VLAANDEREN,
    VN,
    VODKA,
    VOLKSWAGEN,
    VOLVO,
    VOTE,
    VOTING,
    VOTO,
    VOYAGE,
    VU,
    VUELOS,
    WALES,
    WALMART,
    WALTER,
    WANG,
    WANGGOU,
    WATCH,
    WATCHES,
    WEATHER,
    WEATHERCHANNEL,
    WEBCAM,
    WEBER,
    WEBSITE,
    WED,
    WEDDING,
    WEIBO,
    WEIR,
    WF,
    WHOSWHO,
    WIEN,
    WIKI,
    WILLIAMHILL,
    WIN,
    WINDOWS,
    WINE,
    WINNERS,
    WME,
    WOLTERSKLUWER,
    WOODSIDE,
    WORK,
    WORKS,
    WORLD,
    WOW,
    WS,
    WTC,
    WTF,
    XBOX,
    XEROX,
    XFINITY,
    XIHUAN,
    XIN,
    XN,
    XXX,
    XYZ,
    YACHTS,
    YAHOO,
    YAMAXUN,
    YANDEX,
    YE,
    YODOBASHI,
    YOGA,
    YOKOHAMA,
    YOU,
    YOUTUBE,
    YT,
    YUN,
    ZA,
    ZAPPOS,
    ZARA,
    ZERO,
    ZIP,
    ZM,
    ZONE,
    ZUERICH,
    ZW,
}

impl TopLevelDomain {
    pub fn iter() -> Iter<'static, TopLevelDomain> {
        const ALL_TOP_LEVEL_DOMAINS: [TopLevelDomain; 1352] = [
            TopLevelDomain::AAA,
            TopLevelDomain::AARP,
            TopLevelDomain::ABARTH,
            TopLevelDomain::ABB,
            TopLevelDomain::ABBOTT,
            TopLevelDomain::ABBVIE,
            TopLevelDomain::ABC,
            TopLevelDomain::ABLE,
            TopLevelDomain::ABOGADO,
            TopLevelDomain::ABUDHABI,
            TopLevelDomain::AC,
            TopLevelDomain::ACADEMY,
            TopLevelDomain::ACCENTURE,
            TopLevelDomain::ACCOUNTANT,
            TopLevelDomain::ACCOUNTANTS,
            TopLevelDomain::ACO,
            TopLevelDomain::ACTOR,
            TopLevelDomain::AD,
            TopLevelDomain::ADAC,
            TopLevelDomain::ADS,
            TopLevelDomain::ADULT,
            TopLevelDomain::AE,
            TopLevelDomain::AEG,
            TopLevelDomain::AERO,
            TopLevelDomain::AETNA,
            TopLevelDomain::AF,
            TopLevelDomain::AFAMILYCOMPANY,
            TopLevelDomain::AFL,
            TopLevelDomain::AFRICA,
            TopLevelDomain::AG,
            TopLevelDomain::AGAKHAN,
            TopLevelDomain::AGENCY,
            TopLevelDomain::AI,
            TopLevelDomain::AIG,
            TopLevelDomain::AIRBUS,
            TopLevelDomain::AIRFORCE,
            TopLevelDomain::AIRTEL,
            TopLevelDomain::AKDN,
            TopLevelDomain::AL,
            TopLevelDomain::ALFAROMEO,
            TopLevelDomain::ALIBABA,
            TopLevelDomain::ALIPAY,
            TopLevelDomain::ALLFINANZ,
            TopLevelDomain::ALLSTATE,
            TopLevelDomain::ALLY,
            TopLevelDomain::ALSACE,
            TopLevelDomain::ALSTOM,
            TopLevelDomain::AM,
            TopLevelDomain::AMAZON,
            TopLevelDomain::AMERICANEXPRESS,
            TopLevelDomain::AMERICANFAMILY,
            TopLevelDomain::AMEX,
            TopLevelDomain::AMFAM,
            TopLevelDomain::AMICA,
            TopLevelDomain::AMSTERDAM,
            TopLevelDomain::AN,
            TopLevelDomain::ANALYTICS,
            TopLevelDomain::ANDROID,
            TopLevelDomain::ANQUAN,
            TopLevelDomain::ANZ,
            TopLevelDomain::AO,
            TopLevelDomain::AOL,
            TopLevelDomain::APARTMENTS,
            TopLevelDomain::APP,
            TopLevelDomain::APPLE,
            TopLevelDomain::AQ,
            TopLevelDomain::AQUARELLE,
            TopLevelDomain::AR,
            TopLevelDomain::ARAB,
            TopLevelDomain::ARAMCO,
            TopLevelDomain::ARCHI,
            TopLevelDomain::ARMY,
            TopLevelDomain::ARPA,
            TopLevelDomain::ART,
            TopLevelDomain::ARTE,
            TopLevelDomain::AS,
            TopLevelDomain::ASDA,
            TopLevelDomain::ASIA,
            TopLevelDomain::ASSOCIATES,
            TopLevelDomain::AT,
            TopLevelDomain::ATHLETA,
            TopLevelDomain::ATTORNEY,
            TopLevelDomain::AU,
            TopLevelDomain::AUCTION,
            TopLevelDomain::AUDI,
            TopLevelDomain::AUDIBLE,
            TopLevelDomain::AUDIO,
            TopLevelDomain::AUSPOST,
            TopLevelDomain::AUTHOR,
            TopLevelDomain::AUTO,
            TopLevelDomain::AUTOS,
            TopLevelDomain::AVIANCA,
            TopLevelDomain::AW,
            TopLevelDomain::AWS,
            TopLevelDomain::AX,
            TopLevelDomain::AXA,
            TopLevelDomain::AZ,
            TopLevelDomain::AZURE,
            TopLevelDomain::BA,
            TopLevelDomain::BABY,
            TopLevelDomain::BAIDU,
            TopLevelDomain::BANAMEX,
            TopLevelDomain::BANANAREPUBLIC,
            TopLevelDomain::BAND,
            TopLevelDomain::BANK,
            TopLevelDomain::BAR,
            TopLevelDomain::BARCELONA,
            TopLevelDomain::BARCLAYCARD,
            TopLevelDomain::BARCLAYS,
            TopLevelDomain::BAREFOOT,
            TopLevelDomain::BARGAINS,
            TopLevelDomain::BASEBALL,
            TopLevelDomain::BASKETBALL,
            TopLevelDomain::BAUHAUS,
            TopLevelDomain::BAYERN,
            TopLevelDomain::BB,
            TopLevelDomain::BBC,
            TopLevelDomain::BBT,
            TopLevelDomain::BBVA,
            TopLevelDomain::BCG,
            TopLevelDomain::BCN,
            TopLevelDomain::BD,
            TopLevelDomain::BE,
            TopLevelDomain::BEATS,
            TopLevelDomain::BEAUTY,
            TopLevelDomain::BEER,
            TopLevelDomain::BENTLEY,
            TopLevelDomain::BERLIN,
            TopLevelDomain::BEST,
            TopLevelDomain::BESTBUY,
            TopLevelDomain::BET,
            TopLevelDomain::BF,
            TopLevelDomain::BG,
            TopLevelDomain::BH,
            TopLevelDomain::BHARTI,
            TopLevelDomain::BI,
            TopLevelDomain::BIBLE,
            TopLevelDomain::BID,
            TopLevelDomain::BIKE,
            TopLevelDomain::BING,
            TopLevelDomain::BINGO,
            TopLevelDomain::BIO,
            TopLevelDomain::BIZ,
            TopLevelDomain::BJ,
            TopLevelDomain::BL,
            TopLevelDomain::BLACK,
            TopLevelDomain::BLACKFRIDAY,
            TopLevelDomain::BLOCKBUSTER,
            TopLevelDomain::BLOG,
            TopLevelDomain::BLOOMBERG,
            TopLevelDomain::BLUE,
            TopLevelDomain::BM,
            TopLevelDomain::BMS,
            TopLevelDomain::BMW,
            TopLevelDomain::BN,
            TopLevelDomain::BNPPARIBAS,
            TopLevelDomain::BO,
            TopLevelDomain::BOATS,
            TopLevelDomain::BOEHRINGER,
            TopLevelDomain::BOFA,
            TopLevelDomain::BOM,
            TopLevelDomain::BOND,
            TopLevelDomain::BOO,
            TopLevelDomain::BOOK,
            TopLevelDomain::BOOKING,
            TopLevelDomain::BOSCH,
            TopLevelDomain::BOSTIK,
            TopLevelDomain::BOSTON,
            TopLevelDomain::BOT,
            TopLevelDomain::BOUTIQUE,
            TopLevelDomain::BOX,
            TopLevelDomain::BR,
            TopLevelDomain::BRADESCO,
            TopLevelDomain::BRIDGESTONE,
            TopLevelDomain::BROADWAY,
            TopLevelDomain::BROKER,
            TopLevelDomain::BROTHER,
            TopLevelDomain::BRUSSELS,
            TopLevelDomain::BS,
            TopLevelDomain::BT,
            TopLevelDomain::BUDAPEST,
            TopLevelDomain::BUGATTI,
            TopLevelDomain::BUILD,
            TopLevelDomain::BUILDERS,
            TopLevelDomain::BUSINESS,
            TopLevelDomain::BUY,
            TopLevelDomain::BUZZ,
            TopLevelDomain::BV,
            TopLevelDomain::BW,
            TopLevelDomain::BQ,
            TopLevelDomain::BY,
            TopLevelDomain::BZ,
            TopLevelDomain::BZH,
            TopLevelDomain::CA,
            TopLevelDomain::CAB,
            TopLevelDomain::CAFE,
            TopLevelDomain::CAL,
            TopLevelDomain::CALL,
            TopLevelDomain::CALVINKLEIN,
            TopLevelDomain::CAM,
            TopLevelDomain::CAMERA,
            TopLevelDomain::CAMP,
            TopLevelDomain::CANCERRESEARCH,
            TopLevelDomain::CANON,
            TopLevelDomain::CAPETOWN,
            TopLevelDomain::CAPITAL,
            TopLevelDomain::CAPITALONE,
            TopLevelDomain::CAR,
            TopLevelDomain::CARAVAN,
            TopLevelDomain::CARDS,
            TopLevelDomain::CARE,
            TopLevelDomain::CAREER,
            TopLevelDomain::CAREERS,
            TopLevelDomain::CARS,
            TopLevelDomain::CASA,
            TopLevelDomain::CASE,
            TopLevelDomain::CASH,
            TopLevelDomain::CASINO,
            TopLevelDomain::CAT,
            TopLevelDomain::CATERING,
            TopLevelDomain::CATHOLIC,
            TopLevelDomain::CBA,
            TopLevelDomain::CBN,
            TopLevelDomain::CBRE,
            TopLevelDomain::CBS,
            TopLevelDomain::CC,
            TopLevelDomain::CD,
            TopLevelDomain::CENTER,
            TopLevelDomain::CEO,
            TopLevelDomain::CERN,
            TopLevelDomain::CF,
            TopLevelDomain::CFA,
            TopLevelDomain::CFD,
            TopLevelDomain::CG,
            TopLevelDomain::CH,
            TopLevelDomain::CHANEL,
            TopLevelDomain::CHANNEL,
            TopLevelDomain::CHARITY,
            TopLevelDomain::CHASE,
            TopLevelDomain::CHAT,
            TopLevelDomain::CHEAP,
            TopLevelDomain::CHINTAI,
            TopLevelDomain::CHRISTMAS,
            TopLevelDomain::CHROME,
            TopLevelDomain::CHURCH,
            TopLevelDomain::CI,
            TopLevelDomain::CIPRIANI,
            TopLevelDomain::CIRCLE,
            TopLevelDomain::CISCO,
            TopLevelDomain::CITADEL,
            TopLevelDomain::CITI,
            TopLevelDomain::CITIC,
            TopLevelDomain::CITY,
            TopLevelDomain::CITYEATS,
            TopLevelDomain::CK,
            TopLevelDomain::CL,
            TopLevelDomain::CLAIMS,
            TopLevelDomain::CLEANING,
            TopLevelDomain::CLICK,
            TopLevelDomain::CLINIC,
            TopLevelDomain::CLINIQUE,
            TopLevelDomain::CLOTHING,
            TopLevelDomain::CLOUD,
            TopLevelDomain::CLUB,
            TopLevelDomain::CLUBMED,
            TopLevelDomain::CM,
            TopLevelDomain::CN,
            TopLevelDomain::CO,
            TopLevelDomain::COACH,
            TopLevelDomain::CODES,
            TopLevelDomain::COFFEE,
            TopLevelDomain::COLLEGE,
            TopLevelDomain::COLOGNE,
            TopLevelDomain::COM,
            TopLevelDomain::COMCAST,
            TopLevelDomain::COMMBANK,
            TopLevelDomain::COMMUNITY,
            TopLevelDomain::COMPANY,
            TopLevelDomain::COMPARE,
            TopLevelDomain::COMPUTER,
            TopLevelDomain::COMSEC,
            TopLevelDomain::CONDOS,
            TopLevelDomain::CONSTRUCTION,
            TopLevelDomain::CONSULTING,
            TopLevelDomain::CONTACT,
            TopLevelDomain::CONTRACTORS,
            TopLevelDomain::COOKING,
            TopLevelDomain::COOKINGCHANNEL,
            TopLevelDomain::COOL,
            TopLevelDomain::COOP,
            TopLevelDomain::CORSICA,
            TopLevelDomain::COUNTRY,
            TopLevelDomain::COUPON,
            TopLevelDomain::COUPONS,
            TopLevelDomain::COURSES,
            TopLevelDomain::CPA,
            TopLevelDomain::CR,
            TopLevelDomain::CREDIT,
            TopLevelDomain::CREDITCARD,
            TopLevelDomain::CREDITUNION,
            TopLevelDomain::CRICKET,
            TopLevelDomain::CROWN,
            TopLevelDomain::CRS,
            TopLevelDomain::CRUISE,
            TopLevelDomain::CRUISES,
            TopLevelDomain::CSC,
            TopLevelDomain::CU,
            TopLevelDomain::CUISINELLA,
            TopLevelDomain::CV,
            TopLevelDomain::CW,
            TopLevelDomain::CX,
            TopLevelDomain::CY,
            TopLevelDomain::CYMRU,
            TopLevelDomain::CYOU,
            TopLevelDomain::CZ,
            TopLevelDomain::DABUR,
            TopLevelDomain::DAD,
            TopLevelDomain::DANCE,
            TopLevelDomain::DATA,
            TopLevelDomain::DATE,
            TopLevelDomain::DATING,
            TopLevelDomain::DATSUN,
            TopLevelDomain::DAY,
            TopLevelDomain::DCLK,
            TopLevelDomain::DDS,
            TopLevelDomain::DE,
            TopLevelDomain::DEAL,
            TopLevelDomain::DEALER,
            TopLevelDomain::DEALS,
            TopLevelDomain::DEGREE,
            TopLevelDomain::DELIVERY,
            TopLevelDomain::DELL,
            TopLevelDomain::DELOITTE,
            TopLevelDomain::DELTA,
            TopLevelDomain::DEMOCRAT,
            TopLevelDomain::DENTAL,
            TopLevelDomain::DENTIST,
            TopLevelDomain::DESI,
            TopLevelDomain::DESIGN,
            TopLevelDomain::DEV,
            TopLevelDomain::DHL,
            TopLevelDomain::DIAMONDS,
            TopLevelDomain::DIET,
            TopLevelDomain::DIGITAL,
            TopLevelDomain::DIRECT,
            TopLevelDomain::DIRECTORY,
            TopLevelDomain::DISCOUNT,
            TopLevelDomain::DISCOVER,
            TopLevelDomain::DISH,
            TopLevelDomain::DIY,
            TopLevelDomain::DJ,
            TopLevelDomain::DK,
            TopLevelDomain::DM,
            TopLevelDomain::DNP,
            TopLevelDomain::DO,
            TopLevelDomain::DOCS,
            TopLevelDomain::DOCTOR,
            TopLevelDomain::DOG,
            TopLevelDomain::DOMAINS,
            TopLevelDomain::DOT,
            TopLevelDomain::DOWNLOAD,
            TopLevelDomain::DRIVE,
            TopLevelDomain::DTV,
            TopLevelDomain::DUBAI,
            TopLevelDomain::DUCK,
            TopLevelDomain::DUNLOP,
            TopLevelDomain::DUPONT,
            TopLevelDomain::DURBAN,
            TopLevelDomain::DVAG,
            TopLevelDomain::DVR,
            TopLevelDomain::DZ,
            TopLevelDomain::EARTH,
            TopLevelDomain::EAT,
            TopLevelDomain::EC,
            TopLevelDomain::ECO,
            TopLevelDomain::EDEKA,
            TopLevelDomain::EDU,
            TopLevelDomain::EDUCATION,
            TopLevelDomain::EE,
            TopLevelDomain::EG,
            TopLevelDomain::EH,
            TopLevelDomain::EMAIL,
            TopLevelDomain::EMERCK,
            TopLevelDomain::ENERGY,
            TopLevelDomain::ENGINEER,
            TopLevelDomain::ENGINEERING,
            TopLevelDomain::ENTERPRISES,
            TopLevelDomain::EPSON,
            TopLevelDomain::EQUIPMENT,
            TopLevelDomain::ER,
            TopLevelDomain::ERICSSON,
            TopLevelDomain::ERNI,
            TopLevelDomain::ES,
            TopLevelDomain::ESQ,
            TopLevelDomain::ESTATE,
            TopLevelDomain::ET,
            TopLevelDomain::ETISALAT,
            TopLevelDomain::EU,
            TopLevelDomain::EUROVISION,
            TopLevelDomain::EUS,
            TopLevelDomain::EVENTS,
            TopLevelDomain::EXCHANGE,
            TopLevelDomain::EXPERT,
            TopLevelDomain::EXPOSED,
            TopLevelDomain::EXPRESS,
            TopLevelDomain::EXTRASPACE,
            TopLevelDomain::FAGE,
            TopLevelDomain::FAIL,
            TopLevelDomain::FAIRWINDS,
            TopLevelDomain::FAITH,
            TopLevelDomain::FAMILY,
            TopLevelDomain::FAN,
            TopLevelDomain::FANS,
            TopLevelDomain::FARM,
            TopLevelDomain::FARMERS,
            TopLevelDomain::FASHION,
            TopLevelDomain::FAST,
            TopLevelDomain::FEDEX,
            TopLevelDomain::FEEDBACK,
            TopLevelDomain::FERRARI,
            TopLevelDomain::FERRERO,
            TopLevelDomain::FI,
            TopLevelDomain::FIAT,
            TopLevelDomain::FIDELITY,
            TopLevelDomain::FIDO,
            TopLevelDomain::FILM,
            TopLevelDomain::FINAL,
            TopLevelDomain::FINANCE,
            TopLevelDomain::FINANCIAL,
            TopLevelDomain::FIRE,
            TopLevelDomain::FIRESTONE,
            TopLevelDomain::FIRMDALE,
            TopLevelDomain::FISH,
            TopLevelDomain::FISHING,
            TopLevelDomain::FIT,
            TopLevelDomain::FITNESS,
            TopLevelDomain::FJ,
            TopLevelDomain::FK,
            TopLevelDomain::FLICKR,
            TopLevelDomain::FLIGHTS,
            TopLevelDomain::FLIR,
            TopLevelDomain::FLORIST,
            TopLevelDomain::FLOWERS,
            TopLevelDomain::FLY,
            TopLevelDomain::FM,
            TopLevelDomain::FO,
            TopLevelDomain::FOO,
            TopLevelDomain::FOOD,
            TopLevelDomain::FOODNETWORK,
            TopLevelDomain::FOOTBALL,
            TopLevelDomain::FORD,
            TopLevelDomain::FOREX,
            TopLevelDomain::FORSALE,
            TopLevelDomain::FORUM,
            TopLevelDomain::FOUNDATION,
            TopLevelDomain::FOX,
            TopLevelDomain::FR,
            TopLevelDomain::FREE,
            TopLevelDomain::FRESENIUS,
            TopLevelDomain::FRL,
            TopLevelDomain::FROGANS,
            TopLevelDomain::FRONTDOOR,
            TopLevelDomain::FRONTIER,
            TopLevelDomain::FTR,
            TopLevelDomain::FUJITSU,
            TopLevelDomain::FUN,
            TopLevelDomain::FUND,
            TopLevelDomain::FURNITURE,
            TopLevelDomain::FUTBOL,
            TopLevelDomain::FYI,
            TopLevelDomain::GA,
            TopLevelDomain::GAL,
            TopLevelDomain::GALLERY,
            TopLevelDomain::GALLO,
            TopLevelDomain::GALLUP,
            TopLevelDomain::GAME,
            TopLevelDomain::GAMES,
            TopLevelDomain::GAP,
            TopLevelDomain::GARDEN,
            TopLevelDomain::GAY,
            TopLevelDomain::GB,
            TopLevelDomain::GBIZ,
            TopLevelDomain::GD,
            TopLevelDomain::GDN,
            TopLevelDomain::GE,
            TopLevelDomain::GEA,
            TopLevelDomain::GENT,
            TopLevelDomain::GENTING,
            TopLevelDomain::GEORGE,
            TopLevelDomain::GF,
            TopLevelDomain::GG,
            TopLevelDomain::GGEE,
            TopLevelDomain::GH,
            TopLevelDomain::GI,
            TopLevelDomain::GIFT,
            TopLevelDomain::GIFTS,
            TopLevelDomain::GIVES,
            TopLevelDomain::GIVING,
            TopLevelDomain::GL,
            TopLevelDomain::GLADE,
            TopLevelDomain::GLASS,
            TopLevelDomain::GLE,
            TopLevelDomain::GLOBAL,
            TopLevelDomain::GLOBO,
            TopLevelDomain::GM,
            TopLevelDomain::GMAIL,
            TopLevelDomain::GMBH,
            TopLevelDomain::GMO,
            TopLevelDomain::GMX,
            TopLevelDomain::GN,
            TopLevelDomain::GODADDY,
            TopLevelDomain::GOLD,
            TopLevelDomain::GOLDPOINT,
            TopLevelDomain::GOLF,
            TopLevelDomain::GOO,
            TopLevelDomain::GOODYEAR,
            TopLevelDomain::GOOG,
            TopLevelDomain::GOOGLE,
            TopLevelDomain::GOP,
            TopLevelDomain::GOT,
            TopLevelDomain::GOV,
            TopLevelDomain::GP,
            TopLevelDomain::GQ,
            TopLevelDomain::GR,
            TopLevelDomain::GRAINGER,
            TopLevelDomain::GRAPHICS,
            TopLevelDomain::GRATIS,
            TopLevelDomain::GREEN,
            TopLevelDomain::GRIPE,
            TopLevelDomain::GROCERY,
            TopLevelDomain::GROUP,
            TopLevelDomain::GS,
            TopLevelDomain::GT,
            TopLevelDomain::GU,
            TopLevelDomain::GUARDIAN,
            TopLevelDomain::GUCCI,
            TopLevelDomain::GUGE,
            TopLevelDomain::GUIDE,
            TopLevelDomain::GUITARS,
            TopLevelDomain::GURU,
            TopLevelDomain::GW,
            TopLevelDomain::GY,
            TopLevelDomain::HAIR,
            TopLevelDomain::HAMBURG,
            TopLevelDomain::HANGOUT,
            TopLevelDomain::HAUS,
            TopLevelDomain::HBO,
            TopLevelDomain::HDFC,
            TopLevelDomain::HDFCBANK,
            TopLevelDomain::HEALTH,
            TopLevelDomain::HEALTHCARE,
            TopLevelDomain::HELP,
            TopLevelDomain::HELSINKI,
            TopLevelDomain::HERE,
            TopLevelDomain::HERMES,
            TopLevelDomain::HGTV,
            TopLevelDomain::HIPHOP,
            TopLevelDomain::HISAMITSU,
            TopLevelDomain::HITACHI,
            TopLevelDomain::HIV,
            TopLevelDomain::HK,
            TopLevelDomain::HKT,
            TopLevelDomain::HM,
            TopLevelDomain::HN,
            TopLevelDomain::HOCKEY,
            TopLevelDomain::HOLDINGS,
            TopLevelDomain::HOLIDAY,
            TopLevelDomain::HOMEDEPOT,
            TopLevelDomain::HOMEGOODS,
            TopLevelDomain::HOMES,
            TopLevelDomain::HOMESENSE,
            TopLevelDomain::HONDA,
            TopLevelDomain::HORSE,
            TopLevelDomain::HOSPITAL,
            TopLevelDomain::HOST,
            TopLevelDomain::HOSTING,
            TopLevelDomain::HOT,
            TopLevelDomain::HOTELES,
            TopLevelDomain::HOTELS,
            TopLevelDomain::HOTMAIL,
            TopLevelDomain::HOUSE,
            TopLevelDomain::HOW,
            TopLevelDomain::HR,
            TopLevelDomain::HSBC,
            TopLevelDomain::HT,
            TopLevelDomain::HU,
            TopLevelDomain::HUGHES,
            TopLevelDomain::HYATT,
            TopLevelDomain::HYUNDAI,
            TopLevelDomain::IBM,
            TopLevelDomain::ICBC,
            TopLevelDomain::ICE,
            TopLevelDomain::ICU,
            TopLevelDomain::ID,
            TopLevelDomain::IE,
            TopLevelDomain::IEEE,
            TopLevelDomain::IFM,
            TopLevelDomain::IKANO,
            TopLevelDomain::IL,
            TopLevelDomain::IM,
            TopLevelDomain::IMAMAT,
            TopLevelDomain::IMDB,
            TopLevelDomain::IMMO,
            TopLevelDomain::IMMOBILIEN,
            TopLevelDomain::IN,
            TopLevelDomain::INC,
            TopLevelDomain::INDUSTRIES,
            TopLevelDomain::INFINITI,
            TopLevelDomain::INFO,
            TopLevelDomain::ING,
            TopLevelDomain::INK,
            TopLevelDomain::INSTITUTE,
            TopLevelDomain::INSURANCE,
            TopLevelDomain::INSURE,
            TopLevelDomain::INT,
            TopLevelDomain::INTERNATIONAL,
            TopLevelDomain::INTUIT,
            TopLevelDomain::INVESTMENTS,
            TopLevelDomain::IO,
            TopLevelDomain::IPIRANGA,
            TopLevelDomain::IQ,
            TopLevelDomain::IR,
            TopLevelDomain::IRISH,
            TopLevelDomain::IS,
            TopLevelDomain::ISMAILI,
            TopLevelDomain::IST,
            TopLevelDomain::ISTANBUL,
            TopLevelDomain::IT,
            TopLevelDomain::ITAU,
            TopLevelDomain::ITV,
            TopLevelDomain::JAGUAR,
            TopLevelDomain::JAVA,
            TopLevelDomain::JCB,
            TopLevelDomain::JE,
            TopLevelDomain::JEEP,
            TopLevelDomain::JETZT,
            TopLevelDomain::JEWELRY,
            TopLevelDomain::JIO,
            TopLevelDomain::JLL,
            TopLevelDomain::JM,
            TopLevelDomain::JMP,
            TopLevelDomain::JNJ,
            TopLevelDomain::JO,
            TopLevelDomain::JOBS,
            TopLevelDomain::JOBURG,
            TopLevelDomain::JOT,
            TopLevelDomain::JOY,
            TopLevelDomain::JP,
            TopLevelDomain::JPMORGAN,
            TopLevelDomain::JPRS,
            TopLevelDomain::JUEGOS,
            TopLevelDomain::JUNIPER,
            TopLevelDomain::KAUFEN,
            TopLevelDomain::KDDI,
            TopLevelDomain::KE,
            TopLevelDomain::KERRYHOTELS,
            TopLevelDomain::KERRYLOGISTICS,
            TopLevelDomain::KERRYPROPERTIES,
            TopLevelDomain::KFH,
            TopLevelDomain::KG,
            TopLevelDomain::KH,
            TopLevelDomain::KI,
            TopLevelDomain::KIA,
            TopLevelDomain::KIM,
            TopLevelDomain::KINDER,
            TopLevelDomain::KINDLE,
            TopLevelDomain::KITCHEN,
            TopLevelDomain::KIWI,
            TopLevelDomain::KM,
            TopLevelDomain::KN,
            TopLevelDomain::KOELN,
            TopLevelDomain::KOMATSU,
            TopLevelDomain::KOSHER,
            TopLevelDomain::KP,
            TopLevelDomain::KPMG,
            TopLevelDomain::KPN,
            TopLevelDomain::KR,
            TopLevelDomain::KRD,
            TopLevelDomain::KRED,
            TopLevelDomain::KUOKGROUP,
            TopLevelDomain::KW,
            TopLevelDomain::KY,
            TopLevelDomain::KYOTO,
            TopLevelDomain::KZ,
            TopLevelDomain::LA,
            TopLevelDomain::LACAIXA,
            TopLevelDomain::LAMBORGHINI,
            TopLevelDomain::LAMER,
            TopLevelDomain::LANCASTER,
            TopLevelDomain::LANCIA,
            TopLevelDomain::LAND,
            TopLevelDomain::LANDROVER,
            TopLevelDomain::LANXESS,
            TopLevelDomain::LASALLE,
            TopLevelDomain::LAT,
            TopLevelDomain::LATINO,
            TopLevelDomain::LATROBE,
            TopLevelDomain::LAW,
            TopLevelDomain::LAWYER,
            TopLevelDomain::LB,
            TopLevelDomain::LC,
            TopLevelDomain::LDS,
            TopLevelDomain::LEASE,
            TopLevelDomain::LECLERC,
            TopLevelDomain::LEFRAK,
            TopLevelDomain::LEGAL,
            TopLevelDomain::LEGO,
            TopLevelDomain::LEXUS,
            TopLevelDomain::LGBT,
            TopLevelDomain::LI,
            TopLevelDomain::LIDL,
            TopLevelDomain::LIFE,
            TopLevelDomain::LIFEINSURANCE,
            TopLevelDomain::LIFESTYLE,
            TopLevelDomain::LIGHTING,
            TopLevelDomain::LIKE,
            TopLevelDomain::LILLY,
            TopLevelDomain::LIMITED,
            TopLevelDomain::LIMO,
            TopLevelDomain::LINCOLN,
            TopLevelDomain::LINDE,
            TopLevelDomain::LINK,
            TopLevelDomain::LIPSY,
            TopLevelDomain::LIVE,
            TopLevelDomain::LIVING,
            TopLevelDomain::LIXIL,
            TopLevelDomain::LK,
            TopLevelDomain::LLC,
            TopLevelDomain::LLP,
            TopLevelDomain::LOAN,
            TopLevelDomain::LOANS,
            TopLevelDomain::LOCKER,
            TopLevelDomain::LOCUS,
            TopLevelDomain::LOFT,
            TopLevelDomain::LOL,
            TopLevelDomain::LONDON,
            TopLevelDomain::LOTTE,
            TopLevelDomain::LOTTO,
            TopLevelDomain::LOVE,
            TopLevelDomain::LPL,
            TopLevelDomain::LPLFINANCIAL,
            TopLevelDomain::LR,
            TopLevelDomain::LS,
            TopLevelDomain::LT,
            TopLevelDomain::LTD,
            TopLevelDomain::LTDA,
            TopLevelDomain::LU,
            TopLevelDomain::LUNDBECK,
            TopLevelDomain::LUXE,
            TopLevelDomain::LUXURY,
            TopLevelDomain::LV,
            TopLevelDomain::LY,
            TopLevelDomain::MA,
            TopLevelDomain::MACYS,
            TopLevelDomain::MADRID,
            TopLevelDomain::MAIF,
            TopLevelDomain::MAISON,
            TopLevelDomain::MAKEUP,
            TopLevelDomain::MAN,
            TopLevelDomain::MANAGEMENT,
            TopLevelDomain::MANGO,
            TopLevelDomain::MAP,
            TopLevelDomain::MARKET,
            TopLevelDomain::MARKETING,
            TopLevelDomain::MARKETS,
            TopLevelDomain::MARRIOTT,
            TopLevelDomain::MARSHALLS,
            TopLevelDomain::MASERATI,
            TopLevelDomain::MATTEL,
            TopLevelDomain::MBA,
            TopLevelDomain::MC,
            TopLevelDomain::MCKINSEY,
            TopLevelDomain::MD,
            TopLevelDomain::ME,
            TopLevelDomain::MED,
            TopLevelDomain::MEDIA,
            TopLevelDomain::MEET,
            TopLevelDomain::MELBOURNE,
            TopLevelDomain::MEME,
            TopLevelDomain::MEMORIAL,
            TopLevelDomain::MEN,
            TopLevelDomain::MENU,
            TopLevelDomain::MERCKMSD,
            TopLevelDomain::MF,
            TopLevelDomain::MG,
            TopLevelDomain::MH,
            TopLevelDomain::MI,
            TopLevelDomain::MIAMI,
            TopLevelDomain::MICROSOFT,
            TopLevelDomain::MIL,
            TopLevelDomain::MINI,
            TopLevelDomain::MINT,
            TopLevelDomain::MIT,
            TopLevelDomain::MITSUBISHI,
            TopLevelDomain::MK,
            TopLevelDomain::ML,
            TopLevelDomain::MLB,
            TopLevelDomain::MLS,
            TopLevelDomain::MM,
            TopLevelDomain::MMA,
            TopLevelDomain::MN,
            TopLevelDomain::MO,
            TopLevelDomain::MOBI,
            TopLevelDomain::MOBILE,
            TopLevelDomain::MODA,
            TopLevelDomain::MOE,
            TopLevelDomain::MOI,
            TopLevelDomain::MOM,
            TopLevelDomain::MONASH,
            TopLevelDomain::MONEY,
            TopLevelDomain::MONSTER,
            TopLevelDomain::MORMON,
            TopLevelDomain::MORTGAGE,
            TopLevelDomain::MOSCOW,
            TopLevelDomain::MOTO,
            TopLevelDomain::MOTORCYCLES,
            TopLevelDomain::MOV,
            TopLevelDomain::MOVIE,
            TopLevelDomain::MP,
            TopLevelDomain::MQ,
            TopLevelDomain::MR,
            TopLevelDomain::MS,
            TopLevelDomain::MSD,
            TopLevelDomain::MT,
            TopLevelDomain::MTN,
            TopLevelDomain::MTR,
            TopLevelDomain::MU,
            TopLevelDomain::MUSEUM,
            TopLevelDomain::MUTUAL,
            TopLevelDomain::MV,
            TopLevelDomain::MW,
            TopLevelDomain::MX,
            TopLevelDomain::MY,
            TopLevelDomain::MZ,
            TopLevelDomain::NA,
            TopLevelDomain::NAB,
            TopLevelDomain::NAGOYA,
            TopLevelDomain::NAME,
            TopLevelDomain::NATURA,
            TopLevelDomain::NAVY,
            TopLevelDomain::NBA,
            TopLevelDomain::NC,
            TopLevelDomain::NE,
            TopLevelDomain::NEC,
            TopLevelDomain::NET,
            TopLevelDomain::NETBANK,
            TopLevelDomain::NETFLIX,
            TopLevelDomain::NETWORK,
            TopLevelDomain::NEUSTAR,
            TopLevelDomain::NEW,
            TopLevelDomain::NEWS,
            TopLevelDomain::NEXT,
            TopLevelDomain::NEXTDIRECT,
            TopLevelDomain::NEXUS,
            TopLevelDomain::NF,
            TopLevelDomain::NFL,
            TopLevelDomain::NG,
            TopLevelDomain::NGO,
            TopLevelDomain::NHK,
            TopLevelDomain::NI,
            TopLevelDomain::NICO,
            TopLevelDomain::NIKE,
            TopLevelDomain::NIKON,
            TopLevelDomain::NINJA,
            TopLevelDomain::NISSAN,
            TopLevelDomain::NISSAY,
            TopLevelDomain::NL,
            TopLevelDomain::NO,
            TopLevelDomain::NOKIA,
            TopLevelDomain::NORTHWESTERNMUTUAL,
            TopLevelDomain::NORTON,
            TopLevelDomain::NOW,
            TopLevelDomain::NOWRUZ,
            TopLevelDomain::NOWTV,
            TopLevelDomain::NP,
            TopLevelDomain::NR,
            TopLevelDomain::NRA,
            TopLevelDomain::NRW,
            TopLevelDomain::NTT,
            TopLevelDomain::NU,
            TopLevelDomain::NYC,
            TopLevelDomain::NZ,
            TopLevelDomain::OBI,
            TopLevelDomain::OBSERVER,
            TopLevelDomain::OFF,
            TopLevelDomain::OFFICE,
            TopLevelDomain::OKINAWA,
            TopLevelDomain::OLAYAN,
            TopLevelDomain::OLAYANGROUP,
            TopLevelDomain::OLDNAVY,
            TopLevelDomain::OLLO,
            TopLevelDomain::OM,
            TopLevelDomain::OMEGA,
            TopLevelDomain::ONE,
            TopLevelDomain::ONG,
            TopLevelDomain::ONL,
            TopLevelDomain::ONLINE,
            TopLevelDomain::OOO,
            TopLevelDomain::OPEN,
            TopLevelDomain::ORACLE,
            TopLevelDomain::ORANGE,
            TopLevelDomain::ORG,
            TopLevelDomain::ORGANIC,
            TopLevelDomain::ORIGINS,
            TopLevelDomain::OSAKA,
            TopLevelDomain::OTSUKA,
            TopLevelDomain::OTT,
            TopLevelDomain::OVH,
            TopLevelDomain::PA,
            TopLevelDomain::PAGE,
            TopLevelDomain::PANASONIC,
            TopLevelDomain::PARIS,
            TopLevelDomain::PARS,
            TopLevelDomain::PARTNERS,
            TopLevelDomain::PARTS,
            TopLevelDomain::PARTY,
            TopLevelDomain::PASSAGENS,
            TopLevelDomain::PAY,
            TopLevelDomain::PCCW,
            TopLevelDomain::PE,
            TopLevelDomain::PET,
            TopLevelDomain::PF,
            TopLevelDomain::PFIZER,
            TopLevelDomain::PG,
            TopLevelDomain::PH,
            TopLevelDomain::PHARMACY,
            TopLevelDomain::PHD,
            TopLevelDomain::PHILIPS,
            TopLevelDomain::PHONE,
            TopLevelDomain::PHOTO,
            TopLevelDomain::PHOTOGRAPHY,
            TopLevelDomain::PHOTOS,
            TopLevelDomain::PHYSIO,
            TopLevelDomain::PICS,
            TopLevelDomain::PICTET,
            TopLevelDomain::PICTURES,
            TopLevelDomain::PID,
            TopLevelDomain::PIN,
            TopLevelDomain::PING,
            TopLevelDomain::PINK,
            TopLevelDomain::PIONEER,
            TopLevelDomain::PIZZA,
            TopLevelDomain::PK,
            TopLevelDomain::PL,
            TopLevelDomain::PLACE,
            TopLevelDomain::PLAY,
            TopLevelDomain::PLAYSTATION,
            TopLevelDomain::PLUMBING,
            TopLevelDomain::PLUS,
            TopLevelDomain::PM,
            TopLevelDomain::PN,
            TopLevelDomain::PNC,
            TopLevelDomain::POHL,
            TopLevelDomain::POKER,
            TopLevelDomain::POLITIE,
            TopLevelDomain::PORN,
            TopLevelDomain::POST,
            TopLevelDomain::PR,
            TopLevelDomain::PRAMERICA,
            TopLevelDomain::PRAXI,
            TopLevelDomain::PRESS,
            TopLevelDomain::PRIME,
            TopLevelDomain::PRO,
            TopLevelDomain::PROD,
            TopLevelDomain::PRODUCTIONS,
            TopLevelDomain::PROF,
            TopLevelDomain::PROGRESSIVE,
            TopLevelDomain::PROMO,
            TopLevelDomain::PROPERTIES,
            TopLevelDomain::PROPERTY,
            TopLevelDomain::PROTECTION,
            TopLevelDomain::PRU,
            TopLevelDomain::PRUDENTIAL,
            TopLevelDomain::PS,
            TopLevelDomain::PT,
            TopLevelDomain::PUB,
            TopLevelDomain::PW,
            TopLevelDomain::PWC,
            TopLevelDomain::PY,
            TopLevelDomain::QA,
            TopLevelDomain::QPON,
            TopLevelDomain::QUEBEC,
            TopLevelDomain::QUEST,
            TopLevelDomain::QVC,
            TopLevelDomain::RACING,
            TopLevelDomain::RADIO,
            TopLevelDomain::RAID,
            TopLevelDomain::RE,
            TopLevelDomain::READ,
            TopLevelDomain::REALESTATE,
            TopLevelDomain::REALTOR,
            TopLevelDomain::REALTY,
            TopLevelDomain::RECIPES,
            TopLevelDomain::RED,
            TopLevelDomain::REDSTONE,
            TopLevelDomain::REDUMBRELLA,
            TopLevelDomain::REHAB,
            TopLevelDomain::REISE,
            TopLevelDomain::REISEN,
            TopLevelDomain::REIT,
            TopLevelDomain::RELIANCE,
            TopLevelDomain::REN,
            TopLevelDomain::RENT,
            TopLevelDomain::RENTALS,
            TopLevelDomain::REPAIR,
            TopLevelDomain::REPORT,
            TopLevelDomain::REPUBLICAN,
            TopLevelDomain::REST,
            TopLevelDomain::RESTAURANT,
            TopLevelDomain::REVIEW,
            TopLevelDomain::REVIEWS,
            TopLevelDomain::REXROTH,
            TopLevelDomain::RICH,
            TopLevelDomain::RICHARDLI,
            TopLevelDomain::RICOH,
            TopLevelDomain::RIL,
            TopLevelDomain::RIO,
            TopLevelDomain::RIP,
            TopLevelDomain::RMIT,
            TopLevelDomain::RO,
            TopLevelDomain::ROCHER,
            TopLevelDomain::ROCKS,
            TopLevelDomain::RODEO,
            TopLevelDomain::ROGERS,
            TopLevelDomain::ROOM,
            TopLevelDomain::RS,
            TopLevelDomain::RSVP,
            TopLevelDomain::RU,
            TopLevelDomain::RUGBY,
            TopLevelDomain::RUHR,
            TopLevelDomain::RUN,
            TopLevelDomain::RW,
            TopLevelDomain::RWE,
            TopLevelDomain::RYUKYU,
            TopLevelDomain::SA,
            TopLevelDomain::SAARLAND,
            TopLevelDomain::SAFE,
            TopLevelDomain::SAFETY,
            TopLevelDomain::SAKURA,
            TopLevelDomain::SALE,
            TopLevelDomain::SALON,
            TopLevelDomain::SAMSCLUB,
            TopLevelDomain::SAMSUNG,
            TopLevelDomain::SANDVIK,
            TopLevelDomain::SANDVIKCOROMANT,
            TopLevelDomain::SANOFI,
            TopLevelDomain::SAP,
            TopLevelDomain::SARL,
            TopLevelDomain::SAS,
            TopLevelDomain::SAVE,
            TopLevelDomain::SAXO,
            TopLevelDomain::SB,
            TopLevelDomain::SBI,
            TopLevelDomain::SBS,
            TopLevelDomain::SC,
            TopLevelDomain::SCA,
            TopLevelDomain::SCB,
            TopLevelDomain::SCHAEFFLER,
            TopLevelDomain::SCHMIDT,
            TopLevelDomain::SCHOLARSHIPS,
            TopLevelDomain::SCHOOL,
            TopLevelDomain::SCHULE,
            TopLevelDomain::SCHWARZ,
            TopLevelDomain::SCIENCE,
            TopLevelDomain::SCJOHNSON,
            TopLevelDomain::SCOT,
            TopLevelDomain::SD,
            TopLevelDomain::SE,
            TopLevelDomain::SEARCH,
            TopLevelDomain::SEAT,
            TopLevelDomain::SECURE,
            TopLevelDomain::SECURITY,
            TopLevelDomain::SEEK,
            TopLevelDomain::SELECT,
            TopLevelDomain::SENER,
            TopLevelDomain::SERVICES,
            TopLevelDomain::SES,
            TopLevelDomain::SEVEN,
            TopLevelDomain::SEW,
            TopLevelDomain::SEX,
            TopLevelDomain::SEXY,
            TopLevelDomain::SFR,
            TopLevelDomain::SG,
            TopLevelDomain::SH,
            TopLevelDomain::SHANGRILA,
            TopLevelDomain::SHARP,
            TopLevelDomain::SHAW,
            TopLevelDomain::SHELL,
            TopLevelDomain::SHIA,
            TopLevelDomain::SHIKSHA,
            TopLevelDomain::SHOES,
            TopLevelDomain::SHOP,
            TopLevelDomain::SHOPPING,
            TopLevelDomain::SHOUJI,
            TopLevelDomain::SHOW,
            TopLevelDomain::SHOWTIME,
            TopLevelDomain::SI,
            TopLevelDomain::SILK,
            TopLevelDomain::SINA,
            TopLevelDomain::SINGLES,
            TopLevelDomain::SITE,
            TopLevelDomain::SJ,
            TopLevelDomain::SK,
            TopLevelDomain::SKI,
            TopLevelDomain::SKIN,
            TopLevelDomain::SKY,
            TopLevelDomain::SKYPE,
            TopLevelDomain::SL,
            TopLevelDomain::SLING,
            TopLevelDomain::SM,
            TopLevelDomain::SMART,
            TopLevelDomain::SMILE,
            TopLevelDomain::SN,
            TopLevelDomain::SNCF,
            TopLevelDomain::SO,
            TopLevelDomain::SOCCER,
            TopLevelDomain::SOCIAL,
            TopLevelDomain::SOFTBANK,
            TopLevelDomain::SOFTWARE,
            TopLevelDomain::SOHU,
            TopLevelDomain::SOLAR,
            TopLevelDomain::SOLUTIONS,
            TopLevelDomain::SONG,
            TopLevelDomain::SONY,
            TopLevelDomain::SOY,
            TopLevelDomain::SPA,
            TopLevelDomain::SPACE,
            TopLevelDomain::SPORT,
            TopLevelDomain::SPOT,
            TopLevelDomain::SR,
            TopLevelDomain::SRL,
            TopLevelDomain::SS,
            TopLevelDomain::ST,
            TopLevelDomain::STADA,
            TopLevelDomain::STAPLES,
            TopLevelDomain::STAR,
            TopLevelDomain::STATEBANK,
            TopLevelDomain::STATEFARM,
            TopLevelDomain::STC,
            TopLevelDomain::STCGROUP,
            TopLevelDomain::STOCKHOLM,
            TopLevelDomain::STORAGE,
            TopLevelDomain::STORE,
            TopLevelDomain::STREAM,
            TopLevelDomain::STUDIO,
            TopLevelDomain::STUDY,
            TopLevelDomain::STYLE,
            TopLevelDomain::SU,
            TopLevelDomain::SUCKS,
            TopLevelDomain::SUPPLIES,
            TopLevelDomain::SUPPLY,
            TopLevelDomain::SUPPORT,
            TopLevelDomain::SURF,
            TopLevelDomain::SURGERY,
            TopLevelDomain::SUZUKI,
            TopLevelDomain::SV,
            TopLevelDomain::SWATCH,
            TopLevelDomain::SWIFTCOVER,
            TopLevelDomain::SWISS,
            TopLevelDomain::SX,
            TopLevelDomain::SY,
            TopLevelDomain::SYDNEY,
            TopLevelDomain::SYSTEMS,
            TopLevelDomain::SZ,
            TopLevelDomain::TAB,
            TopLevelDomain::TAIPEI,
            TopLevelDomain::TALK,
            TopLevelDomain::TAOBAO,
            TopLevelDomain::TARGET,
            TopLevelDomain::TATAMOTORS,
            TopLevelDomain::TATAR,
            TopLevelDomain::TATTOO,
            TopLevelDomain::TAX,
            TopLevelDomain::TAXI,
            TopLevelDomain::TC,
            TopLevelDomain::TCI,
            TopLevelDomain::TD,
            TopLevelDomain::TDK,
            TopLevelDomain::TEAM,
            TopLevelDomain::TECH,
            TopLevelDomain::TECHNOLOGY,
            TopLevelDomain::TEL,
            TopLevelDomain::TEMASEK,
            TopLevelDomain::TENNIS,
            TopLevelDomain::TEVA,
            TopLevelDomain::TF,
            TopLevelDomain::TG,
            TopLevelDomain::TH,
            TopLevelDomain::THD,
            TopLevelDomain::THEATER,
            TopLevelDomain::THEATRE,
            TopLevelDomain::TIAA,
            TopLevelDomain::TICKETS,
            TopLevelDomain::TIENDA,
            TopLevelDomain::TIFFANY,
            TopLevelDomain::TIPS,
            TopLevelDomain::TIRES,
            TopLevelDomain::TIROL,
            TopLevelDomain::TJ,
            TopLevelDomain::TJMAXX,
            TopLevelDomain::TJX,
            TopLevelDomain::TK,
            TopLevelDomain::TKMAXX,
            TopLevelDomain::TL,
            TopLevelDomain::TM,
            TopLevelDomain::TMALL,
            TopLevelDomain::TN,
            TopLevelDomain::TO,
            TopLevelDomain::TODAY,
            TopLevelDomain::TOKYO,
            TopLevelDomain::TOOLS,
            TopLevelDomain::TOP,
            TopLevelDomain::TORAY,
            TopLevelDomain::TOSHIBA,
            TopLevelDomain::TOTAL,
            TopLevelDomain::TOURS,
            TopLevelDomain::TOWN,
            TopLevelDomain::TOYOTA,
            TopLevelDomain::TOYS,
            TopLevelDomain::TR,
            TopLevelDomain::TRADE,
            TopLevelDomain::TRADING,
            TopLevelDomain::TRAINING,
            TopLevelDomain::TRAVEL,
            TopLevelDomain::TRAVELCHANNEL,
            TopLevelDomain::TRAVELERS,
            TopLevelDomain::TRAVELERSINSURANCE,
            TopLevelDomain::TRUST,
            TopLevelDomain::TRV,
            TopLevelDomain::TT,
            TopLevelDomain::TUBE,
            TopLevelDomain::TUI,
            TopLevelDomain::TUNES,
            TopLevelDomain::TUSHU,
            TopLevelDomain::TV,
            TopLevelDomain::TVS,
            TopLevelDomain::TW,
            TopLevelDomain::TZ,
            TopLevelDomain::UA,
            TopLevelDomain::UBANK,
            TopLevelDomain::UBS,
            TopLevelDomain::UG,
            TopLevelDomain::UK,
            TopLevelDomain::UM,
            TopLevelDomain::UNICOM,
            TopLevelDomain::UNIVERSITY,
            TopLevelDomain::UNO,
            TopLevelDomain::UOL,
            TopLevelDomain::UPS,
            TopLevelDomain::US,
            TopLevelDomain::UY,
            TopLevelDomain::UZ,
            TopLevelDomain::VA,
            TopLevelDomain::VACATIONS,
            TopLevelDomain::VANA,
            TopLevelDomain::VANGUARD,
            TopLevelDomain::VC,
            TopLevelDomain::VE,
            TopLevelDomain::VEGAS,
            TopLevelDomain::VENTURES,
            TopLevelDomain::VERISIGN,
            TopLevelDomain::VERSICHERUNG,
            TopLevelDomain::VET,
            TopLevelDomain::VG,
            TopLevelDomain::VI,
            TopLevelDomain::VIAJES,
            TopLevelDomain::VIDEO,
            TopLevelDomain::VIG,
            TopLevelDomain::VIKING,
            TopLevelDomain::VILLAS,
            TopLevelDomain::VIN,
            TopLevelDomain::VIP,
            TopLevelDomain::VIRGIN,
            TopLevelDomain::VISA,
            TopLevelDomain::VISION,
            TopLevelDomain::VIVA,
            TopLevelDomain::VIVO,
            TopLevelDomain::VLAANDEREN,
            TopLevelDomain::VN,
            TopLevelDomain::VODKA,
            TopLevelDomain::VOLKSWAGEN,
            TopLevelDomain::VOLVO,
            TopLevelDomain::VOTE,
            TopLevelDomain::VOTING,
            TopLevelDomain::VOTO,
            TopLevelDomain::VOYAGE,
            TopLevelDomain::VU,
            TopLevelDomain::VUELOS,
            TopLevelDomain::WALES,
            TopLevelDomain::WALMART,
            TopLevelDomain::WALTER,
            TopLevelDomain::WANG,
            TopLevelDomain::WANGGOU,
            TopLevelDomain::WATCH,
            TopLevelDomain::WATCHES,
            TopLevelDomain::WEATHER,
            TopLevelDomain::WEATHERCHANNEL,
            TopLevelDomain::WEBCAM,
            TopLevelDomain::WEBER,
            TopLevelDomain::WEBSITE,
            TopLevelDomain::WED,
            TopLevelDomain::WEDDING,
            TopLevelDomain::WEIBO,
            TopLevelDomain::WEIR,
            TopLevelDomain::WF,
            TopLevelDomain::WHOSWHO,
            TopLevelDomain::WIEN,
            TopLevelDomain::WIKI,
            TopLevelDomain::WILLIAMHILL,
            TopLevelDomain::WIN,
            TopLevelDomain::WINDOWS,
            TopLevelDomain::WINE,
            TopLevelDomain::WINNERS,
            TopLevelDomain::WME,
            TopLevelDomain::WOLTERSKLUWER,
            TopLevelDomain::WOODSIDE,
            TopLevelDomain::WORK,
            TopLevelDomain::WORKS,
            TopLevelDomain::WORLD,
            TopLevelDomain::WOW,
            TopLevelDomain::WS,
            TopLevelDomain::WTC,
            TopLevelDomain::WTF,
            TopLevelDomain::XBOX,
            TopLevelDomain::XEROX,
            TopLevelDomain::XFINITY,
            TopLevelDomain::XIHUAN,
            TopLevelDomain::XIN,
            TopLevelDomain::XN,
            TopLevelDomain::XXX,
            TopLevelDomain::XYZ,
            TopLevelDomain::YACHTS,
            TopLevelDomain::YAHOO,
            TopLevelDomain::YAMAXUN,
            TopLevelDomain::YANDEX,
            TopLevelDomain::YE,
            TopLevelDomain::YODOBASHI,
            TopLevelDomain::YOGA,
            TopLevelDomain::YOKOHAMA,
            TopLevelDomain::YOU,
            TopLevelDomain::YOUTUBE,
            TopLevelDomain::YT,
            TopLevelDomain::YUN,
            TopLevelDomain::ZA,
            TopLevelDomain::ZAPPOS,
            TopLevelDomain::ZARA,
            TopLevelDomain::ZERO,
            TopLevelDomain::ZIP,
            TopLevelDomain::ZM,
            TopLevelDomain::ZONE,
            TopLevelDomain::ZUERICH,
            TopLevelDomain::ZW,
        ];
        ALL_TOP_LEVEL_DOMAINS.iter()
    }
}

impl FromStr for TopLevelDomain {
    type Err = ();
    fn from_str(word: &str) -> Result<TopLevelDomain, Self::Err> {
        let mut code = word.to_lowercase();
        if code.starts_with(".") {
            let mut chars = code.chars();
            chars.next();
            code = chars.as_str().parse().unwrap();
        }
        let code_as_str: &str = &code;

        match code_as_str {
            "AAA" => Ok(TopLevelDomain::AAA),
            "AARP" => Ok(TopLevelDomain::AARP),
            "ABARTH" => Ok(TopLevelDomain::ABARTH),
            "ABB" => Ok(TopLevelDomain::ABB),
            "ABBOTT" => Ok(TopLevelDomain::ABBOTT),
            "ABBVIE" => Ok(TopLevelDomain::ABBVIE),
            "ABC" => Ok(TopLevelDomain::ABC),
            "ABLE" => Ok(TopLevelDomain::ABLE),
            "ABOGADO" => Ok(TopLevelDomain::ABOGADO),
            "ABUDHABI" => Ok(TopLevelDomain::ABUDHABI),
            "AC" => Ok(TopLevelDomain::AC),
            "ACADEMY" => Ok(TopLevelDomain::ACADEMY),
            "ACCENTURE" => Ok(TopLevelDomain::ACCENTURE),
            "ACCOUNTANT" => Ok(TopLevelDomain::ACCOUNTANT),
            "ACCOUNTANTS" => Ok(TopLevelDomain::ACCOUNTANTS),
            "ACO" => Ok(TopLevelDomain::ACO),
            "ACTOR" => Ok(TopLevelDomain::ACTOR),
            "AD" => Ok(TopLevelDomain::AD),
            "ADAC" => Ok(TopLevelDomain::ADAC),
            "ADS" => Ok(TopLevelDomain::ADS),
            "ADULT" => Ok(TopLevelDomain::ADULT),
            "AE" => Ok(TopLevelDomain::AE),
            "AEG" => Ok(TopLevelDomain::AEG),
            "AERO" => Ok(TopLevelDomain::AERO),
            "AETNA" => Ok(TopLevelDomain::AETNA),
            "AF" => Ok(TopLevelDomain::AF),
            "AFAMILYCOMPANY" => Ok(TopLevelDomain::AFAMILYCOMPANY),
            "AFL" => Ok(TopLevelDomain::AFL),
            "AFRICA" => Ok(TopLevelDomain::AFRICA),
            "AG" => Ok(TopLevelDomain::AG),
            "AGAKHAN" => Ok(TopLevelDomain::AGAKHAN),
            "AGENCY" => Ok(TopLevelDomain::AGENCY),
            "AI" => Ok(TopLevelDomain::AI),
            "AIG" => Ok(TopLevelDomain::AIG),
            "AIRBUS" => Ok(TopLevelDomain::AIRBUS),
            "AIRFORCE" => Ok(TopLevelDomain::AIRFORCE),
            "AIRTEL" => Ok(TopLevelDomain::AIRTEL),
            "AKDN" => Ok(TopLevelDomain::AKDN),
            "AL" => Ok(TopLevelDomain::AL),
            "ALFAROMEO" => Ok(TopLevelDomain::ALFAROMEO),
            "ALIBABA" => Ok(TopLevelDomain::ALIBABA),
            "ALIPAY" => Ok(TopLevelDomain::ALIPAY),
            "ALLFINANZ" => Ok(TopLevelDomain::ALLFINANZ),
            "ALLSTATE" => Ok(TopLevelDomain::ALLSTATE),
            "ALLY" => Ok(TopLevelDomain::ALLY),
            "ALSACE" => Ok(TopLevelDomain::ALSACE),
            "ALSTOM" => Ok(TopLevelDomain::ALSTOM),
            "AM" => Ok(TopLevelDomain::AM),
            "AMAZON" => Ok(TopLevelDomain::AMAZON),
            "AMERICANEXPRESS" => Ok(TopLevelDomain::AMERICANEXPRESS),
            "AMERICANFAMILY" => Ok(TopLevelDomain::AMERICANFAMILY),
            "AMEX" => Ok(TopLevelDomain::AMEX),
            "AMFAM" => Ok(TopLevelDomain::AMFAM),
            "AMICA" => Ok(TopLevelDomain::AMICA),
            "AMSTERDAM" => Ok(TopLevelDomain::AMSTERDAM),
            "AN" => Ok(TopLevelDomain::AN),
            "ANALYTICS" => Ok(TopLevelDomain::ANALYTICS),
            "ANDROID" => Ok(TopLevelDomain::ANDROID),
            "ANQUAN" => Ok(TopLevelDomain::ANQUAN),
            "ANZ" => Ok(TopLevelDomain::ANZ),
            "AO" => Ok(TopLevelDomain::AO),
            "AOL" => Ok(TopLevelDomain::AOL),
            "APARTMENTS" => Ok(TopLevelDomain::APARTMENTS),
            "APP" => Ok(TopLevelDomain::APP),
            "APPLE" => Ok(TopLevelDomain::APPLE),
            "AQ" => Ok(TopLevelDomain::AQ),
            "AQUARELLE" => Ok(TopLevelDomain::AQUARELLE),
            "AR" => Ok(TopLevelDomain::AR),
            "ARAB" => Ok(TopLevelDomain::ARAB),
            "ARAMCO" => Ok(TopLevelDomain::ARAMCO),
            "ARCHI" => Ok(TopLevelDomain::ARCHI),
            "ARMY" => Ok(TopLevelDomain::ARMY),
            "ARPA" => Ok(TopLevelDomain::ARPA),
            "ART" => Ok(TopLevelDomain::ART),
            "ARTE" => Ok(TopLevelDomain::ARTE),
            "AS" => Ok(TopLevelDomain::AS),
            "ASDA" => Ok(TopLevelDomain::ASDA),
            "ASIA" => Ok(TopLevelDomain::ASIA),
            "ASSOCIATES" => Ok(TopLevelDomain::ASSOCIATES),
            "AT" => Ok(TopLevelDomain::AT),
            "ATHLETA" => Ok(TopLevelDomain::ATHLETA),
            "ATTORNEY" => Ok(TopLevelDomain::ATTORNEY),
            "AU" => Ok(TopLevelDomain::AU),
            "AUCTION" => Ok(TopLevelDomain::AUCTION),
            "AUDI" => Ok(TopLevelDomain::AUDI),
            "AUDIBLE" => Ok(TopLevelDomain::AUDIBLE),
            "AUDIO" => Ok(TopLevelDomain::AUDIO),
            "AUSPOST" => Ok(TopLevelDomain::AUSPOST),
            "AUTHOR" => Ok(TopLevelDomain::AUTHOR),
            "AUTO" => Ok(TopLevelDomain::AUTO),
            "AUTOS" => Ok(TopLevelDomain::AUTOS),
            "AVIANCA" => Ok(TopLevelDomain::AVIANCA),
            "AW" => Ok(TopLevelDomain::AW),
            "AWS" => Ok(TopLevelDomain::AWS),
            "AX" => Ok(TopLevelDomain::AX),
            "AXA" => Ok(TopLevelDomain::AXA),
            "AZ" => Ok(TopLevelDomain::AZ),
            "AZURE" => Ok(TopLevelDomain::AZURE),
            "BA" => Ok(TopLevelDomain::BA),
            "BABY" => Ok(TopLevelDomain::BABY),
            "BAIDU" => Ok(TopLevelDomain::BAIDU),
            "BANAMEX" => Ok(TopLevelDomain::BANAMEX),
            "BANANAREPUBLIC" => Ok(TopLevelDomain::BANANAREPUBLIC),
            "BAND" => Ok(TopLevelDomain::BAND),
            "BANK" => Ok(TopLevelDomain::BANK),
            "BAR" => Ok(TopLevelDomain::BAR),
            "BARCELONA" => Ok(TopLevelDomain::BARCELONA),
            "BARCLAYCARD" => Ok(TopLevelDomain::BARCLAYCARD),
            "BARCLAYS" => Ok(TopLevelDomain::BARCLAYS),
            "BAREFOOT" => Ok(TopLevelDomain::BAREFOOT),
            "BARGAINS" => Ok(TopLevelDomain::BARGAINS),
            "BASEBALL" => Ok(TopLevelDomain::BASEBALL),
            "BASKETBALL" => Ok(TopLevelDomain::BASKETBALL),
            "BAUHAUS" => Ok(TopLevelDomain::BAUHAUS),
            "BAYERN" => Ok(TopLevelDomain::BAYERN),
            "BB" => Ok(TopLevelDomain::BB),
            "BBC" => Ok(TopLevelDomain::BBC),
            "BBT" => Ok(TopLevelDomain::BBT),
            "BBVA" => Ok(TopLevelDomain::BBVA),
            "BCG" => Ok(TopLevelDomain::BCG),
            "BCN" => Ok(TopLevelDomain::BCN),
            "BD" => Ok(TopLevelDomain::BD),
            "BE" => Ok(TopLevelDomain::BE),
            "BEATS" => Ok(TopLevelDomain::BEATS),
            "BEAUTY" => Ok(TopLevelDomain::BEAUTY),
            "BEER" => Ok(TopLevelDomain::BEER),
            "BENTLEY" => Ok(TopLevelDomain::BENTLEY),
            "BERLIN" => Ok(TopLevelDomain::BERLIN),
            "BEST" => Ok(TopLevelDomain::BEST),
            "BESTBUY" => Ok(TopLevelDomain::BESTBUY),
            "BET" => Ok(TopLevelDomain::BET),
            "BF" => Ok(TopLevelDomain::BF),
            "BG" => Ok(TopLevelDomain::BG),
            "BH" => Ok(TopLevelDomain::BH),
            "BHARTI" => Ok(TopLevelDomain::BHARTI),
            "BI" => Ok(TopLevelDomain::BI),
            "BIBLE" => Ok(TopLevelDomain::BIBLE),
            "BID" => Ok(TopLevelDomain::BID),
            "BIKE" => Ok(TopLevelDomain::BIKE),
            "BING" => Ok(TopLevelDomain::BING),
            "BINGO" => Ok(TopLevelDomain::BINGO),
            "BIO" => Ok(TopLevelDomain::BIO),
            "BIZ" => Ok(TopLevelDomain::BIZ),
            "BJ" => Ok(TopLevelDomain::BJ),
            "BL" => Ok(TopLevelDomain::BL),
            "BLACK" => Ok(TopLevelDomain::BLACK),
            "BLACKFRIDAY" => Ok(TopLevelDomain::BLACKFRIDAY),
            "BLOCKBUSTER" => Ok(TopLevelDomain::BLOCKBUSTER),
            "BLOG" => Ok(TopLevelDomain::BLOG),
            "BLOOMBERG" => Ok(TopLevelDomain::BLOOMBERG),
            "BLUE" => Ok(TopLevelDomain::BLUE),
            "BM" => Ok(TopLevelDomain::BM),
            "BMS" => Ok(TopLevelDomain::BMS),
            "BMW" => Ok(TopLevelDomain::BMW),
            "BN" => Ok(TopLevelDomain::BN),
            "BNPPARIBAS" => Ok(TopLevelDomain::BNPPARIBAS),
            "BO" => Ok(TopLevelDomain::BO),
            "BOATS" => Ok(TopLevelDomain::BOATS),
            "BOEHRINGER" => Ok(TopLevelDomain::BOEHRINGER),
            "BOFA" => Ok(TopLevelDomain::BOFA),
            "BOM" => Ok(TopLevelDomain::BOM),
            "BOND" => Ok(TopLevelDomain::BOND),
            "BOO" => Ok(TopLevelDomain::BOO),
            "BOOK" => Ok(TopLevelDomain::BOOK),
            "BOOKING" => Ok(TopLevelDomain::BOOKING),
            "BOSCH" => Ok(TopLevelDomain::BOSCH),
            "BOSTIK" => Ok(TopLevelDomain::BOSTIK),
            "BOSTON" => Ok(TopLevelDomain::BOSTON),
            "BOT" => Ok(TopLevelDomain::BOT),
            "BOUTIQUE" => Ok(TopLevelDomain::BOUTIQUE),
            "BOX" => Ok(TopLevelDomain::BOX),
            "BR" => Ok(TopLevelDomain::BR),
            "BRADESCO" => Ok(TopLevelDomain::BRADESCO),
            "BRIDGESTONE" => Ok(TopLevelDomain::BRIDGESTONE),
            "BROADWAY" => Ok(TopLevelDomain::BROADWAY),
            "BROKER" => Ok(TopLevelDomain::BROKER),
            "BROTHER" => Ok(TopLevelDomain::BROTHER),
            "BRUSSELS" => Ok(TopLevelDomain::BRUSSELS),
            "BS" => Ok(TopLevelDomain::BS),
            "BT" => Ok(TopLevelDomain::BT),
            "BUDAPEST" => Ok(TopLevelDomain::BUDAPEST),
            "BUGATTI" => Ok(TopLevelDomain::BUGATTI),
            "BUILD" => Ok(TopLevelDomain::BUILD),
            "BUILDERS" => Ok(TopLevelDomain::BUILDERS),
            "BUSINESS" => Ok(TopLevelDomain::BUSINESS),
            "BUY" => Ok(TopLevelDomain::BUY),
            "BUZZ" => Ok(TopLevelDomain::BUZZ),
            "BV" => Ok(TopLevelDomain::BV),
            "BW" => Ok(TopLevelDomain::BW),
            "BQ" => Ok(TopLevelDomain::BQ),
            "BY" => Ok(TopLevelDomain::BY),
            "BZ" => Ok(TopLevelDomain::BZ),
            "BZH" => Ok(TopLevelDomain::BZH),
            "CA" => Ok(TopLevelDomain::CA),
            "CAB" => Ok(TopLevelDomain::CAB),
            "CAFE" => Ok(TopLevelDomain::CAFE),
            "CAL" => Ok(TopLevelDomain::CAL),
            "CALL" => Ok(TopLevelDomain::CALL),
            "CALVINKLEIN" => Ok(TopLevelDomain::CALVINKLEIN),
            "CAM" => Ok(TopLevelDomain::CAM),
            "CAMERA" => Ok(TopLevelDomain::CAMERA),
            "CAMP" => Ok(TopLevelDomain::CAMP),
            "CANCERRESEARCH" => Ok(TopLevelDomain::CANCERRESEARCH),
            "CANON" => Ok(TopLevelDomain::CANON),
            "CAPETOWN" => Ok(TopLevelDomain::CAPETOWN),
            "CAPITAL" => Ok(TopLevelDomain::CAPITAL),
            "CAPITALONE" => Ok(TopLevelDomain::CAPITALONE),
            "CAR" => Ok(TopLevelDomain::CAR),
            "CARAVAN" => Ok(TopLevelDomain::CARAVAN),
            "CARDS" => Ok(TopLevelDomain::CARDS),
            "CARE" => Ok(TopLevelDomain::CARE),
            "CAREER" => Ok(TopLevelDomain::CAREER),
            "CAREERS" => Ok(TopLevelDomain::CAREERS),
            "CARS" => Ok(TopLevelDomain::CARS),
            "CASA" => Ok(TopLevelDomain::CASA),
            "CASE" => Ok(TopLevelDomain::CASE),
            "CASH" => Ok(TopLevelDomain::CASH),
            "CASINO" => Ok(TopLevelDomain::CASINO),
            "CAT" => Ok(TopLevelDomain::CAT),
            "CATERING" => Ok(TopLevelDomain::CATERING),
            "CATHOLIC" => Ok(TopLevelDomain::CATHOLIC),
            "CBA" => Ok(TopLevelDomain::CBA),
            "CBN" => Ok(TopLevelDomain::CBN),
            "CBRE" => Ok(TopLevelDomain::CBRE),
            "CBS" => Ok(TopLevelDomain::CBS),
            "CC" => Ok(TopLevelDomain::CC),
            "CD" => Ok(TopLevelDomain::CD),
            "CENTER" => Ok(TopLevelDomain::CENTER),
            "CEO" => Ok(TopLevelDomain::CEO),
            "CERN" => Ok(TopLevelDomain::CERN),
            "CF" => Ok(TopLevelDomain::CF),
            "CFA" => Ok(TopLevelDomain::CFA),
            "CFD" => Ok(TopLevelDomain::CFD),
            "CG" => Ok(TopLevelDomain::CG),
            "CH" => Ok(TopLevelDomain::CH),
            "CHANEL" => Ok(TopLevelDomain::CHANEL),
            "CHANNEL" => Ok(TopLevelDomain::CHANNEL),
            "CHARITY" => Ok(TopLevelDomain::CHARITY),
            "CHASE" => Ok(TopLevelDomain::CHASE),
            "CHAT" => Ok(TopLevelDomain::CHAT),
            "CHEAP" => Ok(TopLevelDomain::CHEAP),
            "CHINTAI" => Ok(TopLevelDomain::CHINTAI),
            "CHRISTMAS" => Ok(TopLevelDomain::CHRISTMAS),
            "CHROME" => Ok(TopLevelDomain::CHROME),
            "CHURCH" => Ok(TopLevelDomain::CHURCH),
            "CI" => Ok(TopLevelDomain::CI),
            "CIPRIANI" => Ok(TopLevelDomain::CIPRIANI),
            "CIRCLE" => Ok(TopLevelDomain::CIRCLE),
            "CISCO" => Ok(TopLevelDomain::CISCO),
            "CITADEL" => Ok(TopLevelDomain::CITADEL),
            "CITI" => Ok(TopLevelDomain::CITI),
            "CITIC" => Ok(TopLevelDomain::CITIC),
            "CITY" => Ok(TopLevelDomain::CITY),
            "CITYEATS" => Ok(TopLevelDomain::CITYEATS),
            "CK" => Ok(TopLevelDomain::CK),
            "CL" => Ok(TopLevelDomain::CL),
            "CLAIMS" => Ok(TopLevelDomain::CLAIMS),
            "CLEANING" => Ok(TopLevelDomain::CLEANING),
            "CLICK" => Ok(TopLevelDomain::CLICK),
            "CLINIC" => Ok(TopLevelDomain::CLINIC),
            "CLINIQUE" => Ok(TopLevelDomain::CLINIQUE),
            "CLOTHING" => Ok(TopLevelDomain::CLOTHING),
            "CLOUD" => Ok(TopLevelDomain::CLOUD),
            "CLUB" => Ok(TopLevelDomain::CLUB),
            "CLUBMED" => Ok(TopLevelDomain::CLUBMED),
            "CM" => Ok(TopLevelDomain::CM),
            "CN" => Ok(TopLevelDomain::CN),
            "CO" => Ok(TopLevelDomain::CO),
            "COACH" => Ok(TopLevelDomain::COACH),
            "CODES" => Ok(TopLevelDomain::CODES),
            "COFFEE" => Ok(TopLevelDomain::COFFEE),
            "COLLEGE" => Ok(TopLevelDomain::COLLEGE),
            "COLOGNE" => Ok(TopLevelDomain::COLOGNE),
            "COM" => Ok(TopLevelDomain::COM),
            "COMCAST" => Ok(TopLevelDomain::COMCAST),
            "COMMBANK" => Ok(TopLevelDomain::COMMBANK),
            "COMMUNITY" => Ok(TopLevelDomain::COMMUNITY),
            "COMPANY" => Ok(TopLevelDomain::COMPANY),
            "COMPARE" => Ok(TopLevelDomain::COMPARE),
            "COMPUTER" => Ok(TopLevelDomain::COMPUTER),
            "COMSEC" => Ok(TopLevelDomain::COMSEC),
            "CONDOS" => Ok(TopLevelDomain::CONDOS),
            "CONSTRUCTION" => Ok(TopLevelDomain::CONSTRUCTION),
            "CONSULTING" => Ok(TopLevelDomain::CONSULTING),
            "CONTACT" => Ok(TopLevelDomain::CONTACT),
            "CONTRACTORS" => Ok(TopLevelDomain::CONTRACTORS),
            "COOKING" => Ok(TopLevelDomain::COOKING),
            "COOKINGCHANNEL" => Ok(TopLevelDomain::COOKINGCHANNEL),
            "COOL" => Ok(TopLevelDomain::COOL),
            "COOP" => Ok(TopLevelDomain::COOP),
            "CORSICA" => Ok(TopLevelDomain::CORSICA),
            "COUNTRY" => Ok(TopLevelDomain::COUNTRY),
            "COUPON" => Ok(TopLevelDomain::COUPON),
            "COUPONS" => Ok(TopLevelDomain::COUPONS),
            "COURSES" => Ok(TopLevelDomain::COURSES),
            "CPA" => Ok(TopLevelDomain::CPA),
            "CR" => Ok(TopLevelDomain::CR),
            "CREDIT" => Ok(TopLevelDomain::CREDIT),
            "CREDITCARD" => Ok(TopLevelDomain::CREDITCARD),
            "CREDITUNION" => Ok(TopLevelDomain::CREDITUNION),
            "CRICKET" => Ok(TopLevelDomain::CRICKET),
            "CROWN" => Ok(TopLevelDomain::CROWN),
            "CRS" => Ok(TopLevelDomain::CRS),
            "CRUISE" => Ok(TopLevelDomain::CRUISE),
            "CRUISES" => Ok(TopLevelDomain::CRUISES),
            "CSC" => Ok(TopLevelDomain::CSC),
            "CU" => Ok(TopLevelDomain::CU),
            "CUISINELLA" => Ok(TopLevelDomain::CUISINELLA),
            "CV" => Ok(TopLevelDomain::CV),
            "CW" => Ok(TopLevelDomain::CW),
            "CX" => Ok(TopLevelDomain::CX),
            "CY" => Ok(TopLevelDomain::CY),
            "CYMRU" => Ok(TopLevelDomain::CYMRU),
            "CYOU" => Ok(TopLevelDomain::CYOU),
            "CZ" => Ok(TopLevelDomain::CZ),
            "DABUR" => Ok(TopLevelDomain::DABUR),
            "DAD" => Ok(TopLevelDomain::DAD),
            "DANCE" => Ok(TopLevelDomain::DANCE),
            "DATA" => Ok(TopLevelDomain::DATA),
            "DATE" => Ok(TopLevelDomain::DATE),
            "DATING" => Ok(TopLevelDomain::DATING),
            "DATSUN" => Ok(TopLevelDomain::DATSUN),
            "DAY" => Ok(TopLevelDomain::DAY),
            "DCLK" => Ok(TopLevelDomain::DCLK),
            "DDS" => Ok(TopLevelDomain::DDS),
            "DE" => Ok(TopLevelDomain::DE),
            "DEAL" => Ok(TopLevelDomain::DEAL),
            "DEALER" => Ok(TopLevelDomain::DEALER),
            "DEALS" => Ok(TopLevelDomain::DEALS),
            "DEGREE" => Ok(TopLevelDomain::DEGREE),
            "DELIVERY" => Ok(TopLevelDomain::DELIVERY),
            "DELL" => Ok(TopLevelDomain::DELL),
            "DELOITTE" => Ok(TopLevelDomain::DELOITTE),
            "DELTA" => Ok(TopLevelDomain::DELTA),
            "DEMOCRAT" => Ok(TopLevelDomain::DEMOCRAT),
            "DENTAL" => Ok(TopLevelDomain::DENTAL),
            "DENTIST" => Ok(TopLevelDomain::DENTIST),
            "DESI" => Ok(TopLevelDomain::DESI),
            "DESIGN" => Ok(TopLevelDomain::DESIGN),
            "DEV" => Ok(TopLevelDomain::DEV),
            "DHL" => Ok(TopLevelDomain::DHL),
            "DIAMONDS" => Ok(TopLevelDomain::DIAMONDS),
            "DIET" => Ok(TopLevelDomain::DIET),
            "DIGITAL" => Ok(TopLevelDomain::DIGITAL),
            "DIRECT" => Ok(TopLevelDomain::DIRECT),
            "DIRECTORY" => Ok(TopLevelDomain::DIRECTORY),
            "DISCOUNT" => Ok(TopLevelDomain::DISCOUNT),
            "DISCOVER" => Ok(TopLevelDomain::DISCOVER),
            "DISH" => Ok(TopLevelDomain::DISH),
            "DIY" => Ok(TopLevelDomain::DIY),
            "DJ" => Ok(TopLevelDomain::DJ),
            "DK" => Ok(TopLevelDomain::DK),
            "DM" => Ok(TopLevelDomain::DM),
            "DNP" => Ok(TopLevelDomain::DNP),
            "DO" => Ok(TopLevelDomain::DO),
            "DOCS" => Ok(TopLevelDomain::DOCS),
            "DOCTOR" => Ok(TopLevelDomain::DOCTOR),
            "DOG" => Ok(TopLevelDomain::DOG),
            "DOMAINS" => Ok(TopLevelDomain::DOMAINS),
            "DOT" => Ok(TopLevelDomain::DOT),
            "DOWNLOAD" => Ok(TopLevelDomain::DOWNLOAD),
            "DRIVE" => Ok(TopLevelDomain::DRIVE),
            "DTV" => Ok(TopLevelDomain::DTV),
            "DUBAI" => Ok(TopLevelDomain::DUBAI),
            "DUCK" => Ok(TopLevelDomain::DUCK),
            "DUNLOP" => Ok(TopLevelDomain::DUNLOP),
            "DUPONT" => Ok(TopLevelDomain::DUPONT),
            "DURBAN" => Ok(TopLevelDomain::DURBAN),
            "DVAG" => Ok(TopLevelDomain::DVAG),
            "DVR" => Ok(TopLevelDomain::DVR),
            "DZ" => Ok(TopLevelDomain::DZ),
            "EARTH" => Ok(TopLevelDomain::EARTH),
            "EAT" => Ok(TopLevelDomain::EAT),
            "EC" => Ok(TopLevelDomain::EC),
            "ECO" => Ok(TopLevelDomain::ECO),
            "EDEKA" => Ok(TopLevelDomain::EDEKA),
            "EDU" => Ok(TopLevelDomain::EDU),
            "EDUCATION" => Ok(TopLevelDomain::EDUCATION),
            "EE" => Ok(TopLevelDomain::EE),
            "EG" => Ok(TopLevelDomain::EG),
            "EH" => Ok(TopLevelDomain::EH),
            "EMAIL" => Ok(TopLevelDomain::EMAIL),
            "EMERCK" => Ok(TopLevelDomain::EMERCK),
            "ENERGY" => Ok(TopLevelDomain::ENERGY),
            "ENGINEER" => Ok(TopLevelDomain::ENGINEER),
            "ENGINEERING" => Ok(TopLevelDomain::ENGINEERING),
            "ENTERPRISES" => Ok(TopLevelDomain::ENTERPRISES),
            "EPSON" => Ok(TopLevelDomain::EPSON),
            "EQUIPMENT" => Ok(TopLevelDomain::EQUIPMENT),
            "ER" => Ok(TopLevelDomain::ER),
            "ERICSSON" => Ok(TopLevelDomain::ERICSSON),
            "ERNI" => Ok(TopLevelDomain::ERNI),
            "ES" => Ok(TopLevelDomain::ES),
            "ESQ" => Ok(TopLevelDomain::ESQ),
            "ESTATE" => Ok(TopLevelDomain::ESTATE),
            "ET" => Ok(TopLevelDomain::ET),
            "ETISALAT" => Ok(TopLevelDomain::ETISALAT),
            "EU" => Ok(TopLevelDomain::EU),
            "EUROVISION" => Ok(TopLevelDomain::EUROVISION),
            "EUS" => Ok(TopLevelDomain::EUS),
            "EVENTS" => Ok(TopLevelDomain::EVENTS),
            "EXCHANGE" => Ok(TopLevelDomain::EXCHANGE),
            "EXPERT" => Ok(TopLevelDomain::EXPERT),
            "EXPOSED" => Ok(TopLevelDomain::EXPOSED),
            "EXPRESS" => Ok(TopLevelDomain::EXPRESS),
            "EXTRASPACE" => Ok(TopLevelDomain::EXTRASPACE),
            "FAGE" => Ok(TopLevelDomain::FAGE),
            "FAIL" => Ok(TopLevelDomain::FAIL),
            "FAIRWINDS" => Ok(TopLevelDomain::FAIRWINDS),
            "FAITH" => Ok(TopLevelDomain::FAITH),
            "FAMILY" => Ok(TopLevelDomain::FAMILY),
            "FAN" => Ok(TopLevelDomain::FAN),
            "FANS" => Ok(TopLevelDomain::FANS),
            "FARM" => Ok(TopLevelDomain::FARM),
            "FARMERS" => Ok(TopLevelDomain::FARMERS),
            "FASHION" => Ok(TopLevelDomain::FASHION),
            "FAST" => Ok(TopLevelDomain::FAST),
            "FEDEX" => Ok(TopLevelDomain::FEDEX),
            "FEEDBACK" => Ok(TopLevelDomain::FEEDBACK),
            "FERRARI" => Ok(TopLevelDomain::FERRARI),
            "FERRERO" => Ok(TopLevelDomain::FERRERO),
            "FI" => Ok(TopLevelDomain::FI),
            "FIAT" => Ok(TopLevelDomain::FIAT),
            "FIDELITY" => Ok(TopLevelDomain::FIDELITY),
            "FIDO" => Ok(TopLevelDomain::FIDO),
            "FILM" => Ok(TopLevelDomain::FILM),
            "FINAL" => Ok(TopLevelDomain::FINAL),
            "FINANCE" => Ok(TopLevelDomain::FINANCE),
            "FINANCIAL" => Ok(TopLevelDomain::FINANCIAL),
            "FIRE" => Ok(TopLevelDomain::FIRE),
            "FIRESTONE" => Ok(TopLevelDomain::FIRESTONE),
            "FIRMDALE" => Ok(TopLevelDomain::FIRMDALE),
            "FISH" => Ok(TopLevelDomain::FISH),
            "FISHING" => Ok(TopLevelDomain::FISHING),
            "FIT" => Ok(TopLevelDomain::FIT),
            "FITNESS" => Ok(TopLevelDomain::FITNESS),
            "FJ" => Ok(TopLevelDomain::FJ),
            "FK" => Ok(TopLevelDomain::FK),
            "FLICKR" => Ok(TopLevelDomain::FLICKR),
            "FLIGHTS" => Ok(TopLevelDomain::FLIGHTS),
            "FLIR" => Ok(TopLevelDomain::FLIR),
            "FLORIST" => Ok(TopLevelDomain::FLORIST),
            "FLOWERS" => Ok(TopLevelDomain::FLOWERS),
            "FLY" => Ok(TopLevelDomain::FLY),
            "FM" => Ok(TopLevelDomain::FM),
            "FO" => Ok(TopLevelDomain::FO),
            "FOO" => Ok(TopLevelDomain::FOO),
            "FOOD" => Ok(TopLevelDomain::FOOD),
            "FOODNETWORK" => Ok(TopLevelDomain::FOODNETWORK),
            "FOOTBALL" => Ok(TopLevelDomain::FOOTBALL),
            "FORD" => Ok(TopLevelDomain::FORD),
            "FOREX" => Ok(TopLevelDomain::FOREX),
            "FORSALE" => Ok(TopLevelDomain::FORSALE),
            "FORUM" => Ok(TopLevelDomain::FORUM),
            "FOUNDATION" => Ok(TopLevelDomain::FOUNDATION),
            "FOX" => Ok(TopLevelDomain::FOX),
            "FR" => Ok(TopLevelDomain::FR),
            "FREE" => Ok(TopLevelDomain::FREE),
            "FRESENIUS" => Ok(TopLevelDomain::FRESENIUS),
            "FRL" => Ok(TopLevelDomain::FRL),
            "FROGANS" => Ok(TopLevelDomain::FROGANS),
            "FRONTDOOR" => Ok(TopLevelDomain::FRONTDOOR),
            "FRONTIER" => Ok(TopLevelDomain::FRONTIER),
            "FTR" => Ok(TopLevelDomain::FTR),
            "FUJITSU" => Ok(TopLevelDomain::FUJITSU),
            "FUN" => Ok(TopLevelDomain::FUN),
            "FUND" => Ok(TopLevelDomain::FUND),
            "FURNITURE" => Ok(TopLevelDomain::FURNITURE),
            "FUTBOL" => Ok(TopLevelDomain::FUTBOL),
            "FYI" => Ok(TopLevelDomain::FYI),
            "GA" => Ok(TopLevelDomain::GA),
            "GAL" => Ok(TopLevelDomain::GAL),
            "GALLERY" => Ok(TopLevelDomain::GALLERY),
            "GALLO" => Ok(TopLevelDomain::GALLO),
            "GALLUP" => Ok(TopLevelDomain::GALLUP),
            "GAME" => Ok(TopLevelDomain::GAME),
            "GAMES" => Ok(TopLevelDomain::GAMES),
            "GAP" => Ok(TopLevelDomain::GAP),
            "GARDEN" => Ok(TopLevelDomain::GARDEN),
            "GAY" => Ok(TopLevelDomain::GAY),
            "GB" => Ok(TopLevelDomain::GB),
            "GBIZ" => Ok(TopLevelDomain::GBIZ),
            "GD" => Ok(TopLevelDomain::GD),
            "GDN" => Ok(TopLevelDomain::GDN),
            "GE" => Ok(TopLevelDomain::GE),
            "GEA" => Ok(TopLevelDomain::GEA),
            "GENT" => Ok(TopLevelDomain::GENT),
            "GENTING" => Ok(TopLevelDomain::GENTING),
            "GEORGE" => Ok(TopLevelDomain::GEORGE),
            "GF" => Ok(TopLevelDomain::GF),
            "GG" => Ok(TopLevelDomain::GG),
            "GGEE" => Ok(TopLevelDomain::GGEE),
            "GH" => Ok(TopLevelDomain::GH),
            "GI" => Ok(TopLevelDomain::GI),
            "GIFT" => Ok(TopLevelDomain::GIFT),
            "GIFTS" => Ok(TopLevelDomain::GIFTS),
            "GIVES" => Ok(TopLevelDomain::GIVES),
            "GIVING" => Ok(TopLevelDomain::GIVING),
            "GL" => Ok(TopLevelDomain::GL),
            "GLADE" => Ok(TopLevelDomain::GLADE),
            "GLASS" => Ok(TopLevelDomain::GLASS),
            "GLE" => Ok(TopLevelDomain::GLE),
            "GLOBAL" => Ok(TopLevelDomain::GLOBAL),
            "GLOBO" => Ok(TopLevelDomain::GLOBO),
            "GM" => Ok(TopLevelDomain::GM),
            "GMAIL" => Ok(TopLevelDomain::GMAIL),
            "GMBH" => Ok(TopLevelDomain::GMBH),
            "GMO" => Ok(TopLevelDomain::GMO),
            "GMX" => Ok(TopLevelDomain::GMX),
            "GN" => Ok(TopLevelDomain::GN),
            "GODADDY" => Ok(TopLevelDomain::GODADDY),
            "GOLD" => Ok(TopLevelDomain::GOLD),
            "GOLDPOINT" => Ok(TopLevelDomain::GOLDPOINT),
            "GOLF" => Ok(TopLevelDomain::GOLF),
            "GOO" => Ok(TopLevelDomain::GOO),
            "GOODYEAR" => Ok(TopLevelDomain::GOODYEAR),
            "GOOG" => Ok(TopLevelDomain::GOOG),
            "GOOGLE" => Ok(TopLevelDomain::GOOGLE),
            "GOP" => Ok(TopLevelDomain::GOP),
            "GOT" => Ok(TopLevelDomain::GOT),
            "GOV" => Ok(TopLevelDomain::GOV),
            "GP" => Ok(TopLevelDomain::GP),
            "GQ" => Ok(TopLevelDomain::GQ),
            "GR" => Ok(TopLevelDomain::GR),
            "GRAINGER" => Ok(TopLevelDomain::GRAINGER),
            "GRAPHICS" => Ok(TopLevelDomain::GRAPHICS),
            "GRATIS" => Ok(TopLevelDomain::GRATIS),
            "GREEN" => Ok(TopLevelDomain::GREEN),
            "GRIPE" => Ok(TopLevelDomain::GRIPE),
            "GROCERY" => Ok(TopLevelDomain::GROCERY),
            "GROUP" => Ok(TopLevelDomain::GROUP),
            "GS" => Ok(TopLevelDomain::GS),
            "GT" => Ok(TopLevelDomain::GT),
            "GU" => Ok(TopLevelDomain::GU),
            "GUARDIAN" => Ok(TopLevelDomain::GUARDIAN),
            "GUCCI" => Ok(TopLevelDomain::GUCCI),
            "GUGE" => Ok(TopLevelDomain::GUGE),
            "GUIDE" => Ok(TopLevelDomain::GUIDE),
            "GUITARS" => Ok(TopLevelDomain::GUITARS),
            "GURU" => Ok(TopLevelDomain::GURU),
            "GW" => Ok(TopLevelDomain::GW),
            "GY" => Ok(TopLevelDomain::GY),
            "HAIR" => Ok(TopLevelDomain::HAIR),
            "HAMBURG" => Ok(TopLevelDomain::HAMBURG),
            "HANGOUT" => Ok(TopLevelDomain::HANGOUT),
            "HAUS" => Ok(TopLevelDomain::HAUS),
            "HBO" => Ok(TopLevelDomain::HBO),
            "HDFC" => Ok(TopLevelDomain::HDFC),
            "HDFCBANK" => Ok(TopLevelDomain::HDFCBANK),
            "HEALTH" => Ok(TopLevelDomain::HEALTH),
            "HEALTHCARE" => Ok(TopLevelDomain::HEALTHCARE),
            "HELP" => Ok(TopLevelDomain::HELP),
            "HELSINKI" => Ok(TopLevelDomain::HELSINKI),
            "HERE" => Ok(TopLevelDomain::HERE),
            "HERMES" => Ok(TopLevelDomain::HERMES),
            "HGTV" => Ok(TopLevelDomain::HGTV),
            "HIPHOP" => Ok(TopLevelDomain::HIPHOP),
            "HISAMITSU" => Ok(TopLevelDomain::HISAMITSU),
            "HITACHI" => Ok(TopLevelDomain::HITACHI),
            "HIV" => Ok(TopLevelDomain::HIV),
            "HK" => Ok(TopLevelDomain::HK),
            "HKT" => Ok(TopLevelDomain::HKT),
            "HM" => Ok(TopLevelDomain::HM),
            "HN" => Ok(TopLevelDomain::HN),
            "HOCKEY" => Ok(TopLevelDomain::HOCKEY),
            "HOLDINGS" => Ok(TopLevelDomain::HOLDINGS),
            "HOLIDAY" => Ok(TopLevelDomain::HOLIDAY),
            "HOMEDEPOT" => Ok(TopLevelDomain::HOMEDEPOT),
            "HOMEGOODS" => Ok(TopLevelDomain::HOMEGOODS),
            "HOMES" => Ok(TopLevelDomain::HOMES),
            "HOMESENSE" => Ok(TopLevelDomain::HOMESENSE),
            "HONDA" => Ok(TopLevelDomain::HONDA),
            "HORSE" => Ok(TopLevelDomain::HORSE),
            "HOSPITAL" => Ok(TopLevelDomain::HOSPITAL),
            "HOST" => Ok(TopLevelDomain::HOST),
            "HOSTING" => Ok(TopLevelDomain::HOSTING),
            "HOT" => Ok(TopLevelDomain::HOT),
            "HOTELES" => Ok(TopLevelDomain::HOTELES),
            "HOTELS" => Ok(TopLevelDomain::HOTELS),
            "HOTMAIL" => Ok(TopLevelDomain::HOTMAIL),
            "HOUSE" => Ok(TopLevelDomain::HOUSE),
            "HOW" => Ok(TopLevelDomain::HOW),
            "HR" => Ok(TopLevelDomain::HR),
            "HSBC" => Ok(TopLevelDomain::HSBC),
            "HT" => Ok(TopLevelDomain::HT),
            "HU" => Ok(TopLevelDomain::HU),
            "HUGHES" => Ok(TopLevelDomain::HUGHES),
            "HYATT" => Ok(TopLevelDomain::HYATT),
            "HYUNDAI" => Ok(TopLevelDomain::HYUNDAI),
            "IBM" => Ok(TopLevelDomain::IBM),
            "ICBC" => Ok(TopLevelDomain::ICBC),
            "ICE" => Ok(TopLevelDomain::ICE),
            "ICU" => Ok(TopLevelDomain::ICU),
            "ID" => Ok(TopLevelDomain::ID),
            "IE" => Ok(TopLevelDomain::IE),
            "IEEE" => Ok(TopLevelDomain::IEEE),
            "IFM" => Ok(TopLevelDomain::IFM),
            "IKANO" => Ok(TopLevelDomain::IKANO),
            "IL" => Ok(TopLevelDomain::IL),
            "IM" => Ok(TopLevelDomain::IM),
            "IMAMAT" => Ok(TopLevelDomain::IMAMAT),
            "IMDB" => Ok(TopLevelDomain::IMDB),
            "IMMO" => Ok(TopLevelDomain::IMMO),
            "IMMOBILIEN" => Ok(TopLevelDomain::IMMOBILIEN),
            "IN" => Ok(TopLevelDomain::IN),
            "INC" => Ok(TopLevelDomain::INC),
            "INDUSTRIES" => Ok(TopLevelDomain::INDUSTRIES),
            "INFINITI" => Ok(TopLevelDomain::INFINITI),
            "INFO" => Ok(TopLevelDomain::INFO),
            "ING" => Ok(TopLevelDomain::ING),
            "INK" => Ok(TopLevelDomain::INK),
            "INSTITUTE" => Ok(TopLevelDomain::INSTITUTE),
            "INSURANCE" => Ok(TopLevelDomain::INSURANCE),
            "INSURE" => Ok(TopLevelDomain::INSURE),
            "INT" => Ok(TopLevelDomain::INT),
            "INTERNATIONAL" => Ok(TopLevelDomain::INTERNATIONAL),
            "INTUIT" => Ok(TopLevelDomain::INTUIT),
            "INVESTMENTS" => Ok(TopLevelDomain::INVESTMENTS),
            "IO" => Ok(TopLevelDomain::IO),
            "IPIRANGA" => Ok(TopLevelDomain::IPIRANGA),
            "IQ" => Ok(TopLevelDomain::IQ),
            "IR" => Ok(TopLevelDomain::IR),
            "IRISH" => Ok(TopLevelDomain::IRISH),
            "IS" => Ok(TopLevelDomain::IS),
            "ISMAILI" => Ok(TopLevelDomain::ISMAILI),
            "IST" => Ok(TopLevelDomain::IST),
            "ISTANBUL" => Ok(TopLevelDomain::ISTANBUL),
            "IT" => Ok(TopLevelDomain::IT),
            "ITAU" => Ok(TopLevelDomain::ITAU),
            "ITV" => Ok(TopLevelDomain::ITV),
            "JAGUAR" => Ok(TopLevelDomain::JAGUAR),
            "JAVA" => Ok(TopLevelDomain::JAVA),
            "JCB" => Ok(TopLevelDomain::JCB),
            "JE" => Ok(TopLevelDomain::JE),
            "JEEP" => Ok(TopLevelDomain::JEEP),
            "JETZT" => Ok(TopLevelDomain::JETZT),
            "JEWELRY" => Ok(TopLevelDomain::JEWELRY),
            "JIO" => Ok(TopLevelDomain::JIO),
            "JLL" => Ok(TopLevelDomain::JLL),
            "JM" => Ok(TopLevelDomain::JM),
            "JMP" => Ok(TopLevelDomain::JMP),
            "JNJ" => Ok(TopLevelDomain::JNJ),
            "JO" => Ok(TopLevelDomain::JO),
            "JOBS" => Ok(TopLevelDomain::JOBS),
            "JOBURG" => Ok(TopLevelDomain::JOBURG),
            "JOT" => Ok(TopLevelDomain::JOT),
            "JOY" => Ok(TopLevelDomain::JOY),
            "JP" => Ok(TopLevelDomain::JP),
            "JPMORGAN" => Ok(TopLevelDomain::JPMORGAN),
            "JPRS" => Ok(TopLevelDomain::JPRS),
            "JUEGOS" => Ok(TopLevelDomain::JUEGOS),
            "JUNIPER" => Ok(TopLevelDomain::JUNIPER),
            "KAUFEN" => Ok(TopLevelDomain::KAUFEN),
            "KDDI" => Ok(TopLevelDomain::KDDI),
            "KE" => Ok(TopLevelDomain::KE),
            "KERRYHOTELS" => Ok(TopLevelDomain::KERRYHOTELS),
            "KERRYLOGISTICS" => Ok(TopLevelDomain::KERRYLOGISTICS),
            "KERRYPROPERTIES" => Ok(TopLevelDomain::KERRYPROPERTIES),
            "KFH" => Ok(TopLevelDomain::KFH),
            "KG" => Ok(TopLevelDomain::KG),
            "KH" => Ok(TopLevelDomain::KH),
            "KI" => Ok(TopLevelDomain::KI),
            "KIA" => Ok(TopLevelDomain::KIA),
            "KIM" => Ok(TopLevelDomain::KIM),
            "KINDER" => Ok(TopLevelDomain::KINDER),
            "KINDLE" => Ok(TopLevelDomain::KINDLE),
            "KITCHEN" => Ok(TopLevelDomain::KITCHEN),
            "KIWI" => Ok(TopLevelDomain::KIWI),
            "KM" => Ok(TopLevelDomain::KM),
            "KN" => Ok(TopLevelDomain::KN),
            "KOELN" => Ok(TopLevelDomain::KOELN),
            "KOMATSU" => Ok(TopLevelDomain::KOMATSU),
            "KOSHER" => Ok(TopLevelDomain::KOSHER),
            "KP" => Ok(TopLevelDomain::KP),
            "KPMG" => Ok(TopLevelDomain::KPMG),
            "KPN" => Ok(TopLevelDomain::KPN),
            "KR" => Ok(TopLevelDomain::KR),
            "KRD" => Ok(TopLevelDomain::KRD),
            "KRED" => Ok(TopLevelDomain::KRED),
            "KUOKGROUP" => Ok(TopLevelDomain::KUOKGROUP),
            "KW" => Ok(TopLevelDomain::KW),
            "KY" => Ok(TopLevelDomain::KY),
            "KYOTO" => Ok(TopLevelDomain::KYOTO),
            "KZ" => Ok(TopLevelDomain::KZ),
            "LA" => Ok(TopLevelDomain::LA),
            "LACAIXA" => Ok(TopLevelDomain::LACAIXA),
            "LAMBORGHINI" => Ok(TopLevelDomain::LAMBORGHINI),
            "LAMER" => Ok(TopLevelDomain::LAMER),
            "LANCASTER" => Ok(TopLevelDomain::LANCASTER),
            "LANCIA" => Ok(TopLevelDomain::LANCIA),
            "LAND" => Ok(TopLevelDomain::LAND),
            "LANDROVER" => Ok(TopLevelDomain::LANDROVER),
            "LANXESS" => Ok(TopLevelDomain::LANXESS),
            "LASALLE" => Ok(TopLevelDomain::LASALLE),
            "LAT" => Ok(TopLevelDomain::LAT),
            "LATINO" => Ok(TopLevelDomain::LATINO),
            "LATROBE" => Ok(TopLevelDomain::LATROBE),
            "LAW" => Ok(TopLevelDomain::LAW),
            "LAWYER" => Ok(TopLevelDomain::LAWYER),
            "LB" => Ok(TopLevelDomain::LB),
            "LC" => Ok(TopLevelDomain::LC),
            "LDS" => Ok(TopLevelDomain::LDS),
            "LEASE" => Ok(TopLevelDomain::LEASE),
            "LECLERC" => Ok(TopLevelDomain::LECLERC),
            "LEFRAK" => Ok(TopLevelDomain::LEFRAK),
            "LEGAL" => Ok(TopLevelDomain::LEGAL),
            "LEGO" => Ok(TopLevelDomain::LEGO),
            "LEXUS" => Ok(TopLevelDomain::LEXUS),
            "LGBT" => Ok(TopLevelDomain::LGBT),
            "LI" => Ok(TopLevelDomain::LI),
            "LIDL" => Ok(TopLevelDomain::LIDL),
            "LIFE" => Ok(TopLevelDomain::LIFE),
            "LIFEINSURANCE" => Ok(TopLevelDomain::LIFEINSURANCE),
            "LIFESTYLE" => Ok(TopLevelDomain::LIFESTYLE),
            "LIGHTING" => Ok(TopLevelDomain::LIGHTING),
            "LIKE" => Ok(TopLevelDomain::LIKE),
            "LILLY" => Ok(TopLevelDomain::LILLY),
            "LIMITED" => Ok(TopLevelDomain::LIMITED),
            "LIMO" => Ok(TopLevelDomain::LIMO),
            "LINCOLN" => Ok(TopLevelDomain::LINCOLN),
            "LINDE" => Ok(TopLevelDomain::LINDE),
            "LINK" => Ok(TopLevelDomain::LINK),
            "LIPSY" => Ok(TopLevelDomain::LIPSY),
            "LIVE" => Ok(TopLevelDomain::LIVE),
            "LIVING" => Ok(TopLevelDomain::LIVING),
            "LIXIL" => Ok(TopLevelDomain::LIXIL),
            "LK" => Ok(TopLevelDomain::LK),
            "LLC" => Ok(TopLevelDomain::LLC),
            "LLP" => Ok(TopLevelDomain::LLP),
            "LOAN" => Ok(TopLevelDomain::LOAN),
            "LOANS" => Ok(TopLevelDomain::LOANS),
            "LOCKER" => Ok(TopLevelDomain::LOCKER),
            "LOCUS" => Ok(TopLevelDomain::LOCUS),
            "LOFT" => Ok(TopLevelDomain::LOFT),
            "LOL" => Ok(TopLevelDomain::LOL),
            "LONDON" => Ok(TopLevelDomain::LONDON),
            "LOTTE" => Ok(TopLevelDomain::LOTTE),
            "LOTTO" => Ok(TopLevelDomain::LOTTO),
            "LOVE" => Ok(TopLevelDomain::LOVE),
            "LPL" => Ok(TopLevelDomain::LPL),
            "LPLFINANCIAL" => Ok(TopLevelDomain::LPLFINANCIAL),
            "LR" => Ok(TopLevelDomain::LR),
            "LS" => Ok(TopLevelDomain::LS),
            "LT" => Ok(TopLevelDomain::LT),
            "LTD" => Ok(TopLevelDomain::LTD),
            "LTDA" => Ok(TopLevelDomain::LTDA),
            "LU" => Ok(TopLevelDomain::LU),
            "LUNDBECK" => Ok(TopLevelDomain::LUNDBECK),
            "LUXE" => Ok(TopLevelDomain::LUXE),
            "LUXURY" => Ok(TopLevelDomain::LUXURY),
            "LV" => Ok(TopLevelDomain::LV),
            "LY" => Ok(TopLevelDomain::LY),
            "MA" => Ok(TopLevelDomain::MA),
            "MACYS" => Ok(TopLevelDomain::MACYS),
            "MADRID" => Ok(TopLevelDomain::MADRID),
            "MAIF" => Ok(TopLevelDomain::MAIF),
            "MAISON" => Ok(TopLevelDomain::MAISON),
            "MAKEUP" => Ok(TopLevelDomain::MAKEUP),
            "MAN" => Ok(TopLevelDomain::MAN),
            "MANAGEMENT" => Ok(TopLevelDomain::MANAGEMENT),
            "MANGO" => Ok(TopLevelDomain::MANGO),
            "MAP" => Ok(TopLevelDomain::MAP),
            "MARKET" => Ok(TopLevelDomain::MARKET),
            "MARKETING" => Ok(TopLevelDomain::MARKETING),
            "MARKETS" => Ok(TopLevelDomain::MARKETS),
            "MARRIOTT" => Ok(TopLevelDomain::MARRIOTT),
            "MARSHALLS" => Ok(TopLevelDomain::MARSHALLS),
            "MASERATI" => Ok(TopLevelDomain::MASERATI),
            "MATTEL" => Ok(TopLevelDomain::MATTEL),
            "MBA" => Ok(TopLevelDomain::MBA),
            "MC" => Ok(TopLevelDomain::MC),
            "MCKINSEY" => Ok(TopLevelDomain::MCKINSEY),
            "MD" => Ok(TopLevelDomain::MD),
            "ME" => Ok(TopLevelDomain::ME),
            "MED" => Ok(TopLevelDomain::MED),
            "MEDIA" => Ok(TopLevelDomain::MEDIA),
            "MEET" => Ok(TopLevelDomain::MEET),
            "MELBOURNE" => Ok(TopLevelDomain::MELBOURNE),
            "MEME" => Ok(TopLevelDomain::MEME),
            "MEMORIAL" => Ok(TopLevelDomain::MEMORIAL),
            "MEN" => Ok(TopLevelDomain::MEN),
            "MENU" => Ok(TopLevelDomain::MENU),
            "MERCKMSD" => Ok(TopLevelDomain::MERCKMSD),
            "MF" => Ok(TopLevelDomain::MF),
            "MG" => Ok(TopLevelDomain::MG),
            "MH" => Ok(TopLevelDomain::MH),
            "MI" => Ok(TopLevelDomain::MI),
            "MIAMI" => Ok(TopLevelDomain::MIAMI),
            "MICROSOFT" => Ok(TopLevelDomain::MICROSOFT),
            "MIL" => Ok(TopLevelDomain::MIL),
            "MINI" => Ok(TopLevelDomain::MINI),
            "MINT" => Ok(TopLevelDomain::MINT),
            "MIT" => Ok(TopLevelDomain::MIT),
            "MITSUBISHI" => Ok(TopLevelDomain::MITSUBISHI),
            "MK" => Ok(TopLevelDomain::MK),
            "ML" => Ok(TopLevelDomain::ML),
            "MLB" => Ok(TopLevelDomain::MLB),
            "MLS" => Ok(TopLevelDomain::MLS),
            "MM" => Ok(TopLevelDomain::MM),
            "MMA" => Ok(TopLevelDomain::MMA),
            "MN" => Ok(TopLevelDomain::MN),
            "MO" => Ok(TopLevelDomain::MO),
            "MOBI" => Ok(TopLevelDomain::MOBI),
            "MOBILE" => Ok(TopLevelDomain::MOBILE),
            "MODA" => Ok(TopLevelDomain::MODA),
            "MOE" => Ok(TopLevelDomain::MOE),
            "MOI" => Ok(TopLevelDomain::MOI),
            "MOM" => Ok(TopLevelDomain::MOM),
            "MONASH" => Ok(TopLevelDomain::MONASH),
            "MONEY" => Ok(TopLevelDomain::MONEY),
            "MONSTER" => Ok(TopLevelDomain::MONSTER),
            "MORMON" => Ok(TopLevelDomain::MORMON),
            "MORTGAGE" => Ok(TopLevelDomain::MORTGAGE),
            "MOSCOW" => Ok(TopLevelDomain::MOSCOW),
            "MOTO" => Ok(TopLevelDomain::MOTO),
            "MOTORCYCLES" => Ok(TopLevelDomain::MOTORCYCLES),
            "MOV" => Ok(TopLevelDomain::MOV),
            "MOVIE" => Ok(TopLevelDomain::MOVIE),
            "MP" => Ok(TopLevelDomain::MP),
            "MQ" => Ok(TopLevelDomain::MQ),
            "MR" => Ok(TopLevelDomain::MR),
            "MS" => Ok(TopLevelDomain::MS),
            "MSD" => Ok(TopLevelDomain::MSD),
            "MT" => Ok(TopLevelDomain::MT),
            "MTN" => Ok(TopLevelDomain::MTN),
            "MTR" => Ok(TopLevelDomain::MTR),
            "MU" => Ok(TopLevelDomain::MU),
            "MUSEUM" => Ok(TopLevelDomain::MUSEUM),
            "MUTUAL" => Ok(TopLevelDomain::MUTUAL),
            "MV" => Ok(TopLevelDomain::MV),
            "MW" => Ok(TopLevelDomain::MW),
            "MX" => Ok(TopLevelDomain::MX),
            "MY" => Ok(TopLevelDomain::MY),
            "MZ" => Ok(TopLevelDomain::MZ),
            "NA" => Ok(TopLevelDomain::NA),
            "NAB" => Ok(TopLevelDomain::NAB),
            "NAGOYA" => Ok(TopLevelDomain::NAGOYA),
            "NAME" => Ok(TopLevelDomain::NAME),
            "NATURA" => Ok(TopLevelDomain::NATURA),
            "NAVY" => Ok(TopLevelDomain::NAVY),
            "NBA" => Ok(TopLevelDomain::NBA),
            "NC" => Ok(TopLevelDomain::NC),
            "NE" => Ok(TopLevelDomain::NE),
            "NEC" => Ok(TopLevelDomain::NEC),
            "NET" => Ok(TopLevelDomain::NET),
            "NETBANK" => Ok(TopLevelDomain::NETBANK),
            "NETFLIX" => Ok(TopLevelDomain::NETFLIX),
            "NETWORK" => Ok(TopLevelDomain::NETWORK),
            "NEUSTAR" => Ok(TopLevelDomain::NEUSTAR),
            "NEW" => Ok(TopLevelDomain::NEW),
            "NEWS" => Ok(TopLevelDomain::NEWS),
            "NEXT" => Ok(TopLevelDomain::NEXT),
            "NEXTDIRECT" => Ok(TopLevelDomain::NEXTDIRECT),
            "NEXUS" => Ok(TopLevelDomain::NEXUS),
            "NF" => Ok(TopLevelDomain::NF),
            "NFL" => Ok(TopLevelDomain::NFL),
            "NG" => Ok(TopLevelDomain::NG),
            "NGO" => Ok(TopLevelDomain::NGO),
            "NHK" => Ok(TopLevelDomain::NHK),
            "NI" => Ok(TopLevelDomain::NI),
            "NICO" => Ok(TopLevelDomain::NICO),
            "NIKE" => Ok(TopLevelDomain::NIKE),
            "NIKON" => Ok(TopLevelDomain::NIKON),
            "NINJA" => Ok(TopLevelDomain::NINJA),
            "NISSAN" => Ok(TopLevelDomain::NISSAN),
            "NISSAY" => Ok(TopLevelDomain::NISSAY),
            "NL" => Ok(TopLevelDomain::NL),
            "NO" => Ok(TopLevelDomain::NO),
            "NOKIA" => Ok(TopLevelDomain::NOKIA),
            "NORTHWESTERNMUTUAL" => Ok(TopLevelDomain::NORTHWESTERNMUTUAL),
            "NORTON" => Ok(TopLevelDomain::NORTON),
            "NOW" => Ok(TopLevelDomain::NOW),
            "NOWRUZ" => Ok(TopLevelDomain::NOWRUZ),
            "NOWTV" => Ok(TopLevelDomain::NOWTV),
            "NP" => Ok(TopLevelDomain::NP),
            "NR" => Ok(TopLevelDomain::NR),
            "NRA" => Ok(TopLevelDomain::NRA),
            "NRW" => Ok(TopLevelDomain::NRW),
            "NTT" => Ok(TopLevelDomain::NTT),
            "NU" => Ok(TopLevelDomain::NU),
            "NYC" => Ok(TopLevelDomain::NYC),
            "NZ" => Ok(TopLevelDomain::NZ),
            "OBI" => Ok(TopLevelDomain::OBI),
            "OBSERVER" => Ok(TopLevelDomain::OBSERVER),
            "OFF" => Ok(TopLevelDomain::OFF),
            "OFFICE" => Ok(TopLevelDomain::OFFICE),
            "OKINAWA" => Ok(TopLevelDomain::OKINAWA),
            "OLAYAN" => Ok(TopLevelDomain::OLAYAN),
            "OLAYANGROUP" => Ok(TopLevelDomain::OLAYANGROUP),
            "OLDNAVY" => Ok(TopLevelDomain::OLDNAVY),
            "OLLO" => Ok(TopLevelDomain::OLLO),
            "OM" => Ok(TopLevelDomain::OM),
            "OMEGA" => Ok(TopLevelDomain::OMEGA),
            "ONE" => Ok(TopLevelDomain::ONE),
            "ONG" => Ok(TopLevelDomain::ONG),
            "ONL" => Ok(TopLevelDomain::ONL),
            "ONLINE" => Ok(TopLevelDomain::ONLINE),
            "OOO" => Ok(TopLevelDomain::OOO),
            "OPEN" => Ok(TopLevelDomain::OPEN),
            "ORACLE" => Ok(TopLevelDomain::ORACLE),
            "ORANGE" => Ok(TopLevelDomain::ORANGE),
            "ORG" => Ok(TopLevelDomain::ORG),
            "ORGANIC" => Ok(TopLevelDomain::ORGANIC),
            "ORIGINS" => Ok(TopLevelDomain::ORIGINS),
            "OSAKA" => Ok(TopLevelDomain::OSAKA),
            "OTSUKA" => Ok(TopLevelDomain::OTSUKA),
            "OTT" => Ok(TopLevelDomain::OTT),
            "OVH" => Ok(TopLevelDomain::OVH),
            "PA" => Ok(TopLevelDomain::PA),
            "PAGE" => Ok(TopLevelDomain::PAGE),
            "PANASONIC" => Ok(TopLevelDomain::PANASONIC),
            "PARIS" => Ok(TopLevelDomain::PARIS),
            "PARS" => Ok(TopLevelDomain::PARS),
            "PARTNERS" => Ok(TopLevelDomain::PARTNERS),
            "PARTS" => Ok(TopLevelDomain::PARTS),
            "PARTY" => Ok(TopLevelDomain::PARTY),
            "PASSAGENS" => Ok(TopLevelDomain::PASSAGENS),
            "PAY" => Ok(TopLevelDomain::PAY),
            "PCCW" => Ok(TopLevelDomain::PCCW),
            "PE" => Ok(TopLevelDomain::PE),
            "PET" => Ok(TopLevelDomain::PET),
            "PF" => Ok(TopLevelDomain::PF),
            "PFIZER" => Ok(TopLevelDomain::PFIZER),
            "PG" => Ok(TopLevelDomain::PG),
            "PH" => Ok(TopLevelDomain::PH),
            "PHARMACY" => Ok(TopLevelDomain::PHARMACY),
            "PHD" => Ok(TopLevelDomain::PHD),
            "PHILIPS" => Ok(TopLevelDomain::PHILIPS),
            "PHONE" => Ok(TopLevelDomain::PHONE),
            "PHOTO" => Ok(TopLevelDomain::PHOTO),
            "PHOTOGRAPHY" => Ok(TopLevelDomain::PHOTOGRAPHY),
            "PHOTOS" => Ok(TopLevelDomain::PHOTOS),
            "PHYSIO" => Ok(TopLevelDomain::PHYSIO),
            "PICS" => Ok(TopLevelDomain::PICS),
            "PICTET" => Ok(TopLevelDomain::PICTET),
            "PICTURES" => Ok(TopLevelDomain::PICTURES),
            "PID" => Ok(TopLevelDomain::PID),
            "PIN" => Ok(TopLevelDomain::PIN),
            "PING" => Ok(TopLevelDomain::PING),
            "PINK" => Ok(TopLevelDomain::PINK),
            "PIONEER" => Ok(TopLevelDomain::PIONEER),
            "PIZZA" => Ok(TopLevelDomain::PIZZA),
            "PK" => Ok(TopLevelDomain::PK),
            "PL" => Ok(TopLevelDomain::PL),
            "PLACE" => Ok(TopLevelDomain::PLACE),
            "PLAY" => Ok(TopLevelDomain::PLAY),
            "PLAYSTATION" => Ok(TopLevelDomain::PLAYSTATION),
            "PLUMBING" => Ok(TopLevelDomain::PLUMBING),
            "PLUS" => Ok(TopLevelDomain::PLUS),
            "PM" => Ok(TopLevelDomain::PM),
            "PN" => Ok(TopLevelDomain::PN),
            "PNC" => Ok(TopLevelDomain::PNC),
            "POHL" => Ok(TopLevelDomain::POHL),
            "POKER" => Ok(TopLevelDomain::POKER),
            "POLITIE" => Ok(TopLevelDomain::POLITIE),
            "PORN" => Ok(TopLevelDomain::PORN),
            "POST" => Ok(TopLevelDomain::POST),
            "PR" => Ok(TopLevelDomain::PR),
            "PRAMERICA" => Ok(TopLevelDomain::PRAMERICA),
            "PRAXI" => Ok(TopLevelDomain::PRAXI),
            "PRESS" => Ok(TopLevelDomain::PRESS),
            "PRIME" => Ok(TopLevelDomain::PRIME),
            "PRO" => Ok(TopLevelDomain::PRO),
            "PROD" => Ok(TopLevelDomain::PROD),
            "PRODUCTIONS" => Ok(TopLevelDomain::PRODUCTIONS),
            "PROF" => Ok(TopLevelDomain::PROF),
            "PROGRESSIVE" => Ok(TopLevelDomain::PROGRESSIVE),
            "PROMO" => Ok(TopLevelDomain::PROMO),
            "PROPERTIES" => Ok(TopLevelDomain::PROPERTIES),
            "PROPERTY" => Ok(TopLevelDomain::PROPERTY),
            "PROTECTION" => Ok(TopLevelDomain::PROTECTION),
            "PRU" => Ok(TopLevelDomain::PRU),
            "PRUDENTIAL" => Ok(TopLevelDomain::PRUDENTIAL),
            "PS" => Ok(TopLevelDomain::PS),
            "PT" => Ok(TopLevelDomain::PT),
            "PUB" => Ok(TopLevelDomain::PUB),
            "PW" => Ok(TopLevelDomain::PW),
            "PWC" => Ok(TopLevelDomain::PWC),
            "PY" => Ok(TopLevelDomain::PY),
            "QA" => Ok(TopLevelDomain::QA),
            "QPON" => Ok(TopLevelDomain::QPON),
            "QUEBEC" => Ok(TopLevelDomain::QUEBEC),
            "QUEST" => Ok(TopLevelDomain::QUEST),
            "QVC" => Ok(TopLevelDomain::QVC),
            "RACING" => Ok(TopLevelDomain::RACING),
            "RADIO" => Ok(TopLevelDomain::RADIO),
            "RAID" => Ok(TopLevelDomain::RAID),
            "RE" => Ok(TopLevelDomain::RE),
            "READ" => Ok(TopLevelDomain::READ),
            "REALESTATE" => Ok(TopLevelDomain::REALESTATE),
            "REALTOR" => Ok(TopLevelDomain::REALTOR),
            "REALTY" => Ok(TopLevelDomain::REALTY),
            "RECIPES" => Ok(TopLevelDomain::RECIPES),
            "RED" => Ok(TopLevelDomain::RED),
            "REDSTONE" => Ok(TopLevelDomain::REDSTONE),
            "REDUMBRELLA" => Ok(TopLevelDomain::REDUMBRELLA),
            "REHAB" => Ok(TopLevelDomain::REHAB),
            "REISE" => Ok(TopLevelDomain::REISE),
            "REISEN" => Ok(TopLevelDomain::REISEN),
            "REIT" => Ok(TopLevelDomain::REIT),
            "RELIANCE" => Ok(TopLevelDomain::RELIANCE),
            "REN" => Ok(TopLevelDomain::REN),
            "RENT" => Ok(TopLevelDomain::RENT),
            "RENTALS" => Ok(TopLevelDomain::RENTALS),
            "REPAIR" => Ok(TopLevelDomain::REPAIR),
            "REPORT" => Ok(TopLevelDomain::REPORT),
            "REPUBLICAN" => Ok(TopLevelDomain::REPUBLICAN),
            "REST" => Ok(TopLevelDomain::REST),
            "RESTAURANT" => Ok(TopLevelDomain::RESTAURANT),
            "REVIEW" => Ok(TopLevelDomain::REVIEW),
            "REVIEWS" => Ok(TopLevelDomain::REVIEWS),
            "REXROTH" => Ok(TopLevelDomain::REXROTH),
            "RICH" => Ok(TopLevelDomain::RICH),
            "RICHARDLI" => Ok(TopLevelDomain::RICHARDLI),
            "RICOH" => Ok(TopLevelDomain::RICOH),
            "RIL" => Ok(TopLevelDomain::RIL),
            "RIO" => Ok(TopLevelDomain::RIO),
            "RIP" => Ok(TopLevelDomain::RIP),
            "RMIT" => Ok(TopLevelDomain::RMIT),
            "RO" => Ok(TopLevelDomain::RO),
            "ROCHER" => Ok(TopLevelDomain::ROCHER),
            "ROCKS" => Ok(TopLevelDomain::ROCKS),
            "RODEO" => Ok(TopLevelDomain::RODEO),
            "ROGERS" => Ok(TopLevelDomain::ROGERS),
            "ROOM" => Ok(TopLevelDomain::ROOM),
            "RS" => Ok(TopLevelDomain::RS),
            "RSVP" => Ok(TopLevelDomain::RSVP),
            "RU" => Ok(TopLevelDomain::RU),
            "RUGBY" => Ok(TopLevelDomain::RUGBY),
            "RUHR" => Ok(TopLevelDomain::RUHR),
            "RUN" => Ok(TopLevelDomain::RUN),
            "RW" => Ok(TopLevelDomain::RW),
            "RWE" => Ok(TopLevelDomain::RWE),
            "RYUKYU" => Ok(TopLevelDomain::RYUKYU),
            "SA" => Ok(TopLevelDomain::SA),
            "SAARLAND" => Ok(TopLevelDomain::SAARLAND),
            "SAFE" => Ok(TopLevelDomain::SAFE),
            "SAFETY" => Ok(TopLevelDomain::SAFETY),
            "SAKURA" => Ok(TopLevelDomain::SAKURA),
            "SALE" => Ok(TopLevelDomain::SALE),
            "SALON" => Ok(TopLevelDomain::SALON),
            "SAMSCLUB" => Ok(TopLevelDomain::SAMSCLUB),
            "SAMSUNG" => Ok(TopLevelDomain::SAMSUNG),
            "SANDVIK" => Ok(TopLevelDomain::SANDVIK),
            "SANDVIKCOROMANT" => Ok(TopLevelDomain::SANDVIKCOROMANT),
            "SANOFI" => Ok(TopLevelDomain::SANOFI),
            "SAP" => Ok(TopLevelDomain::SAP),
            "SARL" => Ok(TopLevelDomain::SARL),
            "SAS" => Ok(TopLevelDomain::SAS),
            "SAVE" => Ok(TopLevelDomain::SAVE),
            "SAXO" => Ok(TopLevelDomain::SAXO),
            "SB" => Ok(TopLevelDomain::SB),
            "SBI" => Ok(TopLevelDomain::SBI),
            "SBS" => Ok(TopLevelDomain::SBS),
            "SC" => Ok(TopLevelDomain::SC),
            "SCA" => Ok(TopLevelDomain::SCA),
            "SCB" => Ok(TopLevelDomain::SCB),
            "SCHAEFFLER" => Ok(TopLevelDomain::SCHAEFFLER),
            "SCHMIDT" => Ok(TopLevelDomain::SCHMIDT),
            "SCHOLARSHIPS" => Ok(TopLevelDomain::SCHOLARSHIPS),
            "SCHOOL" => Ok(TopLevelDomain::SCHOOL),
            "SCHULE" => Ok(TopLevelDomain::SCHULE),
            "SCHWARZ" => Ok(TopLevelDomain::SCHWARZ),
            "SCIENCE" => Ok(TopLevelDomain::SCIENCE),
            "SCJOHNSON" => Ok(TopLevelDomain::SCJOHNSON),
            "SCOT" => Ok(TopLevelDomain::SCOT),
            "SD" => Ok(TopLevelDomain::SD),
            "SE" => Ok(TopLevelDomain::SE),
            "SEARCH" => Ok(TopLevelDomain::SEARCH),
            "SEAT" => Ok(TopLevelDomain::SEAT),
            "SECURE" => Ok(TopLevelDomain::SECURE),
            "SECURITY" => Ok(TopLevelDomain::SECURITY),
            "SEEK" => Ok(TopLevelDomain::SEEK),
            "SELECT" => Ok(TopLevelDomain::SELECT),
            "SENER" => Ok(TopLevelDomain::SENER),
            "SERVICES" => Ok(TopLevelDomain::SERVICES),
            "SES" => Ok(TopLevelDomain::SES),
            "SEVEN" => Ok(TopLevelDomain::SEVEN),
            "SEW" => Ok(TopLevelDomain::SEW),
            "SEX" => Ok(TopLevelDomain::SEX),
            "SEXY" => Ok(TopLevelDomain::SEXY),
            "SFR" => Ok(TopLevelDomain::SFR),
            "SG" => Ok(TopLevelDomain::SG),
            "SH" => Ok(TopLevelDomain::SH),
            "SHANGRILA" => Ok(TopLevelDomain::SHANGRILA),
            "SHARP" => Ok(TopLevelDomain::SHARP),
            "SHAW" => Ok(TopLevelDomain::SHAW),
            "SHELL" => Ok(TopLevelDomain::SHELL),
            "SHIA" => Ok(TopLevelDomain::SHIA),
            "SHIKSHA" => Ok(TopLevelDomain::SHIKSHA),
            "SHOES" => Ok(TopLevelDomain::SHOES),
            "SHOP" => Ok(TopLevelDomain::SHOP),
            "SHOPPING" => Ok(TopLevelDomain::SHOPPING),
            "SHOUJI" => Ok(TopLevelDomain::SHOUJI),
            "SHOW" => Ok(TopLevelDomain::SHOW),
            "SHOWTIME" => Ok(TopLevelDomain::SHOWTIME),
            "SI" => Ok(TopLevelDomain::SI),
            "SILK" => Ok(TopLevelDomain::SILK),
            "SINA" => Ok(TopLevelDomain::SINA),
            "SINGLES" => Ok(TopLevelDomain::SINGLES),
            "SITE" => Ok(TopLevelDomain::SITE),
            "SJ" => Ok(TopLevelDomain::SJ),
            "SK" => Ok(TopLevelDomain::SK),
            "SKI" => Ok(TopLevelDomain::SKI),
            "SKIN" => Ok(TopLevelDomain::SKIN),
            "SKY" => Ok(TopLevelDomain::SKY),
            "SKYPE" => Ok(TopLevelDomain::SKYPE),
            "SL" => Ok(TopLevelDomain::SL),
            "SLING" => Ok(TopLevelDomain::SLING),
            "SM" => Ok(TopLevelDomain::SM),
            "SMART" => Ok(TopLevelDomain::SMART),
            "SMILE" => Ok(TopLevelDomain::SMILE),
            "SN" => Ok(TopLevelDomain::SN),
            "SNCF" => Ok(TopLevelDomain::SNCF),
            "SO" => Ok(TopLevelDomain::SO),
            "SOCCER" => Ok(TopLevelDomain::SOCCER),
            "SOCIAL" => Ok(TopLevelDomain::SOCIAL),
            "SOFTBANK" => Ok(TopLevelDomain::SOFTBANK),
            "SOFTWARE" => Ok(TopLevelDomain::SOFTWARE),
            "SOHU" => Ok(TopLevelDomain::SOHU),
            "SOLAR" => Ok(TopLevelDomain::SOLAR),
            "SOLUTIONS" => Ok(TopLevelDomain::SOLUTIONS),
            "SONG" => Ok(TopLevelDomain::SONG),
            "SONY" => Ok(TopLevelDomain::SONY),
            "SOY" => Ok(TopLevelDomain::SOY),
            "SPA" => Ok(TopLevelDomain::SPA),
            "SPACE" => Ok(TopLevelDomain::SPACE),
            "SPORT" => Ok(TopLevelDomain::SPORT),
            "SPOT" => Ok(TopLevelDomain::SPOT),
            "SR" => Ok(TopLevelDomain::SR),
            "SRL" => Ok(TopLevelDomain::SRL),
            "SS" => Ok(TopLevelDomain::SS),
            "ST" => Ok(TopLevelDomain::ST),
            "STADA" => Ok(TopLevelDomain::STADA),
            "STAPLES" => Ok(TopLevelDomain::STAPLES),
            "STAR" => Ok(TopLevelDomain::STAR),
            "STATEBANK" => Ok(TopLevelDomain::STATEBANK),
            "STATEFARM" => Ok(TopLevelDomain::STATEFARM),
            "STC" => Ok(TopLevelDomain::STC),
            "STCGROUP" => Ok(TopLevelDomain::STCGROUP),
            "STOCKHOLM" => Ok(TopLevelDomain::STOCKHOLM),
            "STORAGE" => Ok(TopLevelDomain::STORAGE),
            "STORE" => Ok(TopLevelDomain::STORE),
            "STREAM" => Ok(TopLevelDomain::STREAM),
            "STUDIO" => Ok(TopLevelDomain::STUDIO),
            "STUDY" => Ok(TopLevelDomain::STUDY),
            "STYLE" => Ok(TopLevelDomain::STYLE),
            "SU" => Ok(TopLevelDomain::SU),
            "SUCKS" => Ok(TopLevelDomain::SUCKS),
            "SUPPLIES" => Ok(TopLevelDomain::SUPPLIES),
            "SUPPLY" => Ok(TopLevelDomain::SUPPLY),
            "SUPPORT" => Ok(TopLevelDomain::SUPPORT),
            "SURF" => Ok(TopLevelDomain::SURF),
            "SURGERY" => Ok(TopLevelDomain::SURGERY),
            "SUZUKI" => Ok(TopLevelDomain::SUZUKI),
            "SV" => Ok(TopLevelDomain::SV),
            "SWATCH" => Ok(TopLevelDomain::SWATCH),
            "SWIFTCOVER" => Ok(TopLevelDomain::SWIFTCOVER),
            "SWISS" => Ok(TopLevelDomain::SWISS),
            "SX" => Ok(TopLevelDomain::SX),
            "SY" => Ok(TopLevelDomain::SY),
            "SYDNEY" => Ok(TopLevelDomain::SYDNEY),
            "SYSTEMS" => Ok(TopLevelDomain::SYSTEMS),
            "SZ" => Ok(TopLevelDomain::SZ),
            "TAB" => Ok(TopLevelDomain::TAB),
            "TAIPEI" => Ok(TopLevelDomain::TAIPEI),
            "TALK" => Ok(TopLevelDomain::TALK),
            "TAOBAO" => Ok(TopLevelDomain::TAOBAO),
            "TARGET" => Ok(TopLevelDomain::TARGET),
            "TATAMOTORS" => Ok(TopLevelDomain::TATAMOTORS),
            "TATAR" => Ok(TopLevelDomain::TATAR),
            "TATTOO" => Ok(TopLevelDomain::TATTOO),
            "TAX" => Ok(TopLevelDomain::TAX),
            "TAXI" => Ok(TopLevelDomain::TAXI),
            "TC" => Ok(TopLevelDomain::TC),
            "TCI" => Ok(TopLevelDomain::TCI),
            "TD" => Ok(TopLevelDomain::TD),
            "TDK" => Ok(TopLevelDomain::TDK),
            "TEAM" => Ok(TopLevelDomain::TEAM),
            "TECH" => Ok(TopLevelDomain::TECH),
            "TECHNOLOGY" => Ok(TopLevelDomain::TECHNOLOGY),
            "TEL" => Ok(TopLevelDomain::TEL),
            "TEMASEK" => Ok(TopLevelDomain::TEMASEK),
            "TENNIS" => Ok(TopLevelDomain::TENNIS),
            "TEVA" => Ok(TopLevelDomain::TEVA),
            "TF" => Ok(TopLevelDomain::TF),
            "TG" => Ok(TopLevelDomain::TG),
            "TH" => Ok(TopLevelDomain::TH),
            "THD" => Ok(TopLevelDomain::THD),
            "THEATER" => Ok(TopLevelDomain::THEATER),
            "THEATRE" => Ok(TopLevelDomain::THEATRE),
            "TIAA" => Ok(TopLevelDomain::TIAA),
            "TICKETS" => Ok(TopLevelDomain::TICKETS),
            "TIENDA" => Ok(TopLevelDomain::TIENDA),
            "TIFFANY" => Ok(TopLevelDomain::TIFFANY),
            "TIPS" => Ok(TopLevelDomain::TIPS),
            "TIRES" => Ok(TopLevelDomain::TIRES),
            "TIROL" => Ok(TopLevelDomain::TIROL),
            "TJ" => Ok(TopLevelDomain::TJ),
            "TJMAXX" => Ok(TopLevelDomain::TJMAXX),
            "TJX" => Ok(TopLevelDomain::TJX),
            "TK" => Ok(TopLevelDomain::TK),
            "TKMAXX" => Ok(TopLevelDomain::TKMAXX),
            "TL" => Ok(TopLevelDomain::TL),
            "TM" => Ok(TopLevelDomain::TM),
            "TMALL" => Ok(TopLevelDomain::TMALL),
            "TN" => Ok(TopLevelDomain::TN),
            "TO" => Ok(TopLevelDomain::TO),
            "TODAY" => Ok(TopLevelDomain::TODAY),
            "TOKYO" => Ok(TopLevelDomain::TOKYO),
            "TOOLS" => Ok(TopLevelDomain::TOOLS),
            "TOP" => Ok(TopLevelDomain::TOP),
            "TORAY" => Ok(TopLevelDomain::TORAY),
            "TOSHIBA" => Ok(TopLevelDomain::TOSHIBA),
            "TOTAL" => Ok(TopLevelDomain::TOTAL),
            "TOURS" => Ok(TopLevelDomain::TOURS),
            "TOWN" => Ok(TopLevelDomain::TOWN),
            "TOYOTA" => Ok(TopLevelDomain::TOYOTA),
            "TOYS" => Ok(TopLevelDomain::TOYS),
            "TR" => Ok(TopLevelDomain::TR),
            "TRADE" => Ok(TopLevelDomain::TRADE),
            "TRADING" => Ok(TopLevelDomain::TRADING),
            "TRAINING" => Ok(TopLevelDomain::TRAINING),
            "TRAVEL" => Ok(TopLevelDomain::TRAVEL),
            "TRAVELCHANNEL" => Ok(TopLevelDomain::TRAVELCHANNEL),
            "TRAVELERS" => Ok(TopLevelDomain::TRAVELERS),
            "TRAVELERSINSURANCE" => Ok(TopLevelDomain::TRAVELERSINSURANCE),
            "TRUST" => Ok(TopLevelDomain::TRUST),
            "TRV" => Ok(TopLevelDomain::TRV),
            "TT" => Ok(TopLevelDomain::TT),
            "TUBE" => Ok(TopLevelDomain::TUBE),
            "TUI" => Ok(TopLevelDomain::TUI),
            "TUNES" => Ok(TopLevelDomain::TUNES),
            "TUSHU" => Ok(TopLevelDomain::TUSHU),
            "TV" => Ok(TopLevelDomain::TV),
            "TVS" => Ok(TopLevelDomain::TVS),
            "TW" => Ok(TopLevelDomain::TW),
            "TZ" => Ok(TopLevelDomain::TZ),
            "UA" => Ok(TopLevelDomain::UA),
            "UBANK" => Ok(TopLevelDomain::UBANK),
            "UBS" => Ok(TopLevelDomain::UBS),
            "UG" => Ok(TopLevelDomain::UG),
            "UK" => Ok(TopLevelDomain::UK),
            "UM" => Ok(TopLevelDomain::UM),
            "UNICOM" => Ok(TopLevelDomain::UNICOM),
            "UNIVERSITY" => Ok(TopLevelDomain::UNIVERSITY),
            "UNO" => Ok(TopLevelDomain::UNO),
            "UOL" => Ok(TopLevelDomain::UOL),
            "UPS" => Ok(TopLevelDomain::UPS),
            "US" => Ok(TopLevelDomain::US),
            "UY" => Ok(TopLevelDomain::UY),
            "UZ" => Ok(TopLevelDomain::UZ),
            "VA" => Ok(TopLevelDomain::VA),
            "VACATIONS" => Ok(TopLevelDomain::VACATIONS),
            "VANA" => Ok(TopLevelDomain::VANA),
            "VANGUARD" => Ok(TopLevelDomain::VANGUARD),
            "VC" => Ok(TopLevelDomain::VC),
            "VE" => Ok(TopLevelDomain::VE),
            "VEGAS" => Ok(TopLevelDomain::VEGAS),
            "VENTURES" => Ok(TopLevelDomain::VENTURES),
            "VERISIGN" => Ok(TopLevelDomain::VERISIGN),
            "VERSICHERUNG" => Ok(TopLevelDomain::VERSICHERUNG),
            "VET" => Ok(TopLevelDomain::VET),
            "VG" => Ok(TopLevelDomain::VG),
            "VI" => Ok(TopLevelDomain::VI),
            "VIAJES" => Ok(TopLevelDomain::VIAJES),
            "VIDEO" => Ok(TopLevelDomain::VIDEO),
            "VIG" => Ok(TopLevelDomain::VIG),
            "VIKING" => Ok(TopLevelDomain::VIKING),
            "VILLAS" => Ok(TopLevelDomain::VILLAS),
            "VIN" => Ok(TopLevelDomain::VIN),
            "VIP" => Ok(TopLevelDomain::VIP),
            "VIRGIN" => Ok(TopLevelDomain::VIRGIN),
            "VISA" => Ok(TopLevelDomain::VISA),
            "VISION" => Ok(TopLevelDomain::VISION),
            "VIVA" => Ok(TopLevelDomain::VIVA),
            "VIVO" => Ok(TopLevelDomain::VIVO),
            "VLAANDEREN" => Ok(TopLevelDomain::VLAANDEREN),
            "VN" => Ok(TopLevelDomain::VN),
            "VODKA" => Ok(TopLevelDomain::VODKA),
            "VOLKSWAGEN" => Ok(TopLevelDomain::VOLKSWAGEN),
            "VOLVO" => Ok(TopLevelDomain::VOLVO),
            "VOTE" => Ok(TopLevelDomain::VOTE),
            "VOTING" => Ok(TopLevelDomain::VOTING),
            "VOTO" => Ok(TopLevelDomain::VOTO),
            "VOYAGE" => Ok(TopLevelDomain::VOYAGE),
            "VU" => Ok(TopLevelDomain::VU),
            "VUELOS" => Ok(TopLevelDomain::VUELOS),
            "WALES" => Ok(TopLevelDomain::WALES),
            "WALMART" => Ok(TopLevelDomain::WALMART),
            "WALTER" => Ok(TopLevelDomain::WALTER),
            "WANG" => Ok(TopLevelDomain::WANG),
            "WANGGOU" => Ok(TopLevelDomain::WANGGOU),
            "WATCH" => Ok(TopLevelDomain::WATCH),
            "WATCHES" => Ok(TopLevelDomain::WATCHES),
            "WEATHER" => Ok(TopLevelDomain::WEATHER),
            "WEATHERCHANNEL" => Ok(TopLevelDomain::WEATHERCHANNEL),
            "WEBCAM" => Ok(TopLevelDomain::WEBCAM),
            "WEBER" => Ok(TopLevelDomain::WEBER),
            "WEBSITE" => Ok(TopLevelDomain::WEBSITE),
            "WED" => Ok(TopLevelDomain::WED),
            "WEDDING" => Ok(TopLevelDomain::WEDDING),
            "WEIBO" => Ok(TopLevelDomain::WEIBO),
            "WEIR" => Ok(TopLevelDomain::WEIR),
            "WF" => Ok(TopLevelDomain::WF),
            "WHOSWHO" => Ok(TopLevelDomain::WHOSWHO),
            "WIEN" => Ok(TopLevelDomain::WIEN),
            "WIKI" => Ok(TopLevelDomain::WIKI),
            "WILLIAMHILL" => Ok(TopLevelDomain::WILLIAMHILL),
            "WIN" => Ok(TopLevelDomain::WIN),
            "WINDOWS" => Ok(TopLevelDomain::WINDOWS),
            "WINE" => Ok(TopLevelDomain::WINE),
            "WINNERS" => Ok(TopLevelDomain::WINNERS),
            "WME" => Ok(TopLevelDomain::WME),
            "WOLTERSKLUWER" => Ok(TopLevelDomain::WOLTERSKLUWER),
            "WOODSIDE" => Ok(TopLevelDomain::WOODSIDE),
            "WORK" => Ok(TopLevelDomain::WORK),
            "WORKS" => Ok(TopLevelDomain::WORKS),
            "WORLD" => Ok(TopLevelDomain::WORLD),
            "WOW" => Ok(TopLevelDomain::WOW),
            "WS" => Ok(TopLevelDomain::WS),
            "WTC" => Ok(TopLevelDomain::WTC),
            "WTF" => Ok(TopLevelDomain::WTF),
            "XBOX" => Ok(TopLevelDomain::XBOX),
            "XEROX" => Ok(TopLevelDomain::XEROX),
            "XFINITY" => Ok(TopLevelDomain::XFINITY),
            "XIHUAN" => Ok(TopLevelDomain::XIHUAN),
            "XIN" => Ok(TopLevelDomain::XIN),
            "XN" => Ok(TopLevelDomain::XN),
            "XXX" => Ok(TopLevelDomain::XXX),
            "XYZ" => Ok(TopLevelDomain::XYZ),
            "YACHTS" => Ok(TopLevelDomain::YACHTS),
            "YAHOO" => Ok(TopLevelDomain::YAHOO),
            "YAMAXUN" => Ok(TopLevelDomain::YAMAXUN),
            "YANDEX" => Ok(TopLevelDomain::YANDEX),
            "YE" => Ok(TopLevelDomain::YE),
            "YODOBASHI" => Ok(TopLevelDomain::YODOBASHI),
            "YOGA" => Ok(TopLevelDomain::YOGA),
            "YOKOHAMA" => Ok(TopLevelDomain::YOKOHAMA),
            "YOU" => Ok(TopLevelDomain::YOU),
            "YOUTUBE" => Ok(TopLevelDomain::YOUTUBE),
            "YT" => Ok(TopLevelDomain::YT),
            "YUN" => Ok(TopLevelDomain::YUN),
            "ZA" => Ok(TopLevelDomain::ZA),
            "ZAPPOS" => Ok(TopLevelDomain::ZAPPOS),
            "ZARA" => Ok(TopLevelDomain::ZARA),
            "ZERO" => Ok(TopLevelDomain::ZERO),
            "ZIP" => Ok(TopLevelDomain::ZIP),
            "ZM" => Ok(TopLevelDomain::ZM),
            "ZONE" => Ok(TopLevelDomain::ZONE),
            "ZUERICH" => Ok(TopLevelDomain::ZUERICH),
            "ZW" => Ok(TopLevelDomain::ZW),
            _ => Err(()),
        }
    }
}

impl fmt::Display for TopLevelDomain {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        fmt::Debug::fmt(self, f)
    }
}
