use crate::models::country::NUMBER_OF_COUNTRIES;
use serde::{Deserialize, Serialize};
use std::fmt;
use std::slice::Iter;
use std::str::FromStr;

#[derive(PartialEq, Eq, Hash, Clone, Debug, Serialize, Deserialize)]
pub enum Iso2 {
    AD,
    AE,
    AF,
    AG,
    AI,
    AL,
    AM,
    AN,
    AO,
    AQ,
    AR,
    AS,
    AT,
    AU,
    AW,
    AX,
    AZ,
    BA,
    BB,
    BD,
    BE,
    BF,
    BG,
    BH,
    BI,
    BJ,
    BL,
    BM,
    BN,
    BO,
    BQ,
    BR,
    BS,
    BT,
    BV,
    BW,
    BY,
    BZ,
    CA,
    CC,
    CD,
    CF,
    CG,
    CH,
    CI,
    CK,
    CL,
    CM,
    CN,
    CO,
    CR,
    CU,
    CV,
    CW,
    CX,
    CY,
    CZ,
    DE,
    DJ,
    DK,
    DM,
    DO,
    DZ,
    EC,
    EE,
    EG,
    EH,
    ER,
    ES,
    ET,
    FI,
    FJ,
    FK,
    FM,
    FO,
    FR,
    GA,
    GB,
    GD,
    GE,
    GF,
    GG,
    GH,
    GI,
    GL,
    GM,
    GN,
    GP,
    GQ,
    GR,
    GS,
    GT,
    GU,
    GW,
    GY,
    HK,
    HM,
    HN,
    HR,
    HT,
    HU,
    ID,
    IE,
    IL,
    IM,
    IN,
    IO,
    IQ,
    IR,
    IS,
    IT,
    JE,
    JM,
    JO,
    JP,
    KE,
    KG,
    KH,
    KI,
    KM,
    KN,
    KP,
    KR,
    KW,
    KY,
    KZ,
    LA,
    LB,
    LC,
    LI,
    LK,
    LR,
    LS,
    LT,
    LU,
    LV,
    LY,
    MA,
    MC,
    MD,
    ME,
    MF,
    MG,
    MH,
    MI,
    MK,
    ML,
    MM,
    MN,
    MO,
    MP,
    MQ,
    MR,
    MS,
    MT,
    MU,
    MV,
    MW,
    MX,
    MY,
    MZ,
    NA,
    NC,
    NE,
    NF,
    NG,
    NI,
    NL,
    NO,
    NP,
    NR,
    NU,
    NZ,
    OM,
    PA,
    PE,
    PF,
    PG,
    PH,
    PK,
    PL,
    PM,
    PN,
    PR,
    PS,
    PT,
    PW,
    PY,
    QA,
    RE,
    RO,
    RS,
    RU,
    RW,
    SA,
    SB,
    SC,
    SD,
    SE,
    SG,
    SH,
    SI,
    SJ,
    SK,
    SL,
    SM,
    SN,
    SO,
    SR,
    SS,
    ST,
    SV,
    SX,
    SY,
    SZ,
    TC,
    TD,
    TF,
    TG,
    TH,
    TJ,
    TK,
    TL,
    TM,
    TN,
    TO,
    TR,
    TT,
    TV,
    TW,
    TZ,
    UA,
    UG,
    UM,
    US,
    UY,
    UZ,
    VA,
    VC,
    VE,
    VG,
    VI,
    VN,
    VU,
    WF,
    WS,
    YE,
    YT,
    ZA,
    ZM,
    ZW,
}

impl Iso2 {
    pub fn iter() -> Iter<'static, Iso2> {
        const ALL_ISO2: [Iso2; NUMBER_OF_COUNTRIES as usize] = [
            Iso2::AD,
            Iso2::AE,
            Iso2::AF,
            Iso2::AG,
            Iso2::AI,
            Iso2::AL,
            Iso2::AM,
            Iso2::AN,
            Iso2::AO,
            Iso2::AQ,
            Iso2::AR,
            Iso2::AS,
            Iso2::AT,
            Iso2::AU,
            Iso2::AW,
            Iso2::AX,
            Iso2::AZ,
            Iso2::BA,
            Iso2::BB,
            Iso2::BD,
            Iso2::BE,
            Iso2::BF,
            Iso2::BG,
            Iso2::BH,
            Iso2::BI,
            Iso2::BJ,
            Iso2::BL,
            Iso2::BM,
            Iso2::BN,
            Iso2::BO,
            Iso2::BQ,
            Iso2::BR,
            Iso2::BS,
            Iso2::BT,
            Iso2::BV,
            Iso2::BW,
            Iso2::BY,
            Iso2::BZ,
            Iso2::CA,
            Iso2::CC,
            Iso2::CD,
            Iso2::CF,
            Iso2::CG,
            Iso2::CH,
            Iso2::CI,
            Iso2::CK,
            Iso2::CL,
            Iso2::CM,
            Iso2::CN,
            Iso2::CO,
            Iso2::CR,
            Iso2::CU,
            Iso2::CV,
            Iso2::CW,
            Iso2::CX,
            Iso2::CY,
            Iso2::CZ,
            Iso2::DE,
            Iso2::DJ,
            Iso2::DK,
            Iso2::DM,
            Iso2::DO,
            Iso2::DZ,
            Iso2::EC,
            Iso2::EE,
            Iso2::EG,
            Iso2::EH,
            Iso2::ER,
            Iso2::ES,
            Iso2::ET,
            Iso2::FI,
            Iso2::FJ,
            Iso2::FK,
            Iso2::FM,
            Iso2::FO,
            Iso2::FR,
            Iso2::GA,
            Iso2::GB,
            Iso2::GD,
            Iso2::GE,
            Iso2::GF,
            Iso2::GG,
            Iso2::GH,
            Iso2::GI,
            Iso2::GL,
            Iso2::GM,
            Iso2::GN,
            Iso2::GP,
            Iso2::GQ,
            Iso2::GR,
            Iso2::GS,
            Iso2::GT,
            Iso2::GU,
            Iso2::GW,
            Iso2::GY,
            Iso2::HK,
            Iso2::HM,
            Iso2::HN,
            Iso2::HR,
            Iso2::HT,
            Iso2::HU,
            Iso2::ID,
            Iso2::IE,
            Iso2::IL,
            Iso2::IM,
            Iso2::IN,
            Iso2::IO,
            Iso2::IQ,
            Iso2::IR,
            Iso2::IS,
            Iso2::IT,
            Iso2::JE,
            Iso2::JM,
            Iso2::JO,
            Iso2::JP,
            Iso2::KE,
            Iso2::KG,
            Iso2::KH,
            Iso2::KI,
            Iso2::KM,
            Iso2::KN,
            Iso2::KP,
            Iso2::KR,
            Iso2::KW,
            Iso2::KY,
            Iso2::KZ,
            Iso2::LA,
            Iso2::LB,
            Iso2::LC,
            Iso2::LI,
            Iso2::LK,
            Iso2::LR,
            Iso2::LS,
            Iso2::LT,
            Iso2::LU,
            Iso2::LV,
            Iso2::LY,
            Iso2::MA,
            Iso2::MC,
            Iso2::MD,
            Iso2::ME,
            Iso2::MF,
            Iso2::MG,
            Iso2::MH,
            Iso2::MI,
            Iso2::MK,
            Iso2::ML,
            Iso2::MM,
            Iso2::MN,
            Iso2::MO,
            Iso2::MP,
            Iso2::MQ,
            Iso2::MR,
            Iso2::MS,
            Iso2::MT,
            Iso2::MU,
            Iso2::MV,
            Iso2::MW,
            Iso2::MX,
            Iso2::MY,
            Iso2::MZ,
            Iso2::NA,
            Iso2::NC,
            Iso2::NE,
            Iso2::NF,
            Iso2::NG,
            Iso2::NI,
            Iso2::NL,
            Iso2::NO,
            Iso2::NP,
            Iso2::NR,
            Iso2::NU,
            Iso2::NZ,
            Iso2::OM,
            Iso2::PA,
            Iso2::PE,
            Iso2::PF,
            Iso2::PG,
            Iso2::PH,
            Iso2::PK,
            Iso2::PL,
            Iso2::PM,
            Iso2::PN,
            Iso2::PR,
            Iso2::PS,
            Iso2::PT,
            Iso2::PW,
            Iso2::PY,
            Iso2::QA,
            Iso2::RE,
            Iso2::RO,
            Iso2::RS,
            Iso2::RU,
            Iso2::RW,
            Iso2::SA,
            Iso2::SB,
            Iso2::SC,
            Iso2::SD,
            Iso2::SE,
            Iso2::SG,
            Iso2::SH,
            Iso2::SI,
            Iso2::SJ,
            Iso2::SK,
            Iso2::SL,
            Iso2::SM,
            Iso2::SN,
            Iso2::SO,
            Iso2::SR,
            Iso2::SS,
            Iso2::ST,
            Iso2::SV,
            Iso2::SX,
            Iso2::SY,
            Iso2::SZ,
            Iso2::TC,
            Iso2::TD,
            Iso2::TF,
            Iso2::TG,
            Iso2::TH,
            Iso2::TJ,
            Iso2::TK,
            Iso2::TL,
            Iso2::TM,
            Iso2::TN,
            Iso2::TO,
            Iso2::TR,
            Iso2::TT,
            Iso2::TV,
            Iso2::TW,
            Iso2::TZ,
            Iso2::UA,
            Iso2::UG,
            Iso2::UM,
            Iso2::US,
            Iso2::UY,
            Iso2::UZ,
            Iso2::VA,
            Iso2::VC,
            Iso2::VE,
            Iso2::VG,
            Iso2::VI,
            Iso2::VN,
            Iso2::VU,
            Iso2::WF,
            Iso2::WS,
            Iso2::YE,
            Iso2::YT,
            Iso2::ZA,
            Iso2::ZM,
            Iso2::ZW,
        ];
        ALL_ISO2.iter()
    }
    pub fn covert(iso: Iso3) -> Iso2 {
        match iso {
            Iso3::ABW => Iso2::AW,
            Iso3::AFG => Iso2::AF,
            Iso3::AGO => Iso2::AO,
            Iso3::AIA => Iso2::AI,
            Iso3::ALA => Iso2::AX,
            Iso3::ALB => Iso2::AL,
            Iso3::AND => Iso2::AD,
            Iso3::ANT => Iso2::AN,
            Iso3::ARE => Iso2::AE,
            Iso3::ARG => Iso2::AR,
            Iso3::ARM => Iso2::AM,
            Iso3::ASM => Iso2::AS,
            Iso3::ATA => Iso2::AQ,
            Iso3::ATF => Iso2::TF,
            Iso3::ATG => Iso2::AG,
            Iso3::AUS => Iso2::AU,
            Iso3::AUT => Iso2::AT,
            Iso3::AZE => Iso2::AZ,
            Iso3::BDI => Iso2::BI,
            Iso3::BEL => Iso2::BE,
            Iso3::BEN => Iso2::BJ,
            Iso3::BES => Iso2::BQ,
            Iso3::BFA => Iso2::BF,
            Iso3::BGD => Iso2::BD,
            Iso3::BGR => Iso2::BG,
            Iso3::BHR => Iso2::BH,
            Iso3::BHS => Iso2::BS,
            Iso3::BIH => Iso2::BA,
            Iso3::BLM => Iso2::BL,
            Iso3::BLR => Iso2::BY,
            Iso3::BLZ => Iso2::BZ,
            Iso3::BMU => Iso2::BM,
            Iso3::BOL => Iso2::BO,
            Iso3::BRA => Iso2::BR,
            Iso3::BRB => Iso2::BB,
            Iso3::BRN => Iso2::BN,
            Iso3::BTN => Iso2::BT,
            Iso3::BVT => Iso2::BV,
            Iso3::BWA => Iso2::BW,
            Iso3::CAF => Iso2::CF,
            Iso3::CAN => Iso2::CA,
            Iso3::CCK => Iso2::CC,
            Iso3::CHE => Iso2::CH,
            Iso3::CHL => Iso2::CL,
            Iso3::CHN => Iso2::CN,
            Iso3::CIV => Iso2::CI,
            Iso3::CMR => Iso2::CM,
            Iso3::COD => Iso2::CD,
            Iso3::COG => Iso2::CG,
            Iso3::COK => Iso2::CK,
            Iso3::COL => Iso2::CO,
            Iso3::COM => Iso2::KM,
            Iso3::CPV => Iso2::CV,
            Iso3::CRI => Iso2::CR,
            Iso3::CUB => Iso2::CU,
            Iso3::CUW => Iso2::CW,
            Iso3::CXR => Iso2::CX,
            Iso3::CYM => Iso2::KY,
            Iso3::CYP => Iso2::CY,
            Iso3::CZE => Iso2::CZ,
            Iso3::DEU => Iso2::DE,
            Iso3::DJI => Iso2::DJ,
            Iso3::DMA => Iso2::DM,
            Iso3::DNK => Iso2::DK,
            Iso3::DOM => Iso2::DO,
            Iso3::DZA => Iso2::DZ,
            Iso3::ECU => Iso2::EC,
            Iso3::EGY => Iso2::EG,
            Iso3::ERI => Iso2::ER,
            Iso3::ESH => Iso2::EH,
            Iso3::ESP => Iso2::ES,
            Iso3::EST => Iso2::EE,
            Iso3::ETH => Iso2::ET,
            Iso3::FIN => Iso2::FI,
            Iso3::FJI => Iso2::FJ,
            Iso3::FLK => Iso2::FK,
            Iso3::FRA => Iso2::FR,
            Iso3::FRO => Iso2::FO,
            Iso3::FSM => Iso2::FM,
            Iso3::GAB => Iso2::GA,
            Iso3::GBR => Iso2::GB,
            Iso3::GEO => Iso2::GE,
            Iso3::GGY => Iso2::GG,
            Iso3::GHA => Iso2::GH,
            Iso3::GIB => Iso2::GI,
            Iso3::GIN => Iso2::GN,
            Iso3::GLP => Iso2::GP,
            Iso3::GMB => Iso2::GM,
            Iso3::GNB => Iso2::GW,
            Iso3::GNQ => Iso2::GQ,
            Iso3::GRC => Iso2::GR,
            Iso3::GRD => Iso2::GD,
            Iso3::GRL => Iso2::GL,
            Iso3::GTM => Iso2::GT,
            Iso3::GUF => Iso2::GF,
            Iso3::GUM => Iso2::GU,
            Iso3::GUY => Iso2::GY,
            Iso3::HKG => Iso2::HK,
            Iso3::HMD => Iso2::HM,
            Iso3::HND => Iso2::HN,
            Iso3::HRV => Iso2::HR,
            Iso3::HTI => Iso2::HT,
            Iso3::HUN => Iso2::HU,
            Iso3::IDN => Iso2::ID,
            Iso3::IMN => Iso2::IM,
            Iso3::IND => Iso2::IN,
            Iso3::IOT => Iso2::IO,
            Iso3::IRL => Iso2::IE,
            Iso3::IRN => Iso2::IR,
            Iso3::IRQ => Iso2::IQ,
            Iso3::ISL => Iso2::IS,
            Iso3::ISR => Iso2::IL,
            Iso3::ITA => Iso2::IT,
            Iso3::JAM => Iso2::JM,
            Iso3::JEY => Iso2::JE,
            Iso3::JOR => Iso2::JO,
            Iso3::JPN => Iso2::JP,
            Iso3::KAZ => Iso2::KZ,
            Iso3::KEN => Iso2::KE,
            Iso3::KGZ => Iso2::KG,
            Iso3::KHM => Iso2::KH,
            Iso3::KIR => Iso2::KI,
            Iso3::KNA => Iso2::KN,
            Iso3::KOR => Iso2::KR,
            Iso3::KWT => Iso2::KW,
            Iso3::LAO => Iso2::LA,
            Iso3::LBN => Iso2::LB,
            Iso3::LBR => Iso2::LR,
            Iso3::LBY => Iso2::LY,
            Iso3::LCA => Iso2::LC,
            Iso3::LIE => Iso2::LI,
            Iso3::LKA => Iso2::LK,
            Iso3::LSO => Iso2::LS,
            Iso3::LTU => Iso2::LT,
            Iso3::LUX => Iso2::LU,
            Iso3::LVA => Iso2::LV,
            Iso3::MAC => Iso2::MO,
            Iso3::MAF => Iso2::MF,
            Iso3::MAR => Iso2::MA,
            Iso3::MCO => Iso2::MC,
            Iso3::MDA => Iso2::MD,
            Iso3::MDG => Iso2::MG,
            Iso3::MDV => Iso2::MV,
            Iso3::MEX => Iso2::MX,
            Iso3::MHL => Iso2::MH,
            Iso3::MID => Iso2::MI,
            Iso3::MKD => Iso2::MK,
            Iso3::MLI => Iso2::ML,
            Iso3::MLT => Iso2::MT,
            Iso3::MMR => Iso2::MM,
            Iso3::MNE => Iso2::ME,
            Iso3::MNG => Iso2::MN,
            Iso3::MNP => Iso2::MP,
            Iso3::MOZ => Iso2::MZ,
            Iso3::MRT => Iso2::MR,
            Iso3::MSR => Iso2::MS,
            Iso3::MTQ => Iso2::MQ,
            Iso3::MUS => Iso2::MU,
            Iso3::MWI => Iso2::MW,
            Iso3::MYS => Iso2::MY,
            Iso3::MYT => Iso2::YT,
            Iso3::NAM => Iso2::NA,
            Iso3::NCL => Iso2::NC,
            Iso3::NER => Iso2::NE,
            Iso3::NFK => Iso2::NF,
            Iso3::NGA => Iso2::NG,
            Iso3::NIC => Iso2::NI,
            Iso3::NIU => Iso2::NU,
            Iso3::NLD => Iso2::NL,
            Iso3::NOR => Iso2::NO,
            Iso3::NPL => Iso2::NP,
            Iso3::NRU => Iso2::NR,
            Iso3::NZL => Iso2::NZ,
            Iso3::OMN => Iso2::OM,
            Iso3::PAK => Iso2::PK,
            Iso3::PAN => Iso2::PA,
            Iso3::PCN => Iso2::PN,
            Iso3::PER => Iso2::PE,
            Iso3::PHL => Iso2::PH,
            Iso3::PLW => Iso2::PW,
            Iso3::PNG => Iso2::PG,
            Iso3::POL => Iso2::PL,
            Iso3::PRI => Iso2::PR,
            Iso3::PRK => Iso2::KP,
            Iso3::PRT => Iso2::PT,
            Iso3::PRY => Iso2::PY,
            Iso3::PSE => Iso2::PS,
            Iso3::PYF => Iso2::PF,
            Iso3::QAT => Iso2::QA,
            Iso3::REU => Iso2::RE,
            Iso3::ROU => Iso2::RO,
            Iso3::RUS => Iso2::RU,
            Iso3::RWA => Iso2::RW,
            Iso3::SAU => Iso2::SA,
            Iso3::SDN => Iso2::SD,
            Iso3::SEN => Iso2::SN,
            Iso3::SGP => Iso2::SG,
            Iso3::SGS => Iso2::GS,
            Iso3::SHN => Iso2::SH,
            Iso3::SJM => Iso2::SJ,
            Iso3::SLB => Iso2::SB,
            Iso3::SLE => Iso2::SL,
            Iso3::SLV => Iso2::SV,
            Iso3::SMR => Iso2::SM,
            Iso3::SOM => Iso2::SO,
            Iso3::SPM => Iso2::PM,
            Iso3::SRB => Iso2::RS,
            Iso3::SSD => Iso2::SS,
            Iso3::STP => Iso2::ST,
            Iso3::SUR => Iso2::SR,
            Iso3::SVK => Iso2::SK,
            Iso3::SVN => Iso2::SI,
            Iso3::SWE => Iso2::SE,
            Iso3::SWZ => Iso2::SZ,
            Iso3::SXM => Iso2::SX,
            Iso3::SYC => Iso2::SC,
            Iso3::SYR => Iso2::SY,
            Iso3::TCA => Iso2::TC,
            Iso3::TCD => Iso2::TD,
            Iso3::TGO => Iso2::TG,
            Iso3::THA => Iso2::TH,
            Iso3::TJK => Iso2::TJ,
            Iso3::TKL => Iso2::TK,
            Iso3::TKM => Iso2::TM,
            Iso3::TLS => Iso2::TL,
            Iso3::TON => Iso2::TO,
            Iso3::TTO => Iso2::TT,
            Iso3::TUN => Iso2::TN,
            Iso3::TUR => Iso2::TR,
            Iso3::TUV => Iso2::TV,
            Iso3::TWN => Iso2::TW,
            Iso3::TZA => Iso2::TZ,
            Iso3::UGA => Iso2::UG,
            Iso3::UKR => Iso2::UA,
            Iso3::UMI => Iso2::UM,
            Iso3::URY => Iso2::UY,
            Iso3::USA => Iso2::US,
            Iso3::UZB => Iso2::UZ,
            Iso3::VAT => Iso2::VA,
            Iso3::VCT => Iso2::VC,
            Iso3::VEN => Iso2::VE,
            Iso3::VGB => Iso2::VG,
            Iso3::VIR => Iso2::VI,
            Iso3::VNM => Iso2::VN,
            Iso3::VUT => Iso2::VU,
            Iso3::WLF => Iso2::WF,
            Iso3::WSM => Iso2::WS,
            Iso3::YEM => Iso2::YE,
            Iso3::ZAF => Iso2::ZA,
            Iso3::ZMB => Iso2::ZM,
            Iso3::ZWE => Iso2::ZW,
        }
    }
}

impl FromStr for Iso2 {
    type Err = ();
    fn from_str(iso: &str) -> Result<Iso2, Self::Err> {
        match iso {
            "AD" => Ok(Iso2::AD),
            "AE" => Ok(Iso2::AE),
            "AF" => Ok(Iso2::AF),
            "AG" => Ok(Iso2::AG),
            "AI" => Ok(Iso2::AI),
            "AL" => Ok(Iso2::AL),
            "AM" => Ok(Iso2::AM),
            "AN" => Ok(Iso2::AN),
            "AO" => Ok(Iso2::AO),
            "AQ" => Ok(Iso2::AQ),
            "AR" => Ok(Iso2::AR),
            "AS" => Ok(Iso2::AS),
            "AT" => Ok(Iso2::AT),
            "AU" => Ok(Iso2::AU),
            "AW" => Ok(Iso2::AW),
            "AX" => Ok(Iso2::AX),
            "AZ" => Ok(Iso2::AZ),
            "BA" => Ok(Iso2::BA),
            "BB" => Ok(Iso2::BB),
            "BD" => Ok(Iso2::BD),
            "BE" => Ok(Iso2::BE),
            "BF" => Ok(Iso2::BF),
            "BG" => Ok(Iso2::BG),
            "BH" => Ok(Iso2::BH),
            "BI" => Ok(Iso2::BI),
            "BJ" => Ok(Iso2::BJ),
            "BL" => Ok(Iso2::BL),
            "BM" => Ok(Iso2::BM),
            "BN" => Ok(Iso2::BN),
            "BO" => Ok(Iso2::BO),
            "BQ" => Ok(Iso2::BQ),
            "BR" => Ok(Iso2::BR),
            "BS" => Ok(Iso2::BS),
            "BT" => Ok(Iso2::BT),
            "BV" => Ok(Iso2::BV),
            "BW" => Ok(Iso2::BW),
            "BY" => Ok(Iso2::BY),
            "BZ" => Ok(Iso2::BZ),
            "CA" => Ok(Iso2::CA),
            "CC" => Ok(Iso2::CC),
            "CD" => Ok(Iso2::CD),
            "CF" => Ok(Iso2::CF),
            "CG" => Ok(Iso2::CG),
            "CH" => Ok(Iso2::CH),
            "CI" => Ok(Iso2::CI),
            "CK" => Ok(Iso2::CK),
            "CL" => Ok(Iso2::CL),
            "CM" => Ok(Iso2::CM),
            "CN" => Ok(Iso2::CN),
            "CO" => Ok(Iso2::CO),
            "CR" => Ok(Iso2::CR),
            "CU" => Ok(Iso2::CU),
            "CV" => Ok(Iso2::CV),
            "CW" => Ok(Iso2::CW),
            "CX" => Ok(Iso2::CX),
            "CY" => Ok(Iso2::CY),
            "CZ" => Ok(Iso2::CZ),
            "DE" => Ok(Iso2::DE),
            "DJ" => Ok(Iso2::DJ),
            "DK" => Ok(Iso2::DK),
            "DM" => Ok(Iso2::DM),
            "DO" => Ok(Iso2::DO),
            "DZ" => Ok(Iso2::DZ),
            "EC" => Ok(Iso2::EC),
            "EE" => Ok(Iso2::EE),
            "EG" => Ok(Iso2::EG),
            "EH" => Ok(Iso2::EH),
            "ER" => Ok(Iso2::ER),
            "ES" => Ok(Iso2::ES),
            "ET" => Ok(Iso2::ET),
            "FI" => Ok(Iso2::FI),
            "FJ" => Ok(Iso2::FJ),
            "FK" => Ok(Iso2::FK),
            "FM" => Ok(Iso2::FM),
            "FO" => Ok(Iso2::FO),
            "FR" => Ok(Iso2::FR),
            "GA" => Ok(Iso2::GA),
            "GB" => Ok(Iso2::GB),
            "GD" => Ok(Iso2::GD),
            "GE" => Ok(Iso2::GE),
            "GF" => Ok(Iso2::GF),
            "GG" => Ok(Iso2::GG),
            "GH" => Ok(Iso2::GH),
            "GI" => Ok(Iso2::GI),
            "GL" => Ok(Iso2::GL),
            "GM" => Ok(Iso2::GM),
            "GN" => Ok(Iso2::GN),
            "GP" => Ok(Iso2::GP),
            "GQ" => Ok(Iso2::GQ),
            "GR" => Ok(Iso2::GR),
            "GS" => Ok(Iso2::GS),
            "GT" => Ok(Iso2::GT),
            "GU" => Ok(Iso2::GU),
            "GW" => Ok(Iso2::GW),
            "GY" => Ok(Iso2::GY),
            "HK" => Ok(Iso2::HK),
            "HM" => Ok(Iso2::HM),
            "HN" => Ok(Iso2::HN),
            "HR" => Ok(Iso2::HR),
            "HT" => Ok(Iso2::HT),
            "HU" => Ok(Iso2::HU),
            "ID" => Ok(Iso2::ID),
            "IE" => Ok(Iso2::IE),
            "IL" => Ok(Iso2::IL),
            "IM" => Ok(Iso2::IM),
            "IN" => Ok(Iso2::IN),
            "IO" => Ok(Iso2::IO),
            "IQ" => Ok(Iso2::IQ),
            "IR" => Ok(Iso2::IR),
            "IS" => Ok(Iso2::IS),
            "IT" => Ok(Iso2::IT),
            "JE" => Ok(Iso2::JE),
            "JM" => Ok(Iso2::JM),
            "JO" => Ok(Iso2::JO),
            "JP" => Ok(Iso2::JP),
            "KE" => Ok(Iso2::KE),
            "KG" => Ok(Iso2::KG),
            "KH" => Ok(Iso2::KH),
            "KI" => Ok(Iso2::KI),
            "KM" => Ok(Iso2::KM),
            "KN" => Ok(Iso2::KN),
            "KP" => Ok(Iso2::KP),
            "KR" => Ok(Iso2::KR),
            "KW" => Ok(Iso2::KW),
            "KY" => Ok(Iso2::KY),
            "KZ" => Ok(Iso2::KZ),
            "LA" => Ok(Iso2::LA),
            "LB" => Ok(Iso2::LB),
            "LC" => Ok(Iso2::LC),
            "LI" => Ok(Iso2::LI),
            "LK" => Ok(Iso2::LK),
            "LR" => Ok(Iso2::LR),
            "LS" => Ok(Iso2::LS),
            "LT" => Ok(Iso2::LT),
            "LU" => Ok(Iso2::LU),
            "LV" => Ok(Iso2::LV),
            "LY" => Ok(Iso2::LY),
            "MA" => Ok(Iso2::MA),
            "MC" => Ok(Iso2::MC),
            "MD" => Ok(Iso2::MD),
            "ME" => Ok(Iso2::ME),
            "MF" => Ok(Iso2::MF),
            "MG" => Ok(Iso2::MG),
            "MH" => Ok(Iso2::MH),
            "MI" => Ok(Iso2::MI),
            "MK" => Ok(Iso2::MK),
            "ML" => Ok(Iso2::ML),
            "MM" => Ok(Iso2::MM),
            "MN" => Ok(Iso2::MN),
            "MO" => Ok(Iso2::MO),
            "MP" => Ok(Iso2::MP),
            "MQ" => Ok(Iso2::MQ),
            "MR" => Ok(Iso2::MR),
            "MS" => Ok(Iso2::MS),
            "MT" => Ok(Iso2::MT),
            "MU" => Ok(Iso2::MU),
            "MV" => Ok(Iso2::MV),
            "MW" => Ok(Iso2::MW),
            "MX" => Ok(Iso2::MX),
            "MY" => Ok(Iso2::MY),
            "MZ" => Ok(Iso2::MZ),
            "NA" => Ok(Iso2::NA),
            "NC" => Ok(Iso2::NC),
            "NE" => Ok(Iso2::NE),
            "NF" => Ok(Iso2::NF),
            "NG" => Ok(Iso2::NG),
            "NI" => Ok(Iso2::NI),
            "NL" => Ok(Iso2::NL),
            "NO" => Ok(Iso2::NO),
            "NP" => Ok(Iso2::NP),
            "NR" => Ok(Iso2::NR),
            "NU" => Ok(Iso2::NU),
            "NZ" => Ok(Iso2::NZ),
            "OM" => Ok(Iso2::OM),
            "PA" => Ok(Iso2::PA),
            "PE" => Ok(Iso2::PE),
            "PF" => Ok(Iso2::PF),
            "PG" => Ok(Iso2::PG),
            "PH" => Ok(Iso2::PH),
            "PK" => Ok(Iso2::PK),
            "PL" => Ok(Iso2::PL),
            "PM" => Ok(Iso2::PM),
            "PN" => Ok(Iso2::PN),
            "PR" => Ok(Iso2::PR),
            "PS" => Ok(Iso2::PS),
            "PT" => Ok(Iso2::PT),
            "PW" => Ok(Iso2::PW),
            "PY" => Ok(Iso2::PY),
            "QA" => Ok(Iso2::QA),
            "RE" => Ok(Iso2::RE),
            "RO" => Ok(Iso2::RO),
            "RS" => Ok(Iso2::RS),
            "RU" => Ok(Iso2::RU),
            "RW" => Ok(Iso2::RW),
            "SA" => Ok(Iso2::SA),
            "SB" => Ok(Iso2::SB),
            "SC" => Ok(Iso2::SC),
            "SD" => Ok(Iso2::SD),
            "SE" => Ok(Iso2::SE),
            "SG" => Ok(Iso2::SG),
            "SH" => Ok(Iso2::SH),
            "SI" => Ok(Iso2::SI),
            "SJ" => Ok(Iso2::SJ),
            "SK" => Ok(Iso2::SK),
            "SL" => Ok(Iso2::SL),
            "SM" => Ok(Iso2::SM),
            "SN" => Ok(Iso2::SN),
            "SO" => Ok(Iso2::SO),
            "SR" => Ok(Iso2::SR),
            "SS" => Ok(Iso2::SS),
            "ST" => Ok(Iso2::ST),
            "SV" => Ok(Iso2::SV),
            "SX" => Ok(Iso2::SX),
            "SY" => Ok(Iso2::SY),
            "SZ" => Ok(Iso2::SZ),
            "TC" => Ok(Iso2::TC),
            "TD" => Ok(Iso2::TD),
            "TF" => Ok(Iso2::TF),
            "TG" => Ok(Iso2::TG),
            "TH" => Ok(Iso2::TH),
            "TJ" => Ok(Iso2::TJ),
            "TK" => Ok(Iso2::TK),
            "TL" => Ok(Iso2::TL),
            "TM" => Ok(Iso2::TM),
            "TN" => Ok(Iso2::TN),
            "TO" => Ok(Iso2::TO),
            "TR" => Ok(Iso2::TR),
            "TT" => Ok(Iso2::TT),
            "TV" => Ok(Iso2::TV),
            "TW" => Ok(Iso2::TW),
            "TZ" => Ok(Iso2::TZ),
            "UA" => Ok(Iso2::UA),
            "UG" => Ok(Iso2::UG),
            "UM" => Ok(Iso2::UM),
            "US" => Ok(Iso2::US),
            "UY" => Ok(Iso2::UY),
            "UZ" => Ok(Iso2::UZ),
            "VA" => Ok(Iso2::VA),
            "VC" => Ok(Iso2::VC),
            "VE" => Ok(Iso2::VE),
            "VG" => Ok(Iso2::VG),
            "VI" => Ok(Iso2::VI),
            "VN" => Ok(Iso2::VN),
            "VU" => Ok(Iso2::VU),
            "WF" => Ok(Iso2::WF),
            "WS" => Ok(Iso2::WS),
            "YE" => Ok(Iso2::YE),
            "YT" => Ok(Iso2::YT),
            "ZA" => Ok(Iso2::ZA),
            "ZM" => Ok(Iso2::ZM),
            "ZW" => Ok(Iso2::ZW),
            _ => Err(()),
        }
    }
}

impl fmt::Display for Iso2 {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        fmt::Debug::fmt(self, f)
    }
}

#[derive(PartialEq, Eq, Hash, Clone, Debug, Serialize, Deserialize)]
pub enum Iso3 {
    ABW,
    AFG,
    AGO,
    AIA,
    ALA,
    ALB,
    AND,
    ANT,
    ARE,
    ARG,
    ARM,
    ASM,
    ATA,
    ATF,
    ATG,
    AUS,
    AUT,
    AZE,
    BDI,
    BEL,
    BEN,
    BES,
    BFA,
    BGD,
    BGR,
    BHR,
    BHS,
    BIH,
    BLM,
    BLR,
    BLZ,
    BMU,
    BOL,
    BRA,
    BRB,
    BRN,
    BTN,
    BVT,
    BWA,
    CAF,
    CAN,
    CCK,
    CHE,
    CHL,
    CHN,
    CIV,
    CMR,
    COD,
    COG,
    COK,
    COL,
    COM,
    CPV,
    CRI,
    CUB,
    CUW,
    CXR,
    CYM,
    CYP,
    CZE,
    DEU,
    DJI,
    DMA,
    DNK,
    DOM,
    DZA,
    ECU,
    EGY,
    ERI,
    ESH,
    ESP,
    EST,
    ETH,
    FIN,
    FJI,
    FLK,
    FRA,
    FRO,
    FSM,
    GAB,
    GBR,
    GEO,
    GGY,
    GHA,
    GIB,
    GIN,
    GLP,
    GMB,
    GNB,
    GNQ,
    GRC,
    GRD,
    GRL,
    GTM,
    GUF,
    GUM,
    GUY,
    HKG,
    HMD,
    HND,
    HRV,
    HTI,
    HUN,
    IDN,
    IMN,
    IND,
    IOT,
    IRL,
    IRN,
    IRQ,
    ISL,
    ISR,
    ITA,
    JAM,
    JEY,
    JOR,
    JPN,
    KAZ,
    KEN,
    KGZ,
    KHM,
    KIR,
    KNA,
    KOR,
    KWT,
    LAO,
    LBN,
    LBR,
    LBY,
    LCA,
    LIE,
    LKA,
    LSO,
    LTU,
    LUX,
    LVA,
    MAC,
    MAF,
    MAR,
    MCO,
    MDA,
    MDG,
    MDV,
    MEX,
    MHL,
    MID,
    MKD,
    MLI,
    MLT,
    MMR,
    MNE,
    MNG,
    MNP,
    MOZ,
    MRT,
    MSR,
    MTQ,
    MUS,
    MWI,
    MYS,
    MYT,
    NAM,
    NCL,
    NER,
    NFK,
    NGA,
    NIC,
    NIU,
    NLD,
    NOR,
    NPL,
    NRU,
    NZL,
    OMN,
    PAK,
    PAN,
    PCN,
    PER,
    PHL,
    PLW,
    PNG,
    POL,
    PRI,
    PRK,
    PRT,
    PRY,
    PSE,
    PYF,
    QAT,
    REU,
    ROU,
    RUS,
    RWA,
    SAU,
    SDN,
    SEN,
    SGP,
    SGS,
    SHN,
    SJM,
    SLB,
    SLE,
    SLV,
    SMR,
    SOM,
    SPM,
    SRB,
    SSD,
    STP,
    SUR,
    SVK,
    SVN,
    SWE,
    SWZ,
    SXM,
    SYC,
    SYR,
    TCA,
    TCD,
    TGO,
    THA,
    TJK,
    TKL,
    TKM,
    TLS,
    TON,
    TTO,
    TUN,
    TUR,
    TUV,
    TWN,
    TZA,
    UGA,
    UKR,
    UMI,
    URY,
    USA,
    UZB,
    VAT,
    VCT,
    VEN,
    VGB,
    VIR,
    VNM,
    VUT,
    WLF,
    WSM,
    YEM,
    ZAF,
    ZMB,
    ZWE,
}

impl Iso3 {
    pub fn iter() -> Iter<'static, Iso3> {
        const ALL_ISO3: [Iso3; NUMBER_OF_COUNTRIES as usize] = [
            Iso3::ABW,
            Iso3::AFG,
            Iso3::AGO,
            Iso3::AIA,
            Iso3::ALA,
            Iso3::ALB,
            Iso3::AND,
            Iso3::ANT,
            Iso3::ARE,
            Iso3::ARG,
            Iso3::ARM,
            Iso3::ASM,
            Iso3::ATA,
            Iso3::ATF,
            Iso3::ATG,
            Iso3::AUS,
            Iso3::AUT,
            Iso3::AZE,
            Iso3::BDI,
            Iso3::BEL,
            Iso3::BEN,
            Iso3::BES,
            Iso3::BFA,
            Iso3::BGD,
            Iso3::BGR,
            Iso3::BHR,
            Iso3::BHS,
            Iso3::BIH,
            Iso3::BLM,
            Iso3::BLR,
            Iso3::BLZ,
            Iso3::BMU,
            Iso3::BOL,
            Iso3::BRA,
            Iso3::BRB,
            Iso3::BRN,
            Iso3::BTN,
            Iso3::BVT,
            Iso3::BWA,
            Iso3::CAF,
            Iso3::CAN,
            Iso3::CCK,
            Iso3::CHE,
            Iso3::CHL,
            Iso3::CHN,
            Iso3::CIV,
            Iso3::CMR,
            Iso3::COD,
            Iso3::COG,
            Iso3::COK,
            Iso3::COL,
            Iso3::COM,
            Iso3::CPV,
            Iso3::CRI,
            Iso3::CUB,
            Iso3::CUW,
            Iso3::CXR,
            Iso3::CYM,
            Iso3::CYP,
            Iso3::CZE,
            Iso3::DEU,
            Iso3::DJI,
            Iso3::DMA,
            Iso3::DNK,
            Iso3::DOM,
            Iso3::DZA,
            Iso3::ECU,
            Iso3::EGY,
            Iso3::ERI,
            Iso3::ESH,
            Iso3::ESP,
            Iso3::EST,
            Iso3::ETH,
            Iso3::FIN,
            Iso3::FJI,
            Iso3::FLK,
            Iso3::FRA,
            Iso3::FRO,
            Iso3::FSM,
            Iso3::GAB,
            Iso3::GBR,
            Iso3::GEO,
            Iso3::GGY,
            Iso3::GHA,
            Iso3::GIB,
            Iso3::GIN,
            Iso3::GLP,
            Iso3::GMB,
            Iso3::GNB,
            Iso3::GNQ,
            Iso3::GRC,
            Iso3::GRD,
            Iso3::GRL,
            Iso3::GTM,
            Iso3::GUF,
            Iso3::GUM,
            Iso3::GUY,
            Iso3::HKG,
            Iso3::HMD,
            Iso3::HND,
            Iso3::HRV,
            Iso3::HTI,
            Iso3::HUN,
            Iso3::IDN,
            Iso3::IMN,
            Iso3::IND,
            Iso3::IOT,
            Iso3::IRL,
            Iso3::IRN,
            Iso3::IRQ,
            Iso3::ISL,
            Iso3::ISR,
            Iso3::ITA,
            Iso3::JAM,
            Iso3::JEY,
            Iso3::JOR,
            Iso3::JPN,
            Iso3::KAZ,
            Iso3::KEN,
            Iso3::KGZ,
            Iso3::KHM,
            Iso3::KIR,
            Iso3::KNA,
            Iso3::KOR,
            Iso3::KWT,
            Iso3::LAO,
            Iso3::LBN,
            Iso3::LBR,
            Iso3::LBY,
            Iso3::LCA,
            Iso3::LIE,
            Iso3::LKA,
            Iso3::LSO,
            Iso3::LTU,
            Iso3::LUX,
            Iso3::LVA,
            Iso3::MAC,
            Iso3::MAF,
            Iso3::MAR,
            Iso3::MCO,
            Iso3::MDA,
            Iso3::MDG,
            Iso3::MDV,
            Iso3::MEX,
            Iso3::MHL,
            Iso3::MID,
            Iso3::MKD,
            Iso3::MLI,
            Iso3::MLT,
            Iso3::MMR,
            Iso3::MNE,
            Iso3::MNG,
            Iso3::MNP,
            Iso3::MOZ,
            Iso3::MRT,
            Iso3::MSR,
            Iso3::MTQ,
            Iso3::MUS,
            Iso3::MWI,
            Iso3::MYS,
            Iso3::MYT,
            Iso3::NAM,
            Iso3::NCL,
            Iso3::NER,
            Iso3::NFK,
            Iso3::NGA,
            Iso3::NIC,
            Iso3::NIU,
            Iso3::NLD,
            Iso3::NOR,
            Iso3::NPL,
            Iso3::NRU,
            Iso3::NZL,
            Iso3::OMN,
            Iso3::PAK,
            Iso3::PAN,
            Iso3::PCN,
            Iso3::PER,
            Iso3::PHL,
            Iso3::PLW,
            Iso3::PNG,
            Iso3::POL,
            Iso3::PRI,
            Iso3::PRK,
            Iso3::PRT,
            Iso3::PRY,
            Iso3::PSE,
            Iso3::PYF,
            Iso3::QAT,
            Iso3::REU,
            Iso3::ROU,
            Iso3::RUS,
            Iso3::RWA,
            Iso3::SAU,
            Iso3::SDN,
            Iso3::SEN,
            Iso3::SGP,
            Iso3::SGS,
            Iso3::SHN,
            Iso3::SJM,
            Iso3::SLB,
            Iso3::SLE,
            Iso3::SLV,
            Iso3::SMR,
            Iso3::SOM,
            Iso3::SPM,
            Iso3::SRB,
            Iso3::SSD,
            Iso3::STP,
            Iso3::SUR,
            Iso3::SVK,
            Iso3::SVN,
            Iso3::SWE,
            Iso3::SWZ,
            Iso3::SXM,
            Iso3::SYC,
            Iso3::SYR,
            Iso3::TCA,
            Iso3::TCD,
            Iso3::TGO,
            Iso3::THA,
            Iso3::TJK,
            Iso3::TKL,
            Iso3::TKM,
            Iso3::TLS,
            Iso3::TON,
            Iso3::TTO,
            Iso3::TUN,
            Iso3::TUR,
            Iso3::TUV,
            Iso3::TWN,
            Iso3::TZA,
            Iso3::UGA,
            Iso3::UKR,
            Iso3::UMI,
            Iso3::URY,
            Iso3::USA,
            Iso3::UZB,
            Iso3::VAT,
            Iso3::VCT,
            Iso3::VEN,
            Iso3::VGB,
            Iso3::VIR,
            Iso3::VNM,
            Iso3::VUT,
            Iso3::WLF,
            Iso3::WSM,
            Iso3::YEM,
            Iso3::ZAF,
            Iso3::ZMB,
            Iso3::ZWE,
        ];
        ALL_ISO3.iter()
    }
}

impl FromStr for Iso3 {
    type Err = ();
    fn from_str(iso: &str) -> Result<Iso3, Self::Err> {
        match iso {
            "ABW" => Ok(Iso3::ABW),
            "AFG" => Ok(Iso3::AFG),
            "AGO" => Ok(Iso3::AGO),
            "AIA" => Ok(Iso3::AIA),
            "ALA" => Ok(Iso3::ALA),
            "ALB" => Ok(Iso3::ALB),
            "AND" => Ok(Iso3::AND),
            "ANT" => Ok(Iso3::ANT),
            "ARE" => Ok(Iso3::ARE),
            "ARG" => Ok(Iso3::ARG),
            "ARM" => Ok(Iso3::ARM),
            "ASM" => Ok(Iso3::ASM),
            "ATA" => Ok(Iso3::ATA),
            "ATF" => Ok(Iso3::ATF),
            "ATG" => Ok(Iso3::ATG),
            "AUS" => Ok(Iso3::AUS),
            "AUT" => Ok(Iso3::AUT),
            "AZE" => Ok(Iso3::AZE),
            "BDI" => Ok(Iso3::BDI),
            "BEL" => Ok(Iso3::BEL),
            "BEN" => Ok(Iso3::BEN),
            "BES" => Ok(Iso3::BES),
            "BFA" => Ok(Iso3::BFA),
            "BGD" => Ok(Iso3::BGD),
            "BGR" => Ok(Iso3::BGR),
            "BHR" => Ok(Iso3::BHR),
            "BHS" => Ok(Iso3::BHS),
            "BIH" => Ok(Iso3::BIH),
            "BLM" => Ok(Iso3::BLM),
            "BLR" => Ok(Iso3::BLR),
            "BLZ" => Ok(Iso3::BLZ),
            "BMU" => Ok(Iso3::BMU),
            "BOL" => Ok(Iso3::BOL),
            "BRA" => Ok(Iso3::BRA),
            "BRB" => Ok(Iso3::BRB),
            "BRN" => Ok(Iso3::BRN),
            "BTN" => Ok(Iso3::BTN),
            "BVT" => Ok(Iso3::BVT),
            "BWA" => Ok(Iso3::BWA),
            "CAF" => Ok(Iso3::CAF),
            "CAN" => Ok(Iso3::CAN),
            "CCK" => Ok(Iso3::CCK),
            "CHE" => Ok(Iso3::CHE),
            "CHL" => Ok(Iso3::CHL),
            "CHN" => Ok(Iso3::CHN),
            "CIV" => Ok(Iso3::CIV),
            "CMR" => Ok(Iso3::CMR),
            "COD" => Ok(Iso3::COD),
            "COG" => Ok(Iso3::COG),
            "COK" => Ok(Iso3::COK),
            "COL" => Ok(Iso3::COL),
            "COM" => Ok(Iso3::COM),
            "CPV" => Ok(Iso3::CPV),
            "CRI" => Ok(Iso3::CRI),
            "CUB" => Ok(Iso3::CUB),
            "CUW" => Ok(Iso3::CUW),
            "CXR" => Ok(Iso3::CXR),
            "CYM" => Ok(Iso3::CYM),
            "CYP" => Ok(Iso3::CYP),
            "CZE" => Ok(Iso3::CZE),
            "DEU" => Ok(Iso3::DEU),
            "DJI" => Ok(Iso3::DJI),
            "DMA" => Ok(Iso3::DMA),
            "DNK" => Ok(Iso3::DNK),
            "DOM" => Ok(Iso3::DOM),
            "DZA" => Ok(Iso3::DZA),
            "ECU" => Ok(Iso3::ECU),
            "EGY" => Ok(Iso3::EGY),
            "ERI" => Ok(Iso3::ERI),
            "ESH" => Ok(Iso3::ESH),
            "ESP" => Ok(Iso3::ESP),
            "EST" => Ok(Iso3::EST),
            "ETH" => Ok(Iso3::ETH),
            "FIN" => Ok(Iso3::FIN),
            "FJI" => Ok(Iso3::FJI),
            "FLK" => Ok(Iso3::FLK),
            "FRA" => Ok(Iso3::FRA),
            "FRO" => Ok(Iso3::FRO),
            "FSM" => Ok(Iso3::FSM),
            "GAB" => Ok(Iso3::GAB),
            "GBR" => Ok(Iso3::GBR),
            "GEO" => Ok(Iso3::GEO),
            "GGY" => Ok(Iso3::GGY),
            "GHA" => Ok(Iso3::GHA),
            "GIB" => Ok(Iso3::GIB),
            "GIN" => Ok(Iso3::GIN),
            "GLP" => Ok(Iso3::GLP),
            "GMB" => Ok(Iso3::GMB),
            "GNB" => Ok(Iso3::GNB),
            "GNQ" => Ok(Iso3::GNQ),
            "GRC" => Ok(Iso3::GRC),
            "GRD" => Ok(Iso3::GRD),
            "GRL" => Ok(Iso3::GRL),
            "GTM" => Ok(Iso3::GTM),
            "GUF" => Ok(Iso3::GUF),
            "GUM" => Ok(Iso3::GUM),
            "GUY" => Ok(Iso3::GUY),
            "HKG" => Ok(Iso3::HKG),
            "HMD" => Ok(Iso3::HMD),
            "HND" => Ok(Iso3::HND),
            "HRV" => Ok(Iso3::HRV),
            "HTI" => Ok(Iso3::HTI),
            "HUN" => Ok(Iso3::HUN),
            "IDN" => Ok(Iso3::IDN),
            "IMN" => Ok(Iso3::IMN),
            "IND" => Ok(Iso3::IND),
            "IOT" => Ok(Iso3::IOT),
            "IRL" => Ok(Iso3::IRL),
            "IRN" => Ok(Iso3::IRN),
            "IRQ" => Ok(Iso3::IRQ),
            "ISL" => Ok(Iso3::ISL),
            "ISR" => Ok(Iso3::ISR),
            "ITA" => Ok(Iso3::ITA),
            "JAM" => Ok(Iso3::JAM),
            "JEY" => Ok(Iso3::JEY),
            "JOR" => Ok(Iso3::JOR),
            "JPN" => Ok(Iso3::JPN),
            "KAZ" => Ok(Iso3::KAZ),
            "KEN" => Ok(Iso3::KEN),
            "KGZ" => Ok(Iso3::KGZ),
            "KHM" => Ok(Iso3::KHM),
            "KIR" => Ok(Iso3::KIR),
            "KNA" => Ok(Iso3::KNA),
            "KOR" => Ok(Iso3::KOR),
            "KWT" => Ok(Iso3::KWT),
            "LAO" => Ok(Iso3::LAO),
            "LBN" => Ok(Iso3::LBN),
            "LBR" => Ok(Iso3::LBR),
            "LBY" => Ok(Iso3::LBY),
            "LCA" => Ok(Iso3::LCA),
            "LIE" => Ok(Iso3::LIE),
            "LKA" => Ok(Iso3::LKA),
            "LSO" => Ok(Iso3::LSO),
            "LTU" => Ok(Iso3::LTU),
            "LUX" => Ok(Iso3::LUX),
            "LVA" => Ok(Iso3::LVA),
            "MAC" => Ok(Iso3::MAC),
            "MAF" => Ok(Iso3::MAF),
            "MAR" => Ok(Iso3::MAR),
            "MCO" => Ok(Iso3::MCO),
            "MDA" => Ok(Iso3::MDA),
            "MDG" => Ok(Iso3::MDG),
            "MDV" => Ok(Iso3::MDV),
            "MEX" => Ok(Iso3::MEX),
            "MHL" => Ok(Iso3::MHL),
            "MID" => Ok(Iso3::MID),
            "MKD" => Ok(Iso3::MKD),
            "MLI" => Ok(Iso3::MLI),
            "MLT" => Ok(Iso3::MLT),
            "MMR" => Ok(Iso3::MMR),
            "MNE" => Ok(Iso3::MNE),
            "MNG" => Ok(Iso3::MNG),
            "MNP" => Ok(Iso3::MNP),
            "MOZ" => Ok(Iso3::MOZ),
            "MRT" => Ok(Iso3::MRT),
            "MSR" => Ok(Iso3::MSR),
            "MTQ" => Ok(Iso3::MTQ),
            "MUS" => Ok(Iso3::MUS),
            "MWI" => Ok(Iso3::MWI),
            "MYS" => Ok(Iso3::MYS),
            "MYT" => Ok(Iso3::MYT),
            "NAM" => Ok(Iso3::NAM),
            "NCL" => Ok(Iso3::NCL),
            "NER" => Ok(Iso3::NER),
            "NFK" => Ok(Iso3::NFK),
            "NGA" => Ok(Iso3::NGA),
            "NIC" => Ok(Iso3::NIC),
            "NIU" => Ok(Iso3::NIU),
            "NLD" => Ok(Iso3::NLD),
            "NOR" => Ok(Iso3::NOR),
            "NPL" => Ok(Iso3::NPL),
            "NRU" => Ok(Iso3::NRU),
            "NZL" => Ok(Iso3::NZL),
            "OMN" => Ok(Iso3::OMN),
            "PAK" => Ok(Iso3::PAK),
            "PAN" => Ok(Iso3::PAN),
            "PCN" => Ok(Iso3::PCN),
            "PER" => Ok(Iso3::PER),
            "PHL" => Ok(Iso3::PHL),
            "PLW" => Ok(Iso3::PLW),
            "PNG" => Ok(Iso3::PNG),
            "POL" => Ok(Iso3::POL),
            "PRI" => Ok(Iso3::PRI),
            "PRK" => Ok(Iso3::PRK),
            "PRT" => Ok(Iso3::PRT),
            "PRY" => Ok(Iso3::PRY),
            "PSE" => Ok(Iso3::PSE),
            "PYF" => Ok(Iso3::PYF),
            "QAT" => Ok(Iso3::QAT),
            "REU" => Ok(Iso3::REU),
            "ROU" => Ok(Iso3::ROU),
            "RUS" => Ok(Iso3::RUS),
            "RWA" => Ok(Iso3::RWA),
            "SAU" => Ok(Iso3::SAU),
            "SDN" => Ok(Iso3::SDN),
            "SEN" => Ok(Iso3::SEN),
            "SGP" => Ok(Iso3::SGP),
            "SGS" => Ok(Iso3::SGS),
            "SHN" => Ok(Iso3::SHN),
            "SJM" => Ok(Iso3::SJM),
            "SLB" => Ok(Iso3::SLB),
            "SLE" => Ok(Iso3::SLE),
            "SLV" => Ok(Iso3::SLV),
            "SMR" => Ok(Iso3::SMR),
            "SOM" => Ok(Iso3::SOM),
            "SPM" => Ok(Iso3::SPM),
            "SRB" => Ok(Iso3::SRB),
            "SSD" => Ok(Iso3::SSD),
            "STP" => Ok(Iso3::STP),
            "SUR" => Ok(Iso3::SUR),
            "SVK" => Ok(Iso3::SVK),
            "SVN" => Ok(Iso3::SVN),
            "SWE" => Ok(Iso3::SWE),
            "SWZ" => Ok(Iso3::SWZ),
            "SXM" => Ok(Iso3::SXM),
            "SYC" => Ok(Iso3::SYC),
            "SYR" => Ok(Iso3::SYR),
            "TCA" => Ok(Iso3::TCA),
            "TCD" => Ok(Iso3::TCD),
            "TGO" => Ok(Iso3::TGO),
            "THA" => Ok(Iso3::THA),
            "TJK" => Ok(Iso3::TJK),
            "TKL" => Ok(Iso3::TKL),
            "TKM" => Ok(Iso3::TKM),
            "TLS" => Ok(Iso3::TLS),
            "TON" => Ok(Iso3::TON),
            "TTO" => Ok(Iso3::TTO),
            "TUN" => Ok(Iso3::TUN),
            "TUR" => Ok(Iso3::TUR),
            "TUV" => Ok(Iso3::TUV),
            "TWN" => Ok(Iso3::TWN),
            "TZA" => Ok(Iso3::TZA),
            "UGA" => Ok(Iso3::UGA),
            "UKR" => Ok(Iso3::UKR),
            "UMI" => Ok(Iso3::UMI),
            "URY" => Ok(Iso3::URY),
            "USA" => Ok(Iso3::USA),
            "UZB" => Ok(Iso3::UZB),
            "VAT" => Ok(Iso3::VAT),
            "VCT" => Ok(Iso3::VCT),
            "VEN" => Ok(Iso3::VEN),
            "VGB" => Ok(Iso3::VGB),
            "VIR" => Ok(Iso3::VIR),
            "VNM" => Ok(Iso3::VNM),
            "VUT" => Ok(Iso3::VUT),
            "WLF" => Ok(Iso3::WLF),
            "WSM" => Ok(Iso3::WSM),
            "YEM" => Ok(Iso3::YEM),
            "ZAF" => Ok(Iso3::ZAF),
            "ZMB" => Ok(Iso3::ZMB),
            "ZWE" => Ok(Iso3::ZWE),
            _ => Err(()),
        }
    }
}

impl fmt::Display for Iso3 {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        fmt::Debug::fmt(self, f)
    }
}
