# gotpm [WIP!]
A simple Godot Package Manager to be used in conjunction to git repositories as a simple way of installing your addons without commiting their contents to git.

It tracks your addons within a root file in your project with the addon git URL and it's current version/git reference. So you can install them locally or remotely (CI/CD).

## Example

You can start a new gotpm using `gotpm init` and them install your first package using `gotpm add {url}`.

```bash
gotpm add https://github.com/ceceppa/anima -r 0.3.1
```
The add command will clone the repository on a `.got_modules` folder, checkout to the git reference (tag 0.3.1) and copy the contents of the `addons` directory to your own `addons` folder inside your project.

Your project will end up with a `addons/anima` folder. 

So you can put the following lines on your `.gitignore` file:

```
.got_modules
addons
```

## Commands

| Command | Description |
| ------- | ----------- |
| `gotpm init` | Initialize an empty `gotpm.toml` file used to track yout project dependencies. |
| `gotpm install` | Instal the dependencies listed in the project `gotpm.toml` file. |
| `gotpm add {package} -r ?` | Add a git package to be used in your Godot project. Where package is the git HTTPS URL and the -r Option refer to a git reference (branch name, commit, tag, etc). |
