# This file is meant to be sourced
# Entry point for bash based shells

_GotoHelperFunction() {
    local cur
    DRIVER=goto-cd
    COMPREPLY=()
    cur=${COMP_WORDS[COMP_CWORD]}

    if [ $COMP_CWORD -eq 1 ]; then
        # User is trying to jump
        answers="$($DRIVER --prefix "$cur")"
        COMPREPLY=($answers)

        # Dirty hack to not expand with a space after subfolder expansion
        len=${#COMPREPLY[@]}
        if [[ $len -eq 1 ]] && [[ $answers == *"/"* ]]; then
            fake="x"
            ans="$answers $answers$fake"
            COMPREPLY=($ans)
        fi

        return
    fi

    if [ $COMP_CWORD -eq 2 ]; then
        command=${COMP_WORDS[1]}
        if [ "$command" = "--remove" ] && [ -n "$cur" ]; then
            # User is trying to remove
            answers="$($DRIVER --prefix "$cur")"
            COMPREPLY=($answers)
            return
        fi
    fi
}

function goto() {
    GT=goto-cd
    A=$1
    B=$2
    if [[ ! $A == -* ]] && [ -n "$A" ]; then
        # We are dealing with a goto that wants to go somewhere
        # The first argument is non-null and does not start with a dash!
        target=$($GT --get $A)
        if [ $? -ne 0 ]; then
            echo "$target"
        elif [ -d $target ]; then
            cd $target
        else
            echo "'$target' seems to not be a directory..."
        fi
    else
        # We are dealing with a command + argument
        $GT $A $B $3 $4
    fi
}

complete -F _GotoHelperFunction goto
