
# FIRE: fast inertial relaxation engine algorithm

[![Build Status](https://travis-ci.org/ybyygu/fire.svg?branch=master)](https://travis-ci.org/ybyygu/fire)
[![GPL3 licensed](https://img.shields.io/badge/license-GPL3-blue.svg)](./LICENSE)


# Features

-   Fast & Reliable Rust implementation.
-   MD integration schemes: Velocity Verlet and Semi-implicit Euler methods
-   line search for optimal step size.


# Usage

    use fire::*;
    
    let mut x = [0.0];
    fire().minimize(&mut x, |x, gx| {
        let fx = (x[0] - 1.).powi(2);
        gx[0] = 2.0 * (x[0] - 1.0);
        fx
    });


# References

-   Bitzek, E.; Koskinen, P.; Gähler, F.; Moseler, M.; Gumbsch, P. Structural
    Relaxation Made Simple. Phys. Rev. Lett. 2006, 97 (17), 170201.
    <https://doi.org/10.1103/PhysRevLett.97.170201>.

-   <http://users.jyu.fi/~pekkosk/resources/pdf/FIRE.pdf>

-   Shuang, F.; Xiao, P.; Shi, R.; Ke, F.; Bai, Y. Influence of Integration
    Formulations on the Performance of the Fast Inertial Relaxation Engine (FIRE)
    Method. Computational Materials Science 2019, 156, 135–141.
    <https://doi.org/10.1016/j.commatsci.2018.09.049>.

-   [flos/fire.lua at master · siesta-project/flos](https://github.com/siesta-project/flos/blob/master/flos/optima/fire.lua)

-   [ase/optimize/fire.py · master · shrx / ase · GitLab](https://gitlab.com/shrx/ase/blob/master/ase/optimize/fire.py)

