// [[file:../dimer.note::c6f8257d][c6f8257d]]
mod cg;
mod dimer;
mod fourier;
mod options;
mod raw;
mod rotation;
mod translation;

#[cfg(test)]
mod test;
// c6f8257d ends here

// [[file:../dimer.note::1e3853ed][1e3853ed]]
// #![deny(warnings)]

use gut::prelude::*;
use std::f64::consts::PI;
use vecfx::*;

type DVector = nalgebra::DVector<f64>;

use raw::*;
// 1e3853ed ends here

// [[file:../dimer.note::3da305d7][3da305d7]]
/// The trait for evaluation of potential surface required in DIMER algorithm
pub trait EvaluateDimer {
    /// Get current position
    fn position(&self) -> &[f64];

    /// Update current position
    fn set_position(&mut self, position: &[f64]);

    /// Get energy of potential at current position
    fn get_energy(&mut self) -> Result<f64>;

    /// Get force of potential at current position
    fn get_force(&mut self) -> Result<&[f64]>;
}
// 3da305d7 ends here

// [[file:../dimer.note::a7df26ce][a7df26ce]]
/// Main entry point for DIMER algorithm
pub struct Dimer {
    /// Dimer algorithm parameters
    pub vars: UserOptions,
}

impl Dimer {
    /// Construct a dimer for optimization.
    pub fn new() -> Self {
        Self {
            vars: UserOptions::default(),
        }
    }
}

pub use crate::dimer::*;
pub use options::UserOptions;
// a7df26ce ends here

// [[file:../dimer.note::cfd3ba0e][cfd3ba0e]]
#[cfg(feature = "adhoc")]
/// Docs for local mods
pub mod docs {
    macro_rules! export_doc {
        ($l:ident) => {
            pub mod $l {
                pub use crate::$l::*;
            }
        };
    }

    export_doc!(raw);
    export_doc!(fourier);
    export_doc!(options);
    export_doc!(rotation);
    export_doc!(translation);
    export_doc!(cg);
}
// cfd3ba0e ends here
