CREATE TABLE properties (
       -- id INTEGER PRIMARY KEY NOT NULL,
       model_id INTEGER NOT NULL,
       molecule_id INTEGER NOT NULL,
       data BLOB NOT NULL,
       ctime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       mtime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       PRIMARY KEY (model_id, molecule_id)
);

CREATE TABLE models (
       id INTEGER PRIMARY KEY NOT NULL,
       name TEXT NOT NULL,
       ctime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       mtime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE molecules (
       id INTEGER PRIMARY KEY NOT NULL,
       name TEXT NOT NULL,
       data BLOB NOT NULL,
       ctime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       mtime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE checkpoints (
       id INTEGER PRIMARY KEY NOT NULL,
       key TEXT NOT NULL,
       data BLOB NOT NULL,
       ctime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       mtime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE kvstore (
       id INTEGER PRIMARY KEY NOT NULL,
       collection TEXT NOT NULL,
       key TEXT NOT NULL,
       data BLOB NOT NULL,
       ctime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       mtime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
       UNIQUE(collection, key)
);
