# Coordinated Omission

When Coordinated Omission mitigation is enabled, Goose attempts to mitigate the loss of metrics data (Coordinated Omission) caused by an abnormally lengthy response to a request.

## Definition

To understand Coordinated Omission and how Goose attempts to mitigate it, it's necessary to understand how Goose is scheduling requests. Goose launches one thread per [`GooseUser`](https://docs.rs/goose/*/goose/goose/struct.GooseUser.html). Each [`GooseUser`](https://docs.rs/goose/*/goose/goose/struct.GooseUser.html) is assigned a single [`GooseTaskSet`](https://docs.rs/goose/*/goose/goose/struct.GooseTaskSet.html). Each of these [`GooseUser`](https://docs.rs/goose/*/goose/goose/struct.GooseUser.html) threads then loop repeatedly through all of the [`GooseTasks`](https://docs.rs/goose/*/goose/goose/struct.GooseTask.html) defined in the assigned [`GooseTaskSet`](https://docs.rs/goose/*/goose/goose/struct.GooseTaskSet.html), each of which can involve any number of individual requests. However, at any given time, each [`GooseUser`](https://docs.rs/goose/*/goose/goose/struct.GooseUser.html) is only making a single request and then asynchronously waiting for the response.


If something causes the response to a request to take abnormally long, raw Goose metrics only see this slowdown as affecting a specific request (or one request per [`GooseUser`](https://docs.rs/goose/*/goose/goose/struct.GooseUser.html). The slowdown can be caused by a variety of issues, such as a resource bottleneck (on the Goose client or the web server), garbage collection, a cache stampede, or even a network issue. A real user loading the same web page would see a much larger effect, as all requests to the affected server would stall. Even static assets such as images and scripts hosted on a reliable and fast CDN can be affected, as the web browser won't know to load them until it first loads the HTML from the affected web server. Because Goose is only making one request at a time per [`GooseUser`](https://docs.rs/goose/*/goose/goose/struct.GooseUser.html), it may only see one or very few slow requests and then all other requests resume at normal speed. This results in a bias in the metrics to "ignore" or "hide" the true effect of a slowdown, commonly referred to as Coordinated Omission.
