use crate::api::AcknowledgeRequest;
use crate::client::Client;
use crate::Error;
use std::collections::HashMap;

#[derive(Clone)]
pub struct Message {
    pub(crate) client: Client,
    pub(crate) data: Vec<u8>,
    pub(crate) attributes: HashMap<String, String>,
    pub(crate) ack_id: String,
    pub(crate) message_id: String,
    pub(crate) publish_time: chrono::NaiveDateTime,
    pub(crate) subscription_name: String,
}

impl Message {
    pub async fn ack(&mut self) -> Result<(), Error> {
        let req = AcknowledgeRequest {
            subscription: self.subscription_name.clone(),
            ack_ids: vec![self.ack_id.clone()],
        };
        let req = self.client.insert_authz_token(req).await?;
        self.client.subscriber.acknowledge(req).await?;
        Ok(())
    }
    pub fn data(&self) -> &[u8] {
        self.data.as_slice()
    }
    pub fn id(&self) -> &str {
        self.message_id.as_str()
    }
    pub fn attributes(&self) -> &HashMap<String, String> {
        &self.attributes
    }
}
