use thiserror::Error;
use tonic::metadata::errors::InvalidMetadataValue;
use tonic::Status;

#[derive(Error, Debug)]
pub enum Error {
    #[error("tonic transport error {0}")]
    TransportError(#[from] tonic::transport::Error),
    #[error("token parse error: {0}")]
    TokenParseError(#[from] InvalidMetadataValue),
    #[error("pubsub error: {0}")]
    PubsubError(#[from] Status),
    #[error("anyhow error: {0}")]
    AnyhowError(#[from] anyhow::Error),
}
