use crate::api::subscriber_client::SubscriberClient;
use crate::api::AcknowledgeRequest;
use anyhow::Result;
use std::collections::HashMap;
use tonic::transport::Channel;

#[derive(Clone)]
pub struct Message {
    pub(crate) client: SubscriberClient<Channel>,
    pub(crate) data: Vec<u8>,
    pub(crate) attributes: HashMap<String, String>,
    pub(crate) ack_id: String,
    pub(crate) message_id: String,
    pub(crate) publish_time: chrono::NaiveDateTime,
    pub(crate) subscription_name: String,
}

impl Message {
    pub async fn ack(&mut self) -> Result<()> {
        let req = AcknowledgeRequest {
            subscription: self.subscription_name.clone(),
            ack_ids: vec![self.ack_id.clone()],
        };
        self.client.acknowledge(req).await?;
        Ok(())
    }
    pub fn data(&self) -> &[u8] {
        self.data.as_slice()
    }
    pub fn id(&self) -> &str {
        self.message_id.as_str()
    }
    pub fn attributes(&self) -> &HashMap<String, String> {
        &self.attributes
    }
}
