use crate::api;
use crate::client::Client;
use anyhow::Result;
use std::collections::HashMap;

#[derive(Clone)]
pub struct Topic {
    pub(crate) client: Client,
    pub(crate) name: String,
}

impl Topic {
    pub(crate) fn new(client: Client, name: impl Into<String>) -> Self {
        Self {
            client,
            name: name.into(),
        }
    }
    pub async fn create_subscription(
        &mut self,
        topic_name: &str,
        subscription_name: &str,
        filter: &str,
    ) -> Result<()> {
        let subs = api::Subscription {
            name: format!(
                "projects/{}/subscriptions/{}",
                &self.client.project_id, subscription_name
            ),
            ack_deadline_seconds: 10,
            dead_letter_policy: None,
            detached: false,
            enable_message_ordering: true,
            expiration_policy: None,
            filter: filter.to_string(),
            labels: HashMap::new(),
            message_retention_duration: None,
            push_config: None,
            retain_acked_messages: false,
            retry_policy: None,
            topic: format!("projects/{}/topics/{}", &self.client.project_id, topic_name),
        };
        self.client.subscriber.create_subscription(subs).await?;
        Ok(())
    }
    pub async fn delete_subscription(&mut self, subscription_name: &str) -> Result<()> {
        let req = api::DeleteSubscriptionRequest {
            subscription: format!(
                "projects/{}/subscriptions/{}",
                &self.client.project_id, subscription_name
            ),
        };
        self.client.subscriber.delete_subscription(req).await?;
        Ok(())
    }
}
