<!---
DO NOT EDIT !
This file was generated automatically from 'src/mako/api/README.md.mako'
DO NOT EDIT !
-->
The `google-dialogflow2` library allows access to all features of the *Google Dialogflow* service.

This documentation was generated from *Dialogflow* crate version *3.1.0+20220228*, where *20220228* is the exact revision of the *dialogflow:v2* schema built by the [mako](http://www.makotemplates.org/) code generator *v3.1.0*.

Everything else about the *Dialogflow* *v2* API can be found at the
[official documentation site](https://cloud.google.com/dialogflow/).
# Features

Handle the following *Resources* with ease from the central [hub](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/Dialogflow) ... 

* projects
 * [*agent entity types batch delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeBatchDeleteCall), [*agent entity types batch update*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeBatchUpdateCall), [*agent entity types create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeCreateCall), [*agent entity types delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeDeleteCall), [*agent entity types entities batch create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeEntityBatchCreateCall), [*agent entity types entities batch delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeEntityBatchDeleteCall), [*agent entity types entities batch update*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeEntityBatchUpdateCall), [*agent entity types get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeGetCall), [*agent entity types list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypeListCall), [*agent entity types patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEntityTypePatchCall), [*agent environments create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentCreateCall), [*agent environments delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentDeleteCall), [*agent environments get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentGetCall), [*agent environments get history*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentGetHistoryCall), [*agent environments intents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentIntentListCall), [*agent environments list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentListCall), [*agent environments patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentPatchCall), [*agent environments users sessions contexts create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionContextCreateCall), [*agent environments users sessions contexts delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionContextDeleteCall), [*agent environments users sessions contexts get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionContextGetCall), [*agent environments users sessions contexts list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionContextListCall), [*agent environments users sessions contexts patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionContextPatchCall), [*agent environments users sessions delete contexts*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionDeleteContextCall), [*agent environments users sessions detect intent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionDetectIntentCall), [*agent environments users sessions entity types create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionEntityTypeCreateCall), [*agent environments users sessions entity types delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionEntityTypeDeleteCall), [*agent environments users sessions entity types get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionEntityTypeGetCall), [*agent environments users sessions entity types list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionEntityTypeListCall), [*agent environments users sessions entity types patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentEnvironmentUserSessionEntityTypePatchCall), [*agent export*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentExportCall), [*agent get fulfillment*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentGetFulfillmentCall), [*agent get validation result*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentGetValidationResultCall), [*agent import*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentImportCall), [*agent intents batch delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentBatchDeleteCall), [*agent intents batch update*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentBatchUpdateCall), [*agent intents create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentCreateCall), [*agent intents delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentDeleteCall), [*agent intents get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentGetCall), [*agent intents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentListCall), [*agent intents patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentIntentPatchCall), [*agent knowledge bases create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseCreateCall), [*agent knowledge bases delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDeleteCall), [*agent knowledge bases documents create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDocumentCreateCall), [*agent knowledge bases documents delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDocumentDeleteCall), [*agent knowledge bases documents get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDocumentGetCall), [*agent knowledge bases documents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDocumentListCall), [*agent knowledge bases documents patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDocumentPatchCall), [*agent knowledge bases documents reload*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseDocumentReloadCall), [*agent knowledge bases get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseGetCall), [*agent knowledge bases list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBaseListCall), [*agent knowledge bases patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentKnowledgeBasePatchCall), [*agent restore*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentRestoreCall), [*agent search*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSearchCall), [*agent sessions contexts create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionContextCreateCall), [*agent sessions contexts delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionContextDeleteCall), [*agent sessions contexts get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionContextGetCall), [*agent sessions contexts list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionContextListCall), [*agent sessions contexts patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionContextPatchCall), [*agent sessions delete contexts*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionDeleteContextCall), [*agent sessions detect intent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionDetectIntentCall), [*agent sessions entity types create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionEntityTypeCreateCall), [*agent sessions entity types delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionEntityTypeDeleteCall), [*agent sessions entity types get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionEntityTypeGetCall), [*agent sessions entity types list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionEntityTypeListCall), [*agent sessions entity types patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentSessionEntityTypePatchCall), [*agent train*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentTrainCall), [*agent update fulfillment*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentUpdateFulfillmentCall), [*agent versions create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentVersionCreateCall), [*agent versions delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentVersionDeleteCall), [*agent versions get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentVersionGetCall), [*agent versions list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentVersionListCall), [*agent versions patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAgentVersionPatchCall), [*answer records list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAnswerRecordListCall), [*answer records patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectAnswerRecordPatchCall), [*conversation datasets get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationDatasetGetCall), [*conversation datasets import conversation data*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationDatasetImportConversationDataCall), [*conversation datasets list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationDatasetListCall), [*conversation models create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelCreateCall), [*conversation models delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelDeleteCall), [*conversation models deploy*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelDeployCall), [*conversation models evaluations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelEvaluationGetCall), [*conversation models evaluations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelEvaluationListCall), [*conversation models get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelGetCall), [*conversation models list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelListCall), [*conversation models undeploy*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationModelUndeployCall), [*conversation profiles clear suggestion feature config*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfileClearSuggestionFeatureConfigCall), [*conversation profiles create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfileCreateCall), [*conversation profiles delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfileDeleteCall), [*conversation profiles get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfileGetCall), [*conversation profiles list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfileListCall), [*conversation profiles patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfilePatchCall), [*conversation profiles set suggestion feature config*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationProfileSetSuggestionFeatureConfigCall), [*conversations complete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationCompleteCall), [*conversations create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationCreateCall), [*conversations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationGetCall), [*conversations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationListCall), [*conversations messages list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationMessageListCall), [*conversations participants analyze content*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantAnalyzeContentCall), [*conversations participants create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantCreateCall), [*conversations participants get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantGetCall), [*conversations participants list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantListCall), [*conversations participants patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantPatchCall), [*conversations participants suggestions suggest articles*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantSuggestionSuggestArticleCall), [*conversations participants suggestions suggest faq answers*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantSuggestionSuggestFaqAnswerCall), [*conversations participants suggestions suggest smart replies*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectConversationParticipantSuggestionSuggestSmartReplyCall), [*delete agent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectDeleteAgentCall), [*get agent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectGetAgentCall), [*knowledge bases create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseCreateCall), [*knowledge bases delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDeleteCall), [*knowledge bases documents create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentCreateCall), [*knowledge bases documents delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentDeleteCall), [*knowledge bases documents export*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentExportCall), [*knowledge bases documents get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentGetCall), [*knowledge bases documents import*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentImportCall), [*knowledge bases documents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentListCall), [*knowledge bases documents patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentPatchCall), [*knowledge bases documents reload*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseDocumentReloadCall), [*knowledge bases get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseGetCall), [*knowledge bases list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBaseListCall), [*knowledge bases patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectKnowledgeBasePatchCall), [*locations agent entity types batch delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeBatchDeleteCall), [*locations agent entity types batch update*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeBatchUpdateCall), [*locations agent entity types create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeCreateCall), [*locations agent entity types delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeDeleteCall), [*locations agent entity types entities batch create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeEntityBatchCreateCall), [*locations agent entity types entities batch delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeEntityBatchDeleteCall), [*locations agent entity types entities batch update*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeEntityBatchUpdateCall), [*locations agent entity types get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeGetCall), [*locations agent entity types list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypeListCall), [*locations agent entity types patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEntityTypePatchCall), [*locations agent environments create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentCreateCall), [*locations agent environments delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentDeleteCall), [*locations agent environments get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentGetCall), [*locations agent environments get history*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentGetHistoryCall), [*locations agent environments intents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentIntentListCall), [*locations agent environments list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentListCall), [*locations agent environments patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentPatchCall), [*locations agent environments users sessions contexts create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionContextCreateCall), [*locations agent environments users sessions contexts delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionContextDeleteCall), [*locations agent environments users sessions contexts get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionContextGetCall), [*locations agent environments users sessions contexts list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionContextListCall), [*locations agent environments users sessions contexts patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionContextPatchCall), [*locations agent environments users sessions delete contexts*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionDeleteContextCall), [*locations agent environments users sessions detect intent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionDetectIntentCall), [*locations agent environments users sessions entity types create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionEntityTypeCreateCall), [*locations agent environments users sessions entity types delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionEntityTypeDeleteCall), [*locations agent environments users sessions entity types get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionEntityTypeGetCall), [*locations agent environments users sessions entity types list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionEntityTypeListCall), [*locations agent environments users sessions entity types patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentEnvironmentUserSessionEntityTypePatchCall), [*locations agent export*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentExportCall), [*locations agent get fulfillment*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentGetFulfillmentCall), [*locations agent get validation result*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentGetValidationResultCall), [*locations agent import*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentImportCall), [*locations agent intents batch delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentBatchDeleteCall), [*locations agent intents batch update*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentBatchUpdateCall), [*locations agent intents create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentCreateCall), [*locations agent intents delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentDeleteCall), [*locations agent intents get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentGetCall), [*locations agent intents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentListCall), [*locations agent intents patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentIntentPatchCall), [*locations agent restore*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentRestoreCall), [*locations agent search*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSearchCall), [*locations agent sessions contexts create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionContextCreateCall), [*locations agent sessions contexts delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionContextDeleteCall), [*locations agent sessions contexts get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionContextGetCall), [*locations agent sessions contexts list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionContextListCall), [*locations agent sessions contexts patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionContextPatchCall), [*locations agent sessions delete contexts*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionDeleteContextCall), [*locations agent sessions detect intent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionDetectIntentCall), [*locations agent sessions entity types create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionEntityTypeCreateCall), [*locations agent sessions entity types delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionEntityTypeDeleteCall), [*locations agent sessions entity types get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionEntityTypeGetCall), [*locations agent sessions entity types list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionEntityTypeListCall), [*locations agent sessions entity types patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentSessionEntityTypePatchCall), [*locations agent train*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentTrainCall), [*locations agent update fulfillment*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentUpdateFulfillmentCall), [*locations agent versions create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentVersionCreateCall), [*locations agent versions delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentVersionDeleteCall), [*locations agent versions get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentVersionGetCall), [*locations agent versions list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentVersionListCall), [*locations agent versions patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAgentVersionPatchCall), [*locations answer records list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAnswerRecordListCall), [*locations answer records patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationAnswerRecordPatchCall), [*locations conversation datasets create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationDatasetCreateCall), [*locations conversation datasets delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationDatasetDeleteCall), [*locations conversation datasets get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationDatasetGetCall), [*locations conversation datasets import conversation data*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationDatasetImportConversationDataCall), [*locations conversation datasets list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationDatasetListCall), [*locations conversation models create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelCreateCall), [*locations conversation models delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelDeleteCall), [*locations conversation models deploy*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelDeployCall), [*locations conversation models evaluations create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelEvaluationCreateCall), [*locations conversation models evaluations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelEvaluationGetCall), [*locations conversation models evaluations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelEvaluationListCall), [*locations conversation models get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelGetCall), [*locations conversation models list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelListCall), [*locations conversation models undeploy*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationModelUndeployCall), [*locations conversation profiles clear suggestion feature config*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfileClearSuggestionFeatureConfigCall), [*locations conversation profiles create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfileCreateCall), [*locations conversation profiles delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfileDeleteCall), [*locations conversation profiles get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfileGetCall), [*locations conversation profiles list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfileListCall), [*locations conversation profiles patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfilePatchCall), [*locations conversation profiles set suggestion feature config*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationProfileSetSuggestionFeatureConfigCall), [*locations conversations complete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationCompleteCall), [*locations conversations create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationCreateCall), [*locations conversations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationGetCall), [*locations conversations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationListCall), [*locations conversations messages list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationMessageListCall), [*locations conversations participants analyze content*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantAnalyzeContentCall), [*locations conversations participants create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantCreateCall), [*locations conversations participants get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantGetCall), [*locations conversations participants list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantListCall), [*locations conversations participants patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantPatchCall), [*locations conversations participants suggestions suggest articles*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantSuggestionSuggestArticleCall), [*locations conversations participants suggestions suggest faq answers*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantSuggestionSuggestFaqAnswerCall), [*locations conversations participants suggestions suggest smart replies*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationConversationParticipantSuggestionSuggestSmartReplyCall), [*locations delete agent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationDeleteAgentCall), [*locations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationGetCall), [*locations get agent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationGetAgentCall), [*locations knowledge bases create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseCreateCall), [*locations knowledge bases delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDeleteCall), [*locations knowledge bases documents create*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentCreateCall), [*locations knowledge bases documents delete*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentDeleteCall), [*locations knowledge bases documents export*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentExportCall), [*locations knowledge bases documents get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentGetCall), [*locations knowledge bases documents import*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentImportCall), [*locations knowledge bases documents list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentListCall), [*locations knowledge bases documents patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentPatchCall), [*locations knowledge bases documents reload*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseDocumentReloadCall), [*locations knowledge bases get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseGetCall), [*locations knowledge bases list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBaseListCall), [*locations knowledge bases patch*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationKnowledgeBasePatchCall), [*locations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationListCall), [*locations operations cancel*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationOperationCancelCall), [*locations operations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationOperationGetCall), [*locations operations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationOperationListCall), [*locations set agent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectLocationSetAgentCall), [*operations cancel*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectOperationCancelCall), [*operations get*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectOperationGetCall), [*operations list*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectOperationListCall) and [*set agent*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/api::ProjectSetAgentCall)




# Structure of this Library

The API is structured into the following primary items:

* **[Hub](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/Dialogflow)**
    * a central object to maintain state and allow accessing all *Activities*
    * creates [*Method Builders*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::MethodsBuilder) which in turn
      allow access to individual [*Call Builders*](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::CallBuilder)
* **[Resources](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Resource)**
    * primary types that you can apply *Activities* to
    * a collection of properties and *Parts*
    * **[Parts](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Part)**
        * a collection of properties
        * never directly used in *Activities*
* **[Activities](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::CallBuilder)**
    * operations to apply to *Resources*

All *structures* are marked with applicable traits to further categorize them and ease browsing.

Generally speaking, you can invoke *Activities* like this:

```Rust,ignore
let r = hub.resource().activity(...).doit().await
```

Or specifically ...

```ignore
let r = hub.projects().agent_entity_types_entities_batch_create(...).doit().await
let r = hub.projects().agent_entity_types_entities_batch_delete(...).doit().await
let r = hub.projects().agent_entity_types_entities_batch_update(...).doit().await
let r = hub.projects().agent_entity_types_batch_delete(...).doit().await
let r = hub.projects().agent_entity_types_batch_update(...).doit().await
let r = hub.projects().agent_intents_batch_delete(...).doit().await
let r = hub.projects().agent_intents_batch_update(...).doit().await
let r = hub.projects().agent_knowledge_bases_documents_create(...).doit().await
let r = hub.projects().agent_knowledge_bases_documents_delete(...).doit().await
let r = hub.projects().agent_knowledge_bases_documents_patch(...).doit().await
let r = hub.projects().agent_knowledge_bases_documents_reload(...).doit().await
let r = hub.projects().agent_export(...).doit().await
let r = hub.projects().agent_import(...).doit().await
let r = hub.projects().agent_restore(...).doit().await
let r = hub.projects().agent_train(...).doit().await
let r = hub.projects().conversation_datasets_import_conversation_data(...).doit().await
let r = hub.projects().conversation_models_create(...).doit().await
let r = hub.projects().conversation_models_delete(...).doit().await
let r = hub.projects().conversation_models_deploy(...).doit().await
let r = hub.projects().conversation_models_undeploy(...).doit().await
let r = hub.projects().conversation_profiles_clear_suggestion_feature_config(...).doit().await
let r = hub.projects().conversation_profiles_set_suggestion_feature_config(...).doit().await
let r = hub.projects().knowledge_bases_documents_create(...).doit().await
let r = hub.projects().knowledge_bases_documents_delete(...).doit().await
let r = hub.projects().knowledge_bases_documents_export(...).doit().await
let r = hub.projects().knowledge_bases_documents_import(...).doit().await
let r = hub.projects().knowledge_bases_documents_patch(...).doit().await
let r = hub.projects().knowledge_bases_documents_reload(...).doit().await
let r = hub.projects().locations_agent_entity_types_entities_batch_create(...).doit().await
let r = hub.projects().locations_agent_entity_types_entities_batch_delete(...).doit().await
let r = hub.projects().locations_agent_entity_types_entities_batch_update(...).doit().await
let r = hub.projects().locations_agent_entity_types_batch_delete(...).doit().await
let r = hub.projects().locations_agent_entity_types_batch_update(...).doit().await
let r = hub.projects().locations_agent_intents_batch_delete(...).doit().await
let r = hub.projects().locations_agent_intents_batch_update(...).doit().await
let r = hub.projects().locations_agent_export(...).doit().await
let r = hub.projects().locations_agent_import(...).doit().await
let r = hub.projects().locations_agent_restore(...).doit().await
let r = hub.projects().locations_agent_train(...).doit().await
let r = hub.projects().locations_conversation_datasets_create(...).doit().await
let r = hub.projects().locations_conversation_datasets_delete(...).doit().await
let r = hub.projects().locations_conversation_datasets_import_conversation_data(...).doit().await
let r = hub.projects().locations_conversation_models_evaluations_create(...).doit().await
let r = hub.projects().locations_conversation_models_create(...).doit().await
let r = hub.projects().locations_conversation_models_delete(...).doit().await
let r = hub.projects().locations_conversation_models_deploy(...).doit().await
let r = hub.projects().locations_conversation_models_undeploy(...).doit().await
let r = hub.projects().locations_conversation_profiles_clear_suggestion_feature_config(...).doit().await
let r = hub.projects().locations_conversation_profiles_set_suggestion_feature_config(...).doit().await
let r = hub.projects().locations_knowledge_bases_documents_create(...).doit().await
let r = hub.projects().locations_knowledge_bases_documents_delete(...).doit().await
let r = hub.projects().locations_knowledge_bases_documents_export(...).doit().await
let r = hub.projects().locations_knowledge_bases_documents_import(...).doit().await
let r = hub.projects().locations_knowledge_bases_documents_patch(...).doit().await
let r = hub.projects().locations_knowledge_bases_documents_reload(...).doit().await
let r = hub.projects().locations_operations_get(...).doit().await
let r = hub.projects().operations_get(...).doit().await
```

The `resource()` and `activity(...)` calls create [builders][builder-pattern]. The second one dealing with `Activities` 
supports various methods to configure the impending operation (not shown here). It is made such that all required arguments have to be 
specified right away (i.e. `(...)`), whereas all optional ones can be [build up][builder-pattern] as desired.
The `doit()` method performs the actual communication with the server and returns the respective result.

# Usage

## Setting up your Project

To use this library, you would put the following lines into your `Cargo.toml` file:

```toml
[dependencies]
google-dialogflow2 = "*"
serde = "^1.0"
serde_json = "^1.0"
```

## A complete example

```Rust
extern crate hyper;
extern crate hyper_rustls;
extern crate google_dialogflow2 as dialogflow2;
use dialogflow2::api::GoogleCloudDialogflowV2Document;
use dialogflow2::{Result, Error};
use std::default::Default;
use dialogflow2::{Dialogflow, oauth2, hyper, hyper_rustls};

// Get an ApplicationSecret instance by some means. It contains the `client_id` and 
// `client_secret`, among other things.
let secret: oauth2::ApplicationSecret = Default::default();
// Instantiate the authenticator. It will choose a suitable authentication flow for you, 
// unless you replace  `None` with the desired Flow.
// Provide your own `AuthenticatorDelegate` to adjust the way it operates and get feedback about 
// what's going on. You probably want to bring in your own `TokenStorage` to persist tokens and
// retrieve them from storage.
let auth = oauth2::InstalledFlowAuthenticator::builder(
        secret,
        oauth2::InstalledFlowReturnMethod::HTTPRedirect,
    ).build().await.unwrap();
let mut hub = Dialogflow::new(hyper::Client::builder().build(hyper_rustls::HttpsConnector::with_native_roots().https_or_http().enable_http1().enable_http2().build()), auth);
// As the method needs a request, you would usually fill it with the desired information
// into the respective structure. Some of the parts shown here might not be applicable !
// Values shown here are possibly random and not representative !
let mut req = GoogleCloudDialogflowV2Document::default();

// You can configure optional parameters by calling the respective setters at will, and
// execute the final call using `doit()`.
// Values shown here are possibly random and not representative !
let result = hub.projects().agent_knowledge_bases_documents_patch(req, "name")
             .update_mask("magna")
             .doit().await;

match result {
    Err(e) => match e {
        // The Error enum provides details about what exactly happened.
        // You can also just use its `Debug`, `Display` or `Error` traits
         Error::HttpError(_)
        |Error::Io(_)
        |Error::MissingAPIKey
        |Error::MissingToken(_)
        |Error::Cancelled
        |Error::UploadSizeLimitExceeded(_, _)
        |Error::Failure(_)
        |Error::BadRequest(_)
        |Error::FieldClash(_)
        |Error::JsonDecodeError(_, _) => println!("{}", e),
    },
    Ok(res) => println!("Success: {:?}", res),
}

```
## Handling Errors

All errors produced by the system are provided either as [Result](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Result) enumeration as return value of
the doit() methods, or handed as possibly intermediate results to either the 
[Hub Delegate](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Delegate), or the [Authenticator Delegate](https://docs.rs/yup-oauth2/*/yup_oauth2/trait.AuthenticatorDelegate.html).

When delegates handle errors or intermediate values, they may have a chance to instruct the system to retry. This 
makes the system potentially resilient to all kinds of errors.

## Uploads and Downloads
If a method supports downloads, the response body, which is part of the [Result](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Result), should be
read by you to obtain the media.
If such a method also supports a [Response Result](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::ResponseResult), it will return that by default.
You can see it as meta-data for the actual media. To trigger a media download, you will have to set up the builder by making
this call: `.param("alt", "media")`.

Methods supporting uploads can do so using up to 2 different protocols: 
*simple* and *resumable*. The distinctiveness of each is represented by customized 
`doit(...)` methods, which are then named `upload(...)` and `upload_resumable(...)` respectively.

## Customization and Callbacks

You may alter the way an `doit()` method is called by providing a [delegate](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Delegate) to the 
[Method Builder](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::CallBuilder) before making the final `doit()` call. 
Respective methods will be called to provide progress information, as well as determine whether the system should 
retry on failure.

The [delegate trait](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Delegate) is default-implemented, allowing you to customize it with minimal effort.

## Optional Parts in Server-Requests

All structures provided by this library are made to be [encodable](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::RequestValue) and 
[decodable](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::ResponseResult) via *json*. Optionals are used to indicate that partial requests are responses 
are valid.
Most optionals are are considered [Parts](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::Part) which are identifiable by name, which will be sent to 
the server to indicate either the set parts of the request or the desired parts in the response.

## Builder Arguments

Using [method builders](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::CallBuilder), you are able to prepare an action call by repeatedly calling it's methods.
These will always take a single argument, for which the following statements are true.

* [PODs][wiki-pod] are handed by copy
* strings are passed as `&str`
* [request values](https://docs.rs/google-dialogflow2/3.1.0+20220228/google_dialogflow2/client::RequestValue) are moved

Arguments will always be copied or cloned into the builder, to make them independent of their original life times.

[wiki-pod]: http://en.wikipedia.org/wiki/Plain_old_data_structure
[builder-pattern]: http://en.wikipedia.org/wiki/Builder_pattern
[google-go-api]: https://github.com/google/google-api-go-client

# License
The **dialogflow2** library was generated by Sebastian Thiel, and is placed 
under the *MIT* license.
You can read the full text at the repository's [license file][repo-license].

[repo-license]: https://github.com/Byron/google-apis-rsblob/main/LICENSE.md
