// DO NOT EDIT !
// This file was generated automatically from 'src/mako/cli/main.rs.mako'
// DO NOT EDIT !
#![allow(unused_variables, unused_imports, dead_code, unused_mut)]

extern crate tokio;

#[macro_use]
extern crate clap;

use std::env;
use std::io::{self, Write};
use clap::{App, SubCommand, Arg};

use google_dfareporting3d4::{api, Error, oauth2};

mod client;

use client::{InvalidOptionsError, CLIError, arg_from_str, writer_from_opts, parse_kv_arg,
          input_file_from_opts, input_mime_from_opts, FieldCursor, FieldError, CallType, UploadProtocol,
          calltype_from_str, remove_json_null_values, ComplexType, JsonType, JsonTypeInfo};

use std::default::Default;
use std::str::FromStr;

use serde_json as json;
use clap::ArgMatches;

enum DoitError {
    IoError(String, io::Error),
    ApiError(Error),
}

struct Engine<'n> {
    opt: ArgMatches<'n>,
    hub: api::Dfareporting,
    gp: Vec<&'static str>,
    gpm: Vec<(&'static str, &'static str)>,
}


impl<'n> Engine<'n> {
    async fn _account_active_ad_summaries_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_active_ad_summaries().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("summary-account-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_permission_groups_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_permission_groups().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_permission_groups_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_permission_groups().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_permissions_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_permissions().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_permissions_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_permissions().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_user_profiles_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_user_profiles().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_user_profiles_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-filter.kind" => Some(("advertiserFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-filter.object-ids" => Some(("advertiserFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "advertiser-filter.status" => Some(("advertiserFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-filter.kind" => Some(("campaignFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-filter.object-ids" => Some(("campaignFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "campaign-filter.status" => Some(("campaignFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "comments" => Some(("comments", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "email" => Some(("email", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "locale" => Some(("locale", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter.kind" => Some(("siteFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter.object-ids" => Some(("siteFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "site-filter.status" => Some(("siteFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "trafficker-type" => Some(("traffickerType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-access-type" => Some(("userAccessType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-filter.kind" => Some(("userRoleFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-filter.object-ids" => Some(("userRoleFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "user-role-filter.status" => Some(("userRoleFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-id" => Some(("userRoleId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-filter", "campaign-filter", "comments", "email", "id", "kind", "locale", "name", "object-ids", "site-filter", "status", "subaccount-id", "trafficker-type", "user-access-type", "user-role-filter", "user-role-id"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::AccountUserProfile = json::value::from_value(object).unwrap();
        let mut call = self.hub.account_user_profiles().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_user_profiles_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.account_user_profiles().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "user-role-id" => {
                    call = call.user_role_id(value.unwrap_or(""));
                },
                "subaccount-id" => {
                    call = call.subaccount_id(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "active" => {
                    call = call.active(arg_from_str(value.unwrap_or("false"), err, "active", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["active", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order", "subaccount-id", "user-role-id"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_user_profiles_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-filter.kind" => Some(("advertiserFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-filter.object-ids" => Some(("advertiserFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "advertiser-filter.status" => Some(("advertiserFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-filter.kind" => Some(("campaignFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-filter.object-ids" => Some(("campaignFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "campaign-filter.status" => Some(("campaignFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "comments" => Some(("comments", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "email" => Some(("email", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "locale" => Some(("locale", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter.kind" => Some(("siteFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter.object-ids" => Some(("siteFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "site-filter.status" => Some(("siteFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "trafficker-type" => Some(("traffickerType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-access-type" => Some(("userAccessType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-filter.kind" => Some(("userRoleFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-filter.object-ids" => Some(("userRoleFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "user-role-filter.status" => Some(("userRoleFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-id" => Some(("userRoleId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-filter", "campaign-filter", "comments", "email", "id", "kind", "locale", "name", "object-ids", "site-filter", "status", "subaccount-id", "trafficker-type", "user-access-type", "user-role-filter", "user-role-id"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::AccountUserProfile = json::value::from_value(object).unwrap();
        let mut call = self.hub.account_user_profiles().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _account_user_profiles_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-filter.kind" => Some(("advertiserFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-filter.object-ids" => Some(("advertiserFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "advertiser-filter.status" => Some(("advertiserFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-filter.kind" => Some(("campaignFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-filter.object-ids" => Some(("campaignFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "campaign-filter.status" => Some(("campaignFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "comments" => Some(("comments", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "email" => Some(("email", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "locale" => Some(("locale", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter.kind" => Some(("siteFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter.object-ids" => Some(("siteFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "site-filter.status" => Some(("siteFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "trafficker-type" => Some(("traffickerType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-access-type" => Some(("userAccessType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-filter.kind" => Some(("userRoleFilter.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-filter.object-ids" => Some(("userRoleFilter.objectIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "user-role-filter.status" => Some(("userRoleFilter.status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-role-id" => Some(("userRoleId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-filter", "campaign-filter", "comments", "email", "id", "kind", "locale", "name", "object-ids", "site-filter", "status", "subaccount-id", "trafficker-type", "user-access-type", "user-role-filter", "user-role-id"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::AccountUserProfile = json::value::from_value(object).unwrap();
        let mut call = self.hub.account_user_profiles().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _accounts_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.accounts().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _accounts_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.accounts().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "active" => {
                    call = call.active(arg_from_str(value.unwrap_or("false"), err, "active", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["active", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _accounts_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-permission-ids" => Some(("accountPermissionIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "account-profile" => Some(("accountProfile", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "active-ads-limit-tier" => Some(("activeAdsLimitTier", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active-view-opt-out" => Some(("activeViewOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "available-permission-ids" => Some(("availablePermissionIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "country-id" => Some(("countryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "currency-id" => Some(("currencyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-creative-size-id" => Some(("defaultCreativeSizeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "description" => Some(("description", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "locale" => Some(("locale", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "maximum-image-size" => Some(("maximumImageSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "nielsen-ocr-enabled" => Some(("nielsenOcrEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reports-configuration.exposure-to-conversion-enabled" => Some(("reportsConfiguration.exposureToConversionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reports-configuration.lookback-configuration.click-duration" => Some(("reportsConfiguration.lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "reports-configuration.lookback-configuration.post-impression-activities-duration" => Some(("reportsConfiguration.lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "reports-configuration.report-generation-time-zone-id" => Some(("reportsConfiguration.reportGenerationTimeZoneId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "share-reports-with-twitter" => Some(("shareReportsWithTwitter", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "teaser-size-limit" => Some(("teaserSizeLimit", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-permission-ids", "account-profile", "active", "active-ads-limit-tier", "active-view-opt-out", "available-permission-ids", "click-duration", "country-id", "currency-id", "default-creative-size-id", "description", "exposure-to-conversion-enabled", "id", "kind", "locale", "lookback-configuration", "maximum-image-size", "name", "nielsen-ocr-enabled", "post-impression-activities-duration", "report-generation-time-zone-id", "reports-configuration", "share-reports-with-twitter", "teaser-size-limit"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Account = json::value::from_value(object).unwrap();
        let mut call = self.hub.accounts().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _accounts_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-permission-ids" => Some(("accountPermissionIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "account-profile" => Some(("accountProfile", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "active-ads-limit-tier" => Some(("activeAdsLimitTier", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active-view-opt-out" => Some(("activeViewOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "available-permission-ids" => Some(("availablePermissionIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "country-id" => Some(("countryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "currency-id" => Some(("currencyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-creative-size-id" => Some(("defaultCreativeSizeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "description" => Some(("description", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "locale" => Some(("locale", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "maximum-image-size" => Some(("maximumImageSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "nielsen-ocr-enabled" => Some(("nielsenOcrEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reports-configuration.exposure-to-conversion-enabled" => Some(("reportsConfiguration.exposureToConversionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reports-configuration.lookback-configuration.click-duration" => Some(("reportsConfiguration.lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "reports-configuration.lookback-configuration.post-impression-activities-duration" => Some(("reportsConfiguration.lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "reports-configuration.report-generation-time-zone-id" => Some(("reportsConfiguration.reportGenerationTimeZoneId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "share-reports-with-twitter" => Some(("shareReportsWithTwitter", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "teaser-size-limit" => Some(("teaserSizeLimit", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-permission-ids", "account-profile", "active", "active-ads-limit-tier", "active-view-opt-out", "available-permission-ids", "click-duration", "country-id", "currency-id", "default-creative-size-id", "description", "exposure-to-conversion-enabled", "id", "kind", "locale", "lookback-configuration", "maximum-image-size", "name", "nielsen-ocr-enabled", "post-impression-activities-duration", "report-generation-time-zone-id", "reports-configuration", "share-reports-with-twitter", "teaser-size-limit"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Account = json::value::from_value(object).unwrap();
        let mut call = self.hub.accounts().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _ads_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.ads().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _ads_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "audience-segment-id" => Some(("audienceSegmentId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.computed-click-through-url" => Some(("clickThroughUrl.computedClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.custom-click-through-url" => Some(("clickThroughUrl.customClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.default-landing-page" => Some(("clickThroughUrl.defaultLandingPage", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "click-through-url.landing-page-id" => Some(("clickThroughUrl.landingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.click-through-url-suffix" => Some(("clickThroughUrlSuffixProperties.clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.override-inherited-suffix" => Some(("clickThroughUrlSuffixProperties.overrideInheritedSuffix", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "comments" => Some(("comments", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.creative-optimization-configuration-id" => Some(("creativeRotation.creativeOptimizationConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.type" => Some(("creativeRotation.type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.weight-calculation-strategy" => Some(("creativeRotation.weightCalculationStrategy", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "day-part-targeting.days-of-week" => Some(("dayPartTargeting.daysOfWeek", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "day-part-targeting.hours-of-day" => Some(("dayPartTargeting.hoursOfDay", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Vec })),
                    "day-part-targeting.user-local-time" => Some(("dayPartTargeting.userLocalTime", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagProperties.defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.override-inherited-event-tag" => Some(("defaultClickThroughEventTagProperties.overrideInheritedEventTag", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery-schedule.frequency-cap.duration" => Some(("deliverySchedule.frequencyCap.duration", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.frequency-cap.impressions" => Some(("deliverySchedule.frequencyCap.impressions", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.hard-cutoff" => Some(("deliverySchedule.hardCutoff", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery-schedule.impression-ratio" => Some(("deliverySchedule.impressionRatio", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.priority" => Some(("deliverySchedule.priority", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "dynamic-click-tracker" => Some(("dynamicClickTracker", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "end-time" => Some(("endTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "geo-targeting.exclude-countries" => Some(("geoTargeting.excludeCountries", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "key-value-targeting-expression.expression" => Some(("keyValueTargetingExpression.expression", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "remarketing-list-expression.expression" => Some(("remarketingListExpression.expression", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "start-time" => Some(("startTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "targeting-template-id" => Some(("targetingTemplateId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-id", "advertiser-id-dimension-value", "archived", "audience-segment-id", "campaign-id", "campaign-id-dimension-value", "click-through-url", "click-through-url-suffix", "click-through-url-suffix-properties", "comments", "compatibility", "computed-click-through-url", "create-info", "creative-optimization-configuration-id", "creative-rotation", "custom-click-through-url", "day-part-targeting", "days-of-week", "default-click-through-event-tag-id", "default-click-through-event-tag-properties", "default-landing-page", "delivery-schedule", "dimension-name", "duration", "dynamic-click-tracker", "end-time", "etag", "exclude-countries", "expression", "frequency-cap", "geo-targeting", "hard-cutoff", "height", "hours-of-day", "iab", "id", "id-dimension-value", "impression-ratio", "impressions", "key-value-targeting-expression", "kind", "landing-page-id", "last-modified-info", "match-type", "name", "override-inherited-event-tag", "override-inherited-suffix", "priority", "remarketing-list-expression", "size", "ssl-compliant", "ssl-required", "start-time", "subaccount-id", "targeting-template-id", "time", "type", "user-local-time", "value", "weight-calculation-strategy", "width"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Ad = json::value::from_value(object).unwrap();
        let mut call = self.hub.ads().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _ads_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.ads().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "type" => {
                    call = call.add_type(value.unwrap_or(""));
                },
                "ssl-required" => {
                    call = call.ssl_required(arg_from_str(value.unwrap_or("false"), err, "ssl-required", "boolean"));
                },
                "ssl-compliant" => {
                    call = call.ssl_compliant(arg_from_str(value.unwrap_or("false"), err, "ssl-compliant", "boolean"));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "size-ids" => {
                    call = call.add_size_ids(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "remarketing-list-ids" => {
                    call = call.add_remarketing_list_ids(value.unwrap_or(""));
                },
                "placement-ids" => {
                    call = call.add_placement_ids(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "overridden-event-tag-id" => {
                    call = call.overridden_event_tag_id(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "landing-page-ids" => {
                    call = call.add_landing_page_ids(value.unwrap_or(""));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "dynamic-click-tracker" => {
                    call = call.dynamic_click_tracker(arg_from_str(value.unwrap_or("false"), err, "dynamic-click-tracker", "boolean"));
                },
                "creative-optimization-configuration-ids" => {
                    call = call.add_creative_optimization_configuration_ids(value.unwrap_or(""));
                },
                "creative-ids" => {
                    call = call.add_creative_ids(value.unwrap_or(""));
                },
                "compatibility" => {
                    call = call.compatibility(value.unwrap_or(""));
                },
                "campaign-ids" => {
                    call = call.add_campaign_ids(value.unwrap_or(""));
                },
                "audience-segment-ids" => {
                    call = call.add_audience_segment_ids(value.unwrap_or(""));
                },
                "archived" => {
                    call = call.archived(arg_from_str(value.unwrap_or("false"), err, "archived", "boolean"));
                },
                "advertiser-id" => {
                    call = call.advertiser_id(value.unwrap_or(""));
                },
                "active" => {
                    call = call.active(arg_from_str(value.unwrap_or("false"), err, "active", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["active", "advertiser-id", "archived", "audience-segment-ids", "campaign-ids", "compatibility", "creative-ids", "creative-optimization-configuration-ids", "dynamic-click-tracker", "ids", "landing-page-ids", "max-results", "overridden-event-tag-id", "page-token", "placement-ids", "remarketing-list-ids", "search-string", "size-ids", "sort-field", "sort-order", "ssl-compliant", "ssl-required", "type"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _ads_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "audience-segment-id" => Some(("audienceSegmentId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.computed-click-through-url" => Some(("clickThroughUrl.computedClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.custom-click-through-url" => Some(("clickThroughUrl.customClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.default-landing-page" => Some(("clickThroughUrl.defaultLandingPage", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "click-through-url.landing-page-id" => Some(("clickThroughUrl.landingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.click-through-url-suffix" => Some(("clickThroughUrlSuffixProperties.clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.override-inherited-suffix" => Some(("clickThroughUrlSuffixProperties.overrideInheritedSuffix", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "comments" => Some(("comments", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.creative-optimization-configuration-id" => Some(("creativeRotation.creativeOptimizationConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.type" => Some(("creativeRotation.type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.weight-calculation-strategy" => Some(("creativeRotation.weightCalculationStrategy", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "day-part-targeting.days-of-week" => Some(("dayPartTargeting.daysOfWeek", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "day-part-targeting.hours-of-day" => Some(("dayPartTargeting.hoursOfDay", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Vec })),
                    "day-part-targeting.user-local-time" => Some(("dayPartTargeting.userLocalTime", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagProperties.defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.override-inherited-event-tag" => Some(("defaultClickThroughEventTagProperties.overrideInheritedEventTag", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery-schedule.frequency-cap.duration" => Some(("deliverySchedule.frequencyCap.duration", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.frequency-cap.impressions" => Some(("deliverySchedule.frequencyCap.impressions", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.hard-cutoff" => Some(("deliverySchedule.hardCutoff", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery-schedule.impression-ratio" => Some(("deliverySchedule.impressionRatio", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.priority" => Some(("deliverySchedule.priority", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "dynamic-click-tracker" => Some(("dynamicClickTracker", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "end-time" => Some(("endTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "geo-targeting.exclude-countries" => Some(("geoTargeting.excludeCountries", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "key-value-targeting-expression.expression" => Some(("keyValueTargetingExpression.expression", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "remarketing-list-expression.expression" => Some(("remarketingListExpression.expression", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "start-time" => Some(("startTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "targeting-template-id" => Some(("targetingTemplateId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-id", "advertiser-id-dimension-value", "archived", "audience-segment-id", "campaign-id", "campaign-id-dimension-value", "click-through-url", "click-through-url-suffix", "click-through-url-suffix-properties", "comments", "compatibility", "computed-click-through-url", "create-info", "creative-optimization-configuration-id", "creative-rotation", "custom-click-through-url", "day-part-targeting", "days-of-week", "default-click-through-event-tag-id", "default-click-through-event-tag-properties", "default-landing-page", "delivery-schedule", "dimension-name", "duration", "dynamic-click-tracker", "end-time", "etag", "exclude-countries", "expression", "frequency-cap", "geo-targeting", "hard-cutoff", "height", "hours-of-day", "iab", "id", "id-dimension-value", "impression-ratio", "impressions", "key-value-targeting-expression", "kind", "landing-page-id", "last-modified-info", "match-type", "name", "override-inherited-event-tag", "override-inherited-suffix", "priority", "remarketing-list-expression", "size", "ssl-compliant", "ssl-required", "start-time", "subaccount-id", "targeting-template-id", "time", "type", "user-local-time", "value", "weight-calculation-strategy", "width"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Ad = json::value::from_value(object).unwrap();
        let mut call = self.hub.ads().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _ads_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "audience-segment-id" => Some(("audienceSegmentId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.computed-click-through-url" => Some(("clickThroughUrl.computedClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.custom-click-through-url" => Some(("clickThroughUrl.customClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url.default-landing-page" => Some(("clickThroughUrl.defaultLandingPage", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "click-through-url.landing-page-id" => Some(("clickThroughUrl.landingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.click-through-url-suffix" => Some(("clickThroughUrlSuffixProperties.clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.override-inherited-suffix" => Some(("clickThroughUrlSuffixProperties.overrideInheritedSuffix", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "comments" => Some(("comments", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.creative-optimization-configuration-id" => Some(("creativeRotation.creativeOptimizationConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.type" => Some(("creativeRotation.type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-rotation.weight-calculation-strategy" => Some(("creativeRotation.weightCalculationStrategy", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "day-part-targeting.days-of-week" => Some(("dayPartTargeting.daysOfWeek", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "day-part-targeting.hours-of-day" => Some(("dayPartTargeting.hoursOfDay", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Vec })),
                    "day-part-targeting.user-local-time" => Some(("dayPartTargeting.userLocalTime", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagProperties.defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.override-inherited-event-tag" => Some(("defaultClickThroughEventTagProperties.overrideInheritedEventTag", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery-schedule.frequency-cap.duration" => Some(("deliverySchedule.frequencyCap.duration", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.frequency-cap.impressions" => Some(("deliverySchedule.frequencyCap.impressions", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.hard-cutoff" => Some(("deliverySchedule.hardCutoff", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery-schedule.impression-ratio" => Some(("deliverySchedule.impressionRatio", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery-schedule.priority" => Some(("deliverySchedule.priority", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "dynamic-click-tracker" => Some(("dynamicClickTracker", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "end-time" => Some(("endTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "geo-targeting.exclude-countries" => Some(("geoTargeting.excludeCountries", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "key-value-targeting-expression.expression" => Some(("keyValueTargetingExpression.expression", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "remarketing-list-expression.expression" => Some(("remarketingListExpression.expression", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "start-time" => Some(("startTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "targeting-template-id" => Some(("targetingTemplateId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-id", "advertiser-id-dimension-value", "archived", "audience-segment-id", "campaign-id", "campaign-id-dimension-value", "click-through-url", "click-through-url-suffix", "click-through-url-suffix-properties", "comments", "compatibility", "computed-click-through-url", "create-info", "creative-optimization-configuration-id", "creative-rotation", "custom-click-through-url", "day-part-targeting", "days-of-week", "default-click-through-event-tag-id", "default-click-through-event-tag-properties", "default-landing-page", "delivery-schedule", "dimension-name", "duration", "dynamic-click-tracker", "end-time", "etag", "exclude-countries", "expression", "frequency-cap", "geo-targeting", "hard-cutoff", "height", "hours-of-day", "iab", "id", "id-dimension-value", "impression-ratio", "impressions", "key-value-targeting-expression", "kind", "landing-page-id", "last-modified-info", "match-type", "name", "override-inherited-event-tag", "override-inherited-suffix", "priority", "remarketing-list-expression", "size", "ssl-compliant", "ssl-required", "start-time", "subaccount-id", "targeting-template-id", "time", "type", "user-local-time", "value", "weight-calculation-strategy", "width"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Ad = json::value::from_value(object).unwrap();
        let mut call = self.hub.ads().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_groups_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertiser_groups().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_groups_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertiser_groups().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_groups_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::AdvertiserGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertiser_groups().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_groups_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertiser_groups().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_groups_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::AdvertiserGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertiser_groups().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_groups_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::AdvertiserGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertiser_groups().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_landing_pages_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertiser_landing_pages().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_landing_pages_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["advertiser-id", "archived", "id", "kind", "name", "url"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::LandingPage = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertiser_landing_pages().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_landing_pages_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertiser_landing_pages().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "subaccount-id" => {
                    call = call.subaccount_id(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "campaign-ids" => {
                    call = call.add_campaign_ids(value.unwrap_or(""));
                },
                "archived" => {
                    call = call.archived(arg_from_str(value.unwrap_or("false"), err, "archived", "boolean"));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-ids", "archived", "campaign-ids", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order", "subaccount-id"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_landing_pages_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["advertiser-id", "archived", "id", "kind", "name", "url"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::LandingPage = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertiser_landing_pages().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertiser_landing_pages_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["advertiser-id", "archived", "id", "kind", "name", "url"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::LandingPage = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertiser_landing_pages().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertisers_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertisers().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertisers_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-group-id" => Some(("advertiserGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix" => Some(("clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-email" => Some(("defaultEmail", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "original-floodlight-configuration-id" => Some(("originalFloodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "suspended" => Some(("suspended", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-group-id", "click-through-url-suffix", "default-click-through-event-tag-id", "default-email", "dimension-name", "etag", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "id", "id-dimension-value", "kind", "match-type", "name", "original-floodlight-configuration-id", "status", "subaccount-id", "suspended", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Advertiser = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertisers().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertisers_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.advertisers().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "subaccount-id" => {
                    call = call.subaccount_id(value.unwrap_or(""));
                },
                "status" => {
                    call = call.status(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "only-parent" => {
                    call = call.only_parent(arg_from_str(value.unwrap_or("false"), err, "only-parent", "boolean"));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "include-advertisers-without-groups-only" => {
                    call = call.include_advertisers_without_groups_only(arg_from_str(value.unwrap_or("false"), err, "include-advertisers-without-groups-only", "boolean"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "floodlight-configuration-ids" => {
                    call = call.add_floodlight_configuration_ids(value.unwrap_or(""));
                },
                "advertiser-group-ids" => {
                    call = call.add_advertiser_group_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-group-ids", "floodlight-configuration-ids", "ids", "include-advertisers-without-groups-only", "max-results", "only-parent", "page-token", "search-string", "sort-field", "sort-order", "status", "subaccount-id"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertisers_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-group-id" => Some(("advertiserGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix" => Some(("clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-email" => Some(("defaultEmail", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "original-floodlight-configuration-id" => Some(("originalFloodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "suspended" => Some(("suspended", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-group-id", "click-through-url-suffix", "default-click-through-event-tag-id", "default-email", "dimension-name", "etag", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "id", "id-dimension-value", "kind", "match-type", "name", "original-floodlight-configuration-id", "status", "subaccount-id", "suspended", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Advertiser = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertisers().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _advertisers_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-group-id" => Some(("advertiserGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix" => Some(("clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-email" => Some(("defaultEmail", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "original-floodlight-configuration-id" => Some(("originalFloodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "suspended" => Some(("suspended", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-group-id", "click-through-url-suffix", "default-click-through-event-tag-id", "default-email", "dimension-name", "etag", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "id", "id-dimension-value", "kind", "match-type", "name", "original-floodlight-configuration-id", "status", "subaccount-id", "suspended", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Advertiser = json::value::from_value(object).unwrap();
        let mut call = self.hub.advertisers().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _browsers_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.browsers().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaign_creative_associations_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "creative-id" => Some(("creativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["creative-id", "kind"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CampaignCreativeAssociation = json::value::from_value(object).unwrap();
        let mut call = self.hub.campaign_creative_associations().insert(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("campaign-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaign_creative_associations_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.campaign_creative_associations().list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("campaign-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["max-results", "page-token", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaigns_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.campaigns().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaigns_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.click-through-url" => Some(("adBlockingConfiguration.clickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.creative-bundle-id" => Some(("adBlockingConfiguration.creativeBundleId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.enabled" => Some(("adBlockingConfiguration.enabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.override-click-through-url" => Some(("adBlockingConfiguration.overrideClickThroughUrl", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-group-id" => Some(("advertiserGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "billing-invoice-code" => Some(("billingInvoiceCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.click-through-url-suffix" => Some(("clickThroughUrlSuffixProperties.clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.override-inherited-suffix" => Some(("clickThroughUrlSuffixProperties.overrideInheritedSuffix", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-group-ids" => Some(("creativeGroupIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "creative-optimization-configuration.id" => Some(("creativeOptimizationConfiguration.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-optimization-configuration.name" => Some(("creativeOptimizationConfiguration.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-optimization-configuration.optimization-model" => Some(("creativeOptimizationConfiguration.optimizationModel", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagProperties.defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.override-inherited-event-tag" => Some(("defaultClickThroughEventTagProperties.overrideInheritedEventTag", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "default-landing-page-id" => Some(("defaultLandingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "end-date" => Some(("endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "nielsen-ocr-enabled" => Some(("nielsenOcrEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "start-date" => Some(("startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "trafficker-emails" => Some(("traffickerEmails", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "ad-blocking-configuration", "advertiser-group-id", "advertiser-id", "advertiser-id-dimension-value", "archived", "billing-invoice-code", "click-through-url", "click-through-url-suffix", "click-through-url-suffix-properties", "comment", "create-info", "creative-bundle-id", "creative-group-ids", "creative-optimization-configuration", "default-click-through-event-tag-id", "default-click-through-event-tag-properties", "default-landing-page-id", "dimension-name", "enabled", "end-date", "etag", "external-id", "id", "id-dimension-value", "kind", "last-modified-info", "match-type", "name", "nielsen-ocr-enabled", "optimization-model", "override-click-through-url", "override-inherited-event-tag", "override-inherited-suffix", "start-date", "subaccount-id", "time", "trafficker-emails", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Campaign = json::value::from_value(object).unwrap();
        let mut call = self.hub.campaigns().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaigns_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.campaigns().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "subaccount-id" => {
                    call = call.subaccount_id(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "overridden-event-tag-id" => {
                    call = call.overridden_event_tag_id(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "excluded-ids" => {
                    call = call.add_excluded_ids(value.unwrap_or(""));
                },
                "at-least-one-optimization-activity" => {
                    call = call.at_least_one_optimization_activity(arg_from_str(value.unwrap_or("false"), err, "at-least-one-optimization-activity", "boolean"));
                },
                "archived" => {
                    call = call.archived(arg_from_str(value.unwrap_or("false"), err, "archived", "boolean"));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                "advertiser-group-ids" => {
                    call = call.add_advertiser_group_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-group-ids", "advertiser-ids", "archived", "at-least-one-optimization-activity", "excluded-ids", "ids", "max-results", "overridden-event-tag-id", "page-token", "search-string", "sort-field", "sort-order", "subaccount-id"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaigns_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.click-through-url" => Some(("adBlockingConfiguration.clickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.creative-bundle-id" => Some(("adBlockingConfiguration.creativeBundleId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.enabled" => Some(("adBlockingConfiguration.enabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.override-click-through-url" => Some(("adBlockingConfiguration.overrideClickThroughUrl", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-group-id" => Some(("advertiserGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "billing-invoice-code" => Some(("billingInvoiceCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.click-through-url-suffix" => Some(("clickThroughUrlSuffixProperties.clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.override-inherited-suffix" => Some(("clickThroughUrlSuffixProperties.overrideInheritedSuffix", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-group-ids" => Some(("creativeGroupIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "creative-optimization-configuration.id" => Some(("creativeOptimizationConfiguration.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-optimization-configuration.name" => Some(("creativeOptimizationConfiguration.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-optimization-configuration.optimization-model" => Some(("creativeOptimizationConfiguration.optimizationModel", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagProperties.defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.override-inherited-event-tag" => Some(("defaultClickThroughEventTagProperties.overrideInheritedEventTag", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "default-landing-page-id" => Some(("defaultLandingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "end-date" => Some(("endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "nielsen-ocr-enabled" => Some(("nielsenOcrEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "start-date" => Some(("startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "trafficker-emails" => Some(("traffickerEmails", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "ad-blocking-configuration", "advertiser-group-id", "advertiser-id", "advertiser-id-dimension-value", "archived", "billing-invoice-code", "click-through-url", "click-through-url-suffix", "click-through-url-suffix-properties", "comment", "create-info", "creative-bundle-id", "creative-group-ids", "creative-optimization-configuration", "default-click-through-event-tag-id", "default-click-through-event-tag-properties", "default-landing-page-id", "dimension-name", "enabled", "end-date", "etag", "external-id", "id", "id-dimension-value", "kind", "last-modified-info", "match-type", "name", "nielsen-ocr-enabled", "optimization-model", "override-click-through-url", "override-inherited-event-tag", "override-inherited-suffix", "start-date", "subaccount-id", "time", "trafficker-emails", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Campaign = json::value::from_value(object).unwrap();
        let mut call = self.hub.campaigns().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _campaigns_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.click-through-url" => Some(("adBlockingConfiguration.clickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.creative-bundle-id" => Some(("adBlockingConfiguration.creativeBundleId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.enabled" => Some(("adBlockingConfiguration.enabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ad-blocking-configuration.override-click-through-url" => Some(("adBlockingConfiguration.overrideClickThroughUrl", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-group-id" => Some(("advertiserGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "billing-invoice-code" => Some(("billingInvoiceCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.click-through-url-suffix" => Some(("clickThroughUrlSuffixProperties.clickThroughUrlSuffix", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "click-through-url-suffix-properties.override-inherited-suffix" => Some(("clickThroughUrlSuffixProperties.overrideInheritedSuffix", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-group-ids" => Some(("creativeGroupIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "creative-optimization-configuration.id" => Some(("creativeOptimizationConfiguration.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-optimization-configuration.name" => Some(("creativeOptimizationConfiguration.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "creative-optimization-configuration.optimization-model" => Some(("creativeOptimizationConfiguration.optimizationModel", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.default-click-through-event-tag-id" => Some(("defaultClickThroughEventTagProperties.defaultClickThroughEventTagId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "default-click-through-event-tag-properties.override-inherited-event-tag" => Some(("defaultClickThroughEventTagProperties.overrideInheritedEventTag", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "default-landing-page-id" => Some(("defaultLandingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "end-date" => Some(("endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "nielsen-ocr-enabled" => Some(("nielsenOcrEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "start-date" => Some(("startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "trafficker-emails" => Some(("traffickerEmails", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "ad-blocking-configuration", "advertiser-group-id", "advertiser-id", "advertiser-id-dimension-value", "archived", "billing-invoice-code", "click-through-url", "click-through-url-suffix", "click-through-url-suffix-properties", "comment", "create-info", "creative-bundle-id", "creative-group-ids", "creative-optimization-configuration", "default-click-through-event-tag-id", "default-click-through-event-tag-properties", "default-landing-page-id", "dimension-name", "enabled", "end-date", "etag", "external-id", "id", "id-dimension-value", "kind", "last-modified-info", "match-type", "name", "nielsen-ocr-enabled", "optimization-model", "override-click-through-url", "override-inherited-event-tag", "override-inherited-suffix", "start-date", "subaccount-id", "time", "trafficker-emails", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Campaign = json::value::from_value(object).unwrap();
        let mut call = self.hub.campaigns().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _change_logs_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.change_logs().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _change_logs_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.change_logs().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "user-profile-ids" => {
                    call = call.add_user_profile_ids(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "object-type" => {
                    call = call.object_type(value.unwrap_or(""));
                },
                "object-ids" => {
                    call = call.add_object_ids(value.unwrap_or(""));
                },
                "min-change-time" => {
                    call = call.min_change_time(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "max-change-time" => {
                    call = call.max_change_time(value.unwrap_or(""));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "action" => {
                    call = call.action(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["action", "ids", "max-change-time", "max-results", "min-change-time", "object-ids", "object-type", "page-token", "search-string", "user-profile-ids"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _cities_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.cities().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "region-dart-ids" => {
                    call = call.add_region_dart_ids(value.unwrap_or(""));
                },
                "name-prefix" => {
                    call = call.name_prefix(value.unwrap_or(""));
                },
                "dart-ids" => {
                    call = call.add_dart_ids(value.unwrap_or(""));
                },
                "country-dart-ids" => {
                    call = call.add_country_dart_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["country-dart-ids", "dart-ids", "name-prefix", "region-dart-ids"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _connection_types_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.connection_types().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _connection_types_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.connection_types().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _content_categories_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.content_categories().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _content_categories_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.content_categories().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _content_categories_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::ContentCategory = json::value::from_value(object).unwrap();
        let mut call = self.hub.content_categories().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _content_categories_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.content_categories().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _content_categories_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::ContentCategory = json::value::from_value(object).unwrap();
        let mut call = self.hub.content_categories().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _content_categories_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::ContentCategory = json::value::from_value(object).unwrap();
        let mut call = self.hub.content_categories().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _conversions_batchinsert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "encryption-info.encryption-entity-id" => Some(("encryptionInfo.encryptionEntityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "encryption-info.encryption-entity-type" => Some(("encryptionInfo.encryptionEntityType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "encryption-info.encryption-source" => Some(("encryptionInfo.encryptionSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "encryption-info.kind" => Some(("encryptionInfo.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["encryption-entity-id", "encryption-entity-type", "encryption-info", "encryption-source", "kind"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::ConversionsBatchInsertRequest = json::value::from_value(object).unwrap();
        let mut call = self.hub.conversions().batchinsert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _conversions_batchupdate(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "encryption-info.encryption-entity-id" => Some(("encryptionInfo.encryptionEntityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "encryption-info.encryption-entity-type" => Some(("encryptionInfo.encryptionEntityType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "encryption-info.encryption-source" => Some(("encryptionInfo.encryptionSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "encryption-info.kind" => Some(("encryptionInfo.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["encryption-entity-id", "encryption-entity-type", "encryption-info", "encryption-source", "kind"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::ConversionsBatchUpdateRequest = json::value::from_value(object).unwrap();
        let mut call = self.hub.conversions().batchupdate(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _countries_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.countries().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("dart-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _countries_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.countries().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_assets_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "asset-identifier.name" => Some(("assetIdentifier.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "asset-identifier.type" => Some(("assetIdentifier.type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "detected-features" => Some(("detectedFeatures", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rich-media" => Some(("richMedia", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "warned-validation-rules" => Some(("warnedValidationRules", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["asset-identifier", "detected-features", "dimension-name", "etag", "id", "id-dimension-value", "kind", "match-type", "name", "rich-media", "type", "value", "warned-validation-rules"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeAssetMetadata = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_assets().insert(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("advertiser-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let vals = opt.values_of("mode").unwrap().collect::<Vec<&str>>();
        let protocol = calltype_from_str(vals[0], ["simple"].iter().map(|&v| v.to_string()).collect(), err);
        let mut input_file = input_file_from_opts(vals[1], err);
        let mime_type = input_mime_from_opts(opt.value_of("mime").unwrap_or("application/octet-stream"), err);
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Upload(UploadProtocol::Simple) => call.upload(input_file.unwrap(), mime_type.unwrap()).await,
                CallType::Standard => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_field_values_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_field_values().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("creative-field-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _creative_field_values_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_field_values().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("creative-field-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_field_values_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "value" => Some(("value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["id", "kind", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeFieldValue = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_field_values().insert(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("creative-field-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_field_values_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_field_values().list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("creative-field-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_field_values_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "value" => Some(("value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["id", "kind", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeFieldValue = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_field_values().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("creative-field-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_field_values_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "value" => Some(("value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["id", "kind", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeFieldValue = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_field_values().update(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("creative-field-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_fields_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_fields().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _creative_fields_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_fields().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_fields_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "id", "kind", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeField = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_fields().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_fields_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_fields().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-ids", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_fields_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "id", "kind", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeField = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_fields().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_fields_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "id", "kind", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeField = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_fields().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_groups_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_groups().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_groups_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "group-number" => Some(("groupNumber", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "group-number", "id", "kind", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_groups().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_groups_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creative_groups().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "group-number" => {
                    call = call.group_number(arg_from_str(value.unwrap_or("-0"), err, "group-number", "integer"));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-ids", "group-number", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_groups_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "group-number" => Some(("groupNumber", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "group-number", "id", "kind", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_groups().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creative_groups_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "group-number" => Some(("groupNumber", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "group-number", "id", "kind", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CreativeGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.creative_groups().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creatives_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creatives().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creatives_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ad-parameters" => Some(("adParameters", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-tag-keys" => Some(("adTagKeys", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "allow-script-access" => Some(("allowScriptAccess", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "artwork-type" => Some(("artworkType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "authoring-source" => Some(("authoringSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "authoring-tool" => Some(("authoringTool", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "auto-advance-images" => Some(("autoAdvanceImages", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "background-color" => Some(("backgroundColor", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.computed-click-through-url" => Some(("backupImageClickThroughUrl.computedClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.custom-click-through-url" => Some(("backupImageClickThroughUrl.customClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.landing-page-id" => Some(("backupImageClickThroughUrl.landingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-features" => Some(("backupImageFeatures", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "backup-image-reporting-label" => Some(("backupImageReportingLabel", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-target-window.custom-html" => Some(("backupImageTargetWindow.customHtml", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-target-window.target-window-option" => Some(("backupImageTargetWindow.targetWindowOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "commercial-id" => Some(("commercialId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "companion-creatives" => Some(("companionCreatives", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "convert-flash-to-html5" => Some(("convertFlashToHtml5", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "creative-asset-selection.default-asset-id" => Some(("creativeAssetSelection.defaultAssetId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "custom-key-values" => Some(("customKeyValues", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "dynamic-asset-selection" => Some(("dynamicAssetSelection", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "fs-command.left" => Some(("fsCommand.left", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.position-option" => Some(("fsCommand.positionOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "fs-command.top" => Some(("fsCommand.top", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.window-height" => Some(("fsCommand.windowHeight", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.window-width" => Some(("fsCommand.windowWidth", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "html-code" => Some(("htmlCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "html-code-locked" => Some(("htmlCodeLocked", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "latest-trafficked-creative-id" => Some(("latestTraffickedCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "media-description" => Some(("mediaDescription", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "media-duration" => Some(("mediaDuration", JsonTypeInfo { jtype: JsonType::Float, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-click-through-url" => Some(("obaIcon.iconClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-click-tracking-url" => Some(("obaIcon.iconClickTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-view-tracking-url" => Some(("obaIcon.iconViewTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.program" => Some(("obaIcon.program", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.resource-url" => Some(("obaIcon.resourceUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.height" => Some(("obaIcon.size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "oba-icon.size.iab" => Some(("obaIcon.size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "oba-icon.size.id" => Some(("obaIcon.size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.kind" => Some(("obaIcon.size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.width" => Some(("obaIcon.size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "oba-icon.x-position" => Some(("obaIcon.xPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.y-position" => Some(("obaIcon.yPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "override-css" => Some(("overrideCss", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "progress-offset.offset-percentage" => Some(("progressOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "progress-offset.offset-seconds" => Some(("progressOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "redirect-url" => Some(("redirectUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id" => Some(("renderingId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.dimension-name" => Some(("renderingIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.etag" => Some(("renderingIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.id" => Some(("renderingIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.kind" => Some(("renderingIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.match-type" => Some(("renderingIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.value" => Some(("renderingIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "required-flash-plugin-version" => Some(("requiredFlashPluginVersion", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "required-flash-version" => Some(("requiredFlashVersion", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skip-offset.offset-percentage" => Some(("skipOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skip-offset.offset-seconds" => Some(("skipOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skippable" => Some(("skippable", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-override" => Some(("sslOverride", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "studio-advertiser-id" => Some(("studioAdvertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "studio-creative-id" => Some(("studioCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "studio-trafficked-creative-id" => Some(("studioTraffickedCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "third-party-backup-image-impressions-url" => Some(("thirdPartyBackupImageImpressionsUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "third-party-rich-media-impressions-url" => Some(("thirdPartyRichMediaImpressionsUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "total-file-size" => Some(("totalFileSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "universal-ad-id.registry" => Some(("universalAdId.registry", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "universal-ad-id.value" => Some(("universalAdId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "version" => Some(("version", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "ad-parameters", "ad-tag-keys", "advertiser-id", "allow-script-access", "archived", "artwork-type", "authoring-source", "authoring-tool", "auto-advance-images", "background-color", "backup-image-click-through-url", "backup-image-features", "backup-image-reporting-label", "backup-image-target-window", "commercial-id", "companion-creatives", "compatibility", "computed-click-through-url", "convert-flash-to-html5", "creative-asset-selection", "custom-click-through-url", "custom-html", "custom-key-values", "default-asset-id", "dimension-name", "dynamic-asset-selection", "etag", "fs-command", "height", "html-code", "html-code-locked", "iab", "icon-click-through-url", "icon-click-tracking-url", "icon-view-tracking-url", "id", "id-dimension-value", "kind", "landing-page-id", "last-modified-info", "latest-trafficked-creative-id", "left", "match-type", "media-description", "media-duration", "name", "oba-icon", "offset-percentage", "offset-seconds", "override-css", "position-option", "program", "progress-offset", "redirect-url", "registry", "rendering-id", "rendering-id-dimension-value", "required-flash-plugin-version", "required-flash-version", "resource-url", "size", "skip-offset", "skippable", "ssl-compliant", "ssl-override", "studio-advertiser-id", "studio-creative-id", "studio-trafficked-creative-id", "subaccount-id", "target-window-option", "third-party-backup-image-impressions-url", "third-party-rich-media-impressions-url", "time", "top", "total-file-size", "type", "universal-ad-id", "value", "version", "width", "window-height", "window-width", "x-position", "y-position"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Creative = json::value::from_value(object).unwrap();
        let mut call = self.hub.creatives().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creatives_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.creatives().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "types" => {
                    call = call.add_types(value.unwrap_or(""));
                },
                "studio-creative-id" => {
                    call = call.studio_creative_id(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "size-ids" => {
                    call = call.add_size_ids(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "rendering-ids" => {
                    call = call.add_rendering_ids(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "creative-field-ids" => {
                    call = call.add_creative_field_ids(value.unwrap_or(""));
                },
                "companion-creative-ids" => {
                    call = call.add_companion_creative_ids(value.unwrap_or(""));
                },
                "campaign-id" => {
                    call = call.campaign_id(value.unwrap_or(""));
                },
                "archived" => {
                    call = call.archived(arg_from_str(value.unwrap_or("false"), err, "archived", "boolean"));
                },
                "advertiser-id" => {
                    call = call.advertiser_id(value.unwrap_or(""));
                },
                "active" => {
                    call = call.active(arg_from_str(value.unwrap_or("false"), err, "active", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["active", "advertiser-id", "archived", "campaign-id", "companion-creative-ids", "creative-field-ids", "ids", "max-results", "page-token", "rendering-ids", "search-string", "size-ids", "sort-field", "sort-order", "studio-creative-id", "types"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creatives_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ad-parameters" => Some(("adParameters", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-tag-keys" => Some(("adTagKeys", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "allow-script-access" => Some(("allowScriptAccess", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "artwork-type" => Some(("artworkType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "authoring-source" => Some(("authoringSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "authoring-tool" => Some(("authoringTool", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "auto-advance-images" => Some(("autoAdvanceImages", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "background-color" => Some(("backgroundColor", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.computed-click-through-url" => Some(("backupImageClickThroughUrl.computedClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.custom-click-through-url" => Some(("backupImageClickThroughUrl.customClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.landing-page-id" => Some(("backupImageClickThroughUrl.landingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-features" => Some(("backupImageFeatures", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "backup-image-reporting-label" => Some(("backupImageReportingLabel", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-target-window.custom-html" => Some(("backupImageTargetWindow.customHtml", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-target-window.target-window-option" => Some(("backupImageTargetWindow.targetWindowOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "commercial-id" => Some(("commercialId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "companion-creatives" => Some(("companionCreatives", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "convert-flash-to-html5" => Some(("convertFlashToHtml5", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "creative-asset-selection.default-asset-id" => Some(("creativeAssetSelection.defaultAssetId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "custom-key-values" => Some(("customKeyValues", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "dynamic-asset-selection" => Some(("dynamicAssetSelection", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "fs-command.left" => Some(("fsCommand.left", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.position-option" => Some(("fsCommand.positionOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "fs-command.top" => Some(("fsCommand.top", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.window-height" => Some(("fsCommand.windowHeight", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.window-width" => Some(("fsCommand.windowWidth", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "html-code" => Some(("htmlCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "html-code-locked" => Some(("htmlCodeLocked", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "latest-trafficked-creative-id" => Some(("latestTraffickedCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "media-description" => Some(("mediaDescription", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "media-duration" => Some(("mediaDuration", JsonTypeInfo { jtype: JsonType::Float, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-click-through-url" => Some(("obaIcon.iconClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-click-tracking-url" => Some(("obaIcon.iconClickTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-view-tracking-url" => Some(("obaIcon.iconViewTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.program" => Some(("obaIcon.program", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.resource-url" => Some(("obaIcon.resourceUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.height" => Some(("obaIcon.size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "oba-icon.size.iab" => Some(("obaIcon.size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "oba-icon.size.id" => Some(("obaIcon.size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.kind" => Some(("obaIcon.size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.width" => Some(("obaIcon.size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "oba-icon.x-position" => Some(("obaIcon.xPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.y-position" => Some(("obaIcon.yPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "override-css" => Some(("overrideCss", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "progress-offset.offset-percentage" => Some(("progressOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "progress-offset.offset-seconds" => Some(("progressOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "redirect-url" => Some(("redirectUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id" => Some(("renderingId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.dimension-name" => Some(("renderingIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.etag" => Some(("renderingIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.id" => Some(("renderingIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.kind" => Some(("renderingIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.match-type" => Some(("renderingIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.value" => Some(("renderingIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "required-flash-plugin-version" => Some(("requiredFlashPluginVersion", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "required-flash-version" => Some(("requiredFlashVersion", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skip-offset.offset-percentage" => Some(("skipOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skip-offset.offset-seconds" => Some(("skipOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skippable" => Some(("skippable", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-override" => Some(("sslOverride", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "studio-advertiser-id" => Some(("studioAdvertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "studio-creative-id" => Some(("studioCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "studio-trafficked-creative-id" => Some(("studioTraffickedCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "third-party-backup-image-impressions-url" => Some(("thirdPartyBackupImageImpressionsUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "third-party-rich-media-impressions-url" => Some(("thirdPartyRichMediaImpressionsUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "total-file-size" => Some(("totalFileSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "universal-ad-id.registry" => Some(("universalAdId.registry", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "universal-ad-id.value" => Some(("universalAdId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "version" => Some(("version", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "ad-parameters", "ad-tag-keys", "advertiser-id", "allow-script-access", "archived", "artwork-type", "authoring-source", "authoring-tool", "auto-advance-images", "background-color", "backup-image-click-through-url", "backup-image-features", "backup-image-reporting-label", "backup-image-target-window", "commercial-id", "companion-creatives", "compatibility", "computed-click-through-url", "convert-flash-to-html5", "creative-asset-selection", "custom-click-through-url", "custom-html", "custom-key-values", "default-asset-id", "dimension-name", "dynamic-asset-selection", "etag", "fs-command", "height", "html-code", "html-code-locked", "iab", "icon-click-through-url", "icon-click-tracking-url", "icon-view-tracking-url", "id", "id-dimension-value", "kind", "landing-page-id", "last-modified-info", "latest-trafficked-creative-id", "left", "match-type", "media-description", "media-duration", "name", "oba-icon", "offset-percentage", "offset-seconds", "override-css", "position-option", "program", "progress-offset", "redirect-url", "registry", "rendering-id", "rendering-id-dimension-value", "required-flash-plugin-version", "required-flash-version", "resource-url", "size", "skip-offset", "skippable", "ssl-compliant", "ssl-override", "studio-advertiser-id", "studio-creative-id", "studio-trafficked-creative-id", "subaccount-id", "target-window-option", "third-party-backup-image-impressions-url", "third-party-rich-media-impressions-url", "time", "top", "total-file-size", "type", "universal-ad-id", "value", "version", "width", "window-height", "window-width", "x-position", "y-position"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Creative = json::value::from_value(object).unwrap();
        let mut call = self.hub.creatives().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _creatives_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ad-parameters" => Some(("adParameters", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-tag-keys" => Some(("adTagKeys", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "allow-script-access" => Some(("allowScriptAccess", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "artwork-type" => Some(("artworkType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "authoring-source" => Some(("authoringSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "authoring-tool" => Some(("authoringTool", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "auto-advance-images" => Some(("autoAdvanceImages", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "background-color" => Some(("backgroundColor", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.computed-click-through-url" => Some(("backupImageClickThroughUrl.computedClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.custom-click-through-url" => Some(("backupImageClickThroughUrl.customClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-click-through-url.landing-page-id" => Some(("backupImageClickThroughUrl.landingPageId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-features" => Some(("backupImageFeatures", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "backup-image-reporting-label" => Some(("backupImageReportingLabel", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-target-window.custom-html" => Some(("backupImageTargetWindow.customHtml", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "backup-image-target-window.target-window-option" => Some(("backupImageTargetWindow.targetWindowOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "commercial-id" => Some(("commercialId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "companion-creatives" => Some(("companionCreatives", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "convert-flash-to-html5" => Some(("convertFlashToHtml5", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "creative-asset-selection.default-asset-id" => Some(("creativeAssetSelection.defaultAssetId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "custom-key-values" => Some(("customKeyValues", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "dynamic-asset-selection" => Some(("dynamicAssetSelection", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "fs-command.left" => Some(("fsCommand.left", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.position-option" => Some(("fsCommand.positionOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "fs-command.top" => Some(("fsCommand.top", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.window-height" => Some(("fsCommand.windowHeight", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "fs-command.window-width" => Some(("fsCommand.windowWidth", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "html-code" => Some(("htmlCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "html-code-locked" => Some(("htmlCodeLocked", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "latest-trafficked-creative-id" => Some(("latestTraffickedCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "media-description" => Some(("mediaDescription", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "media-duration" => Some(("mediaDuration", JsonTypeInfo { jtype: JsonType::Float, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-click-through-url" => Some(("obaIcon.iconClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-click-tracking-url" => Some(("obaIcon.iconClickTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.icon-view-tracking-url" => Some(("obaIcon.iconViewTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.program" => Some(("obaIcon.program", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.resource-url" => Some(("obaIcon.resourceUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.height" => Some(("obaIcon.size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "oba-icon.size.iab" => Some(("obaIcon.size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "oba-icon.size.id" => Some(("obaIcon.size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.kind" => Some(("obaIcon.size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.size.width" => Some(("obaIcon.size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "oba-icon.x-position" => Some(("obaIcon.xPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "oba-icon.y-position" => Some(("obaIcon.yPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "override-css" => Some(("overrideCss", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "progress-offset.offset-percentage" => Some(("progressOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "progress-offset.offset-seconds" => Some(("progressOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "redirect-url" => Some(("redirectUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id" => Some(("renderingId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.dimension-name" => Some(("renderingIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.etag" => Some(("renderingIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.id" => Some(("renderingIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.kind" => Some(("renderingIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.match-type" => Some(("renderingIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "rendering-id-dimension-value.value" => Some(("renderingIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "required-flash-plugin-version" => Some(("requiredFlashPluginVersion", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "required-flash-version" => Some(("requiredFlashVersion", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skip-offset.offset-percentage" => Some(("skipOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skip-offset.offset-seconds" => Some(("skipOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "skippable" => Some(("skippable", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-override" => Some(("sslOverride", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "studio-advertiser-id" => Some(("studioAdvertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "studio-creative-id" => Some(("studioCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "studio-trafficked-creative-id" => Some(("studioTraffickedCreativeId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "third-party-backup-image-impressions-url" => Some(("thirdPartyBackupImageImpressionsUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "third-party-rich-media-impressions-url" => Some(("thirdPartyRichMediaImpressionsUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "total-file-size" => Some(("totalFileSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "universal-ad-id.registry" => Some(("universalAdId.registry", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "universal-ad-id.value" => Some(("universalAdId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "version" => Some(("version", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "ad-parameters", "ad-tag-keys", "advertiser-id", "allow-script-access", "archived", "artwork-type", "authoring-source", "authoring-tool", "auto-advance-images", "background-color", "backup-image-click-through-url", "backup-image-features", "backup-image-reporting-label", "backup-image-target-window", "commercial-id", "companion-creatives", "compatibility", "computed-click-through-url", "convert-flash-to-html5", "creative-asset-selection", "custom-click-through-url", "custom-html", "custom-key-values", "default-asset-id", "dimension-name", "dynamic-asset-selection", "etag", "fs-command", "height", "html-code", "html-code-locked", "iab", "icon-click-through-url", "icon-click-tracking-url", "icon-view-tracking-url", "id", "id-dimension-value", "kind", "landing-page-id", "last-modified-info", "latest-trafficked-creative-id", "left", "match-type", "media-description", "media-duration", "name", "oba-icon", "offset-percentage", "offset-seconds", "override-css", "position-option", "program", "progress-offset", "redirect-url", "registry", "rendering-id", "rendering-id-dimension-value", "required-flash-plugin-version", "required-flash-version", "resource-url", "size", "skip-offset", "skippable", "ssl-compliant", "ssl-override", "studio-advertiser-id", "studio-creative-id", "studio-trafficked-creative-id", "subaccount-id", "target-window-option", "third-party-backup-image-impressions-url", "third-party-rich-media-impressions-url", "time", "top", "total-file-size", "type", "universal-ad-id", "value", "version", "width", "window-height", "window-width", "x-position", "y-position"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Creative = json::value::from_value(object).unwrap();
        let mut call = self.hub.creatives().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _custom_events_batchinsert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["kind"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::CustomEventsBatchInsertRequest = json::value::from_value(object).unwrap();
        let mut call = self.hub.custom_events().batchinsert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _dimension_values_query(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "dimension-name" => Some(("dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "end-date" => Some(("endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "start-date" => Some(("startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["dimension-name", "end-date", "kind", "start-date"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::DimensionValueRequest = json::value::from_value(object).unwrap();
        let mut call = self.hub.dimension_values().query(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["max-results", "page-token"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _directory_sites_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.directory_sites().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _directory_sites_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "inpage-tag-formats" => Some(("inpageTagFormats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "interstitial-tag-formats" => Some(("interstitialTagFormats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "settings.active-view-opt-out" => Some(("settings.activeViewOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "settings.dfp-settings.dfp-network-code" => Some(("settings.dfpSettings.dfpNetworkCode", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "settings.dfp-settings.dfp-network-name" => Some(("settings.dfpSettings.dfpNetworkName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "settings.dfp-settings.programmatic-placement-accepted" => Some(("settings.dfpSettings.programmaticPlacementAccepted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "settings.dfp-settings.pub-paid-placement-accepted" => Some(("settings.dfpSettings.pubPaidPlacementAccepted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "settings.dfp-settings.publisher-portal-only" => Some(("settings.dfpSettings.publisherPortalOnly", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "settings.instream-video-placement-accepted" => Some(("settings.instreamVideoPlacementAccepted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "settings.interstitial-placement-accepted" => Some(("settings.interstitialPlacementAccepted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["active-view-opt-out", "dfp-network-code", "dfp-network-name", "dfp-settings", "dimension-name", "etag", "id", "id-dimension-value", "inpage-tag-formats", "instream-video-placement-accepted", "interstitial-placement-accepted", "interstitial-tag-formats", "kind", "match-type", "name", "programmatic-placement-accepted", "pub-paid-placement-accepted", "publisher-portal-only", "settings", "url", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::DirectorySite = json::value::from_value(object).unwrap();
        let mut call = self.hub.directory_sites().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _directory_sites_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.directory_sites().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "dfp-network-code" => {
                    call = call.dfp_network_code(value.unwrap_or(""));
                },
                "active" => {
                    call = call.active(arg_from_str(value.unwrap_or("false"), err, "active", "boolean"));
                },
                "accepts-publisher-paid-placements" => {
                    call = call.accepts_publisher_paid_placements(arg_from_str(value.unwrap_or("false"), err, "accepts-publisher-paid-placements", "boolean"));
                },
                "accepts-interstitial-placements" => {
                    call = call.accepts_interstitial_placements(arg_from_str(value.unwrap_or("false"), err, "accepts-interstitial-placements", "boolean"));
                },
                "accepts-in-stream-video-placements" => {
                    call = call.accepts_in_stream_video_placements(arg_from_str(value.unwrap_or("false"), err, "accepts-in-stream-video-placements", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["accepts-in-stream-video-placements", "accepts-interstitial-placements", "accepts-publisher-paid-placements", "active", "dfp-network-code", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _dynamic_targeting_keys_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.dynamic_targeting_keys().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("object-id").unwrap_or(""), opt.value_of("name").unwrap_or(""), opt.value_of("object-type").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _dynamic_targeting_keys_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "object-id" => Some(("objectId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "object-type" => Some(("objectType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["kind", "name", "object-id", "object-type"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::DynamicTargetingKey = json::value::from_value(object).unwrap();
        let mut call = self.hub.dynamic_targeting_keys().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _dynamic_targeting_keys_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.dynamic_targeting_keys().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "object-type" => {
                    call = call.object_type(value.unwrap_or(""));
                },
                "object-id" => {
                    call = call.object_id(value.unwrap_or(""));
                },
                "names" => {
                    call = call.add_names(value.unwrap_or(""));
                },
                "advertiser-id" => {
                    call = call.advertiser_id(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-id", "names", "object-id", "object-type"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _event_tags_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.event_tags().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _event_tags_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.event_tags().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _event_tags_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "enabled-by-default" => Some(("enabledByDefault", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "exclude-from-adx-requests" => Some(("excludeFromAdxRequests", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter-type" => Some(("siteFilterType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-ids" => Some(("siteIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url-escape-levels" => Some(("urlEscapeLevels", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "campaign-id", "campaign-id-dimension-value", "dimension-name", "enabled-by-default", "etag", "exclude-from-adx-requests", "id", "kind", "match-type", "name", "site-filter-type", "site-ids", "ssl-compliant", "status", "subaccount-id", "type", "url", "url-escape-levels", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::EventTag = json::value::from_value(object).unwrap();
        let mut call = self.hub.event_tags().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _event_tags_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.event_tags().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "event-tag-types" => {
                    call = call.add_event_tag_types(value.unwrap_or(""));
                },
                "enabled" => {
                    call = call.enabled(arg_from_str(value.unwrap_or("false"), err, "enabled", "boolean"));
                },
                "definitions-only" => {
                    call = call.definitions_only(arg_from_str(value.unwrap_or("false"), err, "definitions-only", "boolean"));
                },
                "campaign-id" => {
                    call = call.campaign_id(value.unwrap_or(""));
                },
                "advertiser-id" => {
                    call = call.advertiser_id(value.unwrap_or(""));
                },
                "ad-id" => {
                    call = call.ad_id(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ad-id", "advertiser-id", "campaign-id", "definitions-only", "enabled", "event-tag-types", "ids", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _event_tags_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "enabled-by-default" => Some(("enabledByDefault", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "exclude-from-adx-requests" => Some(("excludeFromAdxRequests", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter-type" => Some(("siteFilterType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-ids" => Some(("siteIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url-escape-levels" => Some(("urlEscapeLevels", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "campaign-id", "campaign-id-dimension-value", "dimension-name", "enabled-by-default", "etag", "exclude-from-adx-requests", "id", "kind", "match-type", "name", "site-filter-type", "site-ids", "ssl-compliant", "status", "subaccount-id", "type", "url", "url-escape-levels", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::EventTag = json::value::from_value(object).unwrap();
        let mut call = self.hub.event_tags().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _event_tags_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "enabled-by-default" => Some(("enabledByDefault", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "exclude-from-adx-requests" => Some(("excludeFromAdxRequests", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-filter-type" => Some(("siteFilterType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-ids" => Some(("siteIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url" => Some(("url", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "url-escape-levels" => Some(("urlEscapeLevels", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "campaign-id", "campaign-id-dimension-value", "dimension-name", "enabled-by-default", "etag", "exclude-from-adx-requests", "id", "kind", "match-type", "name", "site-filter-type", "site-ids", "ssl-compliant", "status", "subaccount-id", "type", "url", "url-escape-levels", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::EventTag = json::value::from_value(object).unwrap();
        let mut call = self.hub.event_tags().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _files_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut download_mode = false;
        let mut call = self.hub.files().get(opt.value_of("report-id").unwrap_or(""), opt.value_of("file-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            if key == "alt" && value.unwrap_or("unset") == "media" {
                                download_mode = true;
                            }
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    if !download_mode {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    } else {
                    let bytes = hyper::body::to_bytes(response.into_body()).await.expect("a string as API currently is inefficient").to_vec();
                    ostream.write_all(&bytes).expect("write to be complete");
                    ostream.flush().expect("io to never fail which should really be fixed one day");
                    }
                    Ok(())
                }
            }
        }
    }

    async fn _files_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.files().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "scope" => {
                    call = call.scope(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["max-results", "page-token", "scope", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_activities().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_generatetag(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_activities().generatetag(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "floodlight-activity-id" => {
                    call = call.floodlight_activity_id(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["floodlight-activity-id"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_activities().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "attribution-enabled" => Some(("attributionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "cache-busting-type" => Some(("cacheBustingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "counting-method" => Some(("countingMethod", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "expected-url" => Some(("expectedUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-id" => Some(("floodlightActivityGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-name" => Some(("floodlightActivityGroupName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-tag-string" => Some(("floodlightActivityGroupTagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-type" => Some(("floodlightActivityGroupType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-tag-type" => Some(("floodlightTagType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "notes" => Some(("notes", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "secure" => Some(("secure", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-format" => Some(("tagFormat", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-string" => Some(("tagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-defined-variable-types" => Some(("userDefinedVariableTypes", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "attribution-enabled", "cache-busting-type", "counting-method", "dimension-name", "etag", "expected-url", "floodlight-activity-group-id", "floodlight-activity-group-name", "floodlight-activity-group-tag-string", "floodlight-activity-group-type", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "floodlight-tag-type", "id", "id-dimension-value", "kind", "match-type", "name", "notes", "secure", "ssl-compliant", "ssl-required", "status", "subaccount-id", "tag-format", "tag-string", "user-defined-variable-types", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightActivity = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_activities().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_activities().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "tag-string" => {
                    call = call.tag_string(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "floodlight-configuration-id" => {
                    call = call.floodlight_configuration_id(value.unwrap_or(""));
                },
                "floodlight-activity-group-type" => {
                    call = call.floodlight_activity_group_type(value.unwrap_or(""));
                },
                "floodlight-activity-group-tag-string" => {
                    call = call.floodlight_activity_group_tag_string(value.unwrap_or(""));
                },
                "floodlight-activity-group-name" => {
                    call = call.floodlight_activity_group_name(value.unwrap_or(""));
                },
                "floodlight-activity-group-ids" => {
                    call = call.add_floodlight_activity_group_ids(value.unwrap_or(""));
                },
                "advertiser-id" => {
                    call = call.advertiser_id(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-id", "floodlight-activity-group-ids", "floodlight-activity-group-name", "floodlight-activity-group-tag-string", "floodlight-activity-group-type", "floodlight-configuration-id", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order", "tag-string"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "attribution-enabled" => Some(("attributionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "cache-busting-type" => Some(("cacheBustingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "counting-method" => Some(("countingMethod", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "expected-url" => Some(("expectedUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-id" => Some(("floodlightActivityGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-name" => Some(("floodlightActivityGroupName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-tag-string" => Some(("floodlightActivityGroupTagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-type" => Some(("floodlightActivityGroupType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-tag-type" => Some(("floodlightTagType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "notes" => Some(("notes", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "secure" => Some(("secure", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-format" => Some(("tagFormat", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-string" => Some(("tagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-defined-variable-types" => Some(("userDefinedVariableTypes", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "attribution-enabled", "cache-busting-type", "counting-method", "dimension-name", "etag", "expected-url", "floodlight-activity-group-id", "floodlight-activity-group-name", "floodlight-activity-group-tag-string", "floodlight-activity-group-type", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "floodlight-tag-type", "id", "id-dimension-value", "kind", "match-type", "name", "notes", "secure", "ssl-compliant", "ssl-required", "status", "subaccount-id", "tag-format", "tag-string", "user-defined-variable-types", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightActivity = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_activities().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activities_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "attribution-enabled" => Some(("attributionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "cache-busting-type" => Some(("cacheBustingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "counting-method" => Some(("countingMethod", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "expected-url" => Some(("expectedUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-id" => Some(("floodlightActivityGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-name" => Some(("floodlightActivityGroupName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-tag-string" => Some(("floodlightActivityGroupTagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-activity-group-type" => Some(("floodlightActivityGroupType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-tag-type" => Some(("floodlightTagType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "notes" => Some(("notes", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "secure" => Some(("secure", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-compliant" => Some(("sslCompliant", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-format" => Some(("tagFormat", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-string" => Some(("tagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "user-defined-variable-types" => Some(("userDefinedVariableTypes", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "attribution-enabled", "cache-busting-type", "counting-method", "dimension-name", "etag", "expected-url", "floodlight-activity-group-id", "floodlight-activity-group-name", "floodlight-activity-group-tag-string", "floodlight-activity-group-type", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "floodlight-tag-type", "id", "id-dimension-value", "kind", "match-type", "name", "notes", "secure", "ssl-compliant", "ssl-required", "status", "subaccount-id", "tag-format", "tag-string", "user-defined-variable-types", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightActivity = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_activities().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activity_groups_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_activity_groups().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activity_groups_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-string" => Some(("tagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "id", "id-dimension-value", "kind", "match-type", "name", "subaccount-id", "tag-string", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightActivityGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_activity_groups().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activity_groups_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_activity_groups().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "type" => {
                    call = call.type_(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "floodlight-configuration-id" => {
                    call = call.floodlight_configuration_id(value.unwrap_or(""));
                },
                "advertiser-id" => {
                    call = call.advertiser_id(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-id", "floodlight-configuration-id", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order", "type"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activity_groups_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-string" => Some(("tagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "id", "id-dimension-value", "kind", "match-type", "name", "subaccount-id", "tag-string", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightActivityGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_activity_groups().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_activity_groups_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id" => Some(("floodlightConfigurationId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.dimension-name" => Some(("floodlightConfigurationIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.etag" => Some(("floodlightConfigurationIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.id" => Some(("floodlightConfigurationIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.kind" => Some(("floodlightConfigurationIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.match-type" => Some(("floodlightConfigurationIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-configuration-id-dimension-value.value" => Some(("floodlightConfigurationIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-string" => Some(("tagString", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "dimension-name", "etag", "floodlight-configuration-id", "floodlight-configuration-id-dimension-value", "id", "id-dimension-value", "kind", "match-type", "name", "subaccount-id", "tag-string", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightActivityGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_activity_groups().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_configurations_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_configurations().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_configurations_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.floodlight_configurations().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_configurations_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "analytics-data-sharing-enabled" => Some(("analyticsDataSharingEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.audible" => Some(("customViewabilityMetric.configuration.audible", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.time-millis" => Some(("customViewabilityMetric.configuration.timeMillis", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.time-percent" => Some(("customViewabilityMetric.configuration.timePercent", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.viewability-percent" => Some(("customViewabilityMetric.configuration.viewabilityPercent", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.id" => Some(("customViewabilityMetric.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.name" => Some(("customViewabilityMetric.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "exposure-to-conversion-enabled" => Some(("exposureToConversionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "first-day-of-week" => Some(("firstDayOfWeek", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "in-app-attribution-tracking-enabled" => Some(("inAppAttributionTrackingEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "lookback-configuration.click-duration" => Some(("lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "lookback-configuration.post-impression-activities-duration" => Some(("lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "natural-search-conversion-attribution-option" => Some(("naturalSearchConversionAttributionOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "omniture-settings.omniture-cost-data-enabled" => Some(("omnitureSettings.omnitureCostDataEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "omniture-settings.omniture-integration-enabled" => Some(("omnitureSettings.omnitureIntegrationEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-settings.dynamic-tag-enabled" => Some(("tagSettings.dynamicTagEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-settings.image-tag-enabled" => Some(("tagSettings.imageTagEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "analytics-data-sharing-enabled", "audible", "click-duration", "configuration", "custom-viewability-metric", "dimension-name", "dynamic-tag-enabled", "etag", "exposure-to-conversion-enabled", "first-day-of-week", "id", "id-dimension-value", "image-tag-enabled", "in-app-attribution-tracking-enabled", "kind", "lookback-configuration", "match-type", "name", "natural-search-conversion-attribution-option", "omniture-cost-data-enabled", "omniture-integration-enabled", "omniture-settings", "post-impression-activities-duration", "subaccount-id", "tag-settings", "time-millis", "time-percent", "value", "viewability-percent"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightConfiguration = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_configurations().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _floodlight_configurations_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "analytics-data-sharing-enabled" => Some(("analyticsDataSharingEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.audible" => Some(("customViewabilityMetric.configuration.audible", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.time-millis" => Some(("customViewabilityMetric.configuration.timeMillis", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.time-percent" => Some(("customViewabilityMetric.configuration.timePercent", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.configuration.viewability-percent" => Some(("customViewabilityMetric.configuration.viewabilityPercent", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.id" => Some(("customViewabilityMetric.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "custom-viewability-metric.name" => Some(("customViewabilityMetric.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "exposure-to-conversion-enabled" => Some(("exposureToConversionEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "first-day-of-week" => Some(("firstDayOfWeek", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "in-app-attribution-tracking-enabled" => Some(("inAppAttributionTrackingEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "lookback-configuration.click-duration" => Some(("lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "lookback-configuration.post-impression-activities-duration" => Some(("lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "natural-search-conversion-attribution-option" => Some(("naturalSearchConversionAttributionOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "omniture-settings.omniture-cost-data-enabled" => Some(("omnitureSettings.omnitureCostDataEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "omniture-settings.omniture-integration-enabled" => Some(("omnitureSettings.omnitureIntegrationEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-settings.dynamic-tag-enabled" => Some(("tagSettings.dynamicTagEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-settings.image-tag-enabled" => Some(("tagSettings.imageTagEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "analytics-data-sharing-enabled", "audible", "click-duration", "configuration", "custom-viewability-metric", "dimension-name", "dynamic-tag-enabled", "etag", "exposure-to-conversion-enabled", "first-day-of-week", "id", "id-dimension-value", "image-tag-enabled", "in-app-attribution-tracking-enabled", "kind", "lookback-configuration", "match-type", "name", "natural-search-conversion-attribution-option", "omniture-cost-data-enabled", "omniture-integration-enabled", "omniture-settings", "post-impression-activities-duration", "subaccount-id", "tag-settings", "time-millis", "time-percent", "value", "viewability-percent"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::FloodlightConfiguration = json::value::from_value(object).unwrap();
        let mut call = self.hub.floodlight_configurations().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _inventory_items_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.inventory_items().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("project-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _inventory_items_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.inventory_items().list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("project-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "type" => {
                    call = call.type_(value.unwrap_or(""));
                },
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "site-id" => {
                    call = call.add_site_id(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "order-id" => {
                    call = call.add_order_id(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "in-plan" => {
                    call = call.in_plan(arg_from_str(value.unwrap_or("false"), err, "in-plan", "boolean"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids", "in-plan", "max-results", "order-id", "page-token", "site-id", "sort-field", "sort-order", "type"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _languages_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.languages().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _metros_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.metros().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _mobile_apps_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.mobile_apps().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _mobile_apps_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.mobile_apps().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "directories" => {
                    call = call.add_directories(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["directories", "ids", "max-results", "page-token", "search-string"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _mobile_carriers_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.mobile_carriers().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _mobile_carriers_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.mobile_carriers().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _operating_system_versions_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.operating_system_versions().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _operating_system_versions_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.operating_system_versions().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _operating_systems_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.operating_systems().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("dart-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _operating_systems_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.operating_systems().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _order_documents_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.order_documents().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("project-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _order_documents_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.order_documents().list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("project-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "site-id" => {
                    call = call.add_site_id(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "order-id" => {
                    call = call.add_order_id(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "approved" => {
                    call = call.approved(arg_from_str(value.unwrap_or("false"), err, "approved", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["approved", "ids", "max-results", "order-id", "page-token", "search-string", "site-id", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _orders_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.orders().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("project-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _orders_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.orders().list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("project-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "site-id" => {
                    call = call.add_site_id(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids", "max-results", "page-token", "search-string", "site-id", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_groups_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placement_groups().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_groups_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "child-placement-ids" => Some(("childPlacementIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "content-category-id" => Some(("contentCategoryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id" => Some(("directorySiteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.dimension-name" => Some(("directorySiteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.etag" => Some(("directorySiteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.id" => Some(("directorySiteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.kind" => Some(("directorySiteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.match-type" => Some(("directorySiteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.value" => Some(("directorySiteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-type" => Some(("placementGroupType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-strategy-id" => Some(("placementStrategyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.cap-cost-option" => Some(("pricingSchedule.capCostOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.end-date" => Some(("pricingSchedule.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.flighted" => Some(("pricingSchedule.flighted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "pricing-schedule.floodlight-activity-id" => Some(("pricingSchedule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.pricing-type" => Some(("pricingSchedule.pricingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.start-date" => Some(("pricingSchedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.testing-start-date" => Some(("pricingSchedule.testingStartDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id" => Some(("primaryPlacementId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.dimension-name" => Some(("primaryPlacementIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.etag" => Some(("primaryPlacementIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.id" => Some(("primaryPlacementIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.kind" => Some(("primaryPlacementIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.match-type" => Some(("primaryPlacementIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.value" => Some(("primaryPlacementIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id" => Some(("siteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.dimension-name" => Some(("siteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.etag" => Some(("siteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.id" => Some(("siteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.kind" => Some(("siteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.match-type" => Some(("siteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.value" => Some(("siteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "archived", "campaign-id", "campaign-id-dimension-value", "cap-cost-option", "child-placement-ids", "comment", "content-category-id", "create-info", "dimension-name", "directory-site-id", "directory-site-id-dimension-value", "end-date", "etag", "external-id", "flighted", "floodlight-activity-id", "id", "id-dimension-value", "kind", "last-modified-info", "match-type", "name", "placement-group-type", "placement-strategy-id", "pricing-schedule", "pricing-type", "primary-placement-id", "primary-placement-id-dimension-value", "site-id", "site-id-dimension-value", "start-date", "subaccount-id", "testing-start-date", "time", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::PlacementGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.placement_groups().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_groups_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placement_groups().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "site-ids" => {
                    call = call.add_site_ids(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "pricing-types" => {
                    call = call.add_pricing_types(value.unwrap_or(""));
                },
                "placement-strategy-ids" => {
                    call = call.add_placement_strategy_ids(value.unwrap_or(""));
                },
                "placement-group-type" => {
                    call = call.placement_group_type(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "min-start-date" => {
                    call = call.min_start_date(value.unwrap_or(""));
                },
                "min-end-date" => {
                    call = call.min_end_date(value.unwrap_or(""));
                },
                "max-start-date" => {
                    call = call.max_start_date(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "max-end-date" => {
                    call = call.max_end_date(value.unwrap_or(""));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "directory-site-ids" => {
                    call = call.add_directory_site_ids(value.unwrap_or(""));
                },
                "content-category-ids" => {
                    call = call.add_content_category_ids(value.unwrap_or(""));
                },
                "campaign-ids" => {
                    call = call.add_campaign_ids(value.unwrap_or(""));
                },
                "archived" => {
                    call = call.archived(arg_from_str(value.unwrap_or("false"), err, "archived", "boolean"));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-ids", "archived", "campaign-ids", "content-category-ids", "directory-site-ids", "ids", "max-end-date", "max-results", "max-start-date", "min-end-date", "min-start-date", "page-token", "placement-group-type", "placement-strategy-ids", "pricing-types", "search-string", "site-ids", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_groups_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "child-placement-ids" => Some(("childPlacementIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "content-category-id" => Some(("contentCategoryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id" => Some(("directorySiteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.dimension-name" => Some(("directorySiteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.etag" => Some(("directorySiteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.id" => Some(("directorySiteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.kind" => Some(("directorySiteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.match-type" => Some(("directorySiteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.value" => Some(("directorySiteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-type" => Some(("placementGroupType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-strategy-id" => Some(("placementStrategyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.cap-cost-option" => Some(("pricingSchedule.capCostOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.end-date" => Some(("pricingSchedule.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.flighted" => Some(("pricingSchedule.flighted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "pricing-schedule.floodlight-activity-id" => Some(("pricingSchedule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.pricing-type" => Some(("pricingSchedule.pricingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.start-date" => Some(("pricingSchedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.testing-start-date" => Some(("pricingSchedule.testingStartDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id" => Some(("primaryPlacementId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.dimension-name" => Some(("primaryPlacementIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.etag" => Some(("primaryPlacementIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.id" => Some(("primaryPlacementIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.kind" => Some(("primaryPlacementIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.match-type" => Some(("primaryPlacementIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.value" => Some(("primaryPlacementIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id" => Some(("siteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.dimension-name" => Some(("siteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.etag" => Some(("siteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.id" => Some(("siteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.kind" => Some(("siteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.match-type" => Some(("siteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.value" => Some(("siteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "archived", "campaign-id", "campaign-id-dimension-value", "cap-cost-option", "child-placement-ids", "comment", "content-category-id", "create-info", "dimension-name", "directory-site-id", "directory-site-id-dimension-value", "end-date", "etag", "external-id", "flighted", "floodlight-activity-id", "id", "id-dimension-value", "kind", "last-modified-info", "match-type", "name", "placement-group-type", "placement-strategy-id", "pricing-schedule", "pricing-type", "primary-placement-id", "primary-placement-id-dimension-value", "site-id", "site-id-dimension-value", "start-date", "subaccount-id", "testing-start-date", "time", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::PlacementGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.placement_groups().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_groups_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "child-placement-ids" => Some(("childPlacementIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "content-category-id" => Some(("contentCategoryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id" => Some(("directorySiteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.dimension-name" => Some(("directorySiteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.etag" => Some(("directorySiteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.id" => Some(("directorySiteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.kind" => Some(("directorySiteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.match-type" => Some(("directorySiteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.value" => Some(("directorySiteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-type" => Some(("placementGroupType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-strategy-id" => Some(("placementStrategyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.cap-cost-option" => Some(("pricingSchedule.capCostOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.end-date" => Some(("pricingSchedule.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.flighted" => Some(("pricingSchedule.flighted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "pricing-schedule.floodlight-activity-id" => Some(("pricingSchedule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.pricing-type" => Some(("pricingSchedule.pricingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.start-date" => Some(("pricingSchedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.testing-start-date" => Some(("pricingSchedule.testingStartDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id" => Some(("primaryPlacementId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.dimension-name" => Some(("primaryPlacementIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.etag" => Some(("primaryPlacementIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.id" => Some(("primaryPlacementIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.kind" => Some(("primaryPlacementIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.match-type" => Some(("primaryPlacementIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary-placement-id-dimension-value.value" => Some(("primaryPlacementIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id" => Some(("siteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.dimension-name" => Some(("siteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.etag" => Some(("siteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.id" => Some(("siteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.kind" => Some(("siteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.match-type" => Some(("siteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.value" => Some(("siteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "advertiser-id", "advertiser-id-dimension-value", "archived", "campaign-id", "campaign-id-dimension-value", "cap-cost-option", "child-placement-ids", "comment", "content-category-id", "create-info", "dimension-name", "directory-site-id", "directory-site-id-dimension-value", "end-date", "etag", "external-id", "flighted", "floodlight-activity-id", "id", "id-dimension-value", "kind", "last-modified-info", "match-type", "name", "placement-group-type", "placement-strategy-id", "pricing-schedule", "pricing-type", "primary-placement-id", "primary-placement-id-dimension-value", "site-id", "site-id-dimension-value", "start-date", "subaccount-id", "testing-start-date", "time", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::PlacementGroup = json::value::from_value(object).unwrap();
        let mut call = self.hub.placement_groups().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_strategies_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placement_strategies().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _placement_strategies_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placement_strategies().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_strategies_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::PlacementStrategy = json::value::from_value(object).unwrap();
        let mut call = self.hub.placement_strategies().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_strategies_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placement_strategies().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_strategies_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::PlacementStrategy = json::value::from_value(object).unwrap();
        let mut call = self.hub.placement_strategies().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placement_strategies_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "id", "kind", "name"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::PlacementStrategy = json::value::from_value(object).unwrap();
        let mut call = self.hub.placement_strategies().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placements_generatetags(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placements().generatetags(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "tag-formats" => {
                    call = call.add_tag_formats(value.unwrap_or(""));
                },
                "placement-ids" => {
                    call = call.add_placement_ids(value.unwrap_or(""));
                },
                "campaign-id" => {
                    call = call.campaign_id(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["campaign-id", "placement-ids", "tag-formats"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placements_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placements().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placements_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-opt-out" => Some(("adBlockingOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "content-category-id" => Some(("contentCategoryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id" => Some(("directorySiteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.dimension-name" => Some(("directorySiteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.etag" => Some(("directorySiteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.id" => Some(("directorySiteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.kind" => Some(("directorySiteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.match-type" => Some(("directorySiteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.value" => Some(("directorySiteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "key-name" => Some(("keyName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "lookback-configuration.click-duration" => Some(("lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "lookback-configuration.post-impression-activities-duration" => Some(("lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "payment-approved" => Some(("paymentApproved", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "payment-source" => Some(("paymentSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id" => Some(("placementGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.dimension-name" => Some(("placementGroupIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.etag" => Some(("placementGroupIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.id" => Some(("placementGroupIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.kind" => Some(("placementGroupIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.match-type" => Some(("placementGroupIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.value" => Some(("placementGroupIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-strategy-id" => Some(("placementStrategyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.cap-cost-option" => Some(("pricingSchedule.capCostOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.end-date" => Some(("pricingSchedule.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.flighted" => Some(("pricingSchedule.flighted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "pricing-schedule.floodlight-activity-id" => Some(("pricingSchedule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.pricing-type" => Some(("pricingSchedule.pricingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.start-date" => Some(("pricingSchedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.testing-start-date" => Some(("pricingSchedule.testingStartDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary" => Some(("primary", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "publisher-update-info.time" => Some(("publisherUpdateInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id" => Some(("siteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.dimension-name" => Some(("siteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.etag" => Some(("siteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.id" => Some(("siteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.kind" => Some(("siteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.match-type" => Some(("siteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.value" => Some(("siteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-formats" => Some(("tagFormats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "tag-setting.additional-key-values" => Some(("tagSetting.additionalKeyValues", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-setting.include-click-through-urls" => Some(("tagSetting.includeClickThroughUrls", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-setting.include-click-tracking" => Some(("tagSetting.includeClickTracking", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-setting.keyword-option" => Some(("tagSetting.keywordOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-active-view-opt-out" => Some(("videoActiveViewOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.companions-disabled" => Some(("videoSettings.companionSettings.companionsDisabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.image-only" => Some(("videoSettings.companionSettings.imageOnly", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.kind" => Some(("videoSettings.companionSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.kind" => Some(("videoSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-enabled" => Some(("videoSettings.obaEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-click-through-url" => Some(("videoSettings.obaSettings.iconClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-click-tracking-url" => Some(("videoSettings.obaSettings.iconClickTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-view-tracking-url" => Some(("videoSettings.obaSettings.iconViewTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.program" => Some(("videoSettings.obaSettings.program", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.resource-url" => Some(("videoSettings.obaSettings.resourceUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.height" => Some(("videoSettings.obaSettings.size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.iab" => Some(("videoSettings.obaSettings.size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.id" => Some(("videoSettings.obaSettings.size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.kind" => Some(("videoSettings.obaSettings.size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.width" => Some(("videoSettings.obaSettings.size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.x-position" => Some(("videoSettings.obaSettings.xPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.y-position" => Some(("videoSettings.obaSettings.yPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.orientation" => Some(("videoSettings.orientation", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.kind" => Some(("videoSettings.skippableSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.progress-offset.offset-percentage" => Some(("videoSettings.skippableSettings.progressOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.progress-offset.offset-seconds" => Some(("videoSettings.skippableSettings.progressOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skip-offset.offset-percentage" => Some(("videoSettings.skippableSettings.skipOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skip-offset.offset-seconds" => Some(("videoSettings.skippableSettings.skipOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skippable" => Some(("videoSettings.skippableSettings.skippable", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.transcode-settings.enabled-video-formats" => Some(("videoSettings.transcodeSettings.enabledVideoFormats", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Vec })),
                    "video-settings.transcode-settings.kind" => Some(("videoSettings.transcodeSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "vpaid-adapter-choice" => Some(("vpaidAdapterChoice", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "ad-blocking-opt-out", "additional-key-values", "advertiser-id", "advertiser-id-dimension-value", "archived", "campaign-id", "campaign-id-dimension-value", "cap-cost-option", "click-duration", "comment", "companion-settings", "companions-disabled", "compatibility", "content-category-id", "create-info", "dimension-name", "directory-site-id", "directory-site-id-dimension-value", "enabled-video-formats", "end-date", "etag", "external-id", "flighted", "floodlight-activity-id", "height", "iab", "icon-click-through-url", "icon-click-tracking-url", "icon-view-tracking-url", "id", "id-dimension-value", "image-only", "include-click-through-urls", "include-click-tracking", "key-name", "keyword-option", "kind", "last-modified-info", "lookback-configuration", "match-type", "name", "oba-enabled", "oba-settings", "offset-percentage", "offset-seconds", "orientation", "payment-approved", "payment-source", "placement-group-id", "placement-group-id-dimension-value", "placement-strategy-id", "post-impression-activities-duration", "pricing-schedule", "pricing-type", "primary", "program", "progress-offset", "publisher-update-info", "resource-url", "site-id", "site-id-dimension-value", "size", "skip-offset", "skippable", "skippable-settings", "ssl-required", "start-date", "status", "subaccount-id", "tag-formats", "tag-setting", "testing-start-date", "time", "transcode-settings", "value", "video-active-view-opt-out", "video-settings", "vpaid-adapter-choice", "width", "x-position", "y-position"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Placement = json::value::from_value(object).unwrap();
        let mut call = self.hub.placements().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placements_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.placements().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "size-ids" => {
                    call = call.add_size_ids(value.unwrap_or(""));
                },
                "site-ids" => {
                    call = call.add_site_ids(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "pricing-types" => {
                    call = call.add_pricing_types(value.unwrap_or(""));
                },
                "placement-strategy-ids" => {
                    call = call.add_placement_strategy_ids(value.unwrap_or(""));
                },
                "payment-source" => {
                    call = call.payment_source(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "min-start-date" => {
                    call = call.min_start_date(value.unwrap_or(""));
                },
                "min-end-date" => {
                    call = call.min_end_date(value.unwrap_or(""));
                },
                "max-start-date" => {
                    call = call.max_start_date(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "max-end-date" => {
                    call = call.max_end_date(value.unwrap_or(""));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "group-ids" => {
                    call = call.add_group_ids(value.unwrap_or(""));
                },
                "directory-site-ids" => {
                    call = call.add_directory_site_ids(value.unwrap_or(""));
                },
                "content-category-ids" => {
                    call = call.add_content_category_ids(value.unwrap_or(""));
                },
                "compatibilities" => {
                    call = call.add_compatibilities(value.unwrap_or(""));
                },
                "campaign-ids" => {
                    call = call.add_campaign_ids(value.unwrap_or(""));
                },
                "archived" => {
                    call = call.archived(arg_from_str(value.unwrap_or("false"), err, "archived", "boolean"));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-ids", "archived", "campaign-ids", "compatibilities", "content-category-ids", "directory-site-ids", "group-ids", "ids", "max-end-date", "max-results", "max-start-date", "min-end-date", "min-start-date", "page-token", "payment-source", "placement-strategy-ids", "pricing-types", "search-string", "site-ids", "size-ids", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placements_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-opt-out" => Some(("adBlockingOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "content-category-id" => Some(("contentCategoryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id" => Some(("directorySiteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.dimension-name" => Some(("directorySiteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.etag" => Some(("directorySiteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.id" => Some(("directorySiteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.kind" => Some(("directorySiteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.match-type" => Some(("directorySiteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.value" => Some(("directorySiteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "key-name" => Some(("keyName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "lookback-configuration.click-duration" => Some(("lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "lookback-configuration.post-impression-activities-duration" => Some(("lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "payment-approved" => Some(("paymentApproved", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "payment-source" => Some(("paymentSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id" => Some(("placementGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.dimension-name" => Some(("placementGroupIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.etag" => Some(("placementGroupIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.id" => Some(("placementGroupIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.kind" => Some(("placementGroupIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.match-type" => Some(("placementGroupIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.value" => Some(("placementGroupIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-strategy-id" => Some(("placementStrategyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.cap-cost-option" => Some(("pricingSchedule.capCostOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.end-date" => Some(("pricingSchedule.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.flighted" => Some(("pricingSchedule.flighted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "pricing-schedule.floodlight-activity-id" => Some(("pricingSchedule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.pricing-type" => Some(("pricingSchedule.pricingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.start-date" => Some(("pricingSchedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.testing-start-date" => Some(("pricingSchedule.testingStartDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary" => Some(("primary", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "publisher-update-info.time" => Some(("publisherUpdateInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id" => Some(("siteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.dimension-name" => Some(("siteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.etag" => Some(("siteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.id" => Some(("siteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.kind" => Some(("siteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.match-type" => Some(("siteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.value" => Some(("siteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-formats" => Some(("tagFormats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "tag-setting.additional-key-values" => Some(("tagSetting.additionalKeyValues", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-setting.include-click-through-urls" => Some(("tagSetting.includeClickThroughUrls", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-setting.include-click-tracking" => Some(("tagSetting.includeClickTracking", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-setting.keyword-option" => Some(("tagSetting.keywordOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-active-view-opt-out" => Some(("videoActiveViewOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.companions-disabled" => Some(("videoSettings.companionSettings.companionsDisabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.image-only" => Some(("videoSettings.companionSettings.imageOnly", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.kind" => Some(("videoSettings.companionSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.kind" => Some(("videoSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-enabled" => Some(("videoSettings.obaEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-click-through-url" => Some(("videoSettings.obaSettings.iconClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-click-tracking-url" => Some(("videoSettings.obaSettings.iconClickTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-view-tracking-url" => Some(("videoSettings.obaSettings.iconViewTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.program" => Some(("videoSettings.obaSettings.program", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.resource-url" => Some(("videoSettings.obaSettings.resourceUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.height" => Some(("videoSettings.obaSettings.size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.iab" => Some(("videoSettings.obaSettings.size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.id" => Some(("videoSettings.obaSettings.size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.kind" => Some(("videoSettings.obaSettings.size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.width" => Some(("videoSettings.obaSettings.size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.x-position" => Some(("videoSettings.obaSettings.xPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.y-position" => Some(("videoSettings.obaSettings.yPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.orientation" => Some(("videoSettings.orientation", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.kind" => Some(("videoSettings.skippableSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.progress-offset.offset-percentage" => Some(("videoSettings.skippableSettings.progressOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.progress-offset.offset-seconds" => Some(("videoSettings.skippableSettings.progressOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skip-offset.offset-percentage" => Some(("videoSettings.skippableSettings.skipOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skip-offset.offset-seconds" => Some(("videoSettings.skippableSettings.skipOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skippable" => Some(("videoSettings.skippableSettings.skippable", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.transcode-settings.enabled-video-formats" => Some(("videoSettings.transcodeSettings.enabledVideoFormats", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Vec })),
                    "video-settings.transcode-settings.kind" => Some(("videoSettings.transcodeSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "vpaid-adapter-choice" => Some(("vpaidAdapterChoice", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "ad-blocking-opt-out", "additional-key-values", "advertiser-id", "advertiser-id-dimension-value", "archived", "campaign-id", "campaign-id-dimension-value", "cap-cost-option", "click-duration", "comment", "companion-settings", "companions-disabled", "compatibility", "content-category-id", "create-info", "dimension-name", "directory-site-id", "directory-site-id-dimension-value", "enabled-video-formats", "end-date", "etag", "external-id", "flighted", "floodlight-activity-id", "height", "iab", "icon-click-through-url", "icon-click-tracking-url", "icon-view-tracking-url", "id", "id-dimension-value", "image-only", "include-click-through-urls", "include-click-tracking", "key-name", "keyword-option", "kind", "last-modified-info", "lookback-configuration", "match-type", "name", "oba-enabled", "oba-settings", "offset-percentage", "offset-seconds", "orientation", "payment-approved", "payment-source", "placement-group-id", "placement-group-id-dimension-value", "placement-strategy-id", "post-impression-activities-duration", "pricing-schedule", "pricing-type", "primary", "program", "progress-offset", "publisher-update-info", "resource-url", "site-id", "site-id-dimension-value", "size", "skip-offset", "skippable", "skippable-settings", "ssl-required", "start-date", "status", "subaccount-id", "tag-formats", "tag-setting", "testing-start-date", "time", "transcode-settings", "value", "video-active-view-opt-out", "video-settings", "vpaid-adapter-choice", "width", "x-position", "y-position"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Placement = json::value::from_value(object).unwrap();
        let mut call = self.hub.placements().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _placements_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "ad-blocking-opt-out" => Some(("adBlockingOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "archived" => Some(("archived", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "campaign-id" => Some(("campaignId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.dimension-name" => Some(("campaignIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.etag" => Some(("campaignIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.id" => Some(("campaignIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.kind" => Some(("campaignIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.match-type" => Some(("campaignIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "campaign-id-dimension-value.value" => Some(("campaignIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "comment" => Some(("comment", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "compatibility" => Some(("compatibility", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "content-category-id" => Some(("contentCategoryId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "create-info.time" => Some(("createInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id" => Some(("directorySiteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.dimension-name" => Some(("directorySiteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.etag" => Some(("directorySiteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.id" => Some(("directorySiteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.kind" => Some(("directorySiteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.match-type" => Some(("directorySiteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "directory-site-id-dimension-value.value" => Some(("directorySiteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "external-id" => Some(("externalId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.dimension-name" => Some(("idDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.etag" => Some(("idDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.id" => Some(("idDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.kind" => Some(("idDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.match-type" => Some(("idDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id-dimension-value.value" => Some(("idDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "key-name" => Some(("keyName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-info.time" => Some(("lastModifiedInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "lookback-configuration.click-duration" => Some(("lookbackConfiguration.clickDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "lookback-configuration.post-impression-activities-duration" => Some(("lookbackConfiguration.postImpressionActivitiesDuration", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "payment-approved" => Some(("paymentApproved", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "payment-source" => Some(("paymentSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id" => Some(("placementGroupId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.dimension-name" => Some(("placementGroupIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.etag" => Some(("placementGroupIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.id" => Some(("placementGroupIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.kind" => Some(("placementGroupIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.match-type" => Some(("placementGroupIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-group-id-dimension-value.value" => Some(("placementGroupIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "placement-strategy-id" => Some(("placementStrategyId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.cap-cost-option" => Some(("pricingSchedule.capCostOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.end-date" => Some(("pricingSchedule.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.flighted" => Some(("pricingSchedule.flighted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "pricing-schedule.floodlight-activity-id" => Some(("pricingSchedule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.pricing-type" => Some(("pricingSchedule.pricingType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.start-date" => Some(("pricingSchedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "pricing-schedule.testing-start-date" => Some(("pricingSchedule.testingStartDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "primary" => Some(("primary", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "publisher-update-info.time" => Some(("publisherUpdateInfo.time", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id" => Some(("siteId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.dimension-name" => Some(("siteIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.etag" => Some(("siteIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.id" => Some(("siteIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.kind" => Some(("siteIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.match-type" => Some(("siteIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "site-id-dimension-value.value" => Some(("siteIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.height" => Some(("size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "size.iab" => Some(("size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "size.id" => Some(("size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.kind" => Some(("size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "size.width" => Some(("size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "ssl-required" => Some(("sslRequired", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "status" => Some(("status", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-formats" => Some(("tagFormats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "tag-setting.additional-key-values" => Some(("tagSetting.additionalKeyValues", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "tag-setting.include-click-through-urls" => Some(("tagSetting.includeClickThroughUrls", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-setting.include-click-tracking" => Some(("tagSetting.includeClickTracking", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "tag-setting.keyword-option" => Some(("tagSetting.keywordOption", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-active-view-opt-out" => Some(("videoActiveViewOptOut", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.companions-disabled" => Some(("videoSettings.companionSettings.companionsDisabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.image-only" => Some(("videoSettings.companionSettings.imageOnly", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.companion-settings.kind" => Some(("videoSettings.companionSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.kind" => Some(("videoSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-enabled" => Some(("videoSettings.obaEnabled", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-click-through-url" => Some(("videoSettings.obaSettings.iconClickThroughUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-click-tracking-url" => Some(("videoSettings.obaSettings.iconClickTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.icon-view-tracking-url" => Some(("videoSettings.obaSettings.iconViewTrackingUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.program" => Some(("videoSettings.obaSettings.program", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.resource-url" => Some(("videoSettings.obaSettings.resourceUrl", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.height" => Some(("videoSettings.obaSettings.size.height", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.iab" => Some(("videoSettings.obaSettings.size.iab", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.id" => Some(("videoSettings.obaSettings.size.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.kind" => Some(("videoSettings.obaSettings.size.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.size.width" => Some(("videoSettings.obaSettings.size.width", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.x-position" => Some(("videoSettings.obaSettings.xPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.oba-settings.y-position" => Some(("videoSettings.obaSettings.yPosition", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.orientation" => Some(("videoSettings.orientation", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.kind" => Some(("videoSettings.skippableSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.progress-offset.offset-percentage" => Some(("videoSettings.skippableSettings.progressOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.progress-offset.offset-seconds" => Some(("videoSettings.skippableSettings.progressOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skip-offset.offset-percentage" => Some(("videoSettings.skippableSettings.skipOffset.offsetPercentage", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skip-offset.offset-seconds" => Some(("videoSettings.skippableSettings.skipOffset.offsetSeconds", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "video-settings.skippable-settings.skippable" => Some(("videoSettings.skippableSettings.skippable", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "video-settings.transcode-settings.enabled-video-formats" => Some(("videoSettings.transcodeSettings.enabledVideoFormats", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Vec })),
                    "video-settings.transcode-settings.kind" => Some(("videoSettings.transcodeSettings.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "vpaid-adapter-choice" => Some(("vpaidAdapterChoice", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "ad-blocking-opt-out", "additional-key-values", "advertiser-id", "advertiser-id-dimension-value", "archived", "campaign-id", "campaign-id-dimension-value", "cap-cost-option", "click-duration", "comment", "companion-settings", "companions-disabled", "compatibility", "content-category-id", "create-info", "dimension-name", "directory-site-id", "directory-site-id-dimension-value", "enabled-video-formats", "end-date", "etag", "external-id", "flighted", "floodlight-activity-id", "height", "iab", "icon-click-through-url", "icon-click-tracking-url", "icon-view-tracking-url", "id", "id-dimension-value", "image-only", "include-click-through-urls", "include-click-tracking", "key-name", "keyword-option", "kind", "last-modified-info", "lookback-configuration", "match-type", "name", "oba-enabled", "oba-settings", "offset-percentage", "offset-seconds", "orientation", "payment-approved", "payment-source", "placement-group-id", "placement-group-id-dimension-value", "placement-strategy-id", "post-impression-activities-duration", "pricing-schedule", "pricing-type", "primary", "program", "progress-offset", "publisher-update-info", "resource-url", "site-id", "site-id-dimension-value", "size", "skip-offset", "skippable", "skippable-settings", "ssl-required", "start-date", "status", "subaccount-id", "tag-formats", "tag-setting", "testing-start-date", "time", "transcode-settings", "value", "video-active-view-opt-out", "video-settings", "vpaid-adapter-choice", "width", "x-position", "y-position"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Placement = json::value::from_value(object).unwrap();
        let mut call = self.hub.placements().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _platform_types_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.platform_types().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _platform_types_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.platform_types().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _postal_codes_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.postal_codes().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("code").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _postal_codes_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.postal_codes().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _projects_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.projects().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _projects_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.projects().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "search-string" => {
                    call = call.search_string(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "ids" => {
                    call = call.add_ids(value.unwrap_or(""));
                },
                "advertiser-ids" => {
                    call = call.add_advertiser_ids(value.unwrap_or(""));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["advertiser-ids", "ids", "max-results", "page-token", "search-string", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _regions_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.regions().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_list_shares_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.remarketing_list_shares().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("remarketing-list-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_list_shares_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "remarketing-list-id" => Some(("remarketingListId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "shared-account-ids" => Some(("sharedAccountIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "shared-advertiser-ids" => Some(("sharedAdvertiserIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["kind", "remarketing-list-id", "shared-account-ids", "shared-advertiser-ids"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::RemarketingListShare = json::value::from_value(object).unwrap();
        let mut call = self.hub.remarketing_list_shares().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_list_shares_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "remarketing-list-id" => Some(("remarketingListId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "shared-account-ids" => Some(("sharedAccountIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "shared-advertiser-ids" => Some(("sharedAdvertiserIds", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["kind", "remarketing-list-id", "shared-account-ids", "shared-advertiser-ids"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::RemarketingListShare = json::value::from_value(object).unwrap();
        let mut call = self.hub.remarketing_list_shares().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_lists_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.remarketing_lists().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_lists_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "description" => Some(("description", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "life-span" => Some(("lifeSpan", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-population-rule.floodlight-activity-id" => Some(("listPopulationRule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-population-rule.floodlight-activity-name" => Some(("listPopulationRule.floodlightActivityName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-size" => Some(("listSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-source" => Some(("listSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-id", "advertiser-id-dimension-value", "description", "dimension-name", "etag", "floodlight-activity-id", "floodlight-activity-name", "id", "kind", "life-span", "list-population-rule", "list-size", "list-source", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::RemarketingList = json::value::from_value(object).unwrap();
        let mut call = self.hub.remarketing_lists().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_lists_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.remarketing_lists().list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("advertiser-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "name" => {
                    call = call.name(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                "floodlight-activity-id" => {
                    call = call.floodlight_activity_id(value.unwrap_or(""));
                },
                "active" => {
                    call = call.active(arg_from_str(value.unwrap_or("false"), err, "active", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["active", "floodlight-activity-id", "max-results", "name", "page-token", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_lists_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "description" => Some(("description", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "life-span" => Some(("lifeSpan", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-population-rule.floodlight-activity-id" => Some(("listPopulationRule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-population-rule.floodlight-activity-name" => Some(("listPopulationRule.floodlightActivityName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-size" => Some(("listSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-source" => Some(("listSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-id", "advertiser-id-dimension-value", "description", "dimension-name", "etag", "floodlight-activity-id", "floodlight-activity-name", "id", "kind", "life-span", "list-population-rule", "list-size", "list-source", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::RemarketingList = json::value::from_value(object).unwrap();
        let mut call = self.hub.remarketing_lists().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _remarketing_lists_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "active" => Some(("active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "advertiser-id" => Some(("advertiserId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.dimension-name" => Some(("advertiserIdDimensionValue.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.etag" => Some(("advertiserIdDimensionValue.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.id" => Some(("advertiserIdDimensionValue.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.kind" => Some(("advertiserIdDimensionValue.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.match-type" => Some(("advertiserIdDimensionValue.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "advertiser-id-dimension-value.value" => Some(("advertiserIdDimensionValue.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "description" => Some(("description", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "life-span" => Some(("lifeSpan", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-population-rule.floodlight-activity-id" => Some(("listPopulationRule.floodlightActivityId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-population-rule.floodlight-activity-name" => Some(("listPopulationRule.floodlightActivityName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-size" => Some(("listSize", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "list-source" => Some(("listSource", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "subaccount-id" => Some(("subaccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "advertiser-id", "advertiser-id-dimension-value", "description", "dimension-name", "etag", "floodlight-activity-id", "floodlight-activity-name", "id", "kind", "life-span", "list-population-rule", "list-size", "list-source", "match-type", "name", "subaccount-id", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::RemarketingList = json::value::from_value(object).unwrap();
        let mut call = self.hub.remarketing_lists().update(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_compatible_fields_query(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.kind" => Some(("criteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.metric-names" => Some(("criteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "criteria.custom-rich-media-events.kind" => Some(("criteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.end-date" => Some(("criteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.kind" => Some(("criteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.relative-date-range" => Some(("criteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.start-date" => Some(("criteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.metric-names" => Some(("criteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.date-range.end-date" => Some(("crossDimensionReachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.kind" => Some(("crossDimensionReachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.relative-date-range" => Some(("crossDimensionReachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.start-date" => Some(("crossDimensionReachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.dimension" => Some(("crossDimensionReachCriteria.dimension", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.metric-names" => Some(("crossDimensionReachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.overlap-metric-names" => Some(("crossDimensionReachCriteria.overlapMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.pivoted" => Some(("crossDimensionReachCriteria.pivoted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner" => Some(("delivery.emailOwner", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner-delivery-type" => Some(("delivery.emailOwnerDeliveryType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery.message" => Some(("delivery.message", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "etag" => Some(("etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "file-name" => Some(("fileName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.end-date" => Some(("floodlightCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.kind" => Some(("floodlightCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.relative-date-range" => Some(("floodlightCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.start-date" => Some(("floodlightCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.dimension-name" => Some(("floodlightCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.etag" => Some(("floodlightCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.id" => Some(("floodlightCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.kind" => Some(("floodlightCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.match-type" => Some(("floodlightCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.value" => Some(("floodlightCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.metric-names" => Some(("floodlightCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "floodlight-criteria.report-properties.include-attributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "format" => Some(("format", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-time" => Some(("lastModifiedTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "owner-profile-id" => Some(("ownerProfileId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.fallback-name" => Some(("pathAttributionCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.kind" => Some(("pathAttributionCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.name" => Some(("pathAttributionCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.end-date" => Some(("pathAttributionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.kind" => Some(("pathAttributionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.relative-date-range" => Some(("pathAttributionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.start-date" => Some(("pathAttributionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.dimension-name" => Some(("pathAttributionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.etag" => Some(("pathAttributionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.id" => Some(("pathAttributionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.kind" => Some(("pathAttributionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.match-type" => Some(("pathAttributionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.value" => Some(("pathAttributionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.metric-names" => Some(("pathAttributionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-criteria.custom-channel-grouping.fallback-name" => Some(("pathCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.kind" => Some(("pathCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.name" => Some(("pathCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.end-date" => Some(("pathCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.kind" => Some(("pathCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.relative-date-range" => Some(("pathCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.start-date" => Some(("pathCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.dimension-name" => Some(("pathCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.etag" => Some(("pathCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.id" => Some(("pathCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.kind" => Some(("pathCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.match-type" => Some(("pathCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.value" => Some(("pathCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.metric-names" => Some(("pathCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.date-range.end-date" => Some(("pathToConversionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.kind" => Some(("pathToConversionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.relative-date-range" => Some(("pathToConversionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.start-date" => Some(("pathToConversionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.dimension-name" => Some(("pathToConversionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.etag" => Some(("pathToConversionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.id" => Some(("pathToConversionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.kind" => Some(("pathToConversionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.match-type" => Some(("pathToConversionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.value" => Some(("pathToConversionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.metric-names" => Some(("pathToConversionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.report-properties.clicks-lookback-window" => Some(("pathToConversionCriteria.reportProperties.clicksLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.impressions-lookback-window" => Some(("pathToConversionCriteria.reportProperties.impressionsLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-attributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-click-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumClickInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-impression-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumImpressionInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-interaction-gap" => Some(("pathToConversionCriteria.reportProperties.maximumInteractionGap", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.pivot-on-interaction-path" => Some(("pathToConversionCriteria.reportProperties.pivotOnInteractionPath", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.kind" => Some(("reachCriteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.metric-names" => Some(("reachCriteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.custom-rich-media-events.kind" => Some(("reachCriteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.end-date" => Some(("reachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.kind" => Some(("reachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.relative-date-range" => Some(("reachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.start-date" => Some(("reachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.enable-all-dimension-combinations" => Some(("reachCriteria.enableAllDimensionCombinations", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.metric-names" => Some(("reachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.reach-by-frequency-metric-names" => Some(("reachCriteria.reachByFrequencyMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.active" => Some(("schedule.active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "schedule.every" => Some(("schedule.every", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "schedule.expiration-date" => Some(("schedule.expirationDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats" => Some(("schedule.repeats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats-on-week-days" => Some(("schedule.repeatsOnWeekDays", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.runs-on-day-of-month" => Some(("schedule.runsOnDayOfMonth", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.start-date" => Some(("schedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "sub-account-id" => Some(("subAccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "activities", "clicks-lookback-window", "criteria", "cross-dimension-reach-criteria", "custom-channel-grouping", "custom-rich-media-events", "date-range", "delivery", "dimension", "dimension-name", "email-owner", "email-owner-delivery-type", "enable-all-dimension-combinations", "end-date", "etag", "every", "expiration-date", "fallback-name", "file-name", "floodlight-config-id", "floodlight-criteria", "format", "id", "impressions-lookback-window", "include-attributed-ip-conversions", "include-unattributed-cookie-conversions", "include-unattributed-ip-conversions", "kind", "last-modified-time", "match-type", "maximum-click-interactions", "maximum-impression-interactions", "maximum-interaction-gap", "message", "metric-names", "name", "overlap-metric-names", "owner-profile-id", "path-attribution-criteria", "path-criteria", "path-to-conversion-criteria", "pivot-on-interaction-path", "pivoted", "reach-by-frequency-metric-names", "reach-criteria", "relative-date-range", "repeats", "repeats-on-week-days", "report-properties", "runs-on-day-of-month", "schedule", "start-date", "sub-account-id", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Report = json::value::from_value(object).unwrap();
        let mut call = self.hub.reports().compatible_fields_query(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_delete(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.reports().delete(opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok(mut response) => {
                    Ok(())
                }
            }
        }
    }

    async fn _reports_files_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut download_mode = false;
        let mut call = self.hub.reports().files_get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""), opt.value_of("file-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            if key == "alt" && value.unwrap_or("unset") == "media" {
                                download_mode = true;
                            }
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    if !download_mode {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    } else {
                    let bytes = hyper::body::to_bytes(response.into_body()).await.expect("a string as API currently is inefficient").to_vec();
                    ostream.write_all(&bytes).expect("write to be complete");
                    ostream.flush().expect("io to never fail which should really be fixed one day");
                    }
                    Ok(())
                }
            }
        }
    }

    async fn _reports_files_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.reports().files_list(opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["max-results", "page-token", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.reports().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.kind" => Some(("criteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.metric-names" => Some(("criteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "criteria.custom-rich-media-events.kind" => Some(("criteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.end-date" => Some(("criteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.kind" => Some(("criteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.relative-date-range" => Some(("criteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.start-date" => Some(("criteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.metric-names" => Some(("criteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.date-range.end-date" => Some(("crossDimensionReachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.kind" => Some(("crossDimensionReachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.relative-date-range" => Some(("crossDimensionReachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.start-date" => Some(("crossDimensionReachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.dimension" => Some(("crossDimensionReachCriteria.dimension", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.metric-names" => Some(("crossDimensionReachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.overlap-metric-names" => Some(("crossDimensionReachCriteria.overlapMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.pivoted" => Some(("crossDimensionReachCriteria.pivoted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner" => Some(("delivery.emailOwner", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner-delivery-type" => Some(("delivery.emailOwnerDeliveryType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery.message" => Some(("delivery.message", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "etag" => Some(("etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "file-name" => Some(("fileName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.end-date" => Some(("floodlightCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.kind" => Some(("floodlightCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.relative-date-range" => Some(("floodlightCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.start-date" => Some(("floodlightCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.dimension-name" => Some(("floodlightCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.etag" => Some(("floodlightCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.id" => Some(("floodlightCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.kind" => Some(("floodlightCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.match-type" => Some(("floodlightCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.value" => Some(("floodlightCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.metric-names" => Some(("floodlightCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "floodlight-criteria.report-properties.include-attributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "format" => Some(("format", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-time" => Some(("lastModifiedTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "owner-profile-id" => Some(("ownerProfileId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.fallback-name" => Some(("pathAttributionCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.kind" => Some(("pathAttributionCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.name" => Some(("pathAttributionCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.end-date" => Some(("pathAttributionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.kind" => Some(("pathAttributionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.relative-date-range" => Some(("pathAttributionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.start-date" => Some(("pathAttributionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.dimension-name" => Some(("pathAttributionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.etag" => Some(("pathAttributionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.id" => Some(("pathAttributionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.kind" => Some(("pathAttributionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.match-type" => Some(("pathAttributionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.value" => Some(("pathAttributionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.metric-names" => Some(("pathAttributionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-criteria.custom-channel-grouping.fallback-name" => Some(("pathCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.kind" => Some(("pathCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.name" => Some(("pathCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.end-date" => Some(("pathCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.kind" => Some(("pathCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.relative-date-range" => Some(("pathCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.start-date" => Some(("pathCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.dimension-name" => Some(("pathCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.etag" => Some(("pathCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.id" => Some(("pathCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.kind" => Some(("pathCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.match-type" => Some(("pathCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.value" => Some(("pathCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.metric-names" => Some(("pathCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.date-range.end-date" => Some(("pathToConversionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.kind" => Some(("pathToConversionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.relative-date-range" => Some(("pathToConversionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.start-date" => Some(("pathToConversionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.dimension-name" => Some(("pathToConversionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.etag" => Some(("pathToConversionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.id" => Some(("pathToConversionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.kind" => Some(("pathToConversionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.match-type" => Some(("pathToConversionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.value" => Some(("pathToConversionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.metric-names" => Some(("pathToConversionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.report-properties.clicks-lookback-window" => Some(("pathToConversionCriteria.reportProperties.clicksLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.impressions-lookback-window" => Some(("pathToConversionCriteria.reportProperties.impressionsLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-attributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-click-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumClickInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-impression-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumImpressionInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-interaction-gap" => Some(("pathToConversionCriteria.reportProperties.maximumInteractionGap", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.pivot-on-interaction-path" => Some(("pathToConversionCriteria.reportProperties.pivotOnInteractionPath", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.kind" => Some(("reachCriteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.metric-names" => Some(("reachCriteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.custom-rich-media-events.kind" => Some(("reachCriteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.end-date" => Some(("reachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.kind" => Some(("reachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.relative-date-range" => Some(("reachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.start-date" => Some(("reachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.enable-all-dimension-combinations" => Some(("reachCriteria.enableAllDimensionCombinations", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.metric-names" => Some(("reachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.reach-by-frequency-metric-names" => Some(("reachCriteria.reachByFrequencyMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.active" => Some(("schedule.active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "schedule.every" => Some(("schedule.every", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "schedule.expiration-date" => Some(("schedule.expirationDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats" => Some(("schedule.repeats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats-on-week-days" => Some(("schedule.repeatsOnWeekDays", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.runs-on-day-of-month" => Some(("schedule.runsOnDayOfMonth", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.start-date" => Some(("schedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "sub-account-id" => Some(("subAccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "activities", "clicks-lookback-window", "criteria", "cross-dimension-reach-criteria", "custom-channel-grouping", "custom-rich-media-events", "date-range", "delivery", "dimension", "dimension-name", "email-owner", "email-owner-delivery-type", "enable-all-dimension-combinations", "end-date", "etag", "every", "expiration-date", "fallback-name", "file-name", "floodlight-config-id", "floodlight-criteria", "format", "id", "impressions-lookback-window", "include-attributed-ip-conversions", "include-unattributed-cookie-conversions", "include-unattributed-ip-conversions", "kind", "last-modified-time", "match-type", "maximum-click-interactions", "maximum-impression-interactions", "maximum-interaction-gap", "message", "metric-names", "name", "overlap-metric-names", "owner-profile-id", "path-attribution-criteria", "path-criteria", "path-to-conversion-criteria", "pivot-on-interaction-path", "pivoted", "reach-by-frequency-metric-names", "reach-criteria", "relative-date-range", "repeats", "repeats-on-week-days", "report-properties", "runs-on-day-of-month", "schedule", "start-date", "sub-account-id", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Report = json::value::from_value(object).unwrap();
        let mut call = self.hub.reports().insert(request, opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_list(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.reports().list(opt.value_of("profile-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "sort-order" => {
                    call = call.sort_order(value.unwrap_or(""));
                },
                "sort-field" => {
                    call = call.sort_field(value.unwrap_or(""));
                },
                "scope" => {
                    call = call.scope(value.unwrap_or(""));
                },
                "page-token" => {
                    call = call.page_token(value.unwrap_or(""));
                },
                "max-results" => {
                    call = call.max_results(arg_from_str(value.unwrap_or("-0"), err, "max-results", "integer"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["max-results", "page-token", "scope", "sort-field", "sort-order"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_patch(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.kind" => Some(("criteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.metric-names" => Some(("criteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "criteria.custom-rich-media-events.kind" => Some(("criteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.end-date" => Some(("criteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.kind" => Some(("criteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.relative-date-range" => Some(("criteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.start-date" => Some(("criteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.metric-names" => Some(("criteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.date-range.end-date" => Some(("crossDimensionReachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.kind" => Some(("crossDimensionReachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.relative-date-range" => Some(("crossDimensionReachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.start-date" => Some(("crossDimensionReachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.dimension" => Some(("crossDimensionReachCriteria.dimension", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.metric-names" => Some(("crossDimensionReachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.overlap-metric-names" => Some(("crossDimensionReachCriteria.overlapMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.pivoted" => Some(("crossDimensionReachCriteria.pivoted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner" => Some(("delivery.emailOwner", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner-delivery-type" => Some(("delivery.emailOwnerDeliveryType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery.message" => Some(("delivery.message", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "etag" => Some(("etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "file-name" => Some(("fileName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.end-date" => Some(("floodlightCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.kind" => Some(("floodlightCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.relative-date-range" => Some(("floodlightCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.start-date" => Some(("floodlightCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.dimension-name" => Some(("floodlightCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.etag" => Some(("floodlightCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.id" => Some(("floodlightCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.kind" => Some(("floodlightCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.match-type" => Some(("floodlightCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.value" => Some(("floodlightCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.metric-names" => Some(("floodlightCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "floodlight-criteria.report-properties.include-attributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "format" => Some(("format", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-time" => Some(("lastModifiedTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "owner-profile-id" => Some(("ownerProfileId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.fallback-name" => Some(("pathAttributionCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.kind" => Some(("pathAttributionCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.name" => Some(("pathAttributionCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.end-date" => Some(("pathAttributionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.kind" => Some(("pathAttributionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.relative-date-range" => Some(("pathAttributionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.start-date" => Some(("pathAttributionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.dimension-name" => Some(("pathAttributionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.etag" => Some(("pathAttributionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.id" => Some(("pathAttributionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.kind" => Some(("pathAttributionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.match-type" => Some(("pathAttributionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.value" => Some(("pathAttributionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.metric-names" => Some(("pathAttributionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-criteria.custom-channel-grouping.fallback-name" => Some(("pathCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.kind" => Some(("pathCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.name" => Some(("pathCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.end-date" => Some(("pathCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.kind" => Some(("pathCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.relative-date-range" => Some(("pathCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.start-date" => Some(("pathCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.dimension-name" => Some(("pathCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.etag" => Some(("pathCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.id" => Some(("pathCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.kind" => Some(("pathCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.match-type" => Some(("pathCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.value" => Some(("pathCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.metric-names" => Some(("pathCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.date-range.end-date" => Some(("pathToConversionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.kind" => Some(("pathToConversionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.relative-date-range" => Some(("pathToConversionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.start-date" => Some(("pathToConversionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.dimension-name" => Some(("pathToConversionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.etag" => Some(("pathToConversionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.id" => Some(("pathToConversionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.kind" => Some(("pathToConversionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.match-type" => Some(("pathToConversionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.value" => Some(("pathToConversionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.metric-names" => Some(("pathToConversionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.report-properties.clicks-lookback-window" => Some(("pathToConversionCriteria.reportProperties.clicksLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.impressions-lookback-window" => Some(("pathToConversionCriteria.reportProperties.impressionsLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-attributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-click-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumClickInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-impression-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumImpressionInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-interaction-gap" => Some(("pathToConversionCriteria.reportProperties.maximumInteractionGap", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.pivot-on-interaction-path" => Some(("pathToConversionCriteria.reportProperties.pivotOnInteractionPath", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.kind" => Some(("reachCriteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.metric-names" => Some(("reachCriteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.custom-rich-media-events.kind" => Some(("reachCriteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.end-date" => Some(("reachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.kind" => Some(("reachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.relative-date-range" => Some(("reachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.start-date" => Some(("reachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.enable-all-dimension-combinations" => Some(("reachCriteria.enableAllDimensionCombinations", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.metric-names" => Some(("reachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.reach-by-frequency-metric-names" => Some(("reachCriteria.reachByFrequencyMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.active" => Some(("schedule.active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "schedule.every" => Some(("schedule.every", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "schedule.expiration-date" => Some(("schedule.expirationDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats" => Some(("schedule.repeats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats-on-week-days" => Some(("schedule.repeatsOnWeekDays", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.runs-on-day-of-month" => Some(("schedule.runsOnDayOfMonth", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.start-date" => Some(("schedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "sub-account-id" => Some(("subAccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "activities", "clicks-lookback-window", "criteria", "cross-dimension-reach-criteria", "custom-channel-grouping", "custom-rich-media-events", "date-range", "delivery", "dimension", "dimension-name", "email-owner", "email-owner-delivery-type", "enable-all-dimension-combinations", "end-date", "etag", "every", "expiration-date", "fallback-name", "file-name", "floodlight-config-id", "floodlight-criteria", "format", "id", "impressions-lookback-window", "include-attributed-ip-conversions", "include-unattributed-cookie-conversions", "include-unattributed-ip-conversions", "kind", "last-modified-time", "match-type", "maximum-click-interactions", "maximum-impression-interactions", "maximum-interaction-gap", "message", "metric-names", "name", "overlap-metric-names", "owner-profile-id", "path-attribution-criteria", "path-criteria", "path-to-conversion-criteria", "pivot-on-interaction-path", "pivoted", "reach-by-frequency-metric-names", "reach-criteria", "relative-date-range", "repeats", "repeats-on-week-days", "report-properties", "runs-on-day-of-month", "schedule", "start-date", "sub-account-id", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Report = json::value::from_value(object).unwrap();
        let mut call = self.hub.reports().patch(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_run(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.reports().run(opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                "synchronous" => {
                    call = call.synchronous(arg_from_str(value.unwrap_or("false"), err, "synchronous", "boolean"));
                },
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v.extend(["synchronous"].iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _reports_update(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cursor.to_string()[..] {
                    "account-id" => Some(("accountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.kind" => Some(("criteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.activities.metric-names" => Some(("criteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "criteria.custom-rich-media-events.kind" => Some(("criteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.end-date" => Some(("criteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.kind" => Some(("criteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.relative-date-range" => Some(("criteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.date-range.start-date" => Some(("criteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "criteria.metric-names" => Some(("criteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.date-range.end-date" => Some(("crossDimensionReachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.kind" => Some(("crossDimensionReachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.relative-date-range" => Some(("crossDimensionReachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.date-range.start-date" => Some(("crossDimensionReachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.dimension" => Some(("crossDimensionReachCriteria.dimension", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "cross-dimension-reach-criteria.metric-names" => Some(("crossDimensionReachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.overlap-metric-names" => Some(("crossDimensionReachCriteria.overlapMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "cross-dimension-reach-criteria.pivoted" => Some(("crossDimensionReachCriteria.pivoted", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner" => Some(("delivery.emailOwner", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "delivery.email-owner-delivery-type" => Some(("delivery.emailOwnerDeliveryType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "delivery.message" => Some(("delivery.message", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "etag" => Some(("etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "file-name" => Some(("fileName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.end-date" => Some(("floodlightCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.kind" => Some(("floodlightCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.relative-date-range" => Some(("floodlightCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.date-range.start-date" => Some(("floodlightCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.dimension-name" => Some(("floodlightCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.etag" => Some(("floodlightCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.id" => Some(("floodlightCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.kind" => Some(("floodlightCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.match-type" => Some(("floodlightCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.floodlight-config-id.value" => Some(("floodlightCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "floodlight-criteria.metric-names" => Some(("floodlightCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "floodlight-criteria.report-properties.include-attributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "floodlight-criteria.report-properties.include-unattributed-ip-conversions" => Some(("floodlightCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "format" => Some(("format", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "id" => Some(("id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "kind" => Some(("kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "last-modified-time" => Some(("lastModifiedTime", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "name" => Some(("name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "owner-profile-id" => Some(("ownerProfileId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.fallback-name" => Some(("pathAttributionCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.kind" => Some(("pathAttributionCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.custom-channel-grouping.name" => Some(("pathAttributionCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.end-date" => Some(("pathAttributionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.kind" => Some(("pathAttributionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.relative-date-range" => Some(("pathAttributionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.date-range.start-date" => Some(("pathAttributionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.dimension-name" => Some(("pathAttributionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.etag" => Some(("pathAttributionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.id" => Some(("pathAttributionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.kind" => Some(("pathAttributionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.match-type" => Some(("pathAttributionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.floodlight-config-id.value" => Some(("pathAttributionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-attribution-criteria.metric-names" => Some(("pathAttributionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-criteria.custom-channel-grouping.fallback-name" => Some(("pathCriteria.customChannelGrouping.fallbackName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.kind" => Some(("pathCriteria.customChannelGrouping.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.custom-channel-grouping.name" => Some(("pathCriteria.customChannelGrouping.name", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.end-date" => Some(("pathCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.kind" => Some(("pathCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.relative-date-range" => Some(("pathCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.date-range.start-date" => Some(("pathCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.dimension-name" => Some(("pathCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.etag" => Some(("pathCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.id" => Some(("pathCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.kind" => Some(("pathCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.match-type" => Some(("pathCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.floodlight-config-id.value" => Some(("pathCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-criteria.metric-names" => Some(("pathCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.date-range.end-date" => Some(("pathToConversionCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.kind" => Some(("pathToConversionCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.relative-date-range" => Some(("pathToConversionCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.date-range.start-date" => Some(("pathToConversionCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.dimension-name" => Some(("pathToConversionCriteria.floodlightConfigId.dimensionName", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.etag" => Some(("pathToConversionCriteria.floodlightConfigId.etag", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.id" => Some(("pathToConversionCriteria.floodlightConfigId.id", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.kind" => Some(("pathToConversionCriteria.floodlightConfigId.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.match-type" => Some(("pathToConversionCriteria.floodlightConfigId.matchType", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.floodlight-config-id.value" => Some(("pathToConversionCriteria.floodlightConfigId.value", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.metric-names" => Some(("pathToConversionCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "path-to-conversion-criteria.report-properties.clicks-lookback-window" => Some(("pathToConversionCriteria.reportProperties.clicksLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.impressions-lookback-window" => Some(("pathToConversionCriteria.reportProperties.impressionsLookbackWindow", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-attributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeAttributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-cookie-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedCookieConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.include-unattributed-ip-conversions" => Some(("pathToConversionCriteria.reportProperties.includeUnattributedIPConversions", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-click-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumClickInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-impression-interactions" => Some(("pathToConversionCriteria.reportProperties.maximumImpressionInteractions", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.maximum-interaction-gap" => Some(("pathToConversionCriteria.reportProperties.maximumInteractionGap", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "path-to-conversion-criteria.report-properties.pivot-on-interaction-path" => Some(("pathToConversionCriteria.reportProperties.pivotOnInteractionPath", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.kind" => Some(("reachCriteria.activities.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.activities.metric-names" => Some(("reachCriteria.activities.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.custom-rich-media-events.kind" => Some(("reachCriteria.customRichMediaEvents.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.end-date" => Some(("reachCriteria.dateRange.endDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.kind" => Some(("reachCriteria.dateRange.kind", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.relative-date-range" => Some(("reachCriteria.dateRange.relativeDateRange", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.date-range.start-date" => Some(("reachCriteria.dateRange.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "reach-criteria.enable-all-dimension-combinations" => Some(("reachCriteria.enableAllDimensionCombinations", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "reach-criteria.metric-names" => Some(("reachCriteria.metricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "reach-criteria.reach-by-frequency-metric-names" => Some(("reachCriteria.reachByFrequencyMetricNames", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.active" => Some(("schedule.active", JsonTypeInfo { jtype: JsonType::Boolean, ctype: ComplexType::Pod })),
                    "schedule.every" => Some(("schedule.every", JsonTypeInfo { jtype: JsonType::Int, ctype: ComplexType::Pod })),
                    "schedule.expiration-date" => Some(("schedule.expirationDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats" => Some(("schedule.repeats", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.repeats-on-week-days" => Some(("schedule.repeatsOnWeekDays", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Vec })),
                    "schedule.runs-on-day-of-month" => Some(("schedule.runsOnDayOfMonth", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "schedule.start-date" => Some(("schedule.startDate", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "sub-account-id" => Some(("subAccountId", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    "type" => Some(("type", JsonTypeInfo { jtype: JsonType::String, ctype: ComplexType::Pod })),
                    _ => {
                        let suggestion = FieldCursor::did_you_mean(key, &vec!["account-id", "active", "activities", "clicks-lookback-window", "criteria", "cross-dimension-reach-criteria", "custom-channel-grouping", "custom-rich-media-events", "date-range", "delivery", "dimension", "dimension-name", "email-owner", "email-owner-delivery-type", "enable-all-dimension-combinations", "end-date", "etag", "every", "expiration-date", "fallback-name", "file-name", "floodlight-config-id", "floodlight-criteria", "format", "id", "impressions-lookback-window", "include-attributed-ip-conversions", "include-unattributed-cookie-conversions", "include-unattributed-ip-conversions", "kind", "last-modified-time", "match-type", "maximum-click-interactions", "maximum-impression-interactions", "maximum-interaction-gap", "message", "metric-names", "name", "overlap-metric-names", "owner-profile-id", "path-attribution-criteria", "path-criteria", "path-to-conversion-criteria", "pivot-on-interaction-path", "pivoted", "reach-by-frequency-metric-names", "reach-criteria", "relative-date-range", "repeats", "repeats-on-week-days", "report-properties", "runs-on-day-of-month", "schedule", "start-date", "sub-account-id", "type", "value"]);
                        err.issues.push(CLIError::Field(FieldError::Unknown(temp_cursor.to_string(), suggestion, value.map(|v| v.to_string()))));
                        None
                    }
                };
            if let Some((field_cursor_str, type_info)) = type_info {
                FieldCursor::from(field_cursor_str).set_json_value(&mut object, value.unwrap(), type_info, err, &temp_cursor);
            }
        }
        let mut request: api::Report = json::value::from_value(object).unwrap();
        let mut call = self.hub.reports().update(request, opt.value_of("profile-id").unwrap_or(""), opt.value_of("report-id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _sites_get(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        let mut call = self.hub.sites().get(opt.value_of("profile-id").unwrap_or(""), opt.value_of("id").unwrap_or(""));
        for parg in opt.values_of("v").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let (key, value) = parse_kv_arg(&*parg, err, false);
            match key {
                _ => {
                    let mut found = false;
                    for param in &self.gp {
                        if key == *param {
                            found = true;
                            call = call.param(self.gpm.iter().find(|t| t.0 == key).unwrap_or(&("", key)).1, value.unwrap_or("unset"));
                            break;
                        }
                    }
                    if !found {
                        err.issues.push(CLIError::UnknownParameter(key.to_string(),
                                                                  {let mut v = Vec::new();
                                                                           v.extend(self.gp.iter().map(|v|*v));
                                                                           v } ));
                    }
                }
            }
        }
        let protocol = CallType::Standard;
        if dry_run {
            Ok(())
        } else {
            assert!(err.issues.len() == 0);
            for scope in self.opt.values_of("url").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
                call = call.add_scope(scope);
            }
            let mut ostream = match writer_from_opts(opt.value_of("out")) {
                Ok(mut f) => f,
                Err(io_err) => return Err(DoitError::IoError(opt.value_of("out").unwrap_or("-").to_string(), io_err)),
            };
            match match protocol {
                CallType::Standard => call.doit().await,
                _ => unreachable!()
            } {
                Err(api_err) => Err(DoitError::ApiError(api_err)),
                Ok((mut response, output_schema)) => {
                    let mut value = json::value::to_value(&output_schema).expect("serde to work");
                    remove_json_null_values(&mut value);
                    json::to_writer_pretty(&mut ostream, &value).unwrap();
                    ostream.flush().unwrap();
                    Ok(())
                }
            }
        }
    }

    async fn _sites_insert(&self, opt: &ArgMatches<'n>, dry_run: bool, err: &mut InvalidOptionsError)
                                                    -> Result<(), DoitError> {
        
        let mut field_cursor = FieldCursor::default();
        let mut object = json::value::Value::Object(Default::default());
        
        for kvarg in opt.values_of("kv").map(|i|i.collect()).unwrap_or(Vec::new()).iter() {
            let last_errc = err.issues.len();
            let (key, value) = parse_kv_arg(&*kvarg, err, false);
            let mut temp_cursor = field_cursor.clone();
            if let Err(field_err) = temp_cursor.set(&*key) {
                err.issues.push(field_err);
            }
            if value.is_none() {
                field_cursor = temp_cursor.clone();
                if err.issues.len() > last_errc {
                    err.issues.remove(last_errc);
                }
                continue;
            }
        
            let type_info: Option<(&'static str, JsonTypeInfo)> =
                match &temp_cur