<!---
DO NOT EDIT !
This file was generated automatically from 'src/mako/api/README.md.mako'
DO NOT EDIT !
-->
The `google-container1` library allows access to all features of the *Google Container* service.

This documentation was generated from *Container* crate version *3.0.0+20220215*, where *20220215* is the exact revision of the *container:v1* schema built by the [mako](http://www.makotemplates.org/) code generator *v3.0.0*.

Everything else about the *Container* *v1* API can be found at the
[official documentation site](https://cloud.google.com/container-engine/).
# Features

Handle the following *Resources* with ease from the central [hub](https://docs.rs/google-container1/3.0.0+20220215/google_container1/Container) ... 

* projects
 * [*aggregated usable subnetworks list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectAggregatedUsableSubnetworkListCall), [*locations clusters complete ip rotation*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterCompleteIpRotationCall), [*locations clusters create*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterCreateCall), [*locations clusters delete*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterDeleteCall), [*locations clusters get*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterGetCall), [*locations clusters get jwks*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterGetJwkCall), [*locations clusters list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterListCall), [*locations clusters node pools create*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolCreateCall), [*locations clusters node pools delete*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolDeleteCall), [*locations clusters node pools get*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolGetCall), [*locations clusters node pools list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolListCall), [*locations clusters node pools rollback*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolRollbackCall), [*locations clusters node pools set autoscaling*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolSetAutoscalingCall), [*locations clusters node pools set management*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolSetManagementCall), [*locations clusters node pools set size*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolSetSizeCall), [*locations clusters node pools update*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterNodePoolUpdateCall), [*locations clusters set addons*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetAddonCall), [*locations clusters set legacy abac*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetLegacyAbacCall), [*locations clusters set locations*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetLocationCall), [*locations clusters set logging*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetLoggingCall), [*locations clusters set maintenance policy*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetMaintenancePolicyCall), [*locations clusters set master auth*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetMasterAuthCall), [*locations clusters set monitoring*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetMonitoringCall), [*locations clusters set network policy*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetNetworkPolicyCall), [*locations clusters set resource labels*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterSetResourceLabelCall), [*locations clusters start ip rotation*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterStartIpRotationCall), [*locations clusters update*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterUpdateCall), [*locations clusters update master*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterUpdateMasterCall), [*locations clusters well-known get openid-configuration*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationClusterWellKnownGetOpenidConfigurationCall), [*locations get server config*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationGetServerConfigCall), [*locations operations cancel*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationOperationCancelCall), [*locations operations get*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationOperationGetCall), [*locations operations list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectLocationOperationListCall), [*zones clusters addons*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterAddonCall), [*zones clusters complete ip rotation*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterCompleteIpRotationCall), [*zones clusters create*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterCreateCall), [*zones clusters delete*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterDeleteCall), [*zones clusters get*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterGetCall), [*zones clusters legacy abac*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterLegacyAbacCall), [*zones clusters list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterListCall), [*zones clusters locations*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterLocationCall), [*zones clusters logging*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterLoggingCall), [*zones clusters master*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterMasterCall), [*zones clusters monitoring*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterMonitoringCall), [*zones clusters node pools autoscaling*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolAutoscalingCall), [*zones clusters node pools create*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolCreateCall), [*zones clusters node pools delete*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolDeleteCall), [*zones clusters node pools get*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolGetCall), [*zones clusters node pools list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolListCall), [*zones clusters node pools rollback*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolRollbackCall), [*zones clusters node pools set management*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolSetManagementCall), [*zones clusters node pools set size*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolSetSizeCall), [*zones clusters node pools update*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterNodePoolUpdateCall), [*zones clusters resource labels*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterResourceLabelCall), [*zones clusters set maintenance policy*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterSetMaintenancePolicyCall), [*zones clusters set master auth*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterSetMasterAuthCall), [*zones clusters set network policy*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterSetNetworkPolicyCall), [*zones clusters start ip rotation*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterStartIpRotationCall), [*zones clusters update*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneClusterUpdateCall), [*zones get serverconfig*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneGetServerconfigCall), [*zones operations cancel*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneOperationCancelCall), [*zones operations get*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneOperationGetCall) and [*zones operations list*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/api::ProjectZoneOperationListCall)




# Structure of this Library

The API is structured into the following primary items:

* **[Hub](https://docs.rs/google-container1/3.0.0+20220215/google_container1/Container)**
    * a central object to maintain state and allow accessing all *Activities*
    * creates [*Method Builders*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::MethodsBuilder) which in turn
      allow access to individual [*Call Builders*](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::CallBuilder)
* **[Resources](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Resource)**
    * primary types that you can apply *Activities* to
    * a collection of properties and *Parts*
    * **[Parts](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Part)**
        * a collection of properties
        * never directly used in *Activities*
* **[Activities](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::CallBuilder)**
    * operations to apply to *Resources*

All *structures* are marked with applicable traits to further categorize them and ease browsing.

Generally speaking, you can invoke *Activities* like this:

```Rust,ignore
let r = hub.resource().activity(...).doit().await
```

Or specifically ...

```ignore
let r = hub.projects().locations_clusters_node_pools_create(...).doit().await
let r = hub.projects().locations_clusters_node_pools_delete(...).doit().await
let r = hub.projects().locations_clusters_node_pools_rollback(...).doit().await
let r = hub.projects().locations_clusters_node_pools_set_autoscaling(...).doit().await
let r = hub.projects().locations_clusters_node_pools_set_management(...).doit().await
let r = hub.projects().locations_clusters_node_pools_set_size(...).doit().await
let r = hub.projects().locations_clusters_node_pools_update(...).doit().await
let r = hub.projects().locations_clusters_complete_ip_rotation(...).doit().await
let r = hub.projects().locations_clusters_create(...).doit().await
let r = hub.projects().locations_clusters_delete(...).doit().await
let r = hub.projects().locations_clusters_set_addons(...).doit().await
let r = hub.projects().locations_clusters_set_legacy_abac(...).doit().await
let r = hub.projects().locations_clusters_set_locations(...).doit().await
let r = hub.projects().locations_clusters_set_logging(...).doit().await
let r = hub.projects().locations_clusters_set_maintenance_policy(...).doit().await
let r = hub.projects().locations_clusters_set_master_auth(...).doit().await
let r = hub.projects().locations_clusters_set_monitoring(...).doit().await
let r = hub.projects().locations_clusters_set_network_policy(...).doit().await
let r = hub.projects().locations_clusters_set_resource_labels(...).doit().await
let r = hub.projects().locations_clusters_start_ip_rotation(...).doit().await
let r = hub.projects().locations_clusters_update(...).doit().await
let r = hub.projects().locations_clusters_update_master(...).doit().await
let r = hub.projects().locations_operations_get(...).doit().await
let r = hub.projects().zones_clusters_node_pools_autoscaling(...).doit().await
let r = hub.projects().zones_clusters_node_pools_create(...).doit().await
let r = hub.projects().zones_clusters_node_pools_delete(...).doit().await
let r = hub.projects().zones_clusters_node_pools_rollback(...).doit().await
let r = hub.projects().zones_clusters_node_pools_set_management(...).doit().await
let r = hub.projects().zones_clusters_node_pools_set_size(...).doit().await
let r = hub.projects().zones_clusters_node_pools_update(...).doit().await
let r = hub.projects().zones_clusters_addons(...).doit().await
let r = hub.projects().zones_clusters_complete_ip_rotation(...).doit().await
let r = hub.projects().zones_clusters_create(...).doit().await
let r = hub.projects().zones_clusters_delete(...).doit().await
let r = hub.projects().zones_clusters_legacy_abac(...).doit().await
let r = hub.projects().zones_clusters_locations(...).doit().await
let r = hub.projects().zones_clusters_logging(...).doit().await
let r = hub.projects().zones_clusters_master(...).doit().await
let r = hub.projects().zones_clusters_monitoring(...).doit().await
let r = hub.projects().zones_clusters_resource_labels(...).doit().await
let r = hub.projects().zones_clusters_set_maintenance_policy(...).doit().await
let r = hub.projects().zones_clusters_set_master_auth(...).doit().await
let r = hub.projects().zones_clusters_set_network_policy(...).doit().await
let r = hub.projects().zones_clusters_start_ip_rotation(...).doit().await
let r = hub.projects().zones_clusters_update(...).doit().await
let r = hub.projects().zones_operations_get(...).doit().await
```

The `resource()` and `activity(...)` calls create [builders][builder-pattern]. The second one dealing with `Activities` 
supports various methods to configure the impending operation (not shown here). It is made such that all required arguments have to be 
specified right away (i.e. `(...)`), whereas all optional ones can be [build up][builder-pattern] as desired.
The `doit()` method performs the actual communication with the server and returns the respective result.

# Usage

## Setting up your Project

To use this library, you would put the following lines into your `Cargo.toml` file:

```toml
[dependencies]
google-container1 = "*"
serde = "^1.0"
serde_json = "^1.0"
```

## A complete example

```Rust
extern crate hyper;
extern crate hyper_rustls;
extern crate google_container1 as container1;
use container1::{Result, Error};
use std::default::Default;
use container1::{Container, oauth2, hyper, hyper_rustls};

// Get an ApplicationSecret instance by some means. It contains the `client_id` and 
// `client_secret`, among other things.
let secret: oauth2::ApplicationSecret = Default::default();
// Instantiate the authenticator. It will choose a suitable authentication flow for you, 
// unless you replace  `None` with the desired Flow.
// Provide your own `AuthenticatorDelegate` to adjust the way it operates and get feedback about 
// what's going on. You probably want to bring in your own `TokenStorage` to persist tokens and
// retrieve them from storage.
let auth = oauth2::InstalledFlowAuthenticator::builder(
        secret,
        oauth2::InstalledFlowReturnMethod::HTTPRedirect,
    ).build().await.unwrap();
let mut hub = Container::new(hyper::Client::builder().build(hyper_rustls::HttpsConnector::with_native_roots()), auth);
// You can configure optional parameters by calling the respective setters at will, and
// execute the final call using `doit()`.
// Values shown here are possibly random and not representative !
let result = hub.projects().locations_clusters_node_pools_delete("name")
             .zone("magna")
             .project_id("no")
             .node_pool_id("ipsum")
             .cluster_id("voluptua.")
             .doit().await;

match result {
    Err(e) => match e {
        // The Error enum provides details about what exactly happened.
        // You can also just use its `Debug`, `Display` or `Error` traits
         Error::HttpError(_)
        |Error::Io(_)
        |Error::MissingAPIKey
        |Error::MissingToken(_)
        |Error::Cancelled
        |Error::UploadSizeLimitExceeded(_, _)
        |Error::Failure(_)
        |Error::BadRequest(_)
        |Error::FieldClash(_)
        |Error::JsonDecodeError(_, _) => println!("{}", e),
    },
    Ok(res) => println!("Success: {:?}", res),
}

```
## Handling Errors

All errors produced by the system are provided either as [Result](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Result) enumeration as return value of
the doit() methods, or handed as possibly intermediate results to either the 
[Hub Delegate](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Delegate), or the [Authenticator Delegate](https://docs.rs/yup-oauth2/*/yup_oauth2/trait.AuthenticatorDelegate.html).

When delegates handle errors or intermediate values, they may have a chance to instruct the system to retry. This 
makes the system potentially resilient to all kinds of errors.

## Uploads and Downloads
If a method supports downloads, the response body, which is part of the [Result](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Result), should be
read by you to obtain the media.
If such a method also supports a [Response Result](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::ResponseResult), it will return that by default.
You can see it as meta-data for the actual media. To trigger a media download, you will have to set up the builder by making
this call: `.param("alt", "media")`.

Methods supporting uploads can do so using up to 2 different protocols: 
*simple* and *resumable*. The distinctiveness of each is represented by customized 
`doit(...)` methods, which are then named `upload(...)` and `upload_resumable(...)` respectively.

## Customization and Callbacks

You may alter the way an `doit()` method is called by providing a [delegate](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Delegate) to the 
[Method Builder](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::CallBuilder) before making the final `doit()` call. 
Respective methods will be called to provide progress information, as well as determine whether the system should 
retry on failure.

The [delegate trait](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Delegate) is default-implemented, allowing you to customize it with minimal effort.

## Optional Parts in Server-Requests

All structures provided by this library are made to be [encodable](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::RequestValue) and 
[decodable](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::ResponseResult) via *json*. Optionals are used to indicate that partial requests are responses 
are valid.
Most optionals are are considered [Parts](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::Part) which are identifiable by name, which will be sent to 
the server to indicate either the set parts of the request or the desired parts in the response.

## Builder Arguments

Using [method builders](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::CallBuilder), you are able to prepare an action call by repeatedly calling it's methods.
These will always take a single argument, for which the following statements are true.

* [PODs][wiki-pod] are handed by copy
* strings are passed as `&str`
* [request values](https://docs.rs/google-container1/3.0.0+20220215/google_container1/client::RequestValue) are moved

Arguments will always be copied or cloned into the builder, to make them independent of their original life times.

[wiki-pod]: http://en.wikipedia.org/wiki/Plain_old_data_structure
[builder-pattern]: http://en.wikipedia.org/wiki/Builder_pattern
[google-go-api]: https://github.com/google/google-api-go-client

# License
The **container1** library was generated by Sebastian Thiel, and is placed 
under the *MIT* license.
You can read the full text at the repository's [license file][repo-license].

[repo-license]: https://github.com/Byron/google-apis-rsblob/main/LICENSE.md
