# google-cloud-spanner

Google Cloud Platform spanner library.

[![crates.io](https://img.shields.io/crates/v/google-cloud-spanner.svg)](https://crates.io/crates/google-cloud-spanner)

* [About Cloud Spanner](https://cloud.google.com/spanner/)
* [Spanner API Documentation](https://cloud.google.com/spanner/docs)
* [Rust client Documentation](https://docs.rs/google-cloud-spanner/latest)

## Installation

```
[dependencies]
google-cloud-spanner = <version>
```

## Quick Start

Create `Client` and call transaction API same as [Google Cloud Go](https://github.com/googleapis/google-cloud-go/tree/main/spanner).

```rust
 use google_cloud_spanner::client::Client;
 use google_cloud_spanner::mutation::insert;
 use google_cloud_spanner::statement::Statement;
 use google_cloud_spanner::reader::AsyncIterator;
 use google_cloud_spanner::value::CommitTimestamp;
 use google_cloud_spanner::client::RunInTxError;

 #[tokio::main]
 async fn main() -> Result<(), anyhow::Error> {

     const DATABASE: &str = "projects/local-project/instances/test-instance/databases/local-database";

     // Create spanner client
     let mut client = Client::new(DATABASE).await?;

     // Insert
     let mutation = insert("Guild", &["GuildId", "OwnerUserID", "UpdatedAt"], &[&"guildId", &"ownerId", &CommitTimestamp::new()]);
     let commit_timestamp = client.apply(vec![mutation]).await?;

     // Read with query
     let mut stmt = Statement::new("SELECT GuildId FROM Guild WHERE OwnerUserID = @OwnerUserID");
     stmt.add_param("OwnerUserID",&"ownerId");
     let mut tx = client.single().await?;
     let mut iter = tx.query(stmt).await?;
     while let Some(row) = iter.next(None).await? {
         let guild_id = row.column_by_name::<String>("GuildId");
     }
     Ok(())
 }
```

## Example
Here is the example with using Warp.
* https://github.com/yoshidan/google-cloud-rust-example/tree/main/spanner/rust

## Performance 

Result of the 24 hours Load Test.

| Metrics | This library | [Google Cloud Go](https://github.com/googleapis/google-cloud-go/tree/main/spanner) | 
| -------- | ----------------| ----------------- |
| RPS | 438.4 | 443.4 |
| Used vCPU | 0.37 ~ 0.42 | 0.65 ~ 0.70 |

* This Library : [Performance report](https://storage.googleapis.com/0432808zbaeatxa/report_1637760853.008414.html) / [CPU Usage](https://storage.googleapis.com/0432808zbaeatxa/CPU%20(6).png)
* Google Cloud Go : [Performance report](https://storage.googleapis.com/0432808zbaeatxa/report_1637673736.2540932.html) / [CPU Usage](https://storage.googleapis.com/0432808zbaeatxa/CPU%20(5).png)

Test condition 
* 2.0 vCPU GKE Autopilot Pod
* 1 Node spanner database server
* 100 Users
* [Here](https://github.com/yoshidan/google-cloud-rust-example/tree/main/spanner) is the application for Load Test.