#!/bin/bash
#
# This will update the grpc crates, and then scan the `src` directory and
# remove all auto-generated rust files.
# The `mod.rs` & `lib.rs` files are NOT generated by `generate.sh`
#
cargo install grpcio-compiler
cargo install protobuf-codegen
find src -name "*.rs" -and -not \( -name "mod.rs" -or -name "lib.rs" \) -print -delete
echo "REMEMBER to: "
echo " [ ] update 'src/lib.rs' _PROTOBUF_VERSION_CHECK to the latest version number"
echo " [ ] update 'grpcio' and 'protobuf' versions in './Cargo.toml' & '../googleapis/Cargo.toml' "
echo " [ ] run 'generate.sh' to generate the rust files. "