/// Configures which glossary should be used for a specific target language,
/// and defines options for applying that glossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TranslateTextGlossaryConfig {
    /// Required. The `glossary` to be applied for this translation.
    ///
    /// The format depends on glossary:
    ///
    /// - User provided custom glossary:
    ///   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
    #[prost(string, tag="1")]
    pub glossary: ::prost::alloc::string::String,
    /// Optional. Indicates match is case-insensitive.
    /// Default value is false if missing.
    #[prost(bool, tag="2")]
    pub ignore_case: bool,
}
/// The request message for synchronous translation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TranslateTextRequest {
    /// Required. The content of the input in string format.
    /// We recommend the total content be less than 30k codepoints. The max length
    /// of this field is 1024.
    /// Use BatchTranslateText for larger text.
    #[prost(string, repeated, tag="1")]
    pub contents: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. The format of the source text, for example, "text/html",
    ///  "text/plain". If left blank, the MIME type defaults to "text/html".
    #[prost(string, tag="3")]
    pub mime_type: ::prost::alloc::string::String,
    /// Optional. The BCP-47 language code of the input text if
    /// known, for example, "en-US" or "sr-Latn". Supported language codes are
    /// listed in Language Support. If the source language isn't specified, the API
    /// attempts to identify the source language automatically and returns the
    /// source language within the response.
    #[prost(string, tag="4")]
    pub source_language_code: ::prost::alloc::string::String,
    /// Required. The BCP-47 language code to use for translation of the input
    /// text, set to one of the language codes listed in Language Support.
    #[prost(string, tag="5")]
    pub target_language_code: ::prost::alloc::string::String,
    /// Required. Project or location to make a call. Must refer to a caller's
    /// project.
    ///
    /// Format: `projects/{project-number-or-id}` or
    /// `projects/{project-number-or-id}/locations/{location-id}`.
    ///
    /// For global calls, use `projects/{project-number-or-id}/locations/global` or
    /// `projects/{project-number-or-id}`.
    ///
    /// Non-global location is required for requests using AutoML models or
    /// custom glossaries.
    ///
    /// Models and glossaries must be within the same region (have same
    /// location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
    #[prost(string, tag="8")]
    pub parent: ::prost::alloc::string::String,
    /// Optional. The `model` type requested for this translation.
    ///
    /// The format depends on model type:
    ///
    /// - AutoML Translation models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
    ///
    /// - General (built-in) models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
    ///
    ///
    /// For global (non-regionalized) requests, use `location-id` `global`.
    /// For example,
    /// `projects/{project-number-or-id}/locations/global/models/general/nmt`.
    ///
    /// If not provided, the default Google model (NMT) will be used.
    #[prost(string, tag="6")]
    pub model: ::prost::alloc::string::String,
    /// Optional. Glossary to be applied. The glossary must be
    /// within the same region (have the same location-id) as the model, otherwise
    /// an INVALID_ARGUMENT (400) error is returned.
    #[prost(message, optional, tag="7")]
    pub glossary_config: ::core::option::Option<TranslateTextGlossaryConfig>,
    /// Optional. The labels with user-defined metadata for the request.
    ///
    /// Label keys and values can be no longer than 63 characters
    /// (Unicode codepoints), can only contain lowercase letters, numeric
    /// characters, underscores and dashes. International characters are allowed.
    /// Label values are optional. Label keys must start with a letter.
    ///
    /// See <https://cloud.google.com/translate/docs/advanced/labels> for more
    /// information.
    #[prost(btree_map="string, string", tag="10")]
    pub labels: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TranslateTextResponse {
    /// Text translation responses with no glossary applied.
    /// This field has the same length as
    /// \[`contents`][google.cloud.translation.v3.TranslateTextRequest.contents\].
    #[prost(message, repeated, tag="1")]
    pub translations: ::prost::alloc::vec::Vec<Translation>,
    /// Text translation responses if a glossary is provided in the request.
    /// This can be the same as
    /// \[`translations`][google.cloud.translation.v3.TranslateTextResponse.translations\]
    /// if no terms apply. This field has the same length as
    /// \[`contents`][google.cloud.translation.v3.TranslateTextRequest.contents\].
    #[prost(message, repeated, tag="3")]
    pub glossary_translations: ::prost::alloc::vec::Vec<Translation>,
}
/// A single translation response.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Translation {
    /// Text translated into the target language.
    /// If an error occurs during translation, this field might be excluded from
    /// the response.
    #[prost(string, tag="1")]
    pub translated_text: ::prost::alloc::string::String,
    /// Only present when `model` is present in the request.
    /// `model` here is normalized to have project number.
    ///
    /// For example:
    /// If the `model` requested in TranslationTextRequest is
    /// `projects/{project-id}/locations/{location-id}/models/general/nmt` then
    /// `model` here would be normalized to
    /// `projects/{project-number}/locations/{location-id}/models/general/nmt`.
    #[prost(string, tag="2")]
    pub model: ::prost::alloc::string::String,
    /// The BCP-47 language code of source text in the initial request, detected
    /// automatically, if no source language was passed within the initial
    /// request. If the source language was passed, auto-detection of the language
    /// does not occur and this field is empty.
    #[prost(string, tag="4")]
    pub detected_language_code: ::prost::alloc::string::String,
    /// The `glossary_config` used for this translation.
    #[prost(message, optional, tag="3")]
    pub glossary_config: ::core::option::Option<TranslateTextGlossaryConfig>,
}
/// The request message for language detection.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DetectLanguageRequest {
    /// Required. Project or location to make a call. Must refer to a caller's
    /// project.
    ///
    /// Format: `projects/{project-number-or-id}/locations/{location-id}` or
    /// `projects/{project-number-or-id}`.
    ///
    /// For global calls, use `projects/{project-number-or-id}/locations/global` or
    /// `projects/{project-number-or-id}`.
    ///
    /// Only models within the same region (has same location-id) can be used.
    /// Otherwise an INVALID_ARGUMENT (400) error is returned.
    #[prost(string, tag="5")]
    pub parent: ::prost::alloc::string::String,
    /// Optional. The language detection model to be used.
    ///
    /// Format:
    /// `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/{model-id}`
    ///
    /// Only one language detection model is currently supported:
    /// `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/default`.
    ///
    /// If not specified, the default model is used.
    #[prost(string, tag="4")]
    pub model: ::prost::alloc::string::String,
    /// Optional. The format of the source text, for example, "text/html",
    /// "text/plain". If left blank, the MIME type defaults to "text/html".
    #[prost(string, tag="3")]
    pub mime_type: ::prost::alloc::string::String,
    /// Optional. The labels with user-defined metadata for the request.
    ///
    /// Label keys and values can be no longer than 63 characters
    /// (Unicode codepoints), can only contain lowercase letters, numeric
    /// characters, underscores and dashes. International characters are allowed.
    /// Label values are optional. Label keys must start with a letter.
    ///
    /// See <https://cloud.google.com/translate/docs/advanced/labels> for more
    /// information.
    #[prost(btree_map="string, string", tag="6")]
    pub labels: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    /// Required. The source of the document from which to detect the language.
    #[prost(oneof="detect_language_request::Source", tags="1")]
    pub source: ::core::option::Option<detect_language_request::Source>,
}
/// Nested message and enum types in `DetectLanguageRequest`.
pub mod detect_language_request {
    /// Required. The source of the document from which to detect the language.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Source {
        /// The content of the input stored as a string.
        #[prost(string, tag="1")]
        Content(::prost::alloc::string::String),
    }
}
/// The response message for language detection.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DetectedLanguage {
    /// The BCP-47 language code of source content in the request, detected
    /// automatically.
    #[prost(string, tag="1")]
    pub language_code: ::prost::alloc::string::String,
    /// The confidence of the detection result for this language.
    #[prost(float, tag="2")]
    pub confidence: f32,
}
/// The response message for language detection.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DetectLanguageResponse {
    /// The most probable language detected by the Translation API. For each
    /// request, the Translation API will always return only one result.
    #[prost(message, repeated, tag="1")]
    pub languages: ::prost::alloc::vec::Vec<DetectedLanguage>,
}
/// The request message for discovering supported languages.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSupportedLanguagesRequest {
    /// Required. Project or location to make a call. Must refer to a caller's
    /// project.
    ///
    /// Format: `projects/{project-number-or-id}` or
    /// `projects/{project-number-or-id}/locations/{location-id}`.
    ///
    /// For global calls, use `projects/{project-number-or-id}/locations/global` or
    /// `projects/{project-number-or-id}`.
    ///
    /// Non-global location is required for AutoML models.
    ///
    /// Only models within the same region (have same location-id) can be used,
    /// otherwise an INVALID_ARGUMENT (400) error is returned.
    #[prost(string, tag="3")]
    pub parent: ::prost::alloc::string::String,
    /// Optional. The language to use to return localized, human readable names
    /// of supported languages. If missing, then display names are not returned
    /// in a response.
    #[prost(string, tag="1")]
    pub display_language_code: ::prost::alloc::string::String,
    /// Optional. Get supported languages of this model.
    ///
    /// The format depends on model type:
    ///
    /// - AutoML Translation models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
    ///
    /// - General (built-in) models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
    ///
    ///
    /// Returns languages supported by the specified model.
    /// If missing, we get supported languages of Google general NMT model.
    #[prost(string, tag="2")]
    pub model: ::prost::alloc::string::String,
}
/// The response message for discovering supported languages.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SupportedLanguages {
    /// A list of supported language responses. This list contains an entry
    /// for each language the Translation API supports.
    #[prost(message, repeated, tag="1")]
    pub languages: ::prost::alloc::vec::Vec<SupportedLanguage>,
}
/// A single supported language response corresponds to information related
/// to one supported language.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SupportedLanguage {
    /// Supported language code, generally consisting of its ISO 639-1
    /// identifier, for example, 'en', 'ja'. In certain cases, BCP-47 codes
    /// including language and region identifiers are returned (for example,
    /// 'zh-TW' and 'zh-CN')
    #[prost(string, tag="1")]
    pub language_code: ::prost::alloc::string::String,
    /// Human readable name of the language localized in the display language
    /// specified in the request.
    #[prost(string, tag="2")]
    pub display_name: ::prost::alloc::string::String,
    /// Can be used as source language.
    #[prost(bool, tag="3")]
    pub support_source: bool,
    /// Can be used as target language.
    #[prost(bool, tag="4")]
    pub support_target: bool,
}
/// The Google Cloud Storage location for the input content.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GcsSource {
    /// Required. Source data URI. For example, `gs://my_bucket/my_object`.
    #[prost(string, tag="1")]
    pub input_uri: ::prost::alloc::string::String,
}
/// Input configuration for BatchTranslateText request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InputConfig {
    /// Optional. Can be "text/plain" or "text/html".
    /// For `.tsv`, "text/html" is used if mime_type is missing.
    /// For `.html`, this field must be "text/html" or empty.
    /// For `.txt`, this field must be "text/plain" or empty.
    #[prost(string, tag="1")]
    pub mime_type: ::prost::alloc::string::String,
    /// Required. Specify the input.
    #[prost(oneof="input_config::Source", tags="2")]
    pub source: ::core::option::Option<input_config::Source>,
}
/// Nested message and enum types in `InputConfig`.
pub mod input_config {
    /// Required. Specify the input.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Source {
        /// Required. Google Cloud Storage location for the source input.
        /// This can be a single file (for example,
        /// `gs://translation-test/input.tsv`) or a wildcard (for example,
        /// `gs://translation-test/*`). If a file extension is `.tsv`, it can
        /// contain either one or two columns. The first column (optional) is the id
        /// of the text request. If the first column is missing, we use the row
        /// number (0-based) from the input file as the ID in the output file. The
        /// second column is the actual text to be
        ///  translated. We recommend each row be <= 10K Unicode codepoints,
        /// otherwise an error might be returned.
        /// Note that the input tsv must be RFC 4180 compliant.
        ///
        /// You could use <https://github.com/Clever/csvlint> to check potential
        /// formatting errors in your tsv file.
        /// csvlint --delimiter='\t' your_input_file.tsv
        ///
        /// The other supported file extensions are `.txt` or `.html`, which is
        /// treated as a single large chunk of text.
        #[prost(message, tag="2")]
        GcsSource(super::GcsSource),
    }
}
/// The Google Cloud Storage location for the output content.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GcsDestination {
    /// Required. The bucket used in 'output_uri_prefix' must exist and there must
    /// be no files under 'output_uri_prefix'. 'output_uri_prefix' must end with
    /// "/" and start with "gs://". One 'output_uri_prefix' can only be used by one
    /// batch translation job at a time. Otherwise an INVALID_ARGUMENT (400) error
    /// is returned.
    #[prost(string, tag="1")]
    pub output_uri_prefix: ::prost::alloc::string::String,
}
/// Output configuration for BatchTranslateText request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OutputConfig {
    /// Required. The destination of output.
    #[prost(oneof="output_config::Destination", tags="1")]
    pub destination: ::core::option::Option<output_config::Destination>,
}
/// Nested message and enum types in `OutputConfig`.
pub mod output_config {
    /// Required. The destination of output.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Destination {
        /// Google Cloud Storage destination for output content.
        /// For every single input file (for example, gs://a/b/c.\[extension\]), we
        /// generate at most 2 * n output files. (n is the # of target_language_codes
        /// in the BatchTranslateTextRequest).
        ///
        /// Output files (tsv) generated are compliant with RFC 4180 except that
        /// record delimiters are '\n' instead of '\r\n'. We don't provide any way to
        /// change record delimiters.
        ///
        /// While the input files are being processed, we write/update an index file
        /// 'index.csv'  under 'output_uri_prefix' (for example,
        /// gs://translation-test/index.csv) The index file is generated/updated as
        /// new files are being translated. The format is:
        ///
        /// input_file,target_language_code,translations_file,errors_file,
        /// glossary_translations_file,glossary_errors_file
        ///
        /// input_file is one file we matched using gcs_source.input_uri.
        /// target_language_code is provided in the request.
        /// translations_file contains the translations. (details provided below)
        /// errors_file contains the errors during processing of the file. (details
        /// below). Both translations_file and errors_file could be empty
        /// strings if we have no content to output.
        /// glossary_translations_file and glossary_errors_file are always empty
        /// strings if the input_file is tsv. They could also be empty if we have no
        /// content to output.
        ///
        /// Once a row is present in index.csv, the input/output matching never
        /// changes. Callers should also expect all the content in input_file are
        /// processed and ready to be consumed (that is, no partial output file is
        /// written).
        ///
        /// Since index.csv will be keeping updated during the process, please make
        /// sure there is no custom retention policy applied on the output bucket
        /// that may avoid file updating.
        /// (<https://cloud.google.com/storage/docs/bucket-lock?hl=en#retention-policy>)
        ///
        /// The format of translations_file (for target language code 'trg') is:
        /// gs://translation_test/a_b_c_'trg'_translations.\[extension\]
        ///
        /// If the input file extension is tsv, the output has the following
        /// columns:
        /// Column 1: ID of the request provided in the input, if it's not
        /// provided in the input, then the input row number is used (0-based).
        /// Column 2: source sentence.
        /// Column 3: translation without applying a glossary. Empty string if there
        /// is an error.
        /// Column 4 (only present if a glossary is provided in the request):
        /// translation after applying the glossary. Empty string if there is an
        /// error applying the glossary. Could be same string as column 3 if there is
        /// no glossary applied.
        ///
        /// If input file extension is a txt or html, the translation is directly
        /// written to the output file. If glossary is requested, a separate
        /// glossary_translations_file has format of
        /// gs://translation_test/a_b_c_'trg'_glossary_translations.\[extension\]
        ///
        /// The format of errors file (for target language code 'trg') is:
        /// gs://translation_test/a_b_c_'trg'_errors.\[extension\]
        ///
        /// If the input file extension is tsv, errors_file contains the following:
        /// Column 1: ID of the request provided in the input, if it's not
        /// provided in the input, then the input row number is used (0-based).
        /// Column 2: source sentence.
        /// Column 3: Error detail for the translation. Could be empty.
        /// Column 4 (only present if a glossary is provided in the request):
        /// Error when applying the glossary.
        ///
        /// If the input file extension is txt or html, glossary_error_file will be
        /// generated that contains error details. glossary_error_file has format of
        /// gs://translation_test/a_b_c_'trg'_glossary_errors.\[extension\]
        #[prost(message, tag="1")]
        GcsDestination(super::GcsDestination),
    }
}
/// A document translation request input config.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DocumentInputConfig {
    /// Specifies the input document's mime_type.
    ///
    /// If not specified it will be determined using the file extension for
    /// gcs_source provided files. For a file provided through bytes content the
    /// mime_type must be provided.
    /// Currently supported mime types are:
    /// - application/pdf
    /// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
    /// - application/vnd.openxmlformats-officedocument.presentationml.presentation
    /// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
    #[prost(string, tag="4")]
    pub mime_type: ::prost::alloc::string::String,
    /// Specifies the source for the document's content.
    /// The input file size should be <= 20MB for
    /// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
    /// - application/vnd.openxmlformats-officedocument.presentationml.presentation
    /// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
    /// The input file size should be <= 20MB and the maximum page limit is 20 for
    /// - application/pdf
    #[prost(oneof="document_input_config::Source", tags="1, 2")]
    pub source: ::core::option::Option<document_input_config::Source>,
}
/// Nested message and enum types in `DocumentInputConfig`.
pub mod document_input_config {
    /// Specifies the source for the document's content.
    /// The input file size should be <= 20MB for
    /// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
    /// - application/vnd.openxmlformats-officedocument.presentationml.presentation
    /// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
    /// The input file size should be <= 20MB and the maximum page limit is 20 for
    /// - application/pdf
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Source {
        /// Document's content represented as a stream of bytes.
        #[prost(bytes, tag="1")]
        Content(::prost::bytes::Bytes),
        /// Google Cloud Storage location. This must be a single file.
        /// For example: gs://example_bucket/example_file.pdf
        #[prost(message, tag="2")]
        GcsSource(super::GcsSource),
    }
}
/// A document translation request output config.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DocumentOutputConfig {
    /// Optional. Specifies the translated document's mime_type.
    /// If not specified, the translated file's mime type will be the same as the
    /// input file's mime type.
    /// Currently only support the output mime type to be the same as input mime
    /// type.
    /// - application/pdf
    /// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
    /// - application/vnd.openxmlformats-officedocument.presentationml.presentation
    /// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
    #[prost(string, tag="3")]
    pub mime_type: ::prost::alloc::string::String,
    /// A URI destination for the translated document.
    /// It is optional to provide a destination. If provided the results from
    /// TranslateDocument will be stored in the destination.
    /// Whether a destination is provided or not, the translated documents will be
    /// returned within TranslateDocumentResponse.document_translation and
    /// TranslateDocumentResponse.glossary_document_translation.
    #[prost(oneof="document_output_config::Destination", tags="1")]
    pub destination: ::core::option::Option<document_output_config::Destination>,
}
/// Nested message and enum types in `DocumentOutputConfig`.
pub mod document_output_config {
    /// A URI destination for the translated document.
    /// It is optional to provide a destination. If provided the results from
    /// TranslateDocument will be stored in the destination.
    /// Whether a destination is provided or not, the translated documents will be
    /// returned within TranslateDocumentResponse.document_translation and
    /// TranslateDocumentResponse.glossary_document_translation.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Destination {
        /// Optional. Google Cloud Storage destination for the translation output,
        /// e.g., `gs://my_bucket/my_directory/`.
        ///
        /// The destination directory provided does not have to be empty, but the
        /// bucket must exist. If a file with the same name as the output file
        /// already exists in the destination an error will be returned.
        ///
        /// For a DocumentInputConfig.contents provided document, the output file
        /// will have the name "output_\[trg]_translations.[ext\]", where
        /// - \[trg\] corresponds to the translated file's language code,
        /// - \[ext\] corresponds to the translated file's extension according to its
        /// mime type.
        ///
        ///
        /// For a DocumentInputConfig.gcs_uri provided document, the output file will
        /// have a name according to its URI. For example: an input file with URI:
        /// "gs://a/b/c.\[extension\]" stored in a gcs_destination bucket with name
        /// "my_bucket" will have an output URI:
        /// "gs://my_bucket/a_b_c_\[trg]_translations.[ext\]", where
        /// - \[trg\] corresponds to the translated file's language code,
        /// - \[ext\] corresponds to the translated file's extension according to its
        /// mime type.
        ///
        ///
        /// If the document was directly provided through the request, then the
        /// output document will have the format:
        /// "gs://my_bucket/translated_document_\[trg]_translations.[ext\], where
        /// - \[trg\] corresponds to the translated file's language code,
        /// - \[ext\] corresponds to the translated file's extension according to its
        /// mime type.
        ///
        /// If a glossary was provided, then the output URI for the glossary
        /// translation will be equal to the default output URI but have
        /// `glossary_translations` instead of `translations`. For the previous
        /// example, its glossary URI would be:
        /// "gs://my_bucket/a_b_c_\[trg]_glossary_translations.[ext\]".
        ///
        /// Thus the max number of output files will be 2 (Translated document,
        /// Glossary translated document).
        ///
        /// Callers should expect no partial outputs. If there is any error during
        /// document translation, no output will be stored in the Cloud Storage
        /// bucket.
        #[prost(message, tag="1")]
        GcsDestination(super::GcsDestination),
    }
}
/// A document translation request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TranslateDocumentRequest {
    /// Required. Location to make a regional call.
    ///
    /// Format: `projects/{project-number-or-id}/locations/{location-id}`.
    ///
    /// For global calls, use `projects/{project-number-or-id}/locations/global` or
    /// `projects/{project-number-or-id}`.
    ///
    /// Non-global location is required for requests using AutoML models or custom
    /// glossaries.
    ///
    /// Models and glossaries must be within the same region (have the same
    /// location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
    #[prost(string, tag="1")]
    pub parent: ::prost::alloc::string::String,
    /// Optional. The BCP-47 language code of the input document if known, for
    /// example, "en-US" or "sr-Latn". Supported language codes are listed in
    /// Language Support. If the source language isn't specified, the API attempts
    /// to identify the source language automatically and returns the source
    /// language within the response. Source language must be specified if the
    /// request contains a glossary or a custom model.
    #[prost(string, tag="2")]
    pub source_language_code: ::prost::alloc::string::String,
    /// Required. The BCP-47 language code to use for translation of the input
    /// document, set to one of the language codes listed in Language Support.
    #[prost(string, tag="3")]
    pub target_language_code: ::prost::alloc::string::String,
    /// Required. Input configurations.
    #[prost(message, optional, tag="4")]
    pub document_input_config: ::core::option::Option<DocumentInputConfig>,
    /// Optional. Output configurations.
    /// Defines if the output file should be stored within Cloud Storage as well
    /// as the desired output format. If not provided the translated file will
    /// only be returned through a byte-stream and its output mime type will be
    /// the same as the input file's mime type.
    #[prost(message, optional, tag="5")]
    pub document_output_config: ::core::option::Option<DocumentOutputConfig>,
    /// Optional. The `model` type requested for this translation.
    ///
    /// The format depends on model type:
    ///
    /// - AutoML Translation models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
    ///
    /// - General (built-in) models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
    ///
    ///
    /// If not provided, the default Google model (NMT) will be used for
    /// translation.
    #[prost(string, tag="6")]
    pub model: ::prost::alloc::string::String,
    /// Optional. Glossary to be applied. The glossary must be within the same
    /// region (have the same location-id) as the model, otherwise an
    /// INVALID_ARGUMENT (400) error is returned.
    #[prost(message, optional, tag="7")]
    pub glossary_config: ::core::option::Option<TranslateTextGlossaryConfig>,
    /// Optional. The labels with user-defined metadata for the request.
    ///
    /// Label keys and values can be no longer than 63 characters (Unicode
    /// codepoints), can only contain lowercase letters, numeric characters,
    /// underscores and dashes. International characters are allowed. Label values
    /// are optional. Label keys must start with a letter.
    ///
    /// See <https://cloud.google.com/translate/docs/advanced/labels> for more
    /// information.
    #[prost(btree_map="string, string", tag="8")]
    pub labels: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
/// A translated document message.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DocumentTranslation {
    /// The array of translated documents. It is expected to be size 1 for now. We
    /// may produce multiple translated documents in the future for other type of
    /// file formats.
    #[prost(bytes="bytes", repeated, tag="1")]
    pub byte_stream_outputs: ::prost::alloc::vec::Vec<::prost::bytes::Bytes>,
    /// The translated document's mime type.
    #[prost(string, tag="2")]
    pub mime_type: ::prost::alloc::string::String,
    /// The detected language for the input document.
    /// If the user did not provide the source language for the input document,
    /// this field will have the language code automatically detected. If the
    /// source language was passed, auto-detection of the language does not occur
    /// and this field is empty.
    #[prost(string, tag="3")]
    pub detected_language_code: ::prost::alloc::string::String,
}
/// A translated document response message.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TranslateDocumentResponse {
    /// Translated document.
    #[prost(message, optional, tag="1")]
    pub document_translation: ::core::option::Option<DocumentTranslation>,
    /// The document's translation output if a glossary is provided in the request.
    /// This can be the same as \[TranslateDocumentResponse.document_translation\]
    /// if no glossary terms apply.
    #[prost(message, optional, tag="2")]
    pub glossary_document_translation: ::core::option::Option<DocumentTranslation>,
    /// Only present when 'model' is present in the request.
    /// 'model' is normalized to have a project number.
    ///
    /// For example:
    /// If the 'model' field in TranslateDocumentRequest is:
    /// `projects/{project-id}/locations/{location-id}/models/general/nmt` then
    /// `model` here would be normalized to
    /// `projects/{project-number}/locations/{location-id}/models/general/nmt`.
    #[prost(string, tag="3")]
    pub model: ::prost::alloc::string::String,
    /// The `glossary_config` used for this translation.
    #[prost(message, optional, tag="4")]
    pub glossary_config: ::core::option::Option<TranslateTextGlossaryConfig>,
}
/// The batch translation request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchTranslateTextRequest {
    /// Required. Location to make a call. Must refer to a caller's project.
    ///
    /// Format: `projects/{project-number-or-id}/locations/{location-id}`.
    ///
    /// The `global` location is not supported for batch translation.
    ///
    /// Only AutoML Translation models or glossaries within the same region (have
    /// the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
    /// error is returned.
    #[prost(string, tag="1")]
    pub parent: ::prost::alloc::string::String,
    /// Required. Source language code.
    #[prost(string, tag="2")]
    pub source_language_code: ::prost::alloc::string::String,
    /// Required. Specify up to 10 language codes here.
    #[prost(string, repeated, tag="3")]
    pub target_language_codes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. The models to use for translation. Map's key is target language
    /// code. Map's value is model name. Value can be a built-in general model,
    /// or an AutoML Translation model.
    ///
    /// The value format depends on model type:
    ///
    /// - AutoML Translation models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
    ///
    /// - General (built-in) models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
    ///
    ///
    /// If the map is empty or a specific model is
    /// not requested for a language pair, then default google model (nmt) is used.
    #[prost(btree_map="string, string", tag="4")]
    pub models: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    /// Required. Input configurations.
    /// The total number of files matched should be <= 100.
    /// The total content size should be <= 100M Unicode codepoints.
    /// The files must use UTF-8 encoding.
    #[prost(message, repeated, tag="5")]
    pub input_configs: ::prost::alloc::vec::Vec<InputConfig>,
    /// Required. Output configuration.
    /// If 2 input configs match to the same file (that is, same input path),
    /// we don't generate output for duplicate inputs.
    #[prost(message, optional, tag="6")]
    pub output_config: ::core::option::Option<OutputConfig>,
    /// Optional. Glossaries to be applied for translation.
    /// It's keyed by target language code.
    #[prost(btree_map="string, message", tag="7")]
    pub glossaries: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, TranslateTextGlossaryConfig>,
    /// Optional. The labels with user-defined metadata for the request.
    ///
    /// Label keys and values can be no longer than 63 characters
    /// (Unicode codepoints), can only contain lowercase letters, numeric
    /// characters, underscores and dashes. International characters are allowed.
    /// Label values are optional. Label keys must start with a letter.
    ///
    /// See <https://cloud.google.com/translate/docs/advanced/labels> for more
    /// information.
    #[prost(btree_map="string, string", tag="9")]
    pub labels: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
/// State metadata for the batch translation operation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchTranslateMetadata {
    /// The state of the operation.
    #[prost(enumeration="batch_translate_metadata::State", tag="1")]
    pub state: i32,
    /// Number of successfully translated characters so far (Unicode codepoints).
    #[prost(int64, tag="2")]
    pub translated_characters: i64,
    /// Number of characters that have failed to process so far (Unicode
    /// codepoints).
    #[prost(int64, tag="3")]
    pub failed_characters: i64,
    /// Total number of characters (Unicode codepoints).
    /// This is the total number of codepoints from input files times the number of
    /// target languages and appears here shortly after the call is submitted.
    #[prost(int64, tag="4")]
    pub total_characters: i64,
    /// Time when the operation was submitted.
    #[prost(message, optional, tag="5")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// Nested message and enum types in `BatchTranslateMetadata`.
pub mod batch_translate_metadata {
    /// State of the job.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// Invalid.
        Unspecified = 0,
        /// Request is being processed.
        Running = 1,
        /// The batch is processed, and at least one item was successfully
        /// processed.
        Succeeded = 2,
        /// The batch is done and no item was successfully processed.
        Failed = 3,
        /// Request is in the process of being canceled after caller invoked
        /// longrunning.Operations.CancelOperation on the request id.
        Cancelling = 4,
        /// The batch is done after the user has called the
        /// longrunning.Operations.CancelOperation. Any records processed before the
        /// cancel command are output as specified in the request.
        Cancelled = 5,
    }
}
/// Stored in the
/// \[google.longrunning.Operation.response][google.longrunning.Operation.response\]
/// field returned by BatchTranslateText if at least one sentence is translated
/// successfully.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchTranslateResponse {
    /// Total number of characters (Unicode codepoints).
    #[prost(int64, tag="1")]
    pub total_characters: i64,
    /// Number of successfully translated characters (Unicode codepoints).
    #[prost(int64, tag="2")]
    pub translated_characters: i64,
    /// Number of characters that have failed to process (Unicode codepoints).
    #[prost(int64, tag="3")]
    pub failed_characters: i64,
    /// Time when the operation was submitted.
    #[prost(message, optional, tag="4")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
    /// The time when the operation is finished and
    /// \[google.longrunning.Operation.done][google.longrunning.Operation.done\] is
    /// set to true.
    #[prost(message, optional, tag="5")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// Input configuration for glossaries.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlossaryInputConfig {
    /// Required. Specify the input.
    #[prost(oneof="glossary_input_config::Source", tags="1")]
    pub source: ::core::option::Option<glossary_input_config::Source>,
}
/// Nested message and enum types in `GlossaryInputConfig`.
pub mod glossary_input_config {
    /// Required. Specify the input.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Source {
        /// Required. Google Cloud Storage location of glossary data.
        /// File format is determined based on the filename extension. API returns
        /// \[google.rpc.Code.INVALID_ARGUMENT\] for unsupported URI-s and file
        /// formats. Wildcards are not allowed. This must be a single file in one of
        /// the following formats:
        ///
        /// For unidirectional glossaries:
        ///
        /// - TSV/CSV (`.tsv`/`.csv`): 2 column file, tab- or comma-separated.
        ///   The first column is source text. The second column is target text.
        ///   The file must not contain headers. That is, the first row is data, not
        ///   column names.
        ///
        /// - TMX (`.tmx`): TMX file with parallel data defining source/target term
        /// pairs.
        ///
        /// For equivalent term sets glossaries:
        ///
        /// - CSV (`.csv`): Multi-column CSV file defining equivalent glossary terms
        ///   in multiple languages. See documentation for more information -
        ///   \[glossaries\](<https://cloud.google.com/translate/docs/advanced/glossary>).
        #[prost(message, tag="1")]
        GcsSource(super::GcsSource),
    }
}
/// Represents a glossary built from user provided data.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Glossary {
    /// Required. The resource name of the glossary. Glossary names have the form
    /// `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// Required. Provides examples to build the glossary from.
    /// Total glossary must not exceed 10M Unicode codepoints.
    #[prost(message, optional, tag="5")]
    pub input_config: ::core::option::Option<GlossaryInputConfig>,
    /// Output only. The number of entries defined in the glossary.
    #[prost(int32, tag="6")]
    pub entry_count: i32,
    /// Output only. When CreateGlossary was called.
    #[prost(message, optional, tag="7")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
    /// Output only. When the glossary creation was finished.
    #[prost(message, optional, tag="8")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
    /// Languages supported by the glossary.
    #[prost(oneof="glossary::Languages", tags="3, 4")]
    pub languages: ::core::option::Option<glossary::Languages>,
}
/// Nested message and enum types in `Glossary`.
pub mod glossary {
    /// Used with unidirectional glossaries.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct LanguageCodePair {
        /// Required. The BCP-47 language code of the input text, for example,
        /// "en-US". Expected to be an exact match for GlossaryTerm.language_code.
        #[prost(string, tag="1")]
        pub source_language_code: ::prost::alloc::string::String,
        /// Required. The BCP-47 language code for translation output, for example,
        /// "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
        #[prost(string, tag="2")]
        pub target_language_code: ::prost::alloc::string::String,
    }
    /// Used with equivalent term set glossaries.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct LanguageCodesSet {
        /// The BCP-47 language code(s) for terms defined in the glossary.
        /// All entries are unique. The list contains at least two entries.
        /// Expected to be an exact match for GlossaryTerm.language_code.
        #[prost(string, repeated, tag="1")]
        pub language_codes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    /// Languages supported by the glossary.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Languages {
        /// Used with unidirectional glossaries.
        #[prost(message, tag="3")]
        LanguagePair(LanguageCodePair),
        /// Used with equivalent term set glossaries.
        #[prost(message, tag="4")]
        LanguageCodesSet(LanguageCodesSet),
    }
}
/// Request message for CreateGlossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateGlossaryRequest {
    /// Required. The project name.
    #[prost(string, tag="1")]
    pub parent: ::prost::alloc::string::String,
    /// Required. The glossary to create.
    #[prost(message, optional, tag="2")]
    pub glossary: ::core::option::Option<Glossary>,
}
/// Request message for GetGlossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlossaryRequest {
    /// Required. The name of the glossary to retrieve.
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
}
/// Request message for DeleteGlossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlossaryRequest {
    /// Required. The name of the glossary to delete.
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
}
/// Request message for ListGlossaries.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListGlossariesRequest {
    /// Required. The name of the project from which to list all of the glossaries.
    #[prost(string, tag="1")]
    pub parent: ::prost::alloc::string::String,
    /// Optional. Requested page size. The server may return fewer glossaries than
    /// requested. If unspecified, the server picks an appropriate default.
    #[prost(int32, tag="2")]
    pub page_size: i32,
    /// Optional. A token identifying a page of results the server should return.
    /// Typically, this is the value of \[ListGlossariesResponse.next_page_token\]
    /// returned from the previous call to `ListGlossaries` method.
    /// The first page is returned if `page_token`is empty or missing.
    #[prost(string, tag="3")]
    pub page_token: ::prost::alloc::string::String,
    /// Optional. Filter specifying constraints of a list operation.
    /// Specify the constraint by the format of "key=value", where key must be
    /// "src" or "tgt", and the value must be a valid language code.
    /// For multiple restrictions, concatenate them by "AND" (uppercase only),
    /// such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used
    /// here, which means using 'en-US' and 'en' can lead to different results,
    /// which depends on the language code you used when you create the glossary.
    /// For the unidirectional glossaries, the "src" and "tgt" add restrictions
    /// on the source and target language code separately.
    /// For the equivalent term set glossaries, the "src" and/or "tgt" add
    /// restrictions on the term set.
    /// For example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
    /// glossaries which exactly match the source language code as "en-US" and the
    /// target language code "zh-CN", but all equivalent term set glossaries which
    /// contain "en-US" and "zh-CN" in their language set will be picked.
    /// If missing, no filtering is performed.
    #[prost(string, tag="4")]
    pub filter: ::prost::alloc::string::String,
}
/// Response message for ListGlossaries.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListGlossariesResponse {
    /// The list of glossaries for a project.
    #[prost(message, repeated, tag="1")]
    pub glossaries: ::prost::alloc::vec::Vec<Glossary>,
    /// A token to retrieve a page of results. Pass this value in the
    /// \[ListGlossariesRequest.page_token\] field in the subsequent call to
    /// `ListGlossaries` method to retrieve the next page of results.
    #[prost(string, tag="2")]
    pub next_page_token: ::prost::alloc::string::String,
}
/// Stored in the
/// \[google.longrunning.Operation.metadata][google.longrunning.Operation.metadata\]
/// field returned by CreateGlossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateGlossaryMetadata {
    /// The name of the glossary that is being created.
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// The current state of the glossary creation operation.
    #[prost(enumeration="create_glossary_metadata::State", tag="2")]
    pub state: i32,
    /// The time when the operation was submitted to the server.
    #[prost(message, optional, tag="3")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// Nested message and enum types in `CreateGlossaryMetadata`.
pub mod create_glossary_metadata {
    /// Enumerates the possible states that the creation request can be in.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// Invalid.
        Unspecified = 0,
        /// Request is being processed.
        Running = 1,
        /// The glossary was successfully created.
        Succeeded = 2,
        /// Failed to create the glossary.
        Failed = 3,
        /// Request is in the process of being canceled after caller invoked
        /// longrunning.Operations.CancelOperation on the request id.
        Cancelling = 4,
        /// The glossary creation request was successfully canceled.
        Cancelled = 5,
    }
}
/// Stored in the
/// \[google.longrunning.Operation.metadata][google.longrunning.Operation.metadata\]
/// field returned by DeleteGlossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlossaryMetadata {
    /// The name of the glossary that is being deleted.
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// The current state of the glossary deletion operation.
    #[prost(enumeration="delete_glossary_metadata::State", tag="2")]
    pub state: i32,
    /// The time when the operation was submitted to the server.
    #[prost(message, optional, tag="3")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// Nested message and enum types in `DeleteGlossaryMetadata`.
pub mod delete_glossary_metadata {
    /// Enumerates the possible states that the creation request can be in.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// Invalid.
        Unspecified = 0,
        /// Request is being processed.
        Running = 1,
        /// The glossary was successfully deleted.
        Succeeded = 2,
        /// Failed to delete the glossary.
        Failed = 3,
        /// Request is in the process of being canceled after caller invoked
        /// longrunning.Operations.CancelOperation on the request id.
        Cancelling = 4,
        /// The glossary deletion request was successfully canceled.
        Cancelled = 5,
    }
}
/// Stored in the
/// \[google.longrunning.Operation.response][google.longrunning.Operation.response\]
/// field returned by DeleteGlossary.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlossaryResponse {
    /// The name of the deleted glossary.
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// The time when the operation was submitted to the server.
    #[prost(message, optional, tag="2")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
    /// The time when the glossary deletion is finished and
    /// \[google.longrunning.Operation.done][google.longrunning.Operation.done\] is
    /// set to true.
    #[prost(message, optional, tag="3")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// The BatchTranslateDocument request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchTranslateDocumentRequest {
    /// Required. Location to make a regional call.
    ///
    /// Format: `projects/{project-number-or-id}/locations/{location-id}`.
    ///
    /// The `global` location is not supported for batch translation.
    ///
    /// Only AutoML Translation models or glossaries within the same region (have
    /// the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
    /// error is returned.
    #[prost(string, tag="1")]
    pub parent: ::prost::alloc::string::String,
    /// Required. The BCP-47 language code of the input document if known, for
    /// example, "en-US" or "sr-Latn". Supported language codes are listed in
    /// Language Support (<https://cloud.google.com/translate/docs/languages>).
    #[prost(string, tag="2")]
    pub source_language_code: ::prost::alloc::string::String,
    /// Required. The BCP-47 language code to use for translation of the input
    /// document. Specify up to 10 language codes here.
    #[prost(string, repeated, tag="3")]
    pub target_language_codes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Required. Input configurations.
    /// The total number of files matched should be <= 100.
    /// The total content size to translate should be <= 100M Unicode codepoints.
    /// The files must use UTF-8 encoding.
    #[prost(message, repeated, tag="4")]
    pub input_configs: ::prost::alloc::vec::Vec<BatchDocumentInputConfig>,
    /// Required. Output configuration.
    /// If 2 input configs match to the same file (that is, same input path),
    /// we don't generate output for duplicate inputs.
    #[prost(message, optional, tag="5")]
    pub output_config: ::core::option::Option<BatchDocumentOutputConfig>,
    /// Optional. The models to use for translation. Map's key is target language
    /// code. Map's value is the model name. Value can be a built-in general model,
    /// or an AutoML Translation model.
    ///
    /// The value format depends on model type:
    ///
    /// - AutoML Translation models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
    ///
    /// - General (built-in) models:
    ///   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
    ///
    ///
    /// If the map is empty or a specific model is
    /// not requested for a language pair, then default google model (nmt) is used.
    #[prost(btree_map="string, string", tag="6")]
    pub models: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    /// Optional. Glossaries to be applied. It's keyed by target language code.
    #[prost(btree_map="string, message", tag="7")]
    pub glossaries: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, TranslateTextGlossaryConfig>,
    /// Optional. File format conversion map to be applied to all input files.
    /// Map's key is the original mime_type. Map's value is the target mime_type of
    /// translated documents.
    ///
    /// Supported file format conversion includes:
    /// - `application/pdf` to
    ///   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
    ///
    /// If nothing specified, output files will be in the same format as the
    /// original file.
    #[prost(btree_map="string, string", tag="8")]
    pub format_conversions: ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
/// Input configuration for BatchTranslateDocument request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchDocumentInputConfig {
    /// Specify the input.
    #[prost(oneof="batch_document_input_config::Source", tags="1")]
    pub source: ::core::option::Option<batch_document_input_config::Source>,
}
/// Nested message and enum types in `BatchDocumentInputConfig`.
pub mod batch_document_input_config {
    /// Specify the input.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Source {
        /// Google Cloud Storage location for the source input.
        /// This can be a single file (for example,
        /// `gs://translation-test/input.docx`) or a wildcard (for example,
        /// `gs://translation-test/*`).
        ///
        /// File mime type is determined based on extension. Supported mime type
        /// includes:
        /// - `pdf`, application/pdf
        /// - `docx`,
        /// application/vnd.openxmlformats-officedocument.wordprocessingml.document
        /// - `pptx`,
        /// application/vnd.openxmlformats-officedocument.presentationml.presentation
        /// - `xlsx`,
        /// application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
        ///
        /// The max file size to support for `.docx`, `.pptx` and `.xlsx` is 100MB.
        /// The max file size to support for `.pdf` is 1GB and the max page limit is
        /// 1000 pages.
        /// The max file size to support for all input documents is 1GB.
        #[prost(message, tag="1")]
        GcsSource(super::GcsSource),
    }
}
/// Output configuration for BatchTranslateDocument request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchDocumentOutputConfig {
    /// The destination of output. The destination directory provided must exist
    /// and be empty.
    #[prost(oneof="batch_document_output_config::Destination", tags="1")]
    pub destination: ::core::option::Option<batch_document_output_config::Destination>,
}
/// Nested message and enum types in `BatchDocumentOutputConfig`.
pub mod batch_document_output_config {
    /// The destination of output. The destination directory provided must exist
    /// and be empty.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Destination {
        /// Google Cloud Storage destination for output content.
        /// For every single input document (for example, gs://a/b/c.\[extension\]), we
        /// generate at most 2 * n output files. (n is the # of target_language_codes
        /// in the BatchTranslateDocumentRequest).
        ///
        /// While the input documents are being processed, we write/update an index
        /// file `index.csv` under `gcs_destination.output_uri_prefix` (for example,
        /// gs://translation_output/index.csv) The index file is generated/updated as
        /// new files are being translated. The format is:
        ///
        /// input_document,target_language_code,translation_output,error_output,
        /// glossary_translation_output,glossary_error_output
        ///
        /// `input_document` is one file we matched using gcs_source.input_uri.
        /// `target_language_code` is provided in the request.
        /// `translation_output` contains the translations. (details provided below)
        /// `error_output` contains the error message during processing of the file.
        /// Both translations_file and errors_file could be empty strings if we have
        /// no content to output.
        /// `glossary_translation_output` and `glossary_error_output` are the
        /// translated output/error when we apply glossaries. They could also be
        /// empty if we have no content to output.
        ///
        /// Once a row is present in index.csv, the input/output matching never
        /// changes. Callers should also expect all the content in input_file are
        /// processed and ready to be consumed (that is, no partial output file is
        /// written).
        ///
        /// Since index.csv will be keeping updated during the process, please make
        /// sure there is no custom retention policy applied on the output bucket
        /// that may avoid file updating.
        /// (<https://cloud.google.com/storage/docs/bucket-lock?hl=en#retention-policy>)
        ///
        /// The naming format of translation output files follows (for target
        /// language code \[trg\]): `translation_output`:
        /// gs://translation_output/a_b_c_\[trg]_translation.[extension\]
        /// `glossary_translation_output`:
        /// gs://translation_test/a_b_c_\[trg]_glossary_translation.[extension\] The
        /// output document will maintain the same file format as the input document.
        ///
        /// The naming format of error output files follows (for target language code
        /// \[trg\]): `error_output`: gs://translation_test/a_b_c_\[trg\]_errors.txt
        /// `glossary_error_output`:
        /// gs://translation_test/a_b_c_\[trg\]_glossary_translation.txt The error
        /// output is a txt file containing error details.
        #[prost(message, tag="1")]
        GcsDestination(super::GcsDestination),
    }
}
/// Stored in the
/// \[google.longrunning.Operation.response][google.longrunning.Operation.response\]
/// field returned by BatchTranslateDocument if at least one document is
/// translated successfully.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchTranslateDocumentResponse {
    /// Total number of pages to translate in all documents. Documents without
    /// clear page definition (such as XLSX) are not counted.
    #[prost(int64, tag="1")]
    pub total_pages: i64,
    /// Number of successfully translated pages in all documents. Documents without
    /// clear page definition (such as XLSX) are not counted.
    #[prost(int64, tag="2")]
    pub translated_pages: i64,
    /// Number of pages that failed to process in all documents. Documents without
    /// clear page definition (such as XLSX) are not counted.
    #[prost(int64, tag="3")]
    pub failed_pages: i64,
    /// Number of billable pages in documents with clear page definition (such as
    /// PDF, DOCX, PPTX)
    #[prost(int64, tag="4")]
    pub total_billable_pages: i64,
    /// Total number of characters (Unicode codepoints) in all documents.
    #[prost(int64, tag="5")]
    pub total_characters: i64,
    /// Number of successfully translated characters (Unicode codepoints) in all
    /// documents.
    #[prost(int64, tag="6")]
    pub translated_characters: i64,
    /// Number of characters that have failed to process (Unicode codepoints) in
    /// all documents.
    #[prost(int64, tag="7")]
    pub failed_characters: i64,
    /// Number of billable characters (Unicode codepoints) in documents without
    /// clear page definition, such as XLSX.
    #[prost(int64, tag="8")]
    pub total_billable_characters: i64,
    /// Time when the operation was submitted.
    #[prost(message, optional, tag="9")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
    /// The time when the operation is finished and
    /// \[google.longrunning.Operation.done][google.longrunning.Operation.done\] is
    /// set to true.
    #[prost(message, optional, tag="10")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// State metadata for the batch translation operation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatchTranslateDocumentMetadata {
    /// The state of the operation.
    #[prost(enumeration="batch_translate_document_metadata::State", tag="1")]
    pub state: i32,
    /// Total number of pages to translate in all documents so far. Documents
    /// without clear page definition (such as XLSX) are not counted.
    #[prost(int64, tag="2")]
    pub total_pages: i64,
    /// Number of successfully translated pages in all documents so far. Documents
    /// without clear page definition (such as XLSX) are not counted.
    #[prost(int64, tag="3")]
    pub translated_pages: i64,
    /// Number of pages that failed to process in all documents so far. Documents
    /// without clear page definition (such as XLSX) are not counted.
    #[prost(int64, tag="4")]
    pub failed_pages: i64,
    /// Number of billable pages in documents with clear page definition (such as
    /// PDF, DOCX, PPTX) so far.
    #[prost(int64, tag="5")]
    pub total_billable_pages: i64,
    /// Total number of characters (Unicode codepoints) in all documents so far.
    #[prost(int64, tag="6")]
    pub total_characters: i64,
    /// Number of successfully translated characters (Unicode codepoints) in all
    /// documents so far.
    #[prost(int64, tag="7")]
    pub translated_characters: i64,
    /// Number of characters that have failed to process (Unicode codepoints) in
    /// all documents so far.
    #[prost(int64, tag="8")]
    pub failed_characters: i64,
    /// Number of billable characters (Unicode codepoints) in documents without
    /// clear page definition (such as XLSX) so far.
    #[prost(int64, tag="9")]
    pub total_billable_characters: i64,
    /// Time when the operation was submitted.
    #[prost(message, optional, tag="10")]
    pub submit_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// Nested message and enum types in `BatchTranslateDocumentMetadata`.
pub mod batch_translate_document_metadata {
    /// State of the job.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// Invalid.
        Unspecified = 0,
        /// Request is being processed.
        Running = 1,
        /// The batch is processed, and at least one item was successfully processed.
        Succeeded = 2,
        /// The batch is done and no item was successfully processed.
        Failed = 3,
        /// Request is in the process of being canceled after caller invoked
        /// longrunning.Operations.CancelOperation on the request id.
        Cancelling = 4,
        /// The batch is done after the user has called the
        /// longrunning.Operations.CancelOperation. Any records processed before the
        /// cancel command are output as specified in the request.
        Cancelled = 5,
    }
}
/// Generated client implementations.
pub mod translation_service_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Provides natural language translation operations.
    #[derive(Debug, Clone)]
    pub struct TranslationServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl<T> TranslationServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Default + Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> TranslationServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            TranslationServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with `gzip`.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_gzip(mut self) -> Self {
            self.inner = self.inner.send_gzip();
            self
        }
        /// Enable decompressing responses with `gzip`.
        #[must_use]
        pub fn accept_gzip(mut self) -> Self {
            self.inner = self.inner.accept_gzip();
            self
        }
        /// Translates input text and returns translated text.
        pub async fn translate_text(
            &mut self,
            request: impl tonic::IntoRequest<super::TranslateTextRequest>,
        ) -> Result<tonic::Response<super::TranslateTextResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/TranslateText",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Detects the language of text within a request.
        pub async fn detect_language(
            &mut self,
            request: impl tonic::IntoRequest<super::DetectLanguageRequest>,
        ) -> Result<tonic::Response<super::DetectLanguageResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/DetectLanguage",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Returns a list of supported languages for translation.
        pub async fn get_supported_languages(
            &mut self,
            request: impl tonic::IntoRequest<super::GetSupportedLanguagesRequest>,
        ) -> Result<tonic::Response<super::SupportedLanguages>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/GetSupportedLanguages",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Translates documents in synchronous mode.
        pub async fn translate_document(
            &mut self,
            request: impl tonic::IntoRequest<super::TranslateDocumentRequest>,
        ) -> Result<tonic::Response<super::TranslateDocumentResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/TranslateDocument",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Translates a large volume of text in asynchronous batch mode.
        /// This function provides real-time output as the inputs are being processed.
        /// If caller cancels a request, the partial results (for an input file, it's
        /// all or nothing) may still be available on the specified output location.
        ///
        /// This call returns immediately and you can
        /// use google.longrunning.Operation.name to poll the status of the call.
        pub async fn batch_translate_text(
            &mut self,
            request: impl tonic::IntoRequest<super::BatchTranslateTextRequest>,
        ) -> Result<
                tonic::Response<super::super::super::super::longrunning::Operation>,
                tonic::Status,
            > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/BatchTranslateText",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Translates a large volume of document in asynchronous batch mode.
        /// This function provides real-time output as the inputs are being processed.
        /// If caller cancels a request, the partial results (for an input file, it's
        /// all or nothing) may still be available on the specified output location.
        ///
        /// This call returns immediately and you can use
        /// google.longrunning.Operation.name to poll the status of the call.
        pub async fn batch_translate_document(
            &mut self,
            request: impl tonic::IntoRequest<super::BatchTranslateDocumentRequest>,
        ) -> Result<
                tonic::Response<super::super::super::super::longrunning::Operation>,
                tonic::Status,
            > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/BatchTranslateDocument",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Creates a glossary and returns the long-running operation. Returns
        /// NOT_FOUND, if the project doesn't exist.
        pub async fn create_glossary(
            &mut self,
            request: impl tonic::IntoRequest<super::CreateGlossaryRequest>,
        ) -> Result<
                tonic::Response<super::super::super::super::longrunning::Operation>,
                tonic::Status,
            > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/CreateGlossary",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
        /// exist.
        pub async fn list_glossaries(
            &mut self,
            request: impl tonic::IntoRequest<super::ListGlossariesRequest>,
        ) -> Result<tonic::Response<super::ListGlossariesResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/ListGlossaries",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
        /// exist.
        pub async fn get_glossary(
            &mut self,
            request: impl tonic::IntoRequest<super::GetGlossaryRequest>,
        ) -> Result<tonic::Response<super::Glossary>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/GetGlossary",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        /// Deletes a glossary, or cancels glossary construction
        /// if the glossary isn't created yet.
        /// Returns NOT_FOUND, if the glossary doesn't exist.
        pub async fn delete_glossary(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteGlossaryRequest>,
        ) -> Result<
                tonic::Response<super::super::super::super::longrunning::Operation>,
                tonic::Status,
            > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.translation.v3.TranslationService/DeleteGlossary",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
    }
}
