///
/// Messages
///
/// A request message for InstanceGroupManagers.AbandonInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AbandonInstancesInstanceGroupManagerRequest {
    /// The name of the managed instance group.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "320929016")]
    pub instance_group_managers_abandon_instances_request_resource:
        ::core::option::Option<InstanceGroupManagersAbandonInstancesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the managed instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroupManagers.AbandonInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AbandonInstancesRegionInstanceGroupManagerRequest {
    /// Name of the managed instance group.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "488499491")]
    pub region_instance_group_managers_abandon_instances_request_resource:
        ::core::option::Option<RegionInstanceGroupManagersAbandonInstancesRequest>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A specification of the type and number of accelerator cards attached to the instance.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AcceleratorConfig {
    /// The number of the guest accelerator cards exposed to this instance.
    #[prost(int32, optional, tag = "504879675")]
    pub accelerator_count: ::core::option::Option<i32>,
    /// Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
    #[prost(string, optional, tag = "138031246")]
    pub accelerator_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents an Accelerator Type resource. Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AcceleratorType {
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The deprecation status associated with this accelerator type.
    #[prost(message, optional, tag = "515138995")]
    pub deprecated: ::core::option::Option<DeprecationStatus>,
    /// [Output Only] An optional textual description of the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Maximum number of accelerator cards allowed per instance.
    #[prost(int32, optional, tag = "263814482")]
    pub maximum_cards_per_instance: ::core::option::Option<i32>,
    /// [Output Only] Name of the resource.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined, fully qualified URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AcceleratorTypeAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of AcceleratorTypesScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        AcceleratorTypesScopedList,
    >,
    /// [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of accelerator types.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AcceleratorTypeList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of AcceleratorType resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<AcceleratorType>,
    /// [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AcceleratorTypesScopedList {
    /// [Output Only] A list of accelerator types contained in this scope.
    #[prost(message, repeated, tag = "520872357")]
    pub accelerator_types: ::prost::alloc::vec::Vec<AcceleratorType>,
    /// [Output Only] An informational warning that appears when the accelerator types list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Accelerators {
    /// Number of accelerator cards exposed to the guest.
    #[prost(int32, optional, tag = "479079316")]
    pub guest_accelerator_count: ::core::option::Option<i32>,
    /// The accelerator type resource name, not a full URL, e.g. 'nvidia-tesla-k80'.
    #[prost(string, optional, tag = "293064725")]
    pub guest_accelerator_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// An access configuration attached to an instance's network interface. Only one access config per instance is supported.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AccessConfig {
    /// [Output Only] The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.
    #[prost(string, optional, tag = "532703707")]
    pub external_ipv6: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The prefix length of the external IPv6 range.
    #[prost(int32, optional, tag = "425672143")]
    pub external_ipv6_prefix_length: ::core::option::Option<i32>,
    /// [Output Only] Type of the resource. Always compute#accessConfig for access configs.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
    #[prost(string, optional, tag = "117634556")]
    pub nat_i_p: ::core::option::Option<::prost::alloc::string::String>,
    /// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
    /// Check the NetworkTier enum for the list of possible values.
    #[prost(string, optional, tag = "517397843")]
    pub network_tier: ::core::option::Option<::prost::alloc::string::String>,
    /// The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled.
    #[prost(string, optional, tag = "316599167")]
    pub public_ptr_domain_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name.
    #[prost(bool, optional, tag = "523870229")]
    pub set_public_ptr: ::core::option::Option<bool>,
    /// The type of configuration. The default and only option is ONE_TO_ONE_NAT.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AccessConfig`.
pub mod access_config {
    /// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum NetworkTier {
        /// A value indicating that the enum field is not set.
        UndefinedNetworkTier = 0,
        /// High quality, Google-grade network tier, support for all networking products.
        Premium = 399530551,
        /// Public internet quality, only limited support for other networking products.
        Standard = 484642493,
    }
    /// The type of configuration. The default and only option is ONE_TO_ONE_NAT.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        DirectIpv6 = 4397213,
        OneToOneNat = 84090205,
    }
}
/// A request message for Instances.AddAccessConfig. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddAccessConfigInstanceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "387825552")]
    pub access_config_resource: ::core::option::Option<AccessConfig>,
    /// The instance name for this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// The name of the network interface to add to this instance.
    #[prost(string, tag = "365387880")]
    pub network_interface: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for FirewallPolicies.AddAssociation. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddAssociationFirewallPolicyRequest {
    /// Name of the firewall policy to update.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "259546170")]
    pub firewall_policy_association_resource: ::core::option::Option<FirewallPolicyAssociation>,
    /// Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
    #[prost(bool, optional, tag = "209541240")]
    pub replace_existing_association: ::core::option::Option<bool>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for TargetPools.AddHealthCheck. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddHealthCheckTargetPoolRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the target pool to add a health check to.
    #[prost(string, tag = "62796298")]
    pub target_pool: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "269573412")]
    pub target_pools_add_health_check_request_resource:
        ::core::option::Option<TargetPoolsAddHealthCheckRequest>,
}
/// A request message for TargetPools.AddInstance. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddInstanceTargetPoolRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetPool resource to add instances to.
    #[prost(string, tag = "62796298")]
    pub target_pool: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "428796404")]
    pub target_pools_add_instance_request_resource:
        ::core::option::Option<TargetPoolsAddInstanceRequest>,
}
/// A request message for InstanceGroups.AddInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddInstancesInstanceGroupRequest {
    /// The name of the instance group where you are adding instances.
    #[prost(string, tag = "81095253")]
    pub instance_group: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "453713246")]
    pub instance_groups_add_instances_request_resource:
        ::core::option::Option<InstanceGroupsAddInstancesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for NodeGroups.AddNodes. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddNodesNodeGroupRequest {
    /// Name of the NodeGroup resource.
    #[prost(string, tag = "469958146")]
    pub node_group: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "131263288")]
    pub node_groups_add_nodes_request_resource: ::core::option::Option<NodeGroupsAddNodesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Networks.AddPeering. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddPeeringNetworkRequest {
    /// Name of the network resource to add peering to.
    #[prost(string, tag = "232872494")]
    pub network: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "388810421")]
    pub networks_add_peering_request_resource: ::core::option::Option<NetworksAddPeeringRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Disks.AddResourcePolicies. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddResourcePoliciesDiskRequest {
    /// The disk name for this request.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "496483363")]
    pub disks_add_resource_policies_request_resource:
        ::core::option::Option<DisksAddResourcePoliciesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Instances.AddResourcePolicies. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddResourcePoliciesInstanceRequest {
    /// The instance name for this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "489351963")]
    pub instances_add_resource_policies_request_resource:
        ::core::option::Option<InstancesAddResourcePoliciesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionDisks.AddResourcePolicies. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddResourcePoliciesRegionDiskRequest {
    /// The disk name for this request.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "284196750")]
    pub region_disks_add_resource_policies_request_resource:
        ::core::option::Option<RegionDisksAddResourcePoliciesRequest>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for FirewallPolicies.AddRule. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddRuleFirewallPolicyRequest {
    /// Name of the firewall policy to update.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "250523523")]
    pub firewall_policy_rule_resource: ::core::option::Option<FirewallPolicyRule>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for SecurityPolicies.AddRule. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddRuleSecurityPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the security policy to update.
    #[prost(string, tag = "171082513")]
    pub security_policy: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "402693443")]
    pub security_policy_rule_resource: ::core::option::Option<SecurityPolicyRule>,
}
/// A request message for BackendBuckets.AddSignedUrlKey. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddSignedUrlKeyBackendBucketRequest {
    /// Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
    #[prost(string, tag = "91714037")]
    pub backend_bucket: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "457625985")]
    pub signed_url_key_resource: ::core::option::Option<SignedUrlKey>,
}
/// A request message for BackendServices.AddSignedUrlKey. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddSignedUrlKeyBackendServiceRequest {
    /// Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "457625985")]
    pub signed_url_key_resource: ::core::option::Option<SignedUrlKey>,
}
/// Represents an IP Address resource. Google Compute Engine has two IP Address resources: * [Global (external and internal)](<https://cloud.google.com/compute/docs/reference/rest/v1/globalAddresses>) * [Regional (external and internal)](<https://cloud.google.com/compute/docs/reference/rest/v1/addresses>) For more information, see Reserving a static external IP address.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Address {
    /// The static IP address represented by this resource.
    #[prost(string, optional, tag = "462920692")]
    pub address: ::core::option::Option<::prost::alloc::string::String>,
    /// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
    /// Check the AddressType enum for the list of possible values.
    #[prost(string, optional, tag = "264307877")]
    pub address_type: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this field when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
    /// Check the IpVersion enum for the list of possible values.
    #[prost(string, optional, tag = "294959552")]
    pub ip_version: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Type of the resource. Always compute#address for addresses.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
    #[prost(string, optional, tag = "232872494")]
    pub network: ::core::option::Option<::prost::alloc::string::String>,
    /// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
    /// Check the NetworkTier enum for the list of possible values.
    #[prost(string, optional, tag = "517397843")]
    pub network_tier: ::core::option::Option<::prost::alloc::string::String>,
    /// The prefix length if the resource represents an IP range.
    #[prost(int32, optional, tag = "453565747")]
    pub prefix_length: ::core::option::Option<i32>,
    /// The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using . - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *IPsec-encrypted Cloud Interconnect* configuration. These addresses are regional resources. Not currently available publicly. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
    /// Check the Purpose enum for the list of possible values.
    #[prost(string, optional, tag = "316407070")]
    pub purpose: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. *This field is not applicable to global addresses.*
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
    #[prost(string, optional, tag = "307827694")]
    pub subnetwork: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URLs of the resources that are using this address.
    #[prost(string, repeated, tag = "111578632")]
    pub users: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Address`.
pub mod address {
    /// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum AddressType {
        /// A value indicating that the enum field is not set.
        UndefinedAddressType = 0,
        /// A publicly visible external IP address.
        External = 35607499,
        /// A private network IP address, for use with an Instance or Internal Load Balancer forwarding rule.
        Internal = 279295677,
        UnspecifiedType = 53933922,
    }
    /// The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum IpVersion {
        /// A value indicating that the enum field is not set.
        UndefinedIpVersion = 0,
        Ipv4 = 2254341,
        Ipv6 = 2254343,
        UnspecifiedVersion = 21850000,
    }
    /// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum NetworkTier {
        /// A value indicating that the enum field is not set.
        UndefinedNetworkTier = 0,
        /// High quality, Google-grade network tier, support for all networking products.
        Premium = 399530551,
        /// Public internet quality, only limited support for other networking products.
        Standard = 484642493,
    }
    /// The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using . - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *IPsec-encrypted Cloud Interconnect* configuration. These addresses are regional resources. Not currently available publicly. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Purpose {
        /// A value indicating that the enum field is not set.
        UndefinedPurpose = 0,
        /// DNS resolver address in the subnetwork.
        DnsResolver = 476114556,
        /// VM internal/alias IP, Internal LB service IP, etc.
        GceEndpoint = 230515243,
        /// A regional internal IP address range reserved for the VLAN attachment that is used in IPsec-encrypted Cloud Interconnect. This regional internal IP address range must not overlap with any IP address range of subnet/route in the VPC network and its peering networks. After the VLAN attachment is created with the reserved IP address range, when creating a new VPN gateway, its interface IP address is allocated from the associated VLAN attachment’s IP address range.
        IpsecInterconnect = 340437251,
        /// External IP automatically reserved for Cloud NAT.
        NatAuto = 163666477,
        /// A private network IP address that can be used to configure Private Service Connect. This purpose can be specified only for GLOBAL addresses of Type INTERNAL
        PrivateServiceConnect = 48134724,
        /// A private network IP address that can be shared by multiple Internal Load Balancer forwarding rules.
        SharedLoadbalancerVip = 294447572,
        /// IP range for peer networks.
        VpcPeering = 400800170,
    }
    /// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// Address is being used by another resource and is not available.
        InUse = 17393485,
        /// Address is reserved and available to use.
        Reserved = 432241448,
        /// Address is being reserved.
        Reserving = 514587225,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddressAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of AddressesScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items:
        ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, AddressesScopedList>,
    /// [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of addresses.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddressList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Address resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Address>,
    /// [Output Only] Type of resource. Always compute#addressList for lists of addresses.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddressesScopedList {
    /// [Output Only] A list of addresses contained in this scope.
    #[prost(message, repeated, tag = "337673122")]
    pub addresses: ::prost::alloc::vec::Vec<Address>,
    /// [Output Only] Informational warning which replaces the list of addresses when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AdvancedMachineFeatures {
    /// Whether to enable nested virtualization or not (default is false).
    #[prost(bool, optional, tag = "16639365")]
    pub enable_nested_virtualization: ::core::option::Option<bool>,
    /// The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    #[prost(int32, optional, tag = "352611671")]
    pub threads_per_core: ::core::option::Option<i32>,
}
/// A request message for AcceleratorTypes.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListAcceleratorTypesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Addresses.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListAddressesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Autoscalers.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListAutoscalersRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for BackendServices.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListBackendServicesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for DiskTypes.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListDiskTypesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Disks.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListDisksRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for ForwardingRules.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListForwardingRulesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for GlobalOperations.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListGlobalOperationsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for HealthChecks.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListHealthChecksRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for InstanceGroupManagers.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListInstanceGroupManagersRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for InstanceGroups.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListInstanceGroupsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Instances.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListInstancesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for InterconnectAttachments.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListInterconnectAttachmentsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for MachineTypes.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListMachineTypesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for NetworkEndpointGroups.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListNetworkEndpointGroupsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for NodeGroups.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListNodeGroupsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for NodeTemplates.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListNodeTemplatesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for NodeTypes.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListNodeTypesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for PacketMirrorings.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListPacketMirroringsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for PublicDelegatedPrefixes.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListPublicDelegatedPrefixesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for RegionCommitments.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListRegionCommitmentsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Reservations.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListReservationsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for ResourcePolicies.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListResourcePoliciesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Routers.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListRoutersRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for ServiceAttachments.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListServiceAttachmentsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for SslCertificates.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListSslCertificatesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for Subnetworks.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListSubnetworksRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for TargetHttpProxies.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListTargetHttpProxiesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for TargetHttpsProxies.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListTargetHttpsProxiesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for TargetInstances.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListTargetInstancesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for TargetPools.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListTargetPoolsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for TargetVpnGateways.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListTargetVpnGatewaysRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for UrlMaps.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListUrlMapsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the project scoping this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for VpnGateways.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListVpnGatewaysRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for VpnTunnels.AggregatedList. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregatedListVpnTunnelsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
    #[prost(bool, optional, tag = "391327988")]
    pub include_all_scopes: ::core::option::Option<bool>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// An alias IP range attached to an instance's network interface.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AliasIpRange {
    /// The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
    #[prost(string, optional, tag = "98117322")]
    pub ip_cidr_range: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
    #[prost(string, optional, tag = "387995966")]
    pub subnetwork_range_name: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk {
    /// Specifies the size of the disk in base-2 GB.
    #[prost(int64, optional, tag = "316263735")]
    pub disk_size_gb: ::core::option::Option<i64>,
    /// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
    /// Check the Interface enum for the list of possible values.
    #[prost(string, optional, tag = "502623545")]
    pub interface: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk`.
pub mod allocation_specific_sku_allocation_allocated_instance_properties_reserved_disk {
    /// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Interface {
        /// A value indicating that the enum field is not set.
        UndefinedInterface = 0,
        Nvme = 2408800,
        Scsi = 2539686,
    }
}
/// Properties of the SKU instances being reserved. Next ID: 9
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AllocationSpecificSkuAllocationReservedInstanceProperties {
    /// Specifies accelerator type and count.
    #[prost(message, repeated, tag = "463595119")]
    pub guest_accelerators: ::prost::alloc::vec::Vec<AcceleratorConfig>,
    /// Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
    #[prost(message, repeated, tag = "229951299")]
    pub local_ssds: ::prost::alloc::vec::Vec<
        AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk,
    >,
    /// An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
    #[prost(string, optional, tag = "350519505")]
    pub location_hint: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
    #[prost(string, optional, tag = "227711026")]
    pub machine_type: ::core::option::Option<::prost::alloc::string::String>,
    /// Minimum cpu platform the reservation.
    #[prost(string, optional, tag = "242912759")]
    pub min_cpu_platform: ::core::option::Option<::prost::alloc::string::String>,
}
/// This reservation type allows to pre allocate specific instance configuration. Next ID: 5
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AllocationSpecificSkuReservation {
    /// Specifies the number of resources that are allocated.
    #[prost(int64, optional, tag = "94851343")]
    pub count: ::core::option::Option<i64>,
    /// [Output Only] Indicates how many instances are in use.
    #[prost(int64, optional, tag = "493458877")]
    pub in_use_count: ::core::option::Option<i64>,
    /// The instance properties for the reservation.
    #[prost(message, optional, tag = "215355165")]
    pub instance_properties:
        ::core::option::Option<AllocationSpecificSkuAllocationReservedInstanceProperties>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Allowed {
    /// The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
    #[prost(string, optional, tag = "488094525")]
    pub i_p_protocol: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: \["22"\], \["80","443"\], and \["12345-12349"\].
    #[prost(string, repeated, tag = "106854418")]
    pub ports: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// A request message for InstanceGroupManagers.ApplyUpdatesToInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ApplyUpdatesToInstancesInstanceGroupManagerRequest {
    /// The name of the managed instance group, should conform to RFC1035.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "259242835")]
    pub instance_group_managers_apply_updates_request_resource:
        ::core::option::Option<InstanceGroupManagersApplyUpdatesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone where the managed instance group is located. Should conform to RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroupManagers.ApplyUpdatesToInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest {
    /// The name of the managed instance group, should conform to RFC1035.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request, should conform to RFC1035.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "76248318")]
    pub region_instance_group_managers_apply_updates_request_resource:
        ::core::option::Option<RegionInstanceGroupManagersApplyUpdatesRequest>,
}
/// A request message for Instances.AttachDisk. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachDiskInstanceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "90605845")]
    pub attached_disk_resource: ::core::option::Option<AttachedDisk>,
    /// Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
    #[prost(bool, optional, tag = "142758425")]
    pub force_attach: ::core::option::Option<bool>,
    /// The instance name for this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for GlobalNetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "30691563")]
    pub global_network_endpoint_groups_attach_endpoints_request_resource:
        ::core::option::Option<GlobalNetworkEndpointGroupsAttachEndpointsRequest>,
    /// The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachNetworkEndpointsNetworkEndpointGroupRequest {
    /// The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "531079")]
    pub network_endpoint_groups_attach_endpoints_request_resource:
        ::core::option::Option<NetworkEndpointGroupsAttachEndpointsRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the network endpoint group is located. It should comply with RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// An instance-attached disk resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachedDisk {
    /// Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
    #[prost(bool, optional, tag = "464761403")]
    pub auto_delete: ::core::option::Option<bool>,
    /// Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
    #[prost(bool, optional, tag = "3029746")]
    pub boot: ::core::option::Option<bool>,
    /// Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
    #[prost(string, optional, tag = "67541716")]
    pub device_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
    #[prost(message, optional, tag = "271660677")]
    pub disk_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// The size of the disk in GB.
    #[prost(int64, optional, tag = "316263735")]
    pub disk_size_gb: ::core::option::Option<i64>,
    /// A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
    #[prost(message, repeated, tag = "79294545")]
    pub guest_os_features: ::prost::alloc::vec::Vec<GuestOsFeature>,
    /// [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
    #[prost(int32, optional, tag = "100346066")]
    pub index: ::core::option::Option<i32>,
    /// [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
    #[prost(message, optional, tag = "17697045")]
    pub initialize_params: ::core::option::Option<AttachedDiskInitializeParams>,
    /// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
    /// Check the Interface enum for the list of possible values.
    #[prost(string, optional, tag = "502623545")]
    pub interface: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Any valid publicly visible licenses.
    #[prost(string, repeated, tag = "337642578")]
    pub licenses: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
    /// Check the Mode enum for the list of possible values.
    #[prost(string, optional, tag = "3357091")]
    pub mode: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] shielded vm initial state stored on disk
    #[prost(message, optional, tag = "192356867")]
    pub shielded_instance_initial_state: ::core::option::Option<InitialStateConfig>,
    /// Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
    #[prost(string, optional, tag = "177235995")]
    pub source: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AttachedDisk`.
pub mod attached_disk {
    /// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Interface {
        /// A value indicating that the enum field is not set.
        UndefinedInterface = 0,
        Nvme = 2408800,
        Scsi = 2539686,
    }
    /// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Mode {
        /// A value indicating that the enum field is not set.
        UndefinedMode = 0,
        /// Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
        ReadOnly = 91950261,
        /// *\[Default\]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
        ReadWrite = 173607894,
    }
    /// Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        Persistent = 460683927,
        Scratch = 496778970,
    }
}
/// [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachedDiskInitializeParams {
    /// An optional description. Provide this property when creating the disk.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
    #[prost(string, optional, tag = "92807149")]
    pub disk_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
    #[prost(int64, optional, tag = "316263735")]
    pub disk_size_gb: ::core::option::Option<i64>,
    /// Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you define this field, you can provide either the full or partial URL. For example, the following are valid values: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is the name of the disk type, not URL.
    #[prost(string, optional, tag = "93009052")]
    pub disk_type: ::core::option::Option<::prost::alloc::string::String>,
    /// Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Specifies which action to take on instance update with this disk. Default is to use the existing disk.
    /// Check the OnUpdateAction enum for the list of possible values.
    #[prost(string, optional, tag = "202451980")]
    pub on_update_action: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
    #[prost(int64, optional, tag = "186769108")]
    pub provisioned_iops: ::core::option::Option<i64>,
    /// Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
    #[prost(string, optional, tag = "50443319")]
    pub source_image: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
    #[prost(message, optional, tag = "381503659")]
    pub source_image_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
    #[prost(string, optional, tag = "126061928")]
    pub source_snapshot: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source snapshot.
    #[prost(message, optional, tag = "303679322")]
    pub source_snapshot_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
}
/// Nested message and enum types in `AttachedDiskInitializeParams`.
pub mod attached_disk_initialize_params {
    /// Specifies which action to take on instance update with this disk. Default is to use the existing disk.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum OnUpdateAction {
        /// A value indicating that the enum field is not set.
        UndefinedOnUpdateAction = 0,
        /// Always recreate the disk.
        RecreateDisk = 494767853,
        /// Recreate the disk if source (image, snapshot) of this disk is different from source of existing disk.
        RecreateDiskIfSourceChanged = 398099712,
        /// Use the existing disk, this is the default behaviour.
        UseExistingDisk = 232682233,
    }
}
/// Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuditConfig {
    /// The configuration for logging of each type of permission.
    #[prost(message, repeated, tag = "488420626")]
    pub audit_log_configs: ::prost::alloc::vec::Vec<AuditLogConfig>,
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, repeated, tag = "232615576")]
    pub exempted_members: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
    #[prost(string, optional, tag = "373540533")]
    pub service: ::core::option::Option<::prost::alloc::string::String>,
}
/// Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuditLogConfig {
    /// Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
    #[prost(string, repeated, tag = "232615576")]
    pub exempted_members: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// This is deprecated and has no effect. Do not use.
    #[prost(bool, optional, tag = "70141850")]
    pub ignore_child_exemptions: ::core::option::Option<bool>,
    /// The log type that this config enables.
    /// Check the LogType enum for the list of possible values.
    #[prost(string, optional, tag = "403115861")]
    pub log_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AuditLogConfig`.
pub mod audit_log_config {
    /// The log type that this config enables.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum LogType {
        /// A value indicating that the enum field is not set.
        UndefinedLogType = 0,
        /// Admin reads. Example: CloudIAM getIamPolicy
        AdminRead = 128951462,
        /// Data reads. Example: CloudSQL Users list
        DataRead = 305224971,
        /// Data writes. Example: CloudSQL Users create
        DataWrite = 340181738,
        /// Default case. Should never be this.
        Unspecified = 154527053,
    }
}
/// This is deprecated and has no effect. Do not use.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuthorizationLoggingOptions {
    /// This is deprecated and has no effect. Do not use.
    /// Check the PermissionType enum for the list of possible values.
    #[prost(string, optional, tag = "525978538")]
    pub permission_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AuthorizationLoggingOptions`.
pub mod authorization_logging_options {
    /// This is deprecated and has no effect. Do not use.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PermissionType {
        /// A value indicating that the enum field is not set.
        UndefinedPermissionType = 0,
        /// This is deprecated and has no effect. Do not use.
        AdminRead = 128951462,
        /// This is deprecated and has no effect. Do not use.
        AdminWrite = 244412079,
        /// This is deprecated and has no effect. Do not use.
        DataRead = 305224971,
        /// This is deprecated and has no effect. Do not use.
        DataWrite = 340181738,
        /// This is deprecated and has no effect. Do not use.
        Unspecified = 440313346,
    }
}
/// Represents an Autoscaler resource. Google Compute Engine has two Autoscaler resources: * \[Zonal\](/compute/docs/reference/rest/v1/autoscalers) * \[Regional\](/compute/docs/reference/rest/v1/regionAutoscalers) Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances. For zonal managed instance groups resource, use the autoscaler resource. For regional managed instance groups, use the regionAutoscalers resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Autoscaler {
    /// The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
    #[prost(message, optional, tag = "221950041")]
    pub autoscaling_policy: ::core::option::Option<AutoscalingPolicy>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
    #[prost(int32, optional, tag = "257915749")]
    pub recommended_size: ::core::option::Option<i32>,
    /// [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Status information of existing scaling schedules.
    #[prost(btree_map = "string, message", tag = "465950178")]
    pub scaling_schedule_status: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ScalingScheduleStatus,
    >,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
    #[prost(message, repeated, tag = "363353845")]
    pub status_details: ::prost::alloc::vec::Vec<AutoscalerStatusDetails>,
    /// URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
    #[prost(string, optional, tag = "192835985")]
    pub target: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Autoscaler`.
pub mod autoscaler {
    /// [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// Configuration is acknowledged to be effective
        Active = 314733318,
        /// Configuration is being deleted
        Deleting = 528602024,
        /// Configuration has errors. Actionable for users.
        Error = 66247144,
        /// Autoscaler backend hasn't read new/updated configuration
        Pending = 35394935,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalerAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of AutoscalersScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        AutoscalersScopedList,
    >,
    /// [Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of Autoscaler resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalerList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Autoscaler resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Autoscaler>,
    /// [Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalerStatusDetails {
    /// The status message.
    #[prost(string, optional, tag = "418054151")]
    pub message: ::core::option::Option<::prost::alloc::string::String>,
    /// The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AutoscalerStatusDetails`.
pub mod autoscaler_status_details {
    /// The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        /// All instances in the instance group are unhealthy (not in RUNNING state).
        AllInstancesUnhealthy = 404965477,
        /// There is no backend service attached to the instance group.
        BackendServiceDoesNotExist = 191417626,
        /// Autoscaler recommends a size greater than maxNumReplicas.
        CappedAtMaxNumReplicas = 518617,
        /// The custom metric samples are not exported often enough to be a credible base for autoscaling.
        CustomMetricDataPointsTooSparse = 328964659,
        /// The custom metric that was specified does not exist or does not have the necessary labels.
        CustomMetricInvalid = 204430550,
        /// The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
        MinEqualsMax = 2821361,
        /// The autoscaler did not receive any data from the custom metric configured for autoscaling.
        MissingCustomMetricDataPoints = 94885086,
        /// The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
        MissingLoadBalancingDataPoints = 509858898,
        /// Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
        ModeOff = 164169907,
        /// Autoscaling is in the "Autoscale only scale out" mode. Instances in the group will be only added.
        ModeOnlyScaleOut = 3840994,
        /// Autoscaling is in the "Autoscale only out" mode. Instances in the group will be only added.
        ModeOnlyUp = 100969842,
        /// The instance group cannot be autoscaled because it has more than one backend service attached to it.
        MoreThanOneBackendService = 151922141,
        /// There is insufficient quota for the necessary resources, such as CPU or number of instances.
        NotEnoughQuotaAvailable = 403101631,
        /// Showed only for regional autoscalers: there is a resource stockout in the chosen region.
        RegionResourceStockout = 528622846,
        /// The target to be scaled does not exist.
        ScalingTargetDoesNotExist = 122636699,
        /// For some scaling schedules minRequiredReplicas is greater than maxNumReplicas. Autoscaler always recommends at most maxNumReplicas instances.
        ScheduledInstancesGreaterThanAutoscalerMax = 29275586,
        /// For some scaling schedules minRequiredReplicas is less than minNumReplicas. Autoscaler always recommends at least minNumReplicas instances.
        ScheduledInstancesLessThanAutoscalerMin = 398287669,
        Unknown = 433141802,
        /// Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
        UnsupportedMaxRateLoadBalancingConfiguration = 330845009,
        /// For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.
        ZoneResourceStockout = 210200502,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalersScopedList {
    /// [Output Only] A list of autoscalers contained in this scope.
    #[prost(message, repeated, tag = "465771644")]
    pub autoscalers: ::prost::alloc::vec::Vec<Autoscaler>,
    /// [Output Only] Informational warning which replaces the list of autoscalers when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Cloud Autoscaler policy.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalingPolicy {
    /// The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds. Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
    #[prost(int32, optional, tag = "107692954")]
    pub cool_down_period_sec: ::core::option::Option<i32>,
    /// Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
    #[prost(message, optional, tag = "381211147")]
    pub cpu_utilization: ::core::option::Option<AutoscalingPolicyCpuUtilization>,
    /// Configuration parameters of autoscaling based on a custom metric.
    #[prost(message, repeated, tag = "131972850")]
    pub custom_metric_utilizations:
        ::prost::alloc::vec::Vec<AutoscalingPolicyCustomMetricUtilization>,
    /// Configuration parameters of autoscaling based on load balancer.
    #[prost(message, optional, tag = "429746403")]
    pub load_balancing_utilization:
        ::core::option::Option<AutoscalingPolicyLoadBalancingUtilization>,
    /// The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
    #[prost(int32, optional, tag = "62327375")]
    pub max_num_replicas: ::core::option::Option<i32>,
    /// The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
    #[prost(int32, optional, tag = "535329825")]
    pub min_num_replicas: ::core::option::Option<i32>,
    /// Defines operating mode for this policy.
    /// Check the Mode enum for the list of possible values.
    #[prost(string, optional, tag = "3357091")]
    pub mode: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "527670872")]
    pub scale_in_control: ::core::option::Option<AutoscalingPolicyScaleInControl>,
    /// Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
    #[prost(btree_map = "string, message", tag = "355416580")]
    pub scaling_schedules: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        AutoscalingPolicyScalingSchedule,
    >,
}
/// Nested message and enum types in `AutoscalingPolicy`.
pub mod autoscaling_policy {
    /// Defines operating mode for this policy.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Mode {
        /// A value indicating that the enum field is not set.
        UndefinedMode = 0,
        /// Do not automatically scale the MIG in or out. The recommended_size field contains the size of MIG that would be set if the actuation mode was enabled.
        Off = 78159,
        /// Automatically scale the MIG in and out according to the policy.
        On = 2527,
        /// Automatically create VMs according to the policy, but do not scale the MIG in.
        OnlyScaleOut = 152713670,
        /// Automatically create VMs according to the policy, but do not scale the MIG in.
        OnlyUp = 478095374,
    }
}
/// CPU utilization policy.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalingPolicyCpuUtilization {
    /// Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
    /// Check the PredictiveMethod enum for the list of possible values.
    #[prost(string, optional, tag = "390220737")]
    pub predictive_method: ::core::option::Option<::prost::alloc::string::String>,
    /// The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
    #[prost(double, optional, tag = "215905870")]
    pub utilization_target: ::core::option::Option<f64>,
}
/// Nested message and enum types in `AutoscalingPolicyCpuUtilization`.
pub mod autoscaling_policy_cpu_utilization {
    /// Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PredictiveMethod {
        /// A value indicating that the enum field is not set.
        UndefinedPredictiveMethod = 0,
        /// No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics
        None = 2402104,
        /// Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
        OptimizeAvailability = 11629437,
    }
}
/// Custom utilization metric policy.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalingPolicyCustomMetricUtilization {
    /// A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
    #[prost(string, optional, tag = "533067184")]
    pub metric: ::core::option::Option<::prost::alloc::string::String>,
    /// If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
    #[prost(double, optional, tag = "504768064")]
    pub single_instance_assignment: ::core::option::Option<f64>,
    /// The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is <https://www.googleapis.com/compute/v1/instance/network/received_bytes_count.> The autoscaler works to keep this value constant for each of the instances.
    #[prost(double, optional, tag = "215905870")]
    pub utilization_target: ::core::option::Option<f64>,
    /// Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
    /// Check the UtilizationTargetType enum for the list of possible values.
    #[prost(string, optional, tag = "340169355")]
    pub utilization_target_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `AutoscalingPolicyCustomMetricUtilization`.
pub mod autoscaling_policy_custom_metric_utilization {
    /// Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum UtilizationTargetType {
        /// A value indicating that the enum field is not set.
        UndefinedUtilizationTargetType = 0,
        /// Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per minute.
        DeltaPerMinute = 87432861,
        /// Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per second.
        DeltaPerSecond = 255180029,
        /// Sets the utilization target value for a gauge metric. The autoscaler will collect the average utilization of the virtual machines from the last couple of minutes, and compare the value to the utilization target value to perform autoscaling.
        Gauge = 67590361,
    }
}
/// Configuration parameters of autoscaling based on load balancing.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalingPolicyLoadBalancingUtilization {
    /// Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
    #[prost(double, optional, tag = "215905870")]
    pub utilization_target: ::core::option::Option<f64>,
}
/// Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalingPolicyScaleInControl {
    /// Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
    #[prost(message, optional, tag = "180710123")]
    pub max_scaled_in_replicas: ::core::option::Option<FixedOrPercent>,
    /// How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
    #[prost(int32, optional, tag = "36405300")]
    pub time_window_sec: ::core::option::Option<i32>,
}
/// Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AutoscalingPolicyScalingSchedule {
    /// A description of a scaling schedule.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
    #[prost(bool, optional, tag = "270940796")]
    pub disabled: ::core::option::Option<bool>,
    /// The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
    #[prost(int32, optional, tag = "212356902")]
    pub duration_sec: ::core::option::Option<i32>,
    /// The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
    #[prost(int32, optional, tag = "365514414")]
    pub min_required_replicas: ::core::option::Option<i32>,
    /// The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
    #[prost(string, optional, tag = "375820951")]
    pub schedule: ::core::option::Option<::prost::alloc::string::String>,
    /// The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: <http://en.wikipedia.org/wiki/Tz_database.> This field is assigned a default value of “UTC” if left empty.
    #[prost(string, optional, tag = "36848094")]
    pub time_zone: ::core::option::Option<::prost::alloc::string::String>,
}
/// Message containing information of one individual backend.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Backend {
    /// Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
    /// Check the BalancingMode enum for the list of possible values.
    #[prost(string, optional, tag = "430286217")]
    pub balancing_mode: ::core::option::Option<::prost::alloc::string::String>,
    /// A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and \[0.1,1.0\]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
    #[prost(float, optional, tag = "315958157")]
    pub capacity_scaler: ::core::option::Option<f32>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
    #[prost(bool, optional, tag = "138892530")]
    pub failover: ::core::option::Option<bool>,
    /// The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](<https://cloud.google.com/load-balancing/docs/backend-service#backends>). You must use the *fully-qualified* URL (starting with <https://www.googleapis.com/>) to specify the instance group or NEG. Partial URLs are not supported.
    #[prost(string, optional, tag = "98629247")]
    pub group: ::core::option::Option<::prost::alloc::string::String>,
    /// Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
    #[prost(int32, optional, tag = "110652154")]
    pub max_connections: ::core::option::Option<i32>,
    /// Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
    #[prost(int32, optional, tag = "216904604")]
    pub max_connections_per_endpoint: ::core::option::Option<i32>,
    /// Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
    #[prost(int32, optional, tag = "104671900")]
    pub max_connections_per_instance: ::core::option::Option<i32>,
    /// Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
    #[prost(int32, optional, tag = "408035035")]
    pub max_rate: ::core::option::Option<i32>,
    /// Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
    #[prost(float, optional, tag = "129832283")]
    pub max_rate_per_endpoint: ::core::option::Option<f32>,
    /// Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
    #[prost(float, optional, tag = "17599579")]
    pub max_rate_per_instance: ::core::option::Option<f32>,
    /// Optional parameter to define a target capacity for the UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
    #[prost(float, optional, tag = "148192199")]
    pub max_utilization: ::core::option::Option<f32>,
}
/// Nested message and enum types in `Backend`.
pub mod backend {
    /// Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum BalancingMode {
        /// A value indicating that the enum field is not set.
        UndefinedBalancingMode = 0,
        /// Balance based on the number of simultaneous connections.
        Connection = 246311646,
        /// Balance based on requests per second (RPS).
        Rate = 2508000,
        /// Balance based on the backend utilization.
        Utilization = 157008386,
    }
}
/// Represents a Cloud Storage Bucket resource. This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendBucket {
    /// Cloud Storage bucket name.
    #[prost(string, optional, tag = "283610048")]
    pub bucket_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Cloud CDN configuration for this BackendBucket.
    #[prost(message, optional, tag = "213976452")]
    pub cdn_policy: ::core::option::Option<BackendBucketCdnPolicy>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// Headers that the HTTP/S load balancer should add to proxied responses.
    #[prost(string, repeated, tag = "387539094")]
    pub custom_response_headers: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// An optional textual description of the resource; provided by the client when the resource is created.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// If true, enable Cloud CDN for this BackendBucket.
    #[prost(bool, optional, tag = "282942321")]
    pub enable_cdn: ::core::option::Option<bool>,
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// Type of the resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
}
/// Message containing Cloud CDN configuration for a backend bucket.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendBucketCdnPolicy {
    /// Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
    #[prost(message, repeated, tag = "486203082")]
    pub bypass_cache_on_request_headers:
        ::prost::alloc::vec::Vec<BackendBucketCdnPolicyBypassCacheOnRequestHeader>,
    /// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
    /// Check the CacheMode enum for the list of possible values.
    #[prost(string, optional, tag = "28877888")]
    pub cache_mode: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 86400s (1 day).
    #[prost(int32, optional, tag = "29034360")]
    pub client_ttl: ::core::option::Option<i32>,
    /// Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    #[prost(int32, optional, tag = "100253422")]
    pub default_ttl: ::core::option::Option<i32>,
    /// Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    #[prost(int32, optional, tag = "307578001")]
    pub max_ttl: ::core::option::Option<i32>,
    /// Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
    #[prost(bool, optional, tag = "336110005")]
    pub negative_caching: ::core::option::Option<bool>,
    /// Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
    #[prost(message, repeated, tag = "155359996")]
    pub negative_caching_policy:
        ::prost::alloc::vec::Vec<BackendBucketCdnPolicyNegativeCachingPolicy>,
    /// If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
    #[prost(bool, optional, tag = "532808276")]
    pub request_coalescing: ::core::option::Option<bool>,
    /// Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
    #[prost(int32, optional, tag = "236682203")]
    pub serve_while_stale: ::core::option::Option<i32>,
    /// Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=\[TTL\]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
    #[prost(int64, optional, tag = "269374534")]
    pub signed_url_cache_max_age_sec: ::core::option::Option<i64>,
    /// [Output Only] Names of the keys for signing request URLs.
    #[prost(string, repeated, tag = "371848885")]
    pub signed_url_key_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `BackendBucketCdnPolicy`.
pub mod backend_bucket_cdn_policy {
    /// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum CacheMode {
        /// A value indicating that the enum field is not set.
        UndefinedCacheMode = 0,
        /// Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        CacheAllStatic = 355027945,
        /// Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
        ForceCacheAll = 486026928,
        InvalidCacheMode = 381295560,
        /// Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
        UseOriginHeaders = 55380261,
    }
}
/// Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendBucketCdnPolicyBypassCacheOnRequestHeader {
    /// The header field name to match on when bypassing cache. Values are case-insensitive.
    #[prost(string, optional, tag = "110223613")]
    pub header_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// Specify CDN TTLs for response error codes.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendBucketCdnPolicyNegativeCachingPolicy {
    /// The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
    #[prost(int32, optional, tag = "3059181")]
    pub code: ::core::option::Option<i32>,
    /// The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    #[prost(int32, optional, tag = "115180")]
    pub ttl: ::core::option::Option<i32>,
}
/// Contains a list of BackendBucket resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendBucketList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of BackendBucket resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<BackendBucket>,
    /// Type of resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Represents a Backend Service resource. A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly. Backend services in Google Compute Engine can be either regionally or globally scoped. * \[Global\](<https://cloud.google.com/compute/docs/reference/rest/v1/backendServices>) * \[Regional\](<https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices>) For more information, see Backend Services.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendService {
    /// Lifetime of cookies in seconds. This setting is applicable to external and internal HTTP(S) load balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(int32, optional, tag = "369996954")]
    pub affinity_cookie_ttl_sec: ::core::option::Option<i32>,
    /// The list of backends that serve this BackendService.
    #[prost(message, repeated, tag = "510839903")]
    pub backends: ::prost::alloc::vec::Vec<Backend>,
    /// Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
    #[prost(message, optional, tag = "213976452")]
    pub cdn_policy: ::core::option::Option<BackendServiceCdnPolicy>,
    #[prost(message, optional, tag = "421340061")]
    pub circuit_breakers: ::core::option::Option<CircuitBreakers>,
    #[prost(message, optional, tag = "461096747")]
    pub connection_draining: ::core::option::Option<ConnectionDraining>,
    /// Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "905883")]
    pub consistent_hash: ::core::option::Option<ConsistentHashLoadBalancerSettings>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// Headers that the load balancer adds to proxied requests. See [Creating custom headers](<https://cloud.google.com/load-balancing/docs/custom-headers>).
    #[prost(string, repeated, tag = "27977992")]
    pub custom_request_headers: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Headers that the load balancer adds to proxied responses. See [Creating custom headers](<https://cloud.google.com/load-balancing/docs/custom-headers>).
    #[prost(string, repeated, tag = "387539094")]
    pub custom_response_headers: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// If true, enables Cloud CDN for the backend service of an external HTTP(S) load balancer.
    #[prost(bool, optional, tag = "250733499")]
    pub enable_c_d_n: ::core::option::Option<bool>,
    /// Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](<https://cloud.google.com/load-balancing/docs/internal/failover-overview>) and [external TCP/UDP Load Balancing](/network/networklb-failover-overview).
    #[prost(message, optional, tag = "105658655")]
    pub failover_policy: ::core::option::Option<BackendServiceFailoverPolicy>,
    /// Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
    #[prost(string, repeated, tag = "448370606")]
    pub health_checks: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
    #[prost(message, optional, tag = "104024")]
    pub iap: ::core::option::Option<BackendServiceIap>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of resource. Always compute#backendService for backend services.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
    /// Check the LoadBalancingScheme enum for the list of possible values.
    #[prost(string, optional, tag = "363890244")]
    pub load_balancing_scheme: ::core::option::Option<::prost::alloc::string::String>,
    /// The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see <https://ai.google/research/pubs/pub44824> This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    /// Check the LocalityLbPolicy enum for the list of possible values.
    #[prost(string, optional, tag = "131431487")]
    pub locality_lb_policy: ::core::option::Option<::prost::alloc::string::String>,
    /// This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
    #[prost(message, optional, tag = "351299741")]
    pub log_config: ::core::option::Option<BackendServiceLogConfig>,
    /// Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
    #[prost(message, optional, tag = "61428376")]
    pub max_stream_duration: ::core::option::Option<Duration>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
    #[prost(string, optional, tag = "232872494")]
    pub network: ::core::option::Option<::prost::alloc::string::String>,
    /// Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "354625086")]
    pub outlier_detection: ::core::option::Option<OutlierDetection>,
    /// Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For Internal TCP/UDP Load Balancing and Network Load Balancing, omit port.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    /// A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](<https://cloud.google.com/load-balancing/docs/backend-service#named_ports>). This parameter has no meaning if the backends are NEGs. For Internal TCP/UDP Load Balancing and Network Load Balancing, omit port_name.
    #[prost(string, optional, tag = "41534345")]
    pub port_name: ::core::option::Option<::prost::alloc::string::String>,
    /// The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
    /// Check the Protocol enum for the list of possible values.
    #[prost(string, optional, tag = "84577944")]
    pub protocol: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The resource URL for the security policy associated with this backend service.
    #[prost(string, optional, tag = "171082513")]
    pub security_policy: ::core::option::Option<::prost::alloc::string::String>,
    /// This field specifies the security policy that applies to this backend service. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
    #[prost(message, optional, tag = "478649922")]
    pub security_settings: ::core::option::Option<SecuritySettings>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// Type of session affinity to use. The default is NONE. For a detailed description of session affinity options, see: [Session affinity](<https://cloud.google.com/load-balancing/docs/backend-service#session_affinity>). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    /// Check the SessionAffinity enum for the list of possible values.
    #[prost(string, optional, tag = "463888561")]
    pub session_affinity: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "450283536")]
    pub subsetting: ::core::option::Option<Subsetting>,
    /// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
    #[prost(int32, optional, tag = "79994995")]
    pub timeout_sec: ::core::option::Option<i32>,
}
/// Nested message and enum types in `BackendService`.
pub mod backend_service {
    /// Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum LoadBalancingScheme {
        /// A value indicating that the enum field is not set.
        UndefinedLoadBalancingScheme = 0,
        /// Signifies that this will be used for external HTTP(S), SSL Proxy, TCP Proxy, or Network Load Balancing
        External = 35607499,
        /// Signifies that this will be used for Internal TCP/UDP Load Balancing.
        Internal = 279295677,
        /// Signifies that this will be used for Internal HTTP(S) Load Balancing.
        InternalManaged = 37350397,
        /// Signifies that this will be used by Traffic Director.
        InternalSelfManaged = 236211150,
        InvalidLoadBalancingScheme = 275352060,
    }
    /// The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see <https://ai.google/research/pubs/pub44824> This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum LocalityLbPolicy {
        /// A value indicating that the enum field is not set.
        UndefinedLocalityLbPolicy = 0,
        InvalidLbPolicy = 323318707,
        /// An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
        LeastRequest = 46604921,
        /// This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see <https://ai.google/research/pubs/pub44824>
        Maglev = 119180266,
        /// Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
        OriginalDestination = 166297216,
        /// The load balancer selects a random healthy host.
        Random = 262527171,
        /// The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
        RingHash = 432795069,
        /// This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
        RoundRobin = 153895801,
    }
    /// The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Protocol {
        /// A value indicating that the enum field is not set.
        UndefinedProtocol = 0,
        /// gRPC (available for Traffic Director).
        Grpc = 2196510,
        Http = 2228360,
        /// HTTP/2 with SSL.
        Http2 = 69079210,
        Https = 69079243,
        /// TCP proxying with SSL.
        Ssl = 82412,
        /// TCP proxying or TCP pass-through.
        Tcp = 82881,
        /// UDP.
        Udp = 83873,
    }
    /// Type of session affinity to use. The default is NONE. For a detailed description of session affinity options, see: [Session affinity](<https://cloud.google.com/load-balancing/docs/backend-service#session_affinity>). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum SessionAffinity {
        /// A value indicating that the enum field is not set.
        UndefinedSessionAffinity = 0,
        /// 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
        ClientIp = 345665051,
        /// 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
        ClientIpNoDestination = 106122516,
        /// 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
        ClientIpPortProto = 221722926,
        /// 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
        ClientIpProto = 25322148,
        /// Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
        GeneratedCookie = 370321204,
        /// The hash is based on a user specified header field.
        HeaderField = 200737960,
        /// The hash is based on a user provided cookie.
        HttpCookie = 494981627,
        /// No session affinity. Connections from the same client IP may go to any instance in the pool.
        None = 2402104,
    }
}
/// Contains a list of BackendServicesScopedList.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of BackendServicesScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        BackendServicesScopedList,
    >,
    /// Type of resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Message containing Cloud CDN configuration for a backend service.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceCdnPolicy {
    /// Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
    #[prost(message, repeated, tag = "486203082")]
    pub bypass_cache_on_request_headers:
        ::prost::alloc::vec::Vec<BackendServiceCdnPolicyBypassCacheOnRequestHeader>,
    /// The CacheKeyPolicy for this CdnPolicy.
    #[prost(message, optional, tag = "159263727")]
    pub cache_key_policy: ::core::option::Option<CacheKeyPolicy>,
    /// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
    /// Check the CacheMode enum for the list of possible values.
    #[prost(string, optional, tag = "28877888")]
    pub cache_mode: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 86400s (1 day).
    #[prost(int32, optional, tag = "29034360")]
    pub client_ttl: ::core::option::Option<i32>,
    /// Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    #[prost(int32, optional, tag = "100253422")]
    pub default_ttl: ::core::option::Option<i32>,
    /// Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    #[prost(int32, optional, tag = "307578001")]
    pub max_ttl: ::core::option::Option<i32>,
    /// Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
    #[prost(bool, optional, tag = "336110005")]
    pub negative_caching: ::core::option::Option<bool>,
    /// Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
    #[prost(message, repeated, tag = "155359996")]
    pub negative_caching_policy:
        ::prost::alloc::vec::Vec<BackendServiceCdnPolicyNegativeCachingPolicy>,
    /// If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
    #[prost(bool, optional, tag = "532808276")]
    pub request_coalescing: ::core::option::Option<bool>,
    /// Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
    #[prost(int32, optional, tag = "236682203")]
    pub serve_while_stale: ::core::option::Option<i32>,
    /// Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=\[TTL\]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
    #[prost(int64, optional, tag = "269374534")]
    pub signed_url_cache_max_age_sec: ::core::option::Option<i64>,
    /// [Output Only] Names of the keys for signing request URLs.
    #[prost(string, repeated, tag = "371848885")]
    pub signed_url_key_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `BackendServiceCdnPolicy`.
pub mod backend_service_cdn_policy {
    /// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum CacheMode {
        /// A value indicating that the enum field is not set.
        UndefinedCacheMode = 0,
        /// Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        CacheAllStatic = 355027945,
        /// Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
        ForceCacheAll = 486026928,
        InvalidCacheMode = 381295560,
        /// Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
        UseOriginHeaders = 55380261,
    }
}
/// Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceCdnPolicyBypassCacheOnRequestHeader {
    /// The header field name to match on when bypassing cache. Values are case-insensitive.
    #[prost(string, optional, tag = "110223613")]
    pub header_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// Specify CDN TTLs for response error codes.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceCdnPolicyNegativeCachingPolicy {
    /// The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
    #[prost(int32, optional, tag = "3059181")]
    pub code: ::core::option::Option<i32>,
    /// The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    #[prost(int32, optional, tag = "115180")]
    pub ttl: ::core::option::Option<i32>,
}
/// For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](<https://cloud.google.com/load-balancing/docs/internal/failover-overview>) and [external TCP/UDP Load Balancing](/network/networklb-failover-overview). On failover or failback, this field indicates whether connection draining will be honored. Google Cloud has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceFailoverPolicy {
    /// This can be set to true only if the protocol is TCP. The default is false.
    #[prost(bool, optional, tag = "182150753")]
    pub disable_connection_drain_on_failover: ::core::option::Option<bool>,
    /// If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](<https://cloud.google.com/load-balancing/docs/internal/failover-overview>) and [external TCP/UDP Load Balancing](/network/networklb-failover-overview). The default is false.
    #[prost(bool, optional, tag = "112289428")]
    pub drop_traffic_if_unhealthy: ::core::option::Option<bool>,
    /// The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](<https://cloud.google.com/load-balancing/docs/internal/failover-overview>) and [external TCP/UDP Load Balancing](/network/networklb-failover-overview).
    #[prost(float, optional, tag = "212667006")]
    pub failover_ratio: ::core::option::Option<f32>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceGroupHealth {
    /// Metadata defined as annotations on the network endpoint group.
    #[prost(btree_map = "string, string", tag = "112032548")]
    pub annotations: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.
    #[prost(message, repeated, tag = "380545845")]
    pub health_status: ::prost::alloc::vec::Vec<HealthStatus>,
    /// [Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
}
/// Identity-Aware Proxy
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceIap {
    /// Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
    #[prost(bool, optional, tag = "1018689")]
    pub enabled: ::core::option::Option<bool>,
    /// OAuth2 client ID to use for the authentication flow.
    #[prost(string, optional, tag = "314017611")]
    pub oauth2_client_id: ::core::option::Option<::prost::alloc::string::String>,
    /// OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
    #[prost(string, optional, tag = "50999520")]
    pub oauth2_client_secret: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] SHA256 hash value for the field oauth2_client_secret above.
    #[prost(string, optional, tag = "112903782")]
    pub oauth2_client_secret_sha256: ::core::option::Option<::prost::alloc::string::String>,
}
/// Contains a list of BackendService resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of BackendService resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<BackendService>,
    /// [Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// The available logging options for the load balancer traffic served by this backend service.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceLogConfig {
    /// This field denotes whether to enable logging for the load balancer traffic served by this backend service.
    #[prost(bool, optional, tag = "311764355")]
    pub enable: ::core::option::Option<bool>,
    /// This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
    #[prost(float, optional, tag = "153193045")]
    pub sample_rate: ::core::option::Option<f32>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServiceReference {
    #[prost(string, optional, tag = "306946058")]
    pub backend_service: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BackendServicesScopedList {
    /// A list of BackendServices contained in this scope.
    #[prost(message, repeated, tag = "388522409")]
    pub backend_services: ::prost::alloc::vec::Vec<BackendService>,
    /// Informational warning which replaces the list of backend services when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Associates `members` with a `role`.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Binding {
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, optional, tag = "441088277")]
    pub binding_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](<https://cloud.google.com/iam/help/conditions/resource-policies>).
    #[prost(message, optional, tag = "212430107")]
    pub condition: ::core::option::Option<Expr>,
    /// Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`.
    #[prost(string, repeated, tag = "412010777")]
    pub members: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
    #[prost(string, optional, tag = "3506294")]
    pub role: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Instances.BulkInsert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BulkInsertInstanceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "41427278")]
    pub bulk_insert_instance_resource_resource: ::core::option::Option<BulkInsertInstanceResource>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A transient resource used in compute.instances.bulkInsert and compute.regionInstances.bulkInsert . This resource is not persisted anywhere, it is used only for processing the requests.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BulkInsertInstanceResource {
    /// The maximum number of instances to create.
    #[prost(int64, optional, tag = "94851343")]
    pub count: ::core::option::Option<i64>,
    /// The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
    #[prost(message, optional, tag = "215355165")]
    pub instance_properties: ::core::option::Option<InstanceProperties>,
    /// Policy for chosing target zone.
    #[prost(message, optional, tag = "465689852")]
    pub location_policy: ::core::option::Option<LocationPolicy>,
    /// The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
    #[prost(int64, optional, tag = "523228386")]
    pub min_count: ::core::option::Option<i64>,
    /// The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
    #[prost(string, optional, tag = "413815260")]
    pub name_pattern: ::core::option::Option<::prost::alloc::string::String>,
    /// Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
    #[prost(btree_map = "string, message", tag = "108502267")]
    pub per_instance_properties: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        BulkInsertInstanceResourcePerInstanceProperties,
    >,
    /// Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - <https://www.googleapis.com/compute/v1/projects/project> /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
    #[prost(string, optional, tag = "332423616")]
    pub source_instance_template: ::core::option::Option<::prost::alloc::string::String>,
}
/// Per-instance properties to be set on individual instances. To be extended in the future.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BulkInsertInstanceResourcePerInstanceProperties {
    /// This field is only temporary. It will be removed. Do not use it.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionInstances.BulkInsert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BulkInsertRegionInstanceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "41427278")]
    pub bulk_insert_instance_resource_resource: ::core::option::Option<BulkInsertInstanceResource>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CacheInvalidationRule {
    /// If set, this invalidation rule will only apply to requests with a Host header matching host.
    #[prost(string, optional, tag = "3208616")]
    pub host: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "3433509")]
    pub path: ::core::option::Option<::prost::alloc::string::String>,
}
/// Message containing what to include in the cache key for a request for Cloud CDN.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CacheKeyPolicy {
    /// If true, requests to different hosts will be cached separately.
    #[prost(bool, optional, tag = "486867679")]
    pub include_host: ::core::option::Option<bool>,
    /// If true, http and https requests will be cached separately.
    #[prost(bool, optional, tag = "303507535")]
    pub include_protocol: ::core::option::Option<bool>,
    /// If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
    #[prost(bool, optional, tag = "474036639")]
    pub include_query_string: ::core::option::Option<bool>,
    /// Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
    #[prost(string, repeated, tag = "354964742")]
    pub query_string_blacklist: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
    #[prost(string, repeated, tag = "52456496")]
    pub query_string_whitelist: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Settings controlling the volume of requests, connections and retries to this backend service.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CircuitBreakers {
    /// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(int32, optional, tag = "110652154")]
    pub max_connections: ::core::option::Option<i32>,
    /// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(int32, optional, tag = "375558887")]
    pub max_pending_requests: ::core::option::Option<i32>,
    /// The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
    #[prost(int32, optional, tag = "28097599")]
    pub max_requests: ::core::option::Option<i32>,
    /// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(int32, optional, tag = "361630528")]
    pub max_requests_per_connection: ::core::option::Option<i32>,
    /// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(int32, optional, tag = "55546219")]
    pub max_retries: ::core::option::Option<i32>,
}
/// A request message for FirewallPolicies.CloneRules. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CloneRulesFirewallPolicyRequest {
    /// Name of the firewall policy to update.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The firewall policy from which to copy rules.
    #[prost(string, optional, tag = "25013549")]
    pub source_firewall_policy: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents a regional Commitment resource. Creating a commitment resource means that you are purchasing a committed use contract with an explicit start and end time. You can create commitments based on vCPUs and memory usage and receive discounted rates. For full details, read Signing Up for Committed Use Discounts.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Commitment {
    /// The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
    /// Check the Category enum for the list of possible values.
    #[prost(string, optional, tag = "50511102")]
    pub category: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Commitment end time in RFC3339 text format.
    #[prost(string, optional, tag = "468096690")]
    pub end_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#commitment for commitments.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// The license specification required as part of a license commitment.
    #[prost(message, optional, tag = "437955148")]
    pub license_resource: ::core::option::Option<LicenseResourceCommitment>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
    /// Check the Plan enum for the list of possible values.
    #[prost(string, optional, tag = "3443497")]
    pub plan: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of the region where this commitment may be used.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// List of reservations in this commitment.
    #[prost(message, repeated, tag = "399717927")]
    pub reservations: ::prost::alloc::vec::Vec<Reservation>,
    /// A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
    #[prost(message, repeated, tag = "164412965")]
    pub resources: ::prost::alloc::vec::Vec<ResourceCommitment>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Commitment start time in RFC3339 text format.
    #[prost(string, optional, tag = "83645817")]
    pub start_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] An optional, human-readable explanation of the status.
    #[prost(string, optional, tag = "297428154")]
    pub status_message: ::core::option::Option<::prost::alloc::string::String>,
    /// The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Commitment`.
pub mod commitment {
    /// The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Category {
        /// A value indicating that the enum field is not set.
        UndefinedCategory = 0,
        Unspecified = 509189462,
        License = 347869217,
        Machine = 469553191,
    }
    /// The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Plan {
        /// A value indicating that the enum field is not set.
        UndefinedPlan = 0,
        Invalid = 530283991,
        ThirtySixMonth = 266295942,
        TwelveMonth = 173083962,
    }
    /// [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        Active = 314733318,
        Creating = 455564985,
        Expired = 482489093,
        NotYetActive = 20607337,
    }
    /// The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        AcceleratorOptimized = 280848403,
        ComputeOptimized = 158349023,
        GeneralPurpose = 299793543,
        GeneralPurposeE2 = 301911877,
        GeneralPurposeN2 = 301912156,
        GeneralPurposeN2d = 232471400,
        MemoryOptimized = 281753417,
        Unspecified = 437714322,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommitmentAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of CommitmentsScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        CommitmentsScopedList,
    >,
    /// [Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of Commitment resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommitmentList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Commitment resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Commitment>,
    /// [Output Only] Type of resource. Always compute#commitmentList for lists of commitments.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommitmentsScopedList {
    /// [Output Only] A list of commitments contained in this scope.
    #[prost(message, repeated, tag = "450664446")]
    pub commitments: ::prost::alloc::vec::Vec<Commitment>,
    /// [Output Only] Informational warning which replaces the list of commitments when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// This is deprecated and has no effect. Do not use.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Condition {
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, optional, tag = "104021")]
    pub iam: ::core::option::Option<::prost::alloc::string::String>,
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, optional, tag = "3553")]
    pub op: ::core::option::Option<::prost::alloc::string::String>,
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, optional, tag = "114272")]
    pub svc: ::core::option::Option<::prost::alloc::string::String>,
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, optional, tag = "114381")]
    pub sys: ::core::option::Option<::prost::alloc::string::String>,
    /// This is deprecated and has no effect. Do not use.
    #[prost(string, repeated, tag = "249928994")]
    pub values: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// A set of Confidential Instance options.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConfidentialInstanceConfig {
    /// Defines whether the instance should have confidential compute enabled.
    #[prost(bool, optional, tag = "102135228")]
    pub enable_confidential_compute: ::core::option::Option<bool>,
}
/// Message containing connection draining configuration.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConnectionDraining {
    /// Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
    #[prost(int32, optional, tag = "225127070")]
    pub draining_timeout_sec: ::core::option::Option<i32>,
}
/// This message defines settings for a consistent hash style load balancer.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConsistentHashLoadBalancerSettings {
    /// Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE.
    #[prost(message, optional, tag = "6673915")]
    pub http_cookie: ::core::option::Option<ConsistentHashLoadBalancerSettingsHttpCookie>,
    /// The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
    #[prost(string, optional, tag = "234798022")]
    pub http_header_name: ::core::option::Option<::prost::alloc::string::String>,
    /// The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
    #[prost(int64, optional, tag = "234380735")]
    pub minimum_ring_size: ::core::option::Option<i64>,
}
/// The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConsistentHashLoadBalancerSettingsHttpCookie {
    /// Name of the cookie.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Path to set for the cookie.
    #[prost(string, optional, tag = "3433509")]
    pub path: ::core::option::Option<::prost::alloc::string::String>,
    /// Lifetime of the cookie.
    #[prost(message, optional, tag = "115180")]
    pub ttl: ::core::option::Option<Duration>,
}
/// The specification for allowing client side cross-origin requests. Please see W3C Recommendation for Cross Origin Resource Sharing
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CorsPolicy {
    /// In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This translates to the Access-Control-Allow-Credentials header. Default is false.
    #[prost(bool, optional, tag = "481263366")]
    pub allow_credentials: ::core::option::Option<bool>,
    /// Specifies the content for the Access-Control-Allow-Headers header.
    #[prost(string, repeated, tag = "45179024")]
    pub allow_headers: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies the content for the Access-Control-Allow-Methods header.
    #[prost(string, repeated, tag = "205405372")]
    pub allow_methods: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies the regualar expression patterns that match allowed origins. For regular expression grammar please see github.com/google/re2/wiki/Syntax An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    #[prost(string, repeated, tag = "215385810")]
    pub allow_origin_regexes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies the list of origins that will be allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    #[prost(string, repeated, tag = "194914071")]
    pub allow_origins: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// If true, specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
    #[prost(bool, optional, tag = "270940796")]
    pub disabled: ::core::option::Option<bool>,
    /// Specifies the content for the Access-Control-Expose-Headers header.
    #[prost(string, repeated, tag = "247604747")]
    pub expose_headers: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
    #[prost(int32, optional, tag = "307559332")]
    pub max_age: ::core::option::Option<i32>,
}
/// A request message for InstanceGroupManagers.CreateInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateInstancesInstanceGroupManagerRequest {
    /// The name of the managed instance group. It should conform to RFC1035.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "24558867")]
    pub instance_group_managers_create_instances_request_resource:
        ::core::option::Option<InstanceGroupManagersCreateInstancesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the managed instance group is located. It should conform to RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroupManagers.CreateInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateInstancesRegionInstanceGroupManagerRequest {
    /// The name of the managed instance group. It should conform to RFC1035.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region where the managed instance group is located. It should conform to RFC1035.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "359014280")]
    pub region_instance_group_managers_create_instances_request_resource:
        ::core::option::Option<RegionInstanceGroupManagersCreateInstancesRequest>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Disks.CreateSnapshot. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateSnapshotDiskRequest {
    /// Name of the persistent disk to snapshot.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
    #[prost(bool, optional, tag = "385550813")]
    pub guest_flush: ::core::option::Option<bool>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "481319977")]
    pub snapshot_resource: ::core::option::Option<Snapshot>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionDisks.CreateSnapshot. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateSnapshotRegionDiskRequest {
    /// Name of the regional persistent disk to snapshot.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "481319977")]
    pub snapshot_resource: ::core::option::Option<Snapshot>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CustomerEncryptionKey {
    /// The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key
    #[prost(string, optional, tag = "484373913")]
    pub kms_key_name: ::core::option::Option<::prost::alloc::string::String>,
    /// The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/
    #[prost(string, optional, tag = "209986261")]
    pub kms_key_service_account: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
    #[prost(string, optional, tag = "449196488")]
    pub raw_key: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: <https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem>
    #[prost(string, optional, tag = "335487397")]
    pub rsa_encrypted_key: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
    #[prost(string, optional, tag = "170112551")]
    pub sha256: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CustomerEncryptionKeyProtectedDisk {
    /// Decrypts data associated with the disk with a customer-supplied encryption key.
    #[prost(message, optional, tag = "271660677")]
    pub disk_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks. For example: "source": "/compute/v1/projects/project_id/zones/zone/disks/ disk_name
    #[prost(string, optional, tag = "177235995")]
    pub source: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Data {
    /// [Output Only] A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
    #[prost(string, optional, tag = "106079")]
    pub key: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A warning data value corresponding to the key.
    #[prost(string, optional, tag = "111972721")]
    pub value: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Instances.DeleteAccessConfig. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteAccessConfigInstanceRequest {
    /// The name of the access config to delete.
    #[prost(string, tag = "72856189")]
    pub access_config: ::prost::alloc::string::String,
    /// The instance name for this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// The name of the network interface.
    #[prost(string, tag = "365387880")]
    pub network_interface: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Addresses.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteAddressRequest {
    /// Name of the address resource to delete.
    #[prost(string, tag = "462920692")]
    pub address: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Autoscalers.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteAutoscalerRequest {
    /// Name of the autoscaler to delete.
    #[prost(string, tag = "517258967")]
    pub autoscaler: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for BackendBuckets.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteBackendBucketRequest {
    /// Name of the BackendBucket resource to delete.
    #[prost(string, tag = "91714037")]
    pub backend_bucket: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for BackendServices.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteBackendServiceRequest {
    /// Name of the BackendService resource to delete.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Disks.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteDiskRequest {
    /// Name of the persistent disk to delete.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ExternalVpnGateways.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteExternalVpnGatewayRequest {
    /// Name of the externalVpnGateways to delete.
    #[prost(string, tag = "109898629")]
    pub external_vpn_gateway: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for FirewallPolicies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteFirewallPolicyRequest {
    /// Name of the firewall policy to delete.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Firewalls.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteFirewallRequest {
    /// Name of the firewall rule to delete.
    #[prost(string, tag = "511016192")]
    pub firewall: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for ForwardingRules.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteForwardingRuleRequest {
    /// Name of the ForwardingRule resource to delete.
    #[prost(string, tag = "269964030")]
    pub forwarding_rule: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalAddresses.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalAddressRequest {
    /// Name of the address resource to delete.
    #[prost(string, tag = "462920692")]
    pub address: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalForwardingRules.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalForwardingRuleRequest {
    /// Name of the ForwardingRule resource to delete.
    #[prost(string, tag = "269964030")]
    pub forwarding_rule: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalNetworkEndpointGroups.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalNetworkEndpointGroupRequest {
    /// The name of the network endpoint group to delete. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalOperationRequest {
    /// Name of the Operations resource to delete.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A response message for GlobalOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalOperationResponse {}
/// A request message for GlobalOrganizationOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalOrganizationOperationRequest {
    /// Name of the Operations resource to delete.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Parent ID for this request.
    #[prost(string, optional, tag = "459714768")]
    pub parent_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A response message for GlobalOrganizationOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalOrganizationOperationResponse {}
/// A request message for GlobalPublicDelegatedPrefixes.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteGlobalPublicDelegatedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the PublicDelegatedPrefix resource to delete.
    #[prost(string, tag = "204238440")]
    pub public_delegated_prefix: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for HealthChecks.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteHealthCheckRequest {
    /// Name of the HealthCheck resource to delete.
    #[prost(string, tag = "308876645")]
    pub health_check: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Images.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteImageRequest {
    /// Name of the image resource to delete.
    #[prost(string, tag = "100313435")]
    pub image: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for InstanceGroupManagers.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInstanceGroupManagerRequest {
    /// The name of the managed instance group to delete.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the managed instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceGroups.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInstanceGroupRequest {
    /// The name of the instance group to delete.
    #[prost(string, tag = "81095253")]
    pub instance_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Instances.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInstanceRequest {
    /// Name of the instance resource to delete.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceTemplates.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInstanceTemplateRequest {
    /// The name of the instance template to delete.
    #[prost(string, tag = "309248228")]
    pub instance_template: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for InstanceGroupManagers.DeleteInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInstancesInstanceGroupManagerRequest {
    /// The name of the managed instance group.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "166421252")]
    pub instance_group_managers_delete_instances_request_resource:
        ::core::option::Option<InstanceGroupManagersDeleteInstancesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the managed instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroupManagers.DeleteInstances. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInstancesRegionInstanceGroupManagerRequest {
    /// Name of the managed instance group.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "500876665")]
    pub region_instance_group_managers_delete_instances_request_resource:
        ::core::option::Option<RegionInstanceGroupManagersDeleteInstancesRequest>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for InterconnectAttachments.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInterconnectAttachmentRequest {
    /// Name of the interconnect attachment to delete.
    #[prost(string, tag = "308135284")]
    pub interconnect_attachment: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Interconnects.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteInterconnectRequest {
    /// Name of the interconnect to delete.
    #[prost(string, tag = "224601230")]
    pub interconnect: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Licenses.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteLicenseRequest {
    /// Name of the license resource to delete.
    #[prost(string, tag = "166757441")]
    pub license: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NetworkEndpointGroups.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteNetworkEndpointGroupRequest {
    /// The name of the network endpoint group to delete. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the network endpoint group is located. It should comply with RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Networks.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteNetworkRequest {
    /// Name of the network to delete.
    #[prost(string, tag = "232872494")]
    pub network: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NodeGroups.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteNodeGroupRequest {
    /// Name of the NodeGroup resource to delete.
    #[prost(string, tag = "469958146")]
    pub node_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for NodeTemplates.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteNodeTemplateRequest {
    /// Name of the NodeTemplate resource to delete.
    #[prost(string, tag = "323154455")]
    pub node_template: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NodeGroups.DeleteNodes. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteNodesNodeGroupRequest {
    /// Name of the NodeGroup resource whose nodes will be deleted.
    #[prost(string, tag = "469958146")]
    pub node_group: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "183298962")]
    pub node_groups_delete_nodes_request_resource:
        ::core::option::Option<NodeGroupsDeleteNodesRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for PacketMirrorings.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeletePacketMirroringRequest {
    /// Name of the PacketMirroring resource to delete.
    #[prost(string, tag = "22305996")]
    pub packet_mirroring: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for InstanceGroupManagers.DeletePerInstanceConfigs. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeletePerInstanceConfigsInstanceGroupManagerRequest {
    /// The name of the managed instance group. It should conform to RFC1035.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "362427680")]
    pub instance_group_managers_delete_per_instance_configs_req_resource:
        ::core::option::Option<InstanceGroupManagersDeletePerInstanceConfigsReq>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone where the managed instance group is located. It should conform to RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroupManagers.DeletePerInstanceConfigs. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeletePerInstanceConfigsRegionInstanceGroupManagerRequest {
    /// The name of the managed instance group. It should conform to RFC1035.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request, should conform to RFC1035.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "740741")]
    pub region_instance_group_manager_delete_instance_config_req_resource:
        ::core::option::Option<RegionInstanceGroupManagerDeleteInstanceConfigReq>,
}
/// A request message for PublicAdvertisedPrefixes.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeletePublicAdvertisedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the PublicAdvertisedPrefix resource to delete.
    #[prost(string, tag = "101874590")]
    pub public_advertised_prefix: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for PublicDelegatedPrefixes.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeletePublicDelegatedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the PublicDelegatedPrefix resource to delete.
    #[prost(string, tag = "204238440")]
    pub public_delegated_prefix: ::prost::alloc::string::String,
    /// Name of the region of this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionAutoscalers.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionAutoscalerRequest {
    /// Name of the autoscaler to delete.
    #[prost(string, tag = "517258967")]
    pub autoscaler: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionBackendServices.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionBackendServiceRequest {
    /// Name of the BackendService resource to delete.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionDisks.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionDiskRequest {
    /// Name of the regional persistent disk to delete.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionHealthChecks.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionHealthCheckRequest {
    /// Name of the HealthCheck resource to delete.
    #[prost(string, tag = "308876645")]
    pub health_check: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionHealthCheckServices.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionHealthCheckServiceRequest {
    /// Name of the HealthCheckService to delete. The name must be 1-63 characters long, and comply with RFC1035.
    #[prost(string, tag = "408374747")]
    pub health_check_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionInstanceGroupManagers.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionInstanceGroupManagerRequest {
    /// Name of the managed instance group to delete.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionNetworkEndpointGroups.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionNetworkEndpointGroupRequest {
    /// The name of the network endpoint group to delete. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region where the network endpoint group is located. It should comply with RFC1035.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionNotificationEndpoints.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionNotificationEndpointRequest {
    /// Name of the NotificationEndpoint resource to delete.
    #[prost(string, tag = "376807017")]
    pub notification_endpoint: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionOperationRequest {
    /// Name of the Operations resource to delete.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A response message for RegionOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionOperationResponse {}
/// A request message for RegionSslCertificates.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionSslCertificateRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the SslCertificate resource to delete.
    #[prost(string, tag = "46443492")]
    pub ssl_certificate: ::prost::alloc::string::String,
}
/// A request message for RegionTargetHttpProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionTargetHttpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetHttpProxy resource to delete.
    #[prost(string, tag = "206872421")]
    pub target_http_proxy: ::prost::alloc::string::String,
}
/// A request message for RegionTargetHttpsProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionTargetHttpsProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetHttpsProxy resource to delete.
    #[prost(string, tag = "52336748")]
    pub target_https_proxy: ::prost::alloc::string::String,
}
/// A request message for RegionUrlMaps.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRegionUrlMapRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// begin_interface: MixerMutationRequestBuilder Request ID to support idempotency.
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the UrlMap resource to delete.
    #[prost(string, tag = "367020684")]
    pub url_map: ::prost::alloc::string::String,
}
/// A request message for Reservations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteReservationRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the reservation to delete.
    #[prost(string, tag = "47530956")]
    pub reservation: ::prost::alloc::string::String,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ResourcePolicies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteResourcePolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource policy to delete.
    #[prost(string, tag = "159240835")]
    pub resource_policy: ::prost::alloc::string::String,
}
/// A request message for Routes.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRouteRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the Route resource to delete.
    #[prost(string, tag = "108704329")]
    pub route: ::prost::alloc::string::String,
}
/// A request message for Routers.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRouterRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the Router resource to delete.
    #[prost(string, tag = "148608841")]
    pub router: ::prost::alloc::string::String,
}
/// A request message for SecurityPolicies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSecurityPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the security policy to delete.
    #[prost(string, tag = "171082513")]
    pub security_policy: ::prost::alloc::string::String,
}
/// A request message for ServiceAttachments.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteServiceAttachmentRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region of this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the ServiceAttachment resource to delete.
    #[prost(string, tag = "338957549")]
    pub service_attachment: ::prost::alloc::string::String,
}
/// A request message for BackendBuckets.DeleteSignedUrlKey. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSignedUrlKeyBackendBucketRequest {
    /// Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
    #[prost(string, tag = "91714037")]
    pub backend_bucket: ::prost::alloc::string::String,
    /// The name of the Signed URL Key to delete.
    #[prost(string, tag = "500938859")]
    pub key_name: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for BackendServices.DeleteSignedUrlKey. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSignedUrlKeyBackendServiceRequest {
    /// Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    /// The name of the Signed URL Key to delete.
    #[prost(string, tag = "500938859")]
    pub key_name: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Snapshots.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSnapshotRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the Snapshot resource to delete.
    #[prost(string, tag = "284874180")]
    pub snapshot: ::prost::alloc::string::String,
}
/// A request message for SslCertificates.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSslCertificateRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the SslCertificate resource to delete.
    #[prost(string, tag = "46443492")]
    pub ssl_certificate: ::prost::alloc::string::String,
}
/// A request message for SslPolicies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSslPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the SSL policy to delete. The name must be 1-63 characters long, and comply with RFC1035.
    #[prost(string, tag = "295190213")]
    pub ssl_policy: ::prost::alloc::string::String,
}
/// A request message for Subnetworks.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteSubnetworkRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the Subnetwork resource to delete.
    #[prost(string, tag = "307827694")]
    pub subnetwork: ::prost::alloc::string::String,
}
/// A request message for TargetGrpcProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetGrpcProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetGrpcProxy resource to delete.
    #[prost(string, tag = "5020283")]
    pub target_grpc_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetHttpProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetHttpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetHttpProxy resource to delete.
    #[prost(string, tag = "206872421")]
    pub target_http_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetHttpsProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetHttpsProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetHttpsProxy resource to delete.
    #[prost(string, tag = "52336748")]
    pub target_https_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetInstances.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetInstanceRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetInstance resource to delete.
    #[prost(string, tag = "289769347")]
    pub target_instance: ::prost::alloc::string::String,
    /// Name of the zone scoping this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for TargetPools.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetPoolRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetPool resource to delete.
    #[prost(string, tag = "62796298")]
    pub target_pool: ::prost::alloc::string::String,
}
/// A request message for TargetSslProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetSslProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetSslProxy resource to delete.
    #[prost(string, tag = "338795853")]
    pub target_ssl_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetTcpProxies.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetTcpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the TargetTcpProxy resource to delete.
    #[prost(string, tag = "503065442")]
    pub target_tcp_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetVpnGateways.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteTargetVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the target VPN gateway to delete.
    #[prost(string, tag = "532512843")]
    pub target_vpn_gateway: ::prost::alloc::string::String,
}
/// A request message for UrlMaps.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteUrlMapRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the UrlMap resource to delete.
    #[prost(string, tag = "367020684")]
    pub url_map: ::prost::alloc::string::String,
}
/// A request message for VpnGateways.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the VPN gateway to delete.
    #[prost(string, tag = "406684153")]
    pub vpn_gateway: ::prost::alloc::string::String,
}
/// A request message for VpnTunnels.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteVpnTunnelRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the VpnTunnel resource to delete.
    #[prost(string, tag = "143821331")]
    pub vpn_tunnel: ::prost::alloc::string::String,
}
/// A request message for ZoneOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteZoneOperationRequest {
    /// Name of the Operations resource to delete.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A response message for ZoneOperations.Delete. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteZoneOperationResponse {}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Denied {
    /// The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
    #[prost(string, optional, tag = "488094525")]
    pub i_p_protocol: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: \["22"\], \["80","443"\], and \["12345-12349"\].
    #[prost(string, repeated, tag = "106854418")]
    pub ports: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// A request message for Images.Deprecate. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeprecateImageRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "333006064")]
    pub deprecation_status_resource: ::core::option::Option<DeprecationStatus>,
    /// Image name.
    #[prost(string, tag = "100313435")]
    pub image: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// Deprecation status for a public resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeprecationStatus {
    /// An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
    #[prost(string, optional, tag = "476721177")]
    pub deleted: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
    #[prost(string, optional, tag = "515138995")]
    pub deprecated: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
    #[prost(string, optional, tag = "357647769")]
    pub obsolete: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
    #[prost(string, optional, tag = "430919186")]
    pub replacement: ::core::option::Option<::prost::alloc::string::String>,
    /// The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `DeprecationStatus`.
pub mod deprecation_status {
    /// The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        Active = 314733318,
        Deleted = 120962041,
        Deprecated = 463360435,
        Obsolete = 66532761,
    }
}
/// A request message for Instances.DetachDisk. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DetachDiskInstanceRequest {
    /// The device name of the disk to detach. Make a get() request on the instance to view currently attached disks and device names.
    #[prost(string, tag = "67541716")]
    pub device_name: ::prost::alloc::string::String,
    /// Instance name for this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for GlobalNetworkEndpointGroups.DetachNetworkEndpoints. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "8898269")]
    pub global_network_endpoint_groups_detach_endpoints_request_resource:
        ::core::option::Option<GlobalNetworkEndpointGroupsDetachEndpointsRequest>,
    /// The name of the network endpoint group where you are removing network endpoints. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NetworkEndpointGroups.DetachNetworkEndpoints. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DetachNetworkEndpointsNetworkEndpointGroupRequest {
    /// The name of the network endpoint group where you are removing network endpoints. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "515608697")]
    pub network_endpoint_groups_detach_endpoints_request_resource:
        ::core::option::Option<NetworkEndpointGroupsDetachEndpointsRequest>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where the network endpoint group is located. It should comply with RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Projects.DisableXpnHost. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisableXpnHostProjectRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Projects.DisableXpnResource. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisableXpnResourceProjectRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "209136170")]
    pub projects_disable_xpn_resource_request_resource:
        ::core::option::Option<ProjectsDisableXpnResourceRequest>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents a Persistent Disk resource. Google Compute Engine has two Disk resources: * \[Zonal\](/compute/docs/reference/rest/v1/disks) * \[Regional\](/compute/docs/reference/rest/v1/regionDisks) Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options. The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks. The regionDisks resource represents a regional persistent disk. For more information, read Regional resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Disk {
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
    #[prost(message, optional, tag = "271660677")]
    pub disk_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
    #[prost(message, repeated, tag = "79294545")]
    pub guest_os_features: ::prost::alloc::vec::Vec<GuestOsFeature>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#disk for disks.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// Labels to apply to this disk. These can be later modified by the setLabels method.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// [Output Only] Last attach timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "42159653")]
    pub last_attach_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Last detach timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "56471027")]
    pub last_detach_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// Integer license codes indicating which licenses are attached to this disk.
    #[prost(int64, repeated, tag = "45482664")]
    pub license_codes: ::prost::alloc::vec::Vec<i64>,
    /// A list of publicly visible licenses. Reserved for Google's use.
    #[prost(string, repeated, tag = "337642578")]
    pub licenses: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
    #[prost(string, optional, tag = "350519505")]
    pub location_hint: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Internal use only.
    #[prost(string, optional, tag = "361137822")]
    pub options: ::core::option::Option<::prost::alloc::string::String>,
    /// Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
    #[prost(int64, optional, tag = "420007943")]
    pub physical_block_size_bytes: ::core::option::Option<i64>,
    /// Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
    #[prost(int64, optional, tag = "186769108")]
    pub provisioned_iops: ::core::option::Option<i64>,
    /// [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
    #[prost(string, repeated, tag = "48438272")]
    pub replica_zones: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Resource policies applied to this disk for automatic snapshot creations.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Reserved for future use.
    #[prost(bool, optional, tag = "480964267")]
    pub satisfies_pzs: ::core::option::Option<bool>,
    /// [Output Only] Server-defined fully-qualified URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
    #[prost(int64, optional, tag = "494929369")]
    pub size_gb: ::core::option::Option<i64>,
    /// The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /disks/disk - <https://www.googleapis.com/compute/v1/projects/project/regions/region> /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
    #[prost(string, optional, tag = "451753793")]
    pub source_disk: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
    #[prost(string, optional, tag = "454190809")]
    pub source_disk_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
    #[prost(string, optional, tag = "50443319")]
    pub source_image: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
    #[prost(message, optional, tag = "381503659")]
    pub source_image_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
    #[prost(string, optional, tag = "55328291")]
    pub source_image_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - <https://www.googleapis.com/compute/v1/projects/project> /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot
    #[prost(string, optional, tag = "126061928")]
    pub source_snapshot: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
    #[prost(message, optional, tag = "303679322")]
    pub source_snapshot_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
    #[prost(string, optional, tag = "98962258")]
    pub source_snapshot_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or <https://storage.googleapis.com/.> This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
    #[prost(string, optional, tag = "233052711")]
    pub source_storage_object: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
    #[prost(string, repeated, tag = "111578632")]
    pub users: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Disk`.
pub mod disk {
    /// [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// Disk is provisioning
        Creating = 455564985,
        /// Disk is deleting.
        Deleting = 528602024,
        /// Disk creation failed.
        Failed = 455706685,
        /// Disk is ready for use.
        Ready = 77848963,
        /// Source data is being copied into the disk.
        Restoring = 404263851,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of DisksScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items:
        ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, DisksScopedList>,
    /// [Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskInstantiationConfig {
    /// Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
    #[prost(bool, optional, tag = "464761403")]
    pub auto_delete: ::core::option::Option<bool>,
    /// The custom source image to be used to restore this disk when instantiating this instance template.
    #[prost(string, optional, tag = "184123149")]
    pub custom_image: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the device name of the disk to which the configurations apply to.
    #[prost(string, optional, tag = "67541716")]
    pub device_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
    /// Check the InstantiateFrom enum for the list of possible values.
    #[prost(string, optional, tag = "393383903")]
    pub instantiate_from: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `DiskInstantiationConfig`.
pub mod disk_instantiation_config {
    /// Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum InstantiateFrom {
        /// A value indicating that the enum field is not set.
        UndefinedInstantiateFrom = 0,
        /// Attach the existing disk in read-only mode. The request will fail if the disk was attached in read-write mode on the source instance. Applicable to: read-only disks.
        AttachReadOnly = 513775419,
        /// Create a blank disk. The disk will be created unformatted. Applicable to: additional read-write disks, local SSDs.
        Blank = 63281460,
        /// Use the custom image specified in the custom_image field. Applicable to: boot disk, additional read-write disks.
        CustomImage = 196311789,
        /// Use the default instantiation option for the corresponding type of disk. For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
        Default = 115302945,
        /// Do not include the disk in the instance template. Applicable to: additional read-write disks, local SSDs, read-only disks.
        DoNotInclude = 104218952,
        /// Use the same source image used for creation of the source instance's corresponding disk. The request will fail if the source VM's disk was created from a snapshot. Applicable to: boot disk, additional read-write disks.
        SourceImage = 62631959,
        /// Use the same source image family used for creation of the source instance's corresponding disk. The request will fail if the source image of the source disk does not belong to any image family. Applicable to: boot disk, additional read-write disks.
        SourceImageFamily = 76850316,
    }
}
/// A list of Disk resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Disk resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Disk>,
    /// [Output Only] Type of resource. Always compute#diskList for lists of disks.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskMoveRequest {
    /// The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> - projects/project/zones/zone - zones/zone
    #[prost(string, optional, tag = "131854653")]
    pub destination_zone: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk
    #[prost(string, optional, tag = "62433163")]
    pub target_disk: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents a Disk Type resource. Google Compute Engine has two Disk Type resources: * \[Regional\](/compute/docs/reference/rest/v1/regionDiskTypes) * \[Zonal\](/compute/docs/reference/rest/v1/diskTypes) You can choose from a variety of disk types based on your needs. For more information, read Storage options. The diskTypes resource represents disk types for a zonal persistent disk. For more information, read Zonal persistent disks. The regionDiskTypes resource represents disk types for a regional persistent disk. For more information, read Regional persistent disks.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskType {
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined default disk size in GB.
    #[prost(int64, optional, tag = "270619253")]
    pub default_disk_size_gb: ::core::option::Option<i64>,
    /// [Output Only] The deprecation status associated with this disk type.
    #[prost(message, optional, tag = "515138995")]
    pub deprecated: ::core::option::Option<DeprecationStatus>,
    /// [Output Only] An optional description of this resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#diskType for disk types.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Name of the resource.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] An optional textual description of the valid disk size, such as "10GB-10TB".
    #[prost(string, optional, tag = "493962464")]
    pub valid_disk_size: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskTypeAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of DiskTypesScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items:
        ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, DiskTypesScopedList>,
    /// [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of disk types.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskTypeList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of DiskType resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<DiskType>,
    /// [Output Only] Type of resource. Always compute#diskTypeList for disk types.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiskTypesScopedList {
    /// [Output Only] A list of disk types contained in this scope.
    #[prost(message, repeated, tag = "198926167")]
    pub disk_types: ::prost::alloc::vec::Vec<DiskType>,
    /// [Output Only] Informational warning which replaces the list of disk types when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksAddResourcePoliciesRequest {
    /// Full or relative path to the resource policy to be added to this disk. You can only specify one resource policy.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksRemoveResourcePoliciesRequest {
    /// Resource policies to be removed from this disk.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksResizeRequest {
    /// The new size of the persistent disk, which is specified in GB.
    #[prost(int64, optional, tag = "494929369")]
    pub size_gb: ::core::option::Option<i64>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksScopedList {
    /// [Output Only] A list of disks contained in this scope.
    #[prost(message, repeated, tag = "95594102")]
    pub disks: ::prost::alloc::vec::Vec<Disk>,
    /// [Output Only] Informational warning which replaces the list of disks when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// A set of Display Device options
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisplayDevice {
    /// Defines whether the instance has Display enabled.
    #[prost(bool, optional, tag = "14266886")]
    pub enable_display: ::core::option::Option<bool>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DistributionPolicy {
    /// The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
    /// Check the TargetShape enum for the list of possible values.
    #[prost(string, optional, tag = "338621299")]
    pub target_shape: ::core::option::Option<::prost::alloc::string::String>,
    /// Zones where the regional managed instance group will create and manage its instances.
    #[prost(message, repeated, tag = "116085319")]
    pub zones: ::prost::alloc::vec::Vec<DistributionPolicyZoneConfiguration>,
}
/// Nested message and enum types in `DistributionPolicy`.
pub mod distribution_policy {
    /// The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum TargetShape {
        /// A value indicating that the enum field is not set.
        UndefinedTargetShape = 0,
        /// The group picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
        Any = 64972,
        /// The group prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across selected zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
        Balanced = 468409608,
        /// The group schedules VM instance creation and deletion to achieve and maintain an even number of managed instances across the selected zones. The distribution is even when the number of managed instances does not differ by more than 1 between any two zones. Recommended for highly available serving workloads.
        Even = 2140442,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DistributionPolicyZoneConfiguration {
    /// The URL of the zone. The zone must exist in the region where the managed instance group is located.
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
/// A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Duration {
    /// Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
    #[prost(int32, optional, tag = "104586303")]
    pub nanos: ::core::option::Option<i32>,
    /// Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    #[prost(int64, optional, tag = "359484031")]
    pub seconds: ::core::option::Option<i64>,
}
/// A request message for Projects.EnableXpnHost. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EnableXpnHostProjectRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Projects.EnableXpnResource. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EnableXpnResourceProjectRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "421980207")]
    pub projects_enable_xpn_resource_request_resource:
        ::core::option::Option<ProjectsEnableXpnResourceRequest>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// [Output Only] If errors are generated during processing of the operation, this field will be populated.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Error {
    /// [Output Only] The array of errors encountered while processing this operation.
    #[prost(message, repeated, tag = "315977579")]
    pub errors: ::prost::alloc::vec::Vec<Errors>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Errors {
    /// [Output Only] The error type identifier for this error.
    #[prost(string, optional, tag = "3059181")]
    pub code: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Indicates the field in the request that caused the error. This property is optional.
    #[prost(string, optional, tag = "290430901")]
    pub location: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] An optional, human-readable error message.
    #[prost(string, optional, tag = "418054151")]
    pub message: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExchangedPeeringRoute {
    /// The destination range of the route.
    #[prost(string, optional, tag = "381327712")]
    pub dest_range: ::core::option::Option<::prost::alloc::string::String>,
    /// True if the peering route has been imported from a peer. The actual import happens if the field networkPeering.importCustomRoutes is true for this network, and networkPeering.exportCustomRoutes is true for the peer network, and the import does not result in a route conflict.
    #[prost(bool, optional, tag = "114502404")]
    pub imported: ::core::option::Option<bool>,
    /// The region of peering route next hop, only applies to dynamic routes.
    #[prost(string, optional, tag = "122577014")]
    pub next_hop_region: ::core::option::Option<::prost::alloc::string::String>,
    /// The priority of the peering route.
    #[prost(uint32, optional, tag = "445151652")]
    pub priority: ::core::option::Option<u32>,
    /// The type of the peering route.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `ExchangedPeeringRoute`.
pub mod exchanged_peering_route {
    /// The type of the peering route.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        /// For routes exported from local network.
        DynamicPeeringRoute = 469794858,
        /// The peering route.
        StaticPeeringRoute = 473407545,
        /// The peering route corresponding to subnetwork range.
        SubnetPeeringRoute = 465782504,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExchangedPeeringRoutesList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of ExchangedPeeringRoute resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<ExchangedPeeringRoute>,
    /// [Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for exchanged peering routes lists.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// A request message for Subnetworks.ExpandIpCidrRange. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExpandIpCidrRangeSubnetworkRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the Subnetwork resource to update.
    #[prost(string, tag = "307827694")]
    pub subnetwork: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "477014110")]
    pub subnetworks_expand_ip_cidr_range_request_resource:
        ::core::option::Option<SubnetworksExpandIpCidrRangeRequest>,
}
/// Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at <https://github.com/google/cel-spec.> Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Expr {
    /// Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Textual representation of an expression in Common Expression Language syntax.
    #[prost(string, optional, tag = "352031384")]
    pub expression: ::core::option::Option<::prost::alloc::string::String>,
    /// Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
    #[prost(string, optional, tag = "290430901")]
    pub location: ::core::option::Option<::prost::alloc::string::String>,
    /// Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
    #[prost(string, optional, tag = "110371416")]
    pub title: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents an external VPN gateway. External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway. To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway. For more information about using external VPN gateways, see Creating an HA VPN gateway and tunnel pair to a peer VPN.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExternalVpnGateway {
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
    #[prost(message, repeated, tag = "12073562")]
    pub interfaces: ::prost::alloc::vec::Vec<ExternalVpnGatewayInterface>,
    /// [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates the user-supplied redundancy type of this external VPN gateway.
    /// Check the RedundancyType enum for the list of possible values.
    #[prost(string, optional, tag = "271443740")]
    pub redundancy_type: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `ExternalVpnGateway`.
pub mod external_vpn_gateway {
    /// Indicates the user-supplied redundancy type of this external VPN gateway.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum RedundancyType {
        /// A value indicating that the enum field is not set.
        UndefinedRedundancyType = 0,
        /// The external VPN gateway has four public IP addresses; at the time of writing this API, the AWS virtual private gateway is an example which has four public IP addresses for high availability connections; there should be two VPN connections in the AWS virtual private gateway , each AWS VPN connection has two public IP addresses; please make sure to put two public IP addresses from one AWS VPN connection into interfaces 0 and 1 of this external VPN gateway, and put the other two public IP addresses from another AWS VPN connection into interfaces 2 and 3 of this external VPN gateway. When displaying highly available configuration status for the VPN tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will always detect whether interfaces 0 and 1 are connected on one interface of HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected to another interface of the HA Cloud VPN gateway.
        FourIpsRedundancy = 520087913,
        /// The external VPN gateway has only one public IP address which internally provide redundancy or failover.
        SingleIpInternallyRedundant = 133914873,
        /// The external VPN gateway has two public IP addresses which are redundant with each other, the following two types of setup on your on-premises side would have this type of redundancy: (1) Two separate on-premises gateways, each with one public IP address, the two on-premises gateways are redundant with each other. (2) A single on-premise gateway with two public IP addresses that are redundant with eatch other.
        TwoIpsRedundancy = 367049635,
    }
}
/// The interface for the external VPN gateway.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExternalVpnGatewayInterface {
    /// The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
    #[prost(uint32, optional, tag = "3355")]
    pub id: ::core::option::Option<u32>,
    /// IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
    #[prost(string, optional, tag = "406272220")]
    pub ip_address: ::core::option::Option<::prost::alloc::string::String>,
}
/// Response to the list request, and contains a list of externalVpnGateways.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExternalVpnGatewayList {
    #[prost(string, optional, tag = "3123477")]
    pub etag: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of ExternalVpnGateway resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<ExternalVpnGateway>,
    /// [Output Only] Type of resource. Always compute#externalVpnGatewayList for lists of externalVpnGateways.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FileContentBuffer {
    /// The raw content in the secure keys file.
    #[prost(string, optional, tag = "414659705")]
    pub content: ::core::option::Option<::prost::alloc::string::String>,
    /// The file type of source file.
    /// Check the FileType enum for the list of possible values.
    #[prost(string, optional, tag = "294346781")]
    pub file_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `FileContentBuffer`.
pub mod file_content_buffer {
    /// The file type of source file.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum FileType {
        /// A value indicating that the enum field is not set.
        UndefinedFileType = 0,
        Bin = 65767,
        Undefined = 137851184,
        X509 = 2674086,
    }
}
/// Represents a Firewall Rule resource. Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Firewall {
    /// The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
    #[prost(message, repeated, tag = "162398632")]
    pub allowed: ::prost::alloc::vec::Vec<Allowed>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
    #[prost(message, repeated, tag = "275217307")]
    pub denied: ::prost::alloc::vec::Vec<Denied>,
    /// An optional description of this resource. Provide this field when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
    #[prost(string, repeated, tag = "305699879")]
    pub destination_ranges: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.
    /// Check the Direction enum for the list of possible values.
    #[prost(string, optional, tag = "111150975")]
    pub direction: ::core::option::Option<::prost::alloc::string::String>,
    /// Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
    #[prost(bool, optional, tag = "270940796")]
    pub disabled: ::core::option::Option<bool>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#firewall for firewall rules.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
    #[prost(message, optional, tag = "351299741")]
    pub log_config: ::core::option::Option<FirewallLogConfig>,
    /// Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression \[a-z]([-a-z0-9]*[a-z0-9\])?. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - <https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network> - projects/myproject/global/networks/my-network - global/networks/default
    #[prost(string, optional, tag = "232872494")]
    pub network: ::core::option::Option<::prost::alloc::string::String>,
    /// Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
    #[prost(int32, optional, tag = "445151652")]
    pub priority: ::core::option::Option<i32>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
    #[prost(string, repeated, tag = "200097658")]
    pub source_ranges: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
    #[prost(string, repeated, tag = "105100756")]
    pub source_service_accounts: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
    #[prost(string, repeated, tag = "452222397")]
    pub source_tags: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
    #[prost(string, repeated, tag = "457639710")]
    pub target_service_accounts: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
    #[prost(string, repeated, tag = "62901767")]
    pub target_tags: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Firewall`.
pub mod firewall {
    /// Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Direction {
        /// A value indicating that the enum field is not set.
        UndefinedDirection = 0,
        /// Indicates that firewall should apply to outgoing traffic.
        Egress = 432880501,
        /// Indicates that firewall should apply to incoming traffic.
        Ingress = 516931221,
    }
}
/// Contains a list of firewalls.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Firewall resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Firewall>,
    /// [Output Only] Type of resource. Always compute#firewallList for lists of firewalls.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// The available logging options for a firewall rule.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallLogConfig {
    /// This field denotes whether to enable logging for a particular firewall rule.
    #[prost(bool, optional, tag = "311764355")]
    pub enable: ::core::option::Option<bool>,
    /// This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
    /// Check the Metadata enum for the list of possible values.
    #[prost(string, optional, tag = "86866735")]
    pub metadata: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `FirewallLogConfig`.
pub mod firewall_log_config {
    /// This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Metadata {
        /// A value indicating that the enum field is not set.
        UndefinedMetadata = 0,
        ExcludeAllMetadata = 334519954,
        IncludeAllMetadata = 164619908,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPoliciesListAssociationsResponse {
    /// A list of associations.
    #[prost(message, repeated, tag = "508736530")]
    pub associations: ::prost::alloc::vec::Vec<FirewallPolicyAssociation>,
    /// [Output Only] Type of firewallPolicy associations. Always compute#FirewallPoliciesListAssociations for lists of firewallPolicy associations.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents a Firewall Policy resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPolicy {
    /// A list of associations that belong to this firewall policy.
    #[prost(message, repeated, tag = "508736530")]
    pub associations: ::prost::alloc::vec::Vec<FirewallPolicyAssociation>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Deprecated, please use short name instead. User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "4473832")]
    pub display_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the firewall policy.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely identifies the Firewall Policy.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The parent of the firewall policy.
    #[prost(string, optional, tag = "78317738")]
    pub parent: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
    #[prost(int32, optional, tag = "388342037")]
    pub rule_tuple_count: ::core::option::Option<i32>,
    /// A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a default rule with action "allow" will be added.
    #[prost(message, repeated, tag = "108873975")]
    pub rules: ::prost::alloc::vec::Vec<FirewallPolicyRule>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource with the resource id.
    #[prost(string, optional, tag = "44520962")]
    pub self_link_with_id: ::core::option::Option<::prost::alloc::string::String>,
    /// User-provided name of the Organization firewall plicy. The name should be unique in the organization in which the firewall policy is created. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "492051566")]
    pub short_name: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPolicyAssociation {
    /// The target that the firewall policy is attached to.
    #[prost(string, optional, tag = "175773741")]
    pub attachment_target: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Deprecated, please use short name instead. The display name of the firewall policy of the association.
    #[prost(string, optional, tag = "4473832")]
    pub display_name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The firewall policy ID of the association.
    #[prost(string, optional, tag = "357211849")]
    pub firewall_policy_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name for an association.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The short name of the firewall policy of the association.
    #[prost(string, optional, tag = "492051566")]
    pub short_name: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPolicyList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of FirewallPolicy resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<FirewallPolicy>,
    /// [Output Only] Type of resource. Always compute#firewallPolicyList for listsof FirewallPolicies
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPolicyRule {
    /// The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
    #[prost(string, optional, tag = "187661878")]
    pub action: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description for this resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// The direction in which this rule applies.
    /// Check the Direction enum for the list of possible values.
    #[prost(string, optional, tag = "111150975")]
    pub direction: ::core::option::Option<::prost::alloc::string::String>,
    /// Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
    #[prost(bool, optional, tag = "270940796")]
    pub disabled: ::core::option::Option<bool>,
    /// Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
    #[prost(bool, optional, tag = "295396515")]
    pub enable_logging: ::core::option::Option<bool>,
    /// [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
    #[prost(message, optional, tag = "103668165")]
    pub r#match: ::core::option::Option<FirewallPolicyRuleMatcher>,
    /// An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
    #[prost(int32, optional, tag = "445151652")]
    pub priority: ::core::option::Option<i32>,
    /// [Output Only] Calculation of the complexity of a single firewall policy rule.
    #[prost(int32, optional, tag = "388342037")]
    pub rule_tuple_count: ::core::option::Option<i32>,
    /// A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
    #[prost(string, repeated, tag = "528230647")]
    pub target_resources: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// A list of service accounts indicating the sets of instances that are applied with this rule.
    #[prost(string, repeated, tag = "457639710")]
    pub target_service_accounts: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `FirewallPolicyRule`.
pub mod firewall_policy_rule {
    /// The direction in which this rule applies.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Direction {
        /// A value indicating that the enum field is not set.
        UndefinedDirection = 0,
        Egress = 432880501,
        Ingress = 516931221,
    }
}
/// Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPolicyRuleMatcher {
    /// CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
    #[prost(string, repeated, tag = "337357713")]
    pub dest_ip_ranges: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Pairs of IP protocols and ports that the rule should match.
    #[prost(message, repeated, tag = "373534261")]
    pub layer4_configs: ::prost::alloc::vec::Vec<FirewallPolicyRuleMatcherLayer4Config>,
    /// CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
    #[prost(string, repeated, tag = "432128083")]
    pub src_ip_ranges: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FirewallPolicyRuleMatcherLayer4Config {
    /// The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
    #[prost(string, optional, tag = "475958960")]
    pub ip_protocol: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: \["22"\], \["80","443"\], and \["12345-12349"\].
    #[prost(string, repeated, tag = "106854418")]
    pub ports: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Encapsulates numeric value that can be either absolute or relative.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FixedOrPercent {
    /// [Output Only] Absolute value of VM instances calculated based on the specific mode. - If the value is fixed, then the calculated value is equal to the fixed value. - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded.
    #[prost(int32, optional, tag = "472082878")]
    pub calculated: ::core::option::Option<i32>,
    /// Specifies a fixed number of VM instances. This must be a positive integer.
    #[prost(int32, optional, tag = "97445748")]
    pub fixed: ::core::option::Option<i32>,
    /// Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
    #[prost(int32, optional, tag = "394814533")]
    pub percent: ::core::option::Option<i32>,
}
/// Represents a Forwarding Rule resource. Forwarding rule resources in Google Cloud can be either regional or global in scope: * \[Global\](<https://cloud.google.com/compute/docs/reference/rest/v1/globalForwardingRules>) * \[Regional\](<https://cloud.google.com/compute/docs/reference/rest/v1/forwardingRules>) A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud Platform load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway). For more information, read Forwarding rule concepts and Using protocol forwarding.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingRule {
    /// IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule. If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address: * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in <https://www.googleapis.com/compute/v1/projects/project_id/regions/region> /addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, see [IP address specifications](<https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications>). Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true. For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
    #[prost(string, optional, tag = "42976943")]
    pub i_p_address: ::core::option::Option<::prost::alloc::string::String>,
    /// The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](<https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends>).
    /// Check the IPProtocolEnum enum for the list of possible values.
    #[prost(string, optional, tag = "488094525")]
    pub i_p_protocol: ::core::option::Option<::prost::alloc::string::String>,
    /// This field is used along with the backend_service field for Internal TCP/UDP Load Balancing or Network Load Balancing, or with the target field for internal and external TargetInstance. You can only use one of ports and port_range, or allPorts. The three are mutually exclusive. For TCP, UDP and SCTP traffic, packets addressed to any ports will be forwarded to the target or backendService.
    #[prost(bool, optional, tag = "445175796")]
    pub all_ports: ::core::option::Option<bool>,
    /// This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
    #[prost(bool, optional, tag = "499409674")]
    pub allow_global_access: ::core::option::Option<bool>,
    /// Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
    #[prost(string, optional, tag = "306946058")]
    pub backend_service: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
    /// Check the IpVersion enum for the list of possible values.
    #[prost(string, optional, tag = "294959552")]
    pub ip_version: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
    #[prost(bool, optional, tag = "119255164")]
    pub is_mirroring_collector: ::core::option::Option<bool>,
    /// [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
    /// Check the LoadBalancingScheme enum for the list of possible values.
    #[prost(string, optional, tag = "363890244")]
    pub load_balancing_scheme: ::core::option::Option<::prost::alloc::string::String>,
    /// Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    #[prost(message, repeated, tag = "464725739")]
    pub metadata_filters: ::prost::alloc::vec::Vec<MetadataFilter>,
    /// Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
    #[prost(string, optional, tag = "232872494")]
    pub network: ::core::option::Option<::prost::alloc::string::String>,
    /// This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
    /// Check the NetworkTier enum for the list of possible values.
    #[prost(string, optional, tag = "517397843")]
    pub network_tier: ::core::option::Option<::prost::alloc::string::String>,
    /// This field can be used only if: - Load balancing scheme is one of EXTERNAL, INTERNAL_SELF_MANAGED or INTERNAL_MANAGED - IPProtocol is one of TCP, UDP, or SCTP. Packets addressed to ports in the specified range will be forwarded to target or backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint ports. Some types of forwarding target have constraints on the acceptable ports. For more information, see [Port specifications](<https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications>). @pattern: \\d+(?:-\\d+)?
    #[prost(string, optional, tag = "217518079")]
    pub port_range: ::core::option::Option<::prost::alloc::string::String>,
    /// The ports field is only supported when the forwarding rule references a backend_service directly. Only packets addressed to the [specified list of ports]((<https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications>)) are forwarded to backends. You can only use one of ports and port_range, or allPorts. The three are mutually exclusive. You can specify a list of up to five ports, which can be non-contiguous. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint ports. @pattern: \\d+(?:-\\d+)?
    #[prost(string, repeated, tag = "106854418")]
    pub ports: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] The PSC connection id of the PSC Forwarding Rule.
    #[prost(uint64, optional, tag = "292082397")]
    pub psc_connection_id: ::core::option::Option<u64>,
    ///
    /// Check the PscConnectionStatus enum for the list of possible values.
    #[prost(string, optional, tag = "184149172")]
    pub psc_connection_status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource. It is only supported for internal load balancing.
    #[prost(message, repeated, tag = "223549694")]
    pub service_directory_registrations:
        ::prost::alloc::vec::Vec<ForwardingRuleServiceDirectoryRegistration>,
    /// An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
    #[prost(string, optional, tag = "417008874")]
    pub service_label: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
    #[prost(string, optional, tag = "359880149")]
    pub service_name: ::core::option::Option<::prost::alloc::string::String>,
    /// This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
    #[prost(string, optional, tag = "307827694")]
    pub subnetwork: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "192835985")]
    pub target: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `ForwardingRule`.
pub mod forwarding_rule {
    /// The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](<https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends>).
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum IpProtocolEnum {
        /// A value indicating that the enum field is not set.
        UndefinedIPProtocolEnum = 0,
        Ah = 2087,
        Esp = 68962,
        Icmp = 2241597,
        Sctp = 2539724,
        Tcp = 82881,
        Udp = 83873,
    }
    /// The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum IpVersion {
        /// A value indicating that the enum field is not set.
        UndefinedIpVersion = 0,
        Ipv4 = 2254341,
        Ipv6 = 2254343,
        UnspecifiedVersion = 21850000,
    }
    /// Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum LoadBalancingScheme {
        /// A value indicating that the enum field is not set.
        UndefinedLoadBalancingScheme = 0,
        External = 35607499,
        Internal = 279295677,
        InternalManaged = 37350397,
        InternalSelfManaged = 236211150,
        Invalid = 530283991,
    }
    /// This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum NetworkTier {
        /// A value indicating that the enum field is not set.
        UndefinedNetworkTier = 0,
        /// High quality, Google-grade network tier, support for all networking products.
        Premium = 399530551,
        /// Public internet quality, only limited support for other networking products.
        Standard = 484642493,
    }
    ///
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PscConnectionStatus {
        /// A value indicating that the enum field is not set.
        UndefinedPscConnectionStatus = 0,
        /// The connection has been accepted by the producer.
        Accepted = 246714279,
        /// The connection has been closed by the producer and will not serve traffic going forward.
        Closed = 380163436,
        /// The connection is pending acceptance by the producer.
        Pending = 35394935,
        /// The connection has been rejected by the producer.
        Rejected = 174130302,
        StatusUnspecified = 42133066,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingRuleAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of ForwardingRulesScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ForwardingRulesScopedList,
    >,
    /// [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of ForwardingRule resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingRuleList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of ForwardingRule resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<ForwardingRule>,
    /// Type of resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingRuleReference {
    #[prost(string, optional, tag = "269964030")]
    pub forwarding_rule: ::core::option::Option<::prost::alloc::string::String>,
}
/// Describes the auto-registration of the Forwarding Rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this Forwarding Rule.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingRuleServiceDirectoryRegistration {
    /// Service Directory namespace to register the forwarding rule under.
    #[prost(string, optional, tag = "178476379")]
    pub namespace: ::core::option::Option<::prost::alloc::string::String>,
    /// Service Directory service to register the forwarding rule under.
    #[prost(string, optional, tag = "373540533")]
    pub service: ::core::option::Option<::prost::alloc::string::String>,
    /// \[Optional\] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
    #[prost(string, optional, tag = "74030416")]
    pub service_directory_region: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingRulesScopedList {
    /// A list of forwarding rules contained in this scope.
    #[prost(message, repeated, tag = "315821365")]
    pub forwarding_rules: ::prost::alloc::vec::Vec<ForwardingRule>,
    /// Informational warning which replaces the list of forwarding rules when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GrpcHealthCheck {
    /// The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
    #[prost(string, optional, tag = "136533078")]
    pub grpc_service_name: ::core::option::Option<::prost::alloc::string::String>,
    /// The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    /// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
    #[prost(string, optional, tag = "41534345")]
    pub port_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.
    /// Check the PortSpecification enum for the list of possible values.
    #[prost(string, optional, tag = "51590597")]
    pub port_specification: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `GRPCHealthCheck`.
pub mod grpc_health_check {
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PortSpecification {
        /// A value indicating that the enum field is not set.
        UndefinedPortSpecification = 0,
        /// The port number in port is used for health checking.
        UseFixedPort = 190235748,
        /// The portName is used for health checking.
        UseNamedPort = 349300671,
        /// For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
        UseServingPort = 362637516,
    }
}
/// A request message for AcceleratorTypes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAcceleratorTypeRequest {
    /// Name of the accelerator type to return.
    #[prost(string, tag = "138031246")]
    pub accelerator_type: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Addresses.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAddressRequest {
    /// Name of the address resource to return.
    #[prost(string, tag = "462920692")]
    pub address: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for FirewallPolicies.GetAssociation. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAssociationFirewallPolicyRequest {
    /// Name of the firewall policy to which the queried rule belongs.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
    /// The name of the association to get from the firewall policy.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Autoscalers.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAutoscalerRequest {
    /// Name of the autoscaler to return.
    #[prost(string, tag = "517258967")]
    pub autoscaler: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for BackendBuckets.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetBackendBucketRequest {
    /// Name of the BackendBucket resource to return.
    #[prost(string, tag = "91714037")]
    pub backend_bucket: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for BackendServices.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetBackendServiceRequest {
    /// Name of the BackendService resource to return.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for Interconnects.GetDiagnostics. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetDiagnosticsInterconnectRequest {
    /// Name of the interconnect resource to query.
    #[prost(string, tag = "224601230")]
    pub interconnect: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for Disks.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetDiskRequest {
    /// Name of the persistent disk to return.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for DiskTypes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetDiskTypeRequest {
    /// Name of the disk type to return.
    #[prost(string, tag = "93009052")]
    pub disk_type: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Instances.GetEffectiveFirewalls. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetEffectiveFirewallsInstanceRequest {
    /// Name of the instance scoping this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// The name of the network interface to get the effective firewalls.
    #[prost(string, tag = "365387880")]
    pub network_interface: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Networks.GetEffectiveFirewalls. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetEffectiveFirewallsNetworkRequest {
    /// Name of the network for this request.
    #[prost(string, tag = "232872494")]
    pub network: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for ExternalVpnGateways.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetExternalVpnGatewayRequest {
    /// Name of the externalVpnGateway to return.
    #[prost(string, tag = "109898629")]
    pub external_vpn_gateway: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for FirewallPolicies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFirewallPolicyRequest {
    /// Name of the firewall policy to get.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
}
/// A request message for Firewalls.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFirewallRequest {
    /// Name of the firewall rule to return.
    #[prost(string, tag = "511016192")]
    pub firewall: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for ForwardingRules.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetForwardingRuleRequest {
    /// Name of the ForwardingRule resource to return.
    #[prost(string, tag = "269964030")]
    pub forwarding_rule: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for Images.GetFromFamily. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFromFamilyImageRequest {
    /// Name of the image family to search for.
    #[prost(string, tag = "328751972")]
    pub family: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for GlobalAddresses.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlobalAddressRequest {
    /// Name of the address resource to return.
    #[prost(string, tag = "462920692")]
    pub address: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for GlobalForwardingRules.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlobalForwardingRuleRequest {
    /// Name of the ForwardingRule resource to return.
    #[prost(string, tag = "269964030")]
    pub forwarding_rule: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for GlobalNetworkEndpointGroups.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlobalNetworkEndpointGroupRequest {
    /// The name of the network endpoint group. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for GlobalOperations.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlobalOperationRequest {
    /// Name of the Operations resource to return.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for GlobalOrganizationOperations.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlobalOrganizationOperationRequest {
    /// Name of the Operations resource to return.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Parent ID for this request.
    #[prost(string, optional, tag = "459714768")]
    pub parent_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalPublicDelegatedPrefixes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGlobalPublicDelegatedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the PublicDelegatedPrefix resource to return.
    #[prost(string, tag = "204238440")]
    pub public_delegated_prefix: ::prost::alloc::string::String,
}
/// A request message for Instances.GetGuestAttributes. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetGuestAttributesInstanceRequest {
    /// Name of the instance scoping this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Specifies the guest attributes path to be queried.
    #[prost(string, optional, tag = "368591164")]
    pub query_path: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the key for the guest attributes entry.
    #[prost(string, optional, tag = "164364828")]
    pub variable_key: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for BackendServices.GetHealth. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetHealthBackendServiceRequest {
    /// Name of the BackendService resource to which the queried instance belongs.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "112951123")]
    pub resource_group_reference_resource: ::core::option::Option<ResourceGroupReference>,
}
/// A request message for HealthChecks.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetHealthCheckRequest {
    /// Name of the HealthCheck resource to return.
    #[prost(string, tag = "308876645")]
    pub health_check: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for RegionBackendServices.GetHealth. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetHealthRegionBackendServiceRequest {
    /// Name of the BackendService resource for which to get health.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "112951123")]
    pub resource_group_reference_resource: ::core::option::Option<ResourceGroupReference>,
}
/// A request message for TargetPools.GetHealth. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetHealthTargetPoolRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "292926060")]
    pub instance_reference_resource: ::core::option::Option<InstanceReference>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the TargetPool resource to which the queried instance belongs.
    #[prost(string, tag = "62796298")]
    pub target_pool: ::prost::alloc::string::String,
}
/// A request message for Disks.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyDiskRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for FirewallPolicies.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyFirewallPolicyRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for Images.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyImageRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for Instances.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyInstanceRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceTemplates.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyInstanceTemplateRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for Licenses.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyLicenseRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for NodeGroups.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyNodeGroupRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for NodeTemplates.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyNodeTemplateRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for RegionDisks.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyRegionDiskRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for Reservations.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyReservationRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ResourcePolicies.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyResourcePolicyRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for ServiceAttachments.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicyServiceAttachmentRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for Snapshots.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicySnapshotRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for Subnetworks.GetIamPolicy. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetIamPolicySubnetworkRequest {
    /// Requested IAM Policy version.
    #[prost(int32, optional, tag = "499220029")]
    pub options_requested_policy_version: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name or id of the resource for this request.
    #[prost(string, tag = "195806222")]
    pub resource: ::prost::alloc::string::String,
}
/// A request message for ImageFamilyViews.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetImageFamilyViewRequest {
    /// Name of the image family to search for.
    #[prost(string, tag = "328751972")]
    pub family: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Images.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetImageRequest {
    /// Name of the image resource to return.
    #[prost(string, tag = "100313435")]
    pub image: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for InstanceGroupManagers.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInstanceGroupManagerRequest {
    /// The name of the managed instance group.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone where the managed instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceGroups.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInstanceGroupRequest {
    /// The name of the instance group.
    #[prost(string, tag = "81095253")]
    pub instance_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone where the instance group is located.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Instances.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInstanceRequest {
    /// Name of the instance resource to return.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceTemplates.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInstanceTemplateRequest {
    /// The name of the instance template.
    #[prost(string, tag = "309248228")]
    pub instance_template: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for InterconnectAttachments.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInterconnectAttachmentRequest {
    /// Name of the interconnect attachment to return.
    #[prost(string, tag = "308135284")]
    pub interconnect_attachment: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for InterconnectLocations.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInterconnectLocationRequest {
    /// Name of the interconnect location to return.
    #[prost(string, tag = "492235846")]
    pub interconnect_location: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for Interconnects.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetInterconnectRequest {
    /// Name of the interconnect to return.
    #[prost(string, tag = "224601230")]
    pub interconnect: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for LicenseCodes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetLicenseCodeRequest {
    /// Number corresponding to the License code resource to return.
    #[prost(string, tag = "1467179")]
    pub license_code: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for Licenses.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetLicenseRequest {
    /// Name of the License resource to return.
    #[prost(string, tag = "166757441")]
    pub license: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for MachineTypes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetMachineTypeRequest {
    /// Name of the machine type to return.
    #[prost(string, tag = "227711026")]
    pub machine_type: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Routers.GetNatMappingInfo. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetNatMappingInfoRoutersRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
    /// Name of the Router resource to query for Nat Mapping information of VM endpoints.
    #[prost(string, tag = "148608841")]
    pub router: ::prost::alloc::string::String,
}
/// A request message for NetworkEndpointGroups.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetNetworkEndpointGroupRequest {
    /// The name of the network endpoint group. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone where the network endpoint group is located. It should comply with RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Networks.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetNetworkRequest {
    /// Name of the network to return.
    #[prost(string, tag = "232872494")]
    pub network: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for NodeGroups.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetNodeGroupRequest {
    /// Name of the node group to return.
    #[prost(string, tag = "469958146")]
    pub node_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for NodeTemplates.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetNodeTemplateRequest {
    /// Name of the node template to return.
    #[prost(string, tag = "323154455")]
    pub node_template: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for NodeTypes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetNodeTypeRequest {
    /// Name of the node type to return.
    #[prost(string, tag = "465832791")]
    pub node_type: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for PacketMirrorings.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetPacketMirroringRequest {
    /// Name of the PacketMirroring resource to return.
    #[prost(string, tag = "22305996")]
    pub packet_mirroring: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for Projects.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetProjectRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for PublicAdvertisedPrefixes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetPublicAdvertisedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the PublicAdvertisedPrefix resource to return.
    #[prost(string, tag = "101874590")]
    pub public_advertised_prefix: ::prost::alloc::string::String,
}
/// A request message for PublicDelegatedPrefixes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetPublicDelegatedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the PublicDelegatedPrefix resource to return.
    #[prost(string, tag = "204238440")]
    pub public_delegated_prefix: ::prost::alloc::string::String,
    /// Name of the region of this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionAutoscalers.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionAutoscalerRequest {
    /// Name of the autoscaler to return.
    #[prost(string, tag = "517258967")]
    pub autoscaler: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionBackendServices.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionBackendServiceRequest {
    /// Name of the BackendService resource to return.
    #[prost(string, tag = "306946058")]
    pub backend_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionCommitments.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionCommitmentRequest {
    /// Name of the commitment to return.
    #[prost(string, tag = "482134805")]
    pub commitment: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionDisks.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionDiskRequest {
    /// Name of the regional persistent disk to return.
    #[prost(string, tag = "3083677")]
    pub disk: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionDiskTypes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionDiskTypeRequest {
    /// Name of the disk type to return.
    #[prost(string, tag = "93009052")]
    pub disk_type: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionHealthChecks.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionHealthCheckRequest {
    /// Name of the HealthCheck resource to return.
    #[prost(string, tag = "308876645")]
    pub health_check: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionHealthCheckServices.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionHealthCheckServiceRequest {
    /// Name of the HealthCheckService to update. The name must be 1-63 characters long, and comply with RFC1035.
    #[prost(string, tag = "408374747")]
    pub health_check_service: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroupManagers.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionInstanceGroupManagerRequest {
    /// Name of the managed instance group to return.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionInstanceGroups.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionInstanceGroupRequest {
    /// Name of the instance group resource to return.
    #[prost(string, tag = "81095253")]
    pub instance_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionNetworkEndpointGroups.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionNetworkEndpointGroupRequest {
    /// The name of the network endpoint group. It should comply with RFC1035.
    #[prost(string, tag = "433907078")]
    pub network_endpoint_group: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region where the network endpoint group is located. It should comply with RFC1035.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionNotificationEndpoints.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionNotificationEndpointRequest {
    /// Name of the NotificationEndpoint resource to return.
    #[prost(string, tag = "376807017")]
    pub notification_endpoint: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionOperations.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionOperationRequest {
    /// Name of the Operations resource to return.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for Regions.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region resource to return.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
}
/// A request message for RegionSslCertificates.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionSslCertificateRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the SslCertificate resource to return.
    #[prost(string, tag = "46443492")]
    pub ssl_certificate: ::prost::alloc::string::String,
}
/// A request message for RegionTargetHttpProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionTargetHttpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the TargetHttpProxy resource to return.
    #[prost(string, tag = "206872421")]
    pub target_http_proxy: ::prost::alloc::string::String,
}
/// A request message for RegionTargetHttpsProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionTargetHttpsProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the TargetHttpsProxy resource to return.
    #[prost(string, tag = "52336748")]
    pub target_https_proxy: ::prost::alloc::string::String,
}
/// A request message for RegionUrlMaps.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRegionUrlMapRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the UrlMap resource to return.
    #[prost(string, tag = "367020684")]
    pub url_map: ::prost::alloc::string::String,
}
/// A request message for Reservations.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetReservationRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the reservation to retrieve.
    #[prost(string, tag = "47530956")]
    pub reservation: ::prost::alloc::string::String,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ResourcePolicies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetResourcePolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the resource policy to retrieve.
    #[prost(string, tag = "159240835")]
    pub resource_policy: ::prost::alloc::string::String,
}
/// A request message for Routes.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRouteRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the Route resource to return.
    #[prost(string, tag = "108704329")]
    pub route: ::prost::alloc::string::String,
}
/// A request message for Routers.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRouterRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the Router resource to return.
    #[prost(string, tag = "148608841")]
    pub router: ::prost::alloc::string::String,
}
/// A request message for Routers.GetRouterStatus. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRouterStatusRouterRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the Router resource to query.
    #[prost(string, tag = "148608841")]
    pub router: ::prost::alloc::string::String,
}
/// A request message for FirewallPolicies.GetRule. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRuleFirewallPolicyRequest {
    /// Name of the firewall policy to which the queried rule belongs.
    #[prost(string, tag = "498173265")]
    pub firewall_policy: ::prost::alloc::string::String,
    /// The priority of the rule to get from the firewall policy.
    #[prost(int32, optional, tag = "445151652")]
    pub priority: ::core::option::Option<i32>,
}
/// A request message for SecurityPolicies.GetRule. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRuleSecurityPolicyRequest {
    /// The priority of the rule to get from the security policy.
    #[prost(int32, optional, tag = "445151652")]
    pub priority: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the security policy to which the queried rule belongs.
    #[prost(string, tag = "171082513")]
    pub security_policy: ::prost::alloc::string::String,
}
/// A request message for Instances.GetScreenshot. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetScreenshotInstanceRequest {
    /// Name of the instance scoping this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for SecurityPolicies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSecurityPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the security policy to get.
    #[prost(string, tag = "171082513")]
    pub security_policy: ::prost::alloc::string::String,
}
/// A request message for Instances.GetSerialPortOutput. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSerialPortOutputInstanceRequest {
    /// Name of the instance for this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Specifies which COM or serial port to retrieve data from.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Specifies the starting byte position of the output to return. To start with the first byte of output to the specified port, omit this field or set it to `0`. If the output for that byte position is available, this field matches the `start` parameter sent with the request. If the amount of serial console output exceeds the size of the buffer (1 MB), the oldest output is discarded and is no longer available. If the requested start position refers to discarded output, the start position is adjusted to the oldest output still available, and the adjusted start position is returned as the `start` property value. You can also provide a negative start position, which translates to the most recent number of bytes written to the serial port. For example, -3 is interpreted as the most recent 3 bytes written to the serial console.
    #[prost(int64, optional, tag = "109757538")]
    pub start: ::core::option::Option<i64>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ServiceAttachments.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetServiceAttachmentRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region of this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the ServiceAttachment resource to return.
    #[prost(string, tag = "338957549")]
    pub service_attachment: ::prost::alloc::string::String,
}
/// A request message for Instances.GetShieldedInstanceIdentity. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetShieldedInstanceIdentityInstanceRequest {
    /// Name or id of the instance scoping this request.
    #[prost(string, tag = "18257045")]
    pub instance: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Snapshots.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSnapshotRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the Snapshot resource to return.
    #[prost(string, tag = "284874180")]
    pub snapshot: ::prost::alloc::string::String,
}
/// A request message for SslCertificates.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSslCertificateRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the SslCertificate resource to return.
    #[prost(string, tag = "46443492")]
    pub ssl_certificate: ::prost::alloc::string::String,
}
/// A request message for SslPolicies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSslPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the SSL policy to update. The name must be 1-63 characters long, and comply with RFC1035.
    #[prost(string, tag = "295190213")]
    pub ssl_policy: ::prost::alloc::string::String,
}
/// A request message for VpnGateways.GetStatus. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetStatusVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the VPN gateway to return.
    #[prost(string, tag = "406684153")]
    pub vpn_gateway: ::prost::alloc::string::String,
}
/// A request message for Subnetworks.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSubnetworkRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the Subnetwork resource to return.
    #[prost(string, tag = "307827694")]
    pub subnetwork: ::prost::alloc::string::String,
}
/// A request message for TargetGrpcProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetGrpcProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the TargetGrpcProxy resource to return.
    #[prost(string, tag = "5020283")]
    pub target_grpc_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetHttpProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetHttpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the TargetHttpProxy resource to return.
    #[prost(string, tag = "206872421")]
    pub target_http_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetHttpsProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetHttpsProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the TargetHttpsProxy resource to return.
    #[prost(string, tag = "52336748")]
    pub target_https_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetInstances.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetInstanceRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the TargetInstance resource to return.
    #[prost(string, tag = "289769347")]
    pub target_instance: ::prost::alloc::string::String,
    /// Name of the zone scoping this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for TargetPools.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetPoolRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the TargetPool resource to return.
    #[prost(string, tag = "62796298")]
    pub target_pool: ::prost::alloc::string::String,
}
/// A request message for TargetSslProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetSslProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the TargetSslProxy resource to return.
    #[prost(string, tag = "338795853")]
    pub target_ssl_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetTcpProxies.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetTcpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the TargetTcpProxy resource to return.
    #[prost(string, tag = "503065442")]
    pub target_tcp_proxy: ::prost::alloc::string::String,
}
/// A request message for TargetVpnGateways.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTargetVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the target VPN gateway to return.
    #[prost(string, tag = "532512843")]
    pub target_vpn_gateway: ::prost::alloc::string::String,
}
/// A request message for UrlMaps.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetUrlMapRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the UrlMap resource to return.
    #[prost(string, tag = "367020684")]
    pub url_map: ::prost::alloc::string::String,
}
/// A request message for VpnGateways.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the VPN gateway to return.
    #[prost(string, tag = "406684153")]
    pub vpn_gateway: ::prost::alloc::string::String,
}
/// A request message for VpnTunnels.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetVpnTunnelRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Name of the VpnTunnel resource to return.
    #[prost(string, tag = "143821331")]
    pub vpn_tunnel: ::prost::alloc::string::String,
}
/// A request message for Projects.GetXpnHost. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetXpnHostProjectRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
}
/// A request message for Projects.GetXpnResources. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetXpnResourcesProjectsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for ZoneOperations.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetZoneOperationRequest {
    /// Name of the Operations resource to return.
    #[prost(string, tag = "52090215")]
    pub operation: ::prost::alloc::string::String,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Zones.Get. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetZoneRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the zone resource to return.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlobalNetworkEndpointGroupsAttachEndpointsRequest {
    /// The list of network endpoints to be attached.
    #[prost(message, repeated, tag = "149850285")]
    pub network_endpoints: ::prost::alloc::vec::Vec<NetworkEndpoint>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlobalNetworkEndpointGroupsDetachEndpointsRequest {
    /// The list of network endpoints to be detached.
    #[prost(message, repeated, tag = "149850285")]
    pub network_endpoints: ::prost::alloc::vec::Vec<NetworkEndpoint>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlobalOrganizationSetPolicyRequest {
    /// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
    #[prost(message, repeated, tag = "403251854")]
    pub bindings: ::prost::alloc::vec::Vec<Binding>,
    /// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
    #[prost(string, optional, tag = "3123477")]
    pub etag: ::core::option::Option<::prost::alloc::string::String>,
    /// REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
    #[prost(message, optional, tag = "91071794")]
    pub policy: ::core::option::Option<Policy>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlobalSetLabelsRequest {
    /// The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of labels to apply for this resource. Each label key & value must comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For example, "webserver-frontend": "images". A label value can also be empty (e.g. "my-label": "").
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlobalSetPolicyRequest {
    /// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
    #[prost(message, repeated, tag = "403251854")]
    pub bindings: ::prost::alloc::vec::Vec<Binding>,
    /// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
    #[prost(string, optional, tag = "3123477")]
    pub etag: ::core::option::Option<::prost::alloc::string::String>,
    /// REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
    #[prost(message, optional, tag = "91071794")]
    pub policy: ::core::option::Option<Policy>,
}
/// A guest attributes entry.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GuestAttributes {
    /// [Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// The path to be queried. This can be the default namespace ('') or a nested namespace ('\/') or a specified key ('\/\').
    #[prost(string, optional, tag = "368591164")]
    pub query_path: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The value of the requested queried path.
    #[prost(message, optional, tag = "157570874")]
    pub query_value: ::core::option::Option<GuestAttributesValue>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// The key to search for.
    #[prost(string, optional, tag = "164364828")]
    pub variable_key: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The value found for the requested key.
    #[prost(string, optional, tag = "124582382")]
    pub variable_value: ::core::option::Option<::prost::alloc::string::String>,
}
/// A guest attributes namespace/key/value entry.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GuestAttributesEntry {
    /// Key for the guest attribute entry.
    #[prost(string, optional, tag = "106079")]
    pub key: ::core::option::Option<::prost::alloc::string::String>,
    /// Namespace for the guest attribute entry.
    #[prost(string, optional, tag = "178476379")]
    pub namespace: ::core::option::Option<::prost::alloc::string::String>,
    /// Value for the guest attribute entry.
    #[prost(string, optional, tag = "111972721")]
    pub value: ::core::option::Option<::prost::alloc::string::String>,
}
/// Array of guest attribute namespace/key/value tuples.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GuestAttributesValue {
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<GuestAttributesEntry>,
}
/// Guest OS features.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GuestOsFeature {
    /// The ID of a supported feature. Read Enabling guest operating system features to see a list of available options.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `GuestOsFeature`.
pub mod guest_os_feature {
    /// The ID of a supported feature. Read Enabling guest operating system features to see a list of available options.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        FeatureTypeUnspecified = 531767259,
        Gvnic = 68209305,
        MultiIpSubnet = 151776719,
        SecureBoot = 376811194,
        SevCapable = 87083793,
        UefiCompatible = 195865408,
        VirtioScsiMultiqueue = 201597069,
        Windows = 456863331,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Http2HealthCheck {
    /// The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
    #[prost(string, optional, tag = "3208616")]
    pub host: ::core::option::Option<::prost::alloc::string::String>,
    /// The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    /// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
    #[prost(string, optional, tag = "41534345")]
    pub port_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.
    /// Check the PortSpecification enum for the list of possible values.
    #[prost(string, optional, tag = "51590597")]
    pub port_specification: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
    /// Check the ProxyHeader enum for the list of possible values.
    #[prost(string, optional, tag = "160374142")]
    pub proxy_header: ::core::option::Option<::prost::alloc::string::String>,
    /// The request path of the HTTP/2 health check request. The default value is /.
    #[prost(string, optional, tag = "229403605")]
    pub request_path: ::core::option::Option<::prost::alloc::string::String>,
    /// The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
    #[prost(string, optional, tag = "196547649")]
    pub response: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `HTTP2HealthCheck`.
pub mod http2_health_check {
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PortSpecification {
        /// A value indicating that the enum field is not set.
        UndefinedPortSpecification = 0,
        /// The port number in port is used for health checking.
        UseFixedPort = 190235748,
        /// The portName is used for health checking.
        UseNamedPort = 349300671,
        /// For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
        UseServingPort = 362637516,
    }
    /// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ProxyHeader {
        /// A value indicating that the enum field is not set.
        UndefinedProxyHeader = 0,
        None = 2402104,
        ProxyV1 = 334352940,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpHealthCheck {
    /// The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
    #[prost(string, optional, tag = "3208616")]
    pub host: ::core::option::Option<::prost::alloc::string::String>,
    /// The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    /// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
    #[prost(string, optional, tag = "41534345")]
    pub port_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.
    /// Check the PortSpecification enum for the list of possible values.
    #[prost(string, optional, tag = "51590597")]
    pub port_specification: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
    /// Check the ProxyHeader enum for the list of possible values.
    #[prost(string, optional, tag = "160374142")]
    pub proxy_header: ::core::option::Option<::prost::alloc::string::String>,
    /// The request path of the HTTP health check request. The default value is /.
    #[prost(string, optional, tag = "229403605")]
    pub request_path: ::core::option::Option<::prost::alloc::string::String>,
    /// The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
    #[prost(string, optional, tag = "196547649")]
    pub response: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `HTTPHealthCheck`.
pub mod http_health_check {
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PortSpecification {
        /// A value indicating that the enum field is not set.
        UndefinedPortSpecification = 0,
        /// The port number in port is used for health checking.
        UseFixedPort = 190235748,
        /// The portName is used for health checking.
        UseNamedPort = 349300671,
        /// For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
        UseServingPort = 362637516,
    }
    /// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ProxyHeader {
        /// A value indicating that the enum field is not set.
        UndefinedProxyHeader = 0,
        None = 2402104,
        ProxyV1 = 334352940,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpsHealthCheck {
    /// The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
    #[prost(string, optional, tag = "3208616")]
    pub host: ::core::option::Option<::prost::alloc::string::String>,
    /// The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    /// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
    #[prost(string, optional, tag = "41534345")]
    pub port_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.
    /// Check the PortSpecification enum for the list of possible values.
    #[prost(string, optional, tag = "51590597")]
    pub port_specification: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
    /// Check the ProxyHeader enum for the list of possible values.
    #[prost(string, optional, tag = "160374142")]
    pub proxy_header: ::core::option::Option<::prost::alloc::string::String>,
    /// The request path of the HTTPS health check request. The default value is /.
    #[prost(string, optional, tag = "229403605")]
    pub request_path: ::core::option::Option<::prost::alloc::string::String>,
    /// The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
    #[prost(string, optional, tag = "196547649")]
    pub response: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `HTTPSHealthCheck`.
pub mod https_health_check {
    /// Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PortSpecification {
        /// A value indicating that the enum field is not set.
        UndefinedPortSpecification = 0,
        /// The port number in port is used for health checking.
        UseFixedPort = 190235748,
        /// The portName is used for health checking.
        UseNamedPort = 349300671,
        /// For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
        UseServingPort = 362637516,
    }
    /// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ProxyHeader {
        /// A value indicating that the enum field is not set.
        UndefinedProxyHeader = 0,
        None = 2402104,
        ProxyV1 = 334352940,
    }
}
/// Represents a Health Check resource. Google Compute Engine has two Health Check resources: * \[Global\](/compute/docs/reference/rest/v1/healthChecks) * \[Regional\](/compute/docs/reference/rest/v1/regionHealthChecks) Internal HTTP(S) load balancers must use regional health checks (`compute.v1.regionHealthChecks`). Traffic Director must use global health checks (`compute.v1.HealthChecks`). Internal TCP/UDP load balancers can use either regional or global health checks (`compute.v1.regionHealthChecks` or `compute.v1.HealthChecks`). External HTTP(S), TCP proxy, and SSL proxy load balancers as well as managed instance group auto-healing must use global health checks (`compute.v1.HealthChecks`). Backend service-based network load balancers must use regional health checks (`compute.v1.regionHealthChecks`). Target pool-based network load balancers must use legacy HTTP health checks (`compute.v1.httpHealthChecks`). For more information, see Health checks overview.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheck {
    /// How often (in seconds) to send a health check. The default value is 5 seconds.
    #[prost(int32, optional, tag = "345561006")]
    pub check_interval_sec: ::core::option::Option<i32>,
    /// [Output Only] Creation timestamp in 3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "85529574")]
    pub grpc_health_check: ::core::option::Option<GrpcHealthCheck>,
    /// A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
    #[prost(int32, optional, tag = "403212361")]
    pub healthy_threshold: ::core::option::Option<i32>,
    #[prost(message, optional, tag = "11360986")]
    pub http2_health_check: ::core::option::Option<Http2HealthCheck>,
    #[prost(message, optional, tag = "412586940")]
    pub http_health_check: ::core::option::Option<HttpHealthCheck>,
    #[prost(message, optional, tag = "436046905")]
    pub https_health_check: ::core::option::Option<HttpsHealthCheck>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// Type of the resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Configure logging on this health check.
    #[prost(message, optional, tag = "351299741")]
    pub log_config: ::core::option::Option<HealthCheckLogConfig>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Region where the health check resides. Not applicable to global health checks.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "280032440")]
    pub ssl_health_check: ::core::option::Option<SslHealthCheck>,
    #[prost(message, optional, tag = "469980419")]
    pub tcp_health_check: ::core::option::Option<TcpHealthCheck>,
    /// How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
    #[prost(int32, optional, tag = "79994995")]
    pub timeout_sec: ::core::option::Option<i32>,
    /// Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of the protocol-specific health check field must be specified, which must match type field.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
    /// A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
    #[prost(int32, optional, tag = "227958480")]
    pub unhealthy_threshold: ::core::option::Option<i32>,
}
/// Nested message and enum types in `HealthCheck`.
pub mod health_check {
    /// Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of the protocol-specific health check field must be specified, which must match type field.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        Grpc = 2196510,
        Http = 2228360,
        Http2 = 69079210,
        Https = 69079243,
        Invalid = 530283991,
        Ssl = 82412,
        Tcp = 82881,
    }
}
/// Contains a list of HealthCheck resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheckList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of HealthCheck resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<HealthCheck>,
    /// Type of resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheckLogConfig {
    /// Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
    #[prost(bool, optional, tag = "311764355")]
    pub enable: ::core::option::Option<bool>,
}
/// A full or valid partial URL to a health check. For example, the following are valid URLs: - <https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check> - projects/project-id/global/httpHealthChecks/health-check - global/httpHealthChecks/health-check
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheckReference {
    #[prost(string, optional, tag = "308876645")]
    pub health_check: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents a Health-Check as a Service resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheckService {
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthCheckService. An up-to-date fingerprint must be provided in order to patch/update the HealthCheckService; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthCheckService.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of URLs to the HealthCheck resources. Must have at least one HealthCheck, and not more than 10. HealthCheck resources must have portSpecification=USE_SERVING_PORT or portSpecification=USE_FIXED_PORT. For regional HealthCheckService, the HealthCheck must be regional and in the same region. For global HealthCheckService, HealthCheck must be global. Mix of regional and global HealthChecks is not supported. Multiple regional HealthChecks must belong to the same region. Regional HealthChecks must belong to the same region as zones of NEGs.
    #[prost(string, repeated, tag = "448370606")]
    pub health_checks: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. .
    /// Check the HealthStatusAggregationPolicy enum for the list of possible values.
    #[prost(string, optional, tag = "253163129")]
    pub health_status_aggregation_policy: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output only] Type of the resource. Always compute#healthCheckServicefor health check services.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of URLs to the NetworkEndpointGroup resources. Must not have more than 100. For regional HealthCheckService, NEGs must be in zones in the region of the HealthCheckService.
    #[prost(string, repeated, tag = "29346733")]
    pub network_endpoint_groups: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// A list of URLs to the NotificationEndpoint resources. Must not have more than 10. A list of endpoints for receiving notifications of change in health status. For regional HealthCheckService, NotificationEndpoint must be regional and in the same region. For global HealthCheckService, NotificationEndpoint must be global.
    #[prost(string, repeated, tag = "406728490")]
    pub notification_endpoints: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] URL of the region where the health check service resides. This field is not applicable to global health check services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `HealthCheckService`.
pub mod health_check_service {
    /// Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. .
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum HealthStatusAggregationPolicy {
        /// A value indicating that the enum field is not set.
        UndefinedHealthStatusAggregationPolicy = 0,
        /// If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY.
        And = 64951,
        /// An EndpointHealth message is returned for each backend in the health check service.
        NoAggregation = 426445124,
    }
}
/// A full or valid partial URL to a health check service. For example, the following are valid URLs: - <https://www.googleapis.com/compute/beta/projects/project-id/regions/us-west1/healthCheckServices/health-check-service> - projects/project-id/regions/us-west1/healthCheckServices/health-check-service - regions/us-west1/healthCheckServices/health-check-service
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheckServiceReference {
    #[prost(string, optional, tag = "408374747")]
    pub health_check_service: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthCheckServicesList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of HealthCheckService resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<HealthCheckService>,
    /// [Output Only] Type of the resource. Always compute#healthCheckServicesList for lists of HealthCheckServices.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthChecksAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of HealthChecksScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        HealthChecksScopedList,
    >,
    /// Type of resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthChecksScopedList {
    /// A list of HealthChecks contained in this scope.
    #[prost(message, repeated, tag = "448370606")]
    pub health_checks: ::prost::alloc::vec::Vec<HealthCheck>,
    /// Informational warning which replaces the list of backend services when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthStatus {
    /// Metadata defined as annotations for network endpoint.
    #[prost(btree_map = "string, string", tag = "112032548")]
    pub annotations: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// URL of the forwarding rule associated with the health status of the instance.
    #[prost(string, optional, tag = "269964030")]
    pub forwarding_rule: ::core::option::Option<::prost::alloc::string::String>,
    /// A forwarding rule IP address assigned to this instance.
    #[prost(string, optional, tag = "172250632")]
    pub forwarding_rule_ip: ::core::option::Option<::prost::alloc::string::String>,
    /// Health state of the instance.
    /// Check the HealthState enum for the list of possible values.
    #[prost(string, optional, tag = "324007150")]
    pub health_state: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the instance resource.
    #[prost(string, optional, tag = "18257045")]
    pub instance: ::core::option::Option<::prost::alloc::string::String>,
    /// For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
    #[prost(string, optional, tag = "406272220")]
    pub ip_address: ::core::option::Option<::prost::alloc::string::String>,
    /// The named port of the instance group, not necessarily the port that is health-checked.
    #[prost(int32, optional, tag = "3446913")]
    pub port: ::core::option::Option<i32>,
    #[prost(string, optional, tag = "282149496")]
    pub weight: ::core::option::Option<::prost::alloc::string::String>,
    ///
    /// Check the WeightError enum for the list of possible values.
    #[prost(string, optional, tag = "522501505")]
    pub weight_error: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `HealthStatus`.
pub mod health_status {
    /// Health state of the instance.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum HealthState {
        /// A value indicating that the enum field is not set.
        UndefinedHealthState = 0,
        Healthy = 439801213,
        Unhealthy = 462118084,
    }
    ///
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum WeightError {
        /// A value indicating that the enum field is not set.
        UndefinedWeightError = 0,
        /// The response to a Health Check probe had the HTTP response header field X-Load-Balancing-Endpoint-Weight, but its content was invalid (i.e., not a non-negative single-precision floating-point number in decimal string representation).
        InvalidWeight = 383698400,
        /// The response to a Health Check probe did not have the HTTP response header field X-Load-Balancing-Endpoint-Weight.
        MissingWeight = 384027537,
        /// This is the value when the accompanied health status is either TIMEOUT (i.e.,the Health Check probe was not able to get a response in time) or UNKNOWN. For the latter, it should be typically because there has not been sufficient time to parse and report the weight for a new backend (which is with 0.0.0.0 ip address). However, it can be also due to an outage case for which the health status is explicitly reset to UNKNOWN.
        UnavailableWeight = 439464295,
        /// This is the default value when WeightReportMode is DISABLE, and is also the initial value when WeightReportMode has just updated to ENABLE or DRY_RUN and there has not been sufficient time to parse and report the backend weight.
        WeightNone = 502428831,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HealthStatusForNetworkEndpoint {
    /// URL of the backend service associated with the health state of the network endpoint.
    #[prost(message, optional, tag = "306946058")]
    pub backend_service: ::core::option::Option<BackendServiceReference>,
    /// URL of the forwarding rule associated with the health state of the network endpoint.
    #[prost(message, optional, tag = "269964030")]
    pub forwarding_rule: ::core::option::Option<ForwardingRuleReference>,
    /// URL of the health check associated with the health state of the network endpoint.
    #[prost(message, optional, tag = "308876645")]
    pub health_check: ::core::option::Option<HealthCheckReference>,
    /// URL of the health check service associated with the health state of the network endpoint.
    #[prost(message, optional, tag = "408374747")]
    pub health_check_service: ::core::option::Option<HealthCheckServiceReference>,
    /// Health state of the network endpoint determined based on the health checks configured.
    /// Check the HealthState enum for the list of possible values.
    #[prost(string, optional, tag = "324007150")]
    pub health_state: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `HealthStatusForNetworkEndpoint`.
pub mod health_status_for_network_endpoint {
    /// Health state of the network endpoint determined based on the health checks configured.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum HealthState {
        /// A value indicating that the enum field is not set.
        UndefinedHealthState = 0,
        Draining = 480455402,
        Healthy = 439801213,
        Unhealthy = 462118084,
        Unknown = 433141802,
    }
}
/// UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HostRule {
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of (\[a-z0-9-.\]*). In that case, * must be the first character and must be followed in the pattern by either - or .. * based matching is not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(string, repeated, tag = "99467211")]
    pub hosts: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
    #[prost(string, optional, tag = "337813272")]
    pub path_matcher: ::core::option::Option<::prost::alloc::string::String>,
}
/// Specification for how requests are aborted as part of fault injection.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpFaultAbort {
    /// The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.
    #[prost(uint32, optional, tag = "468949897")]
    pub http_status: ::core::option::Option<u32>,
    /// The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection. The value must be between 0.0 and 100.0 inclusive.
    #[prost(double, optional, tag = "151909018")]
    pub percentage: ::core::option::Option<f64>,
}
/// Specifies the delay introduced by Loadbalancer before forwarding the request to the backend service as part of fault injection.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpFaultDelay {
    /// Specifies the value of the fixed delay interval.
    #[prost(message, optional, tag = "317037816")]
    pub fixed_delay: ::core::option::Option<Duration>,
    /// The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection. The value must be between 0.0 and 100.0 inclusive.
    #[prost(double, optional, tag = "151909018")]
    pub percentage: ::core::option::Option<f64>,
}
/// The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by Loadbalancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the Loadbalancer for a percentage of requests.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpFaultInjection {
    /// The specification for how client requests are aborted as part of fault injection.
    #[prost(message, optional, tag = "92611376")]
    pub abort: ::core::option::Option<HttpFaultAbort>,
    /// The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
    #[prost(message, optional, tag = "95467907")]
    pub delay: ::core::option::Option<HttpFaultDelay>,
}
/// The request and response header transformations that take effect before the request is passed along to the selected backendService.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpHeaderAction {
    /// Headers to add to a matching request prior to forwarding the request to the backendService.
    #[prost(message, repeated, tag = "72111974")]
    pub request_headers_to_add: ::prost::alloc::vec::Vec<HttpHeaderOption>,
    /// A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
    #[prost(string, repeated, tag = "218425247")]
    pub request_headers_to_remove: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Headers to add the response prior to sending the response back to the client.
    #[prost(message, repeated, tag = "32136052")]
    pub response_headers_to_add: ::prost::alloc::vec::Vec<HttpHeaderOption>,
    /// A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
    #[prost(string, repeated, tag = "75415761")]
    pub response_headers_to_remove: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// matchRule criteria for request header matches.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpHeaderMatch {
    /// The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    #[prost(string, optional, tag = "457641093")]
    pub exact_match: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to target gRPC proxy that has validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin.
    #[prost(string, optional, tag = "110223613")]
    pub header_name: ::core::option::Option<::prost::alloc::string::String>,
    /// If set to false, the headerMatch is considered a match if the match criteria above are met. If set to true, the headerMatch is considered a match if the match criteria above are NOT met. The default setting is false.
    #[prost(bool, optional, tag = "501130268")]
    pub invert_match: ::core::option::Option<bool>,
    /// The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    #[prost(string, optional, tag = "257898968")]
    pub prefix_match: ::core::option::Option<::prost::alloc::string::String>,
    /// A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    #[prost(bool, optional, tag = "67435841")]
    pub present_match: ::core::option::Option<bool>,
    /// The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. Note that rangeMatch is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
    #[prost(message, optional, tag = "97244227")]
    pub range_match: ::core::option::Option<Int64RangeMatch>,
    /// The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see: github.com/google/re2/wiki/Syntax For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. Note that regexMatch only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    #[prost(string, optional, tag = "107387853")]
    pub regex_match: ::core::option::Option<::prost::alloc::string::String>,
    /// The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    #[prost(string, optional, tag = "426488663")]
    pub suffix_match: ::core::option::Option<::prost::alloc::string::String>,
}
/// Specification determining how headers are added to requests or responses.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpHeaderOption {
    /// The name of the header.
    #[prost(string, optional, tag = "110223613")]
    pub header_name: ::core::option::Option<::prost::alloc::string::String>,
    /// The value of the header to add.
    #[prost(string, optional, tag = "203094335")]
    pub header_value: ::core::option::Option<::prost::alloc::string::String>,
    /// If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is false.
    #[prost(bool, optional, tag = "20755124")]
    pub replace: ::core::option::Option<bool>,
}
/// HttpRouteRuleMatch criteria for a request's query parameter.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpQueryParameterMatch {
    /// The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch or regexMatch must be set.
    #[prost(string, optional, tag = "457641093")]
    pub exact_match: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch or regexMatch must be set.
    #[prost(bool, optional, tag = "67435841")]
    pub present_match: ::core::option::Option<bool>,
    /// The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For the regular expression grammar, please see github.com/google/re2/wiki/Syntax Only one of presentMatch, exactMatch or regexMatch must be set. Note that regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
    #[prost(string, optional, tag = "107387853")]
    pub regex_match: ::core::option::Option<::prost::alloc::string::String>,
}
/// Specifies settings for an HTTP redirect.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpRedirectAction {
    /// The host that will be used in the redirect response instead of the one that was supplied in the request. The value must be between 1 and 255 characters.
    #[prost(string, optional, tag = "107417747")]
    pub host_redirect: ::core::option::Option<::prost::alloc::string::String>,
    /// If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
    #[prost(bool, optional, tag = "170260656")]
    pub https_redirect: ::core::option::Option<bool>,
    /// The path that will be used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect. The value must be between 1 and 1024 characters.
    #[prost(string, optional, tag = "272342710")]
    pub path_redirect: ::core::option::Option<::prost::alloc::string::String>,
    /// The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect. The value must be between 1 and 1024 characters.
    #[prost(string, optional, tag = "446184169")]
    pub prefix_redirect: ::core::option::Option<::prost::alloc::string::String>,
    /// The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
    /// Check the RedirectResponseCode enum for the list of possible values.
    #[prost(string, optional, tag = "436710408")]
    pub redirect_response_code: ::core::option::Option<::prost::alloc::string::String>,
    /// If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
    #[prost(bool, optional, tag = "52284641")]
    pub strip_query: ::core::option::Option<bool>,
}
/// Nested message and enum types in `HttpRedirectAction`.
pub mod http_redirect_action {
    /// The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum RedirectResponseCode {
        /// A value indicating that the enum field is not set.
        UndefinedRedirectResponseCode = 0,
        /// Http Status Code 302 - Found.
        Found = 67084130,
        /// Http Status Code 301 - Moved Permanently.
        MovedPermanentlyDefault = 386698449,
        /// Http Status Code 308 - Permanent Redirect maintaining HTTP method.
        PermanentRedirect = 382006381,
        /// Http Status Code 303 - See Other.
        SeeOther = 445380580,
        /// Http Status Code 307 - Temporary Redirect maintaining HTTP method.
        TemporaryRedirect = 489550378,
    }
}
/// The retry policy associates with HttpRouteRule
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpRetryPolicy {
    /// Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
    #[prost(uint32, optional, tag = "251680141")]
    pub num_retries: ::core::option::Option<u32>,
    /// Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in HttpRouteAction. If timeout in HttpRouteAction is not set, will use the largest timeout among all backend services associated with the route.
    #[prost(message, optional, tag = "280041147")]
    pub per_try_timeout: ::core::option::Option<Duration>,
    /// Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: Retry will be attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - - connect-failure: A retry will be attempted on failures connecting to the instance or endpoint, for example due to connection timeouts. - retriable-4xx: A retry will be attempted if the instance or endpoint responds with a retriable 4xx response code. Currently the only retriable error supported is 409. - refused-stream: A retry will be attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: A retry will be attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: A retry will be attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: A retry will be attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: A retry will be attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: A retry will be attempted if the gRPC status code in the response header is set to unavailable.
    #[prost(string, repeated, tag = "28815535")]
    pub retry_conditions: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpRouteAction {
    /// The specification for allowing client side cross-origin requests. Please see W3C Recommendation for Cross Origin Resource Sharing Not supported when the URL map is bound to target gRPC proxy.
    #[prost(message, optional, tag = "398943748")]
    pub cors_policy: ::core::option::Option<CorsPolicy>,
    /// The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by Loadbalancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the Loadbalancer for a percentage of requests. For the requests impacted by fault injection, timeout and retry_policy will be ignored by clients that are configured with a fault_injection_policy.
    #[prost(message, optional, tag = "412781079")]
    pub fault_injection_policy: ::core::option::Option<HttpFaultInjection>,
    /// Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (i.e. end-of-stream), the duration in this field is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, will use the largest maxStreamDuration among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    #[prost(message, optional, tag = "61428376")]
    pub max_stream_duration: ::core::option::Option<Duration>,
    /// Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. Loadbalancer does not wait for responses from the shadow service. Prior to sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "220196866")]
    pub request_mirror_policy: ::core::option::Option<RequestMirrorPolicy>,
    /// Specifies the retry policy associated with this route. Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "56799913")]
    pub retry_policy: ::core::option::Option<HttpRetryPolicy>,
    /// Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (i.e. end-of-stream) up until the response has been completely processed. Timeout includes all retries. If not specified, will use the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "296701281")]
    pub timeout: ::core::option::Option<Duration>,
    /// The spec to modify the URL of the request, prior to forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers. Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "273333948")]
    pub url_rewrite: ::core::option::Option<UrlRewrite>,
    /// A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. Once a backendService is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
    #[prost(message, repeated, tag = "337028049")]
    pub weighted_backend_services: ::prost::alloc::vec::Vec<WeightedBackendService>,
}
/// An HttpRouteRule specifies how to match an HTTP request and the corresponding routing action that load balancing proxies will perform.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpRouteRule {
    /// The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here are applied before the matching pathMatchers[].headerAction and after pathMatchers\[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[\].headerAction Note that headerAction is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, optional, tag = "328077352")]
    pub header_action: ::core::option::Option<HttpHeaderAction>,
    /// The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
    #[prost(message, repeated, tag = "376200701")]
    pub match_rules: ::prost::alloc::vec::Vec<HttpRouteRuleMatch>,
    /// For routeRules within a given pathMatcher, priority determines the order in which load balancer will interpret routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 0 and 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
    #[prost(int32, optional, tag = "445151652")]
    pub priority: ::core::option::Option<i32>,
    /// In response to a matching matchRule, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a routeRule's routeAction.
    #[prost(message, optional, tag = "424563948")]
    pub route_action: ::core::option::Option<HttpRouteAction>,
    /// The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
    #[prost(string, optional, tag = "373540533")]
    pub service: ::core::option::Option<::prost::alloc::string::String>,
    /// When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to target gRPC proxy.
    #[prost(message, optional, tag = "405147820")]
    pub url_redirect: ::core::option::Option<HttpRedirectAction>,
}
/// HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpRouteRuleMatch {
    /// For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
    #[prost(string, optional, tag = "214598875")]
    pub full_path_match: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a list of header match criteria, all of which must match corresponding headers in the request.
    #[prost(message, repeated, tag = "361903489")]
    pub header_matches: ::prost::alloc::vec::Vec<HttpHeaderMatch>,
    /// Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to target gRPC proxy.
    #[prost(bool, optional, tag = "464324989")]
    pub ignore_case: ::core::option::Option<bool>,
    /// Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
    #[prost(message, repeated, tag = "464725739")]
    pub metadata_filters: ::prost::alloc::vec::Vec<MetadataFilter>,
    /// For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
    #[prost(string, optional, tag = "257898968")]
    pub prefix_match: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to target gRPC proxy.
    #[prost(message, repeated, tag = "286231270")]
    pub query_parameter_matches: ::prost::alloc::vec::Vec<HttpQueryParameterMatch>,
    /// For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For regular expression grammar please see github.com/google/re2/wiki/Syntax Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Note that regexMatch only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    #[prost(string, optional, tag = "107387853")]
    pub regex_match: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents an Image resource. You can use images to create boot disks for your VM instances. For more information, read Images.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Image {
    /// Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
    #[prost(int64, optional, tag = "381093450")]
    pub archive_size_bytes: ::core::option::Option<i64>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// The deprecation status associated with this image.
    #[prost(message, optional, tag = "515138995")]
    pub deprecated: ::core::option::Option<DeprecationStatus>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Size of the image when restored onto a persistent disk (in GB).
    #[prost(int64, optional, tag = "316263735")]
    pub disk_size_gb: ::core::option::Option<i64>,
    /// The name of the image family to which this image belongs. You can create disks by specifying an image family instead of a specific image name. The image family always returns its latest image that is not deprecated. The name of the image family must comply with RFC1035.
    #[prost(string, optional, tag = "328751972")]
    pub family: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
    #[prost(message, repeated, tag = "79294545")]
    pub guest_os_features: ::prost::alloc::vec::Vec<GuestOsFeature>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// Encrypts the image using a customer-supplied encryption key. After you encrypt an image with a customer-supplied key, you must provide the same key if you use the image later (e.g. to create a disk from the image). Customer-supplied encryption keys do not protect access to metadata of the disk. If you do not provide an encryption key when creating the image, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the image later.
    #[prost(message, optional, tag = "379512583")]
    pub image_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// [Output Only] Type of the resource. Always compute#image for images.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// A fingerprint for the labels being applied to this image, which is essentially a hash of the labels used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an image.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// Labels to apply to this image. These can be later modified by the setLabels method.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Integer license codes indicating which licenses are attached to this image.
    #[prost(int64, repeated, tag = "45482664")]
    pub license_codes: ::prost::alloc::vec::Vec<i64>,
    /// Any applicable license URI.
    #[prost(string, repeated, tag = "337642578")]
    pub licenses: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The parameters of the raw disk image.
    #[prost(message, optional, tag = "503113556")]
    pub raw_disk: ::core::option::Option<RawDisk>,
    /// [Output Only] Reserved for future use.
    #[prost(bool, optional, tag = "480964267")]
    pub satisfies_pzs: ::core::option::Option<bool>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// Set the secure boot keys of shielded instance.
    #[prost(message, optional, tag = "192356867")]
    pub shielded_instance_initial_state: ::core::option::Option<InitialStateConfig>,
    /// URL of the source disk used to create this image. For example, the following are valid values: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
    #[prost(string, optional, tag = "451753793")]
    pub source_disk: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
    #[prost(message, optional, tag = "531501153")]
    pub source_disk_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// [Output Only] The ID value of the disk used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given disk name.
    #[prost(string, optional, tag = "454190809")]
    pub source_disk_id: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the source image used to create this image. The following are valid formats for the URL: - <https://www.googleapis.com/compute/v1/projects/project_id/global/> images/image_name - projects/project_id/global/images/image_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
    #[prost(string, optional, tag = "50443319")]
    pub source_image: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
    #[prost(message, optional, tag = "381503659")]
    pub source_image_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// [Output Only] The ID value of the image used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given image name.
    #[prost(string, optional, tag = "55328291")]
    pub source_image_id: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the source snapshot used to create this image. The following are valid formats for the URL: - <https://www.googleapis.com/compute/v1/projects/project_id/global/> snapshots/snapshot_name - projects/project_id/global/snapshots/snapshot_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
    #[prost(string, optional, tag = "126061928")]
    pub source_snapshot: ::core::option::Option<::prost::alloc::string::String>,
    /// The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
    #[prost(message, optional, tag = "303679322")]
    pub source_snapshot_encryption_key: ::core::option::Option<CustomerEncryptionKey>,
    /// [Output Only] The ID value of the snapshot used to create this image. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given snapshot name.
    #[prost(string, optional, tag = "98962258")]
    pub source_snapshot_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The type of the image used to create this disk. The default and only value is RAW
    /// Check the SourceType enum for the list of possible values.
    #[prost(string, optional, tag = "452245726")]
    pub source_type: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// Cloud Storage bucket storage location of the image (regional or multi-regional).
    #[prost(string, repeated, tag = "328005274")]
    pub storage_locations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Image`.
pub mod image {
    /// The type of the image used to create this disk. The default and only value is RAW
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum SourceType {
        /// A value indicating that the enum field is not set.
        UndefinedSourceType = 0,
        Raw = 80904,
    }
    /// [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// Image is deleting.
        Deleting = 528602024,
        /// Image creation failed due to an error.
        Failed = 455706685,
        /// Image hasn't been created as yet.
        Pending = 35394935,
        /// Image has been successfully created.
        Ready = 77848963,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ImageFamilyView {
    /// The latest image that is part of the specified image family in the requested location, and that is not deprecated.
    #[prost(message, optional, tag = "100313435")]
    pub image: ::core::option::Option<Image>,
}
/// Contains a list of images.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ImageList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Image resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Image>,
    /// Type of resource.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Initial State for shielded instance, these are public keys which are safe to store in public
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InitialStateConfig {
    /// The Key Database (db).
    #[prost(message, repeated, tag = "99253")]
    pub dbs: ::prost::alloc::vec::Vec<FileContentBuffer>,
    /// The forbidden key database (dbx).
    #[prost(message, repeated, tag = "3077113")]
    pub dbxs: ::prost::alloc::vec::Vec<FileContentBuffer>,
    /// The Key Exchange Key (KEK).
    #[prost(message, repeated, tag = "3288130")]
    pub keks: ::prost::alloc::vec::Vec<FileContentBuffer>,
    /// The Platform Key (PK).
    #[prost(message, optional, tag = "3579")]
    pub pk: ::core::option::Option<FileContentBuffer>,
}
/// A request message for Addresses.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertAddressRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "483888121")]
    pub address_resource: ::core::option::Option<Address>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Autoscalers.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertAutoscalerRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "207616118")]
    pub autoscaler_resource: ::core::option::Option<Autoscaler>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for BackendBuckets.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertBackendBucketRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "380757784")]
    pub backend_bucket_resource: ::core::option::Option<BackendBucket>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for BackendServices.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertBackendServiceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "347586723")]
    pub backend_service_resource: ::core::option::Option<BackendService>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Disks.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertDiskRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "25880688")]
    pub disk_resource: ::core::option::Option<Disk>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Source image to restore onto a disk. This field is optional.
    #[prost(string, optional, tag = "50443319")]
    pub source_image: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ExternalVpnGateways.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertExternalVpnGatewayRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "486813576")]
    pub external_vpn_gateway_resource: ::core::option::Option<ExternalVpnGateway>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for FirewallPolicies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertFirewallPolicyRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "495049532")]
    pub firewall_policy_resource: ::core::option::Option<FirewallPolicy>,
    /// Parent ID for this request. The ID can be either be "folders/\[FOLDER_ID\]" if the parent is a folder or "organizations/\[ORGANIZATION_ID\]" if the parent is an organization.
    #[prost(string, tag = "459714768")]
    pub parent_id: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Firewalls.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertFirewallRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "41425005")]
    pub firewall_resource: ::core::option::Option<Firewall>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for ForwardingRules.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertForwardingRuleRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "301211695")]
    pub forwarding_rule_resource: ::core::option::Option<ForwardingRule>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalAddresses.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertGlobalAddressRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "483888121")]
    pub address_resource: ::core::option::Option<Address>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalForwardingRules.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertGlobalForwardingRuleRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "301211695")]
    pub forwarding_rule_resource: ::core::option::Option<ForwardingRule>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalNetworkEndpointGroups.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertGlobalNetworkEndpointGroupRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "525788839")]
    pub network_endpoint_group_resource: ::core::option::Option<NetworkEndpointGroup>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for GlobalPublicDelegatedPrefixes.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertGlobalPublicDelegatedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "47594501")]
    pub public_delegated_prefix_resource: ::core::option::Option<PublicDelegatedPrefix>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for HealthChecks.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertHealthCheckRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "201925032")]
    pub health_check_resource: ::core::option::Option<HealthCheck>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Images.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertImageRequest {
    /// Force image creation if true.
    #[prost(bool, optional, tag = "197723344")]
    pub force_create: ::core::option::Option<bool>,
    /// The body resource for this request
    #[prost(message, optional, tag = "371171954")]
    pub image_resource: ::core::option::Option<Image>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for InstanceGroupManagers.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertInstanceGroupManagerRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "261063946")]
    pub instance_group_manager_resource: ::core::option::Option<InstanceGroupManager>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where you want to create the managed instance group.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceGroups.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertInstanceGroupRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "286612152")]
    pub instance_group_resource: ::core::option::Option<InstanceGroup>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where you want to create the instance group.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Instances.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertInstanceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "215988344")]
    pub instance_resource: ::core::option::Option<Instance>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies instance template to create the instance. This field is optional. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - <https://www.googleapis.com/compute/v1/projects/project> /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate
    #[prost(string, optional, tag = "332423616")]
    pub source_instance_template: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceTemplates.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertInstanceTemplateRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "10679561")]
    pub instance_template_resource: ::core::option::Option<InstanceTemplate>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for InterconnectAttachments.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertInterconnectAttachmentRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "212341369")]
    pub interconnect_attachment_resource: ::core::option::Option<InterconnectAttachment>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// If true, the request will not be committed.
    #[prost(bool, optional, tag = "242744629")]
    pub validate_only: ::core::option::Option<bool>,
}
/// A request message for Interconnects.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertInterconnectRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "397611167")]
    pub interconnect_resource: ::core::option::Option<Interconnect>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Licenses.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertLicenseRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "437955148")]
    pub license_resource: ::core::option::Option<License>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NetworkEndpointGroups.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertNetworkEndpointGroupRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "525788839")]
    pub network_endpoint_group_resource: ::core::option::Option<NetworkEndpointGroup>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone where you want to create the network endpoint group. It should comply with RFC1035.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Networks.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertNetworkRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "122105599")]
    pub network_resource: ::core::option::Option<Network>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for NodeGroups.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertNodeGroupRequest {
    /// Initial count of nodes in the node group.
    #[prost(int32, tag = "71951469")]
    pub initial_node_count: i32,
    /// The body resource for this request
    #[prost(message, optional, tag = "505321899")]
    pub node_group_resource: ::core::option::Option<NodeGroup>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for NodeTemplates.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertNodeTemplateRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "127364406")]
    pub node_template_resource: ::core::option::Option<NodeTemplate>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for PacketMirrorings.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertPacketMirroringRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "493501985")]
    pub packet_mirroring_resource: ::core::option::Option<PacketMirroring>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for PublicAdvertisedPrefixes.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertPublicAdvertisedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "233614223")]
    pub public_advertised_prefix_resource: ::core::option::Option<PublicAdvertisedPrefix>,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for PublicDelegatedPrefixes.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertPublicDelegatedPrefixeRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The body resource for this request
    #[prost(message, optional, tag = "47594501")]
    pub public_delegated_prefix_resource: ::core::option::Option<PublicDelegatedPrefix>,
    /// Name of the region of this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionAutoscalers.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionAutoscalerRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "207616118")]
    pub autoscaler_resource: ::core::option::Option<Autoscaler>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionBackendServices.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionBackendServiceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "347586723")]
    pub backend_service_resource: ::core::option::Option<BackendService>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionCommitments.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionCommitmentRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "244240888")]
    pub commitment_resource: ::core::option::Option<Commitment>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionDisks.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionDiskRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "25880688")]
    pub disk_resource: ::core::option::Option<Disk>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Source image to restore onto a disk. This field is optional.
    #[prost(string, optional, tag = "50443319")]
    pub source_image: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionHealthChecks.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionHealthCheckRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "201925032")]
    pub health_check_resource: ::core::option::Option<HealthCheck>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionHealthCheckServices.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionHealthCheckServiceRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "477367794")]
    pub health_check_service_resource: ::core::option::Option<HealthCheckService>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionInstanceGroupManagers.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionInstanceGroupManagerRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "261063946")]
    pub instance_group_manager_resource: ::core::option::Option<InstanceGroupManager>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionNetworkEndpointGroups.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionNetworkEndpointGroupRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "525788839")]
    pub network_endpoint_group_resource: ::core::option::Option<NetworkEndpointGroup>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// The name of the region where you want to create the network endpoint group. It should comply with RFC1035.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionNotificationEndpoints.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionNotificationEndpointRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "338459940")]
    pub notification_endpoint_resource: ::core::option::Option<NotificationEndpoint>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for RegionSslCertificates.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionSslCertificateRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "180709897")]
    pub ssl_certificate_resource: ::core::option::Option<SslCertificate>,
}
/// A request message for RegionTargetHttpProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionTargetHttpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "24696744")]
    pub target_http_proxy_resource: ::core::option::Option<TargetHttpProxy>,
}
/// A request message for RegionTargetHttpsProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionTargetHttpsProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "433657473")]
    pub target_https_proxy_resource: ::core::option::Option<TargetHttpsProxy>,
}
/// A request message for RegionUrlMaps.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRegionUrlMapRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// begin_interface: MixerMutationRequestBuilder Request ID to support idempotency.
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "168675425")]
    pub url_map_resource: ::core::option::Option<UrlMap>,
}
/// A request message for Reservations.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertReservationRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "285030177")]
    pub reservation_resource: ::core::option::Option<Reservation>,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for ResourcePolicies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertResourcePolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "76826186")]
    pub resource_policy_resource: ::core::option::Option<ResourcePolicy>,
}
/// A request message for Routes.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRouteRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "225428804")]
    pub route_resource: ::core::option::Option<Route>,
}
/// A request message for Routers.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertRouterRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "155222084")]
    pub router_resource: ::core::option::Option<Router>,
}
/// A request message for SecurityPolicies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertSecurityPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "216159612")]
    pub security_policy_resource: ::core::option::Option<SecurityPolicy>,
}
/// A request message for ServiceAttachments.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertServiceAttachmentRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region of this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "472980256")]
    pub service_attachment_resource: ::core::option::Option<ServiceAttachment>,
}
/// A request message for SslCertificates.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertSslCertificateRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "180709897")]
    pub ssl_certificate_resource: ::core::option::Option<SslCertificate>,
}
/// A request message for SslPolicies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertSslPolicyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "274891848")]
    pub ssl_policy_resource: ::core::option::Option<SslPolicy>,
}
/// A request message for Subnetworks.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertSubnetworkRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "42233151")]
    pub subnetwork_resource: ::core::option::Option<Subnetwork>,
}
/// A request message for TargetGrpcProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetGrpcProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "328922450")]
    pub target_grpc_proxy_resource: ::core::option::Option<TargetGrpcProxy>,
}
/// A request message for TargetHttpProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetHttpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "24696744")]
    pub target_http_proxy_resource: ::core::option::Option<TargetHttpProxy>,
}
/// A request message for TargetHttpsProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetHttpsProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "433657473")]
    pub target_https_proxy_resource: ::core::option::Option<TargetHttpsProxy>,
}
/// A request message for TargetInstances.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetInstanceRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "430453066")]
    pub target_instance_resource: ::core::option::Option<TargetInstance>,
    /// Name of the zone scoping this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for TargetPools.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetPoolRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region scoping this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "101281443")]
    pub target_pool_resource: ::core::option::Option<TargetPool>,
}
/// A request message for TargetSslProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetSslProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "142016192")]
    pub target_ssl_proxy_resource: ::core::option::Option<TargetSslProxy>,
}
/// A request message for TargetTcpProxies.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetTcpProxyRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "145913931")]
    pub target_tcp_proxy_resource: ::core::option::Option<TargetTcpProxy>,
}
/// A request message for TargetVpnGateways.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertTargetVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "498050")]
    pub target_vpn_gateway_resource: ::core::option::Option<TargetVpnGateway>,
}
/// A request message for UrlMaps.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertUrlMapRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "168675425")]
    pub url_map_resource: ::core::option::Option<UrlMap>,
}
/// A request message for VpnGateways.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertVpnGatewayRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "182688660")]
    pub vpn_gateway_resource: ::core::option::Option<VpnGateway>,
}
/// A request message for VpnTunnels.Insert. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InsertVpnTunnelRequest {
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The body resource for this request
    #[prost(message, optional, tag = "86839482")]
    pub vpn_tunnel_resource: ::core::option::Option<VpnTunnel>,
}
/// Represents an Instance resource. An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Instance {
    /// Controls for advanced machine-related behavior features.
    #[prost(message, optional, tag = "409646002")]
    pub advanced_machine_features: ::core::option::Option<AdvancedMachineFeatures>,
    /// Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
    #[prost(bool, optional, tag = "467731324")]
    pub can_ip_forward: ::core::option::Option<bool>,
    #[prost(message, optional, tag = "490637685")]
    pub confidential_instance_config: ::core::option::Option<ConfidentialInstanceConfig>,
    /// [Output Only] The CPU platform used by this instance.
    #[prost(string, optional, tag = "410285354")]
    pub cpu_platform: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// Whether the resource should be protected against deletion.
    #[prost(bool, optional, tag = "458014698")]
    pub deletion_protection: ::core::option::Option<bool>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Array of disks associated with this instance. Persistent disks must be created before you can assign them.
    #[prost(message, repeated, tag = "95594102")]
    pub disks: ::prost::alloc::vec::Vec<AttachedDisk>,
    /// Enables display device for the instance.
    #[prost(message, optional, tag = "258933875")]
    pub display_device: ::core::option::Option<DisplayDevice>,
    /// Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of the type and count of accelerator cards attached to the instance.
    #[prost(message, repeated, tag = "463595119")]
    pub guest_accelerators: ::prost::alloc::vec::Vec<AcceleratorConfig>,
    /// Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is \[INSTANCE_NAME].c.[PROJECT_ID\].internal when using the global DNS, and \[INSTANCE_NAME].[ZONE].c.[PROJECT_ID\].internal when using zonal DNS.
    #[prost(string, optional, tag = "237067315")]
    pub hostname: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#instance for instances.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// Labels to apply to this instance. These can be later modified by the setLabels method.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// [Output Only] Last start timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "443830736")]
    pub last_start_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Last stop timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "412823010")]
    pub last_stop_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Last suspended timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "356275337")]
    pub last_suspended_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
    #[prost(string, optional, tag = "227711026")]
    pub machine_type: ::core::option::Option<::prost::alloc::string::String>,
    /// The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
    #[prost(message, optional, tag = "86866735")]
    pub metadata: ::core::option::Option<Metadata>,
    /// Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
    #[prost(string, optional, tag = "242912759")]
    pub min_cpu_platform: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
    #[prost(message, repeated, tag = "52735243")]
    pub network_interfaces: ::prost::alloc::vec::Vec<NetworkInterface>,
    /// The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
    /// Check the PrivateIpv6GoogleAccess enum for the list of possible values.
    #[prost(string, optional, tag = "48277006")]
    pub private_ipv6_google_access: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the reservations that this instance can consume from.
    #[prost(message, optional, tag = "157850683")]
    pub reservation_affinity: ::core::option::Option<ReservationAffinity>,
    /// Resource policies applied to this instance.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Reserved for future use.
    #[prost(bool, optional, tag = "480964267")]
    pub satisfies_pzs: ::core::option::Option<bool>,
    /// Sets the scheduling options for this instance.
    #[prost(message, optional, tag = "386688404")]
    pub scheduling: ::core::option::Option<Scheduling>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
    #[prost(message, repeated, tag = "277537328")]
    pub service_accounts: ::prost::alloc::vec::Vec<ServiceAccount>,
    #[prost(message, optional, tag = "12862901")]
    pub shielded_instance_config: ::core::option::Option<ShieldedInstanceConfig>,
    #[prost(message, optional, tag = "163696919")]
    pub shielded_instance_integrity_policy: ::core::option::Option<ShieldedInstanceIntegrityPolicy>,
    /// [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
    #[prost(bool, optional, tag = "123693144")]
    pub start_restricted: ::core::option::Option<bool>,
    /// [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] An optional, human-readable explanation of the status.
    #[prost(string, optional, tag = "297428154")]
    pub status_message: ::core::option::Option<::prost::alloc::string::String>,
    /// Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
    #[prost(message, optional, tag = "3552281")]
    pub tags: ::core::option::Option<Tags>,
    /// [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Instance`.
pub mod instance {
    /// The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PrivateIpv6GoogleAccess {
        /// A value indicating that the enum field is not set.
        UndefinedPrivateIpv6GoogleAccess = 0,
        /// Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
        EnableBidirectionalAccessToGoogle = 427975994,
        /// Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
        EnableOutboundVmAccessToGoogle = 288210263,
        /// Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
        InheritFromSubnetwork = 530256959,
    }
    /// [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// The Nanny is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
        Deprovisioning = 428935662,
        /// Resources are being allocated for the instance.
        Provisioning = 290896621,
        /// The instance is in repair.
        Repairing = 413483285,
        /// The instance is running.
        Running = 121282975,
        /// All required resources have been allocated and the instance is being started.
        Staging = 431072283,
        /// The instance has stopped successfully.
        Stopped = 444276141,
        /// The instance is currently stopping (either being deleted or killed).
        Stopping = 350791796,
        /// The instance has suspended.
        Suspended = 51223995,
        /// The instance is suspending.
        Suspending = 514206246,
        /// The instance has stopped (either by explicit action or underlying failure).
        Terminated = 250018339,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// An object that contains a list of instances scoped by zone.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items:
        ::prost::alloc::collections::BTreeMap<::prost::alloc::string::String, InstancesScopedList>,
    /// [Output Only] Type of resource. Always compute#instanceAggregatedList for aggregated lists of Instance resources.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Represents an Instance Group resource. Instance Groups can be used to configure a target for load balancing. Instance groups can either be managed or unmanaged. To create managed instance groups, use the instanceGroupManager or regionInstanceGroupManager resource instead. Use zonal unmanaged instance groups if you need to apply load balancing to groups of heterogeneous instances or if you need to manage the instances yourself. You cannot create regional unmanaged instance groups. For more information, read Instance groups.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroup {
    /// [Output Only] The creation timestamp for this instance group in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect conflicts when multiple users change the named ports concurrently.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A unique identifier for this instance group, generated by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    ///  Assigns a name to a port number. For example: {name: "http", port: 80} This allows the system to reference ports by the assigned name instead of a port number. Named ports can also contain multiple ports. For example: [{name: "http", port: 80},{name: "http", port: 8080}] Named ports apply to all instances in this instance group.
    #[prost(message, repeated, tag = "427598732")]
    pub named_ports: ::prost::alloc::vec::Vec<NamedPort>,
    /// [Output Only] The URL of the network to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).
    #[prost(string, optional, tag = "232872494")]
    pub network: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URL of the region where the instance group is located (for regional resources).
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URL for this instance group. The server generates this URL.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The total number of instances in the instance group.
    #[prost(int32, optional, tag = "3530753")]
    pub size: ::core::option::Option<i32>,
    /// [Output Only] The URL of the subnetwork to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).
    #[prost(string, optional, tag = "307827694")]
    pub subnetwork: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URL of the zone where the instance group is located (for zonal resources).
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InstanceGroupsScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        InstanceGroupsScopedList,
    >,
    /// [Output Only] The resource type, which is always compute#instanceGroupAggregatedList for aggregated lists of instance groups.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// A list of InstanceGroup resources.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InstanceGroup resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InstanceGroup>,
    /// [Output Only] The resource type, which is always compute#instanceGroupList for instance group lists.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Represents a Managed Instance Group resource. An instance group is a collection of VM instances that you can manage as a single entity. For more information, read Instance groups. For zonal Managed Instance Group, use the instanceGroupManagers resource. For regional Managed Instance Group, use the regionInstanceGroupManagers resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManager {
    /// The autohealing policy for this managed instance group. You can specify only one value.
    #[prost(message, repeated, tag = "456799109")]
    pub auto_healing_policies: ::prost::alloc::vec::Vec<InstanceGroupManagerAutoHealingPolicy>,
    /// The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
    #[prost(string, optional, tag = "389106439")]
    pub base_instance_name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
    #[prost(message, optional, tag = "164045879")]
    pub current_actions: ::core::option::Option<InstanceGroupManagerActionsSummary>,
    /// An optional description of this resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
    #[prost(message, optional, tag = "534558541")]
    pub distribution_policy: ::core::option::Option<DistributionPolicy>,
    /// Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A unique identifier for this resource type. The server generates this identifier.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] The URL of the Instance Group resource.
    #[prost(string, optional, tag = "81095253")]
    pub instance_group: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
    #[prost(string, optional, tag = "309248228")]
    pub instance_template: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Named ports configured for the Instance Groups complementary to this Instance Group Manager.
    #[prost(message, repeated, tag = "427598732")]
    pub named_ports: ::prost::alloc::vec::Vec<NamedPort>,
    /// [Output Only] The URL of the region where the managed instance group resides (for regional resources).
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URL for this managed instance group. The server defines this URL.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// Stateful configuration for this Instanced Group Manager
    #[prost(message, optional, tag = "47538565")]
    pub stateful_policy: ::core::option::Option<StatefulPolicy>,
    /// [Output Only] The status of this managed instance group.
    #[prost(message, optional, tag = "181260274")]
    pub status: ::core::option::Option<InstanceGroupManagerStatus>,
    /// The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
    #[prost(string, repeated, tag = "336072617")]
    pub target_pools: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
    #[prost(int32, optional, tag = "62880239")]
    pub target_size: ::core::option::Option<i32>,
    /// The update policy for this managed instance group.
    #[prost(message, optional, tag = "175809896")]
    pub update_policy: ::core::option::Option<InstanceGroupManagerUpdatePolicy>,
    /// Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
    #[prost(message, repeated, tag = "162430619")]
    pub versions: ::prost::alloc::vec::Vec<InstanceGroupManagerVersion>,
    /// [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
    #[prost(string, optional, tag = "3744684")]
    pub zone: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerActionsSummary {
    /// [Output Only] The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.
    #[prost(int32, optional, tag = "440023373")]
    pub abandoning: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully. If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.
    #[prost(int32, optional, tag = "209809081")]
    pub creating: ::core::option::Option<i32>,
    /// [Output Only] The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group's targetSize value accordingly.
    #[prost(int32, optional, tag = "369916745")]
    pub creating_without_retries: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.
    #[prost(int32, optional, tag = "282846120")]
    pub deleting: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are running and have no scheduled actions.
    #[prost(int32, optional, tag = "3387192")]
    pub none: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.
    #[prost(int32, optional, tag = "339057132")]
    pub recreating: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.
    #[prost(int32, optional, tag = "215044903")]
    pub refreshing: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.
    #[prost(int32, optional, tag = "372312947")]
    pub restarting: ::core::option::Option<i32>,
    /// [Output Only] The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.
    #[prost(int32, optional, tag = "451612873")]
    pub verifying: ::core::option::Option<i32>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InstanceGroupManagersScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        InstanceGroupManagersScopedList,
    >,
    /// [Output Only] The resource type, which is always compute#instanceGroupManagerAggregatedList for an aggregated list of managed instance groups.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerAutoHealingPolicy {
    /// The URL for the health check that signals autohealing.
    #[prost(string, optional, tag = "308876645")]
    pub health_check: ::core::option::Option<::prost::alloc::string::String>,
    /// The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
    #[prost(int32, optional, tag = "263207002")]
    pub initial_delay_sec: ::core::option::Option<i32>,
}
/// [Output Only] A list of managed instance groups.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InstanceGroupManager resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InstanceGroupManager>,
    /// [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerStatus {
    /// [Output Only] The URL of the Autoscaler that targets this instance group manager.
    #[prost(string, optional, tag = "517258967")]
    pub autoscaler: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.
    #[prost(bool, optional, tag = "108410864")]
    pub is_stable: ::core::option::Option<bool>,
    /// [Output Only] Stateful status of the given Instance Group Manager.
    #[prost(message, optional, tag = "244462412")]
    pub stateful: ::core::option::Option<InstanceGroupManagerStatusStateful>,
    /// [Output Only] A status of consistency of Instances' versions with their target version specified by version field on Instance Group Manager.
    #[prost(message, optional, tag = "289386200")]
    pub version_target: ::core::option::Option<InstanceGroupManagerStatusVersionTarget>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerStatusStateful {
    /// [Output Only] A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful config even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions.
    #[prost(bool, optional, tag = "110474224")]
    pub has_stateful_config: ::core::option::Option<bool>,
    /// [Output Only] Status of per-instance configs on the instance.
    #[prost(message, optional, tag = "526265001")]
    pub per_instance_configs:
        ::core::option::Option<InstanceGroupManagerStatusStatefulPerInstanceConfigs>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerStatusStatefulPerInstanceConfigs {
    /// A bit indicating if all of the group's per-instance configs (listed in the output of a listPerInstanceConfigs API call) have status EFFECTIVE or there are no per-instance-configs.
    #[prost(bool, optional, tag = "516540553")]
    pub all_effective: ::core::option::Option<bool>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerStatusVersionTarget {
    /// [Output Only] A bit indicating whether version target has been reached in this managed instance group, i.e. all instances are in their target version. Instances' target version are specified by version field on Instance Group Manager.
    #[prost(bool, optional, tag = "433209149")]
    pub is_reached: ::core::option::Option<bool>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerUpdatePolicy {
    /// The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
    #[prost(string, optional, tag = "292630424")]
    pub instance_redistribution_type: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
    #[prost(message, optional, tag = "302572691")]
    pub max_surge: ::core::option::Option<FixedOrPercent>,
    /// The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
    #[prost(message, optional, tag = "404940277")]
    pub max_unavailable: ::core::option::Option<FixedOrPercent>,
    /// Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
    #[prost(string, optional, tag = "270567060")]
    pub minimal_action: ::core::option::Option<::prost::alloc::string::String>,
    /// What action should be used to replace instances. See minimal_action.REPLACE
    #[prost(string, optional, tag = "505931694")]
    pub replacement_method: ::core::option::Option<::prost::alloc::string::String>,
    /// The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagerVersion {
    /// The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
    #[prost(string, optional, tag = "309248228")]
    pub instance_template: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the version. Unique among all versions in the scope of this managed instance group.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
    #[prost(message, optional, tag = "62880239")]
    pub target_size: ::core::option::Option<FixedOrPercent>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersAbandonInstancesRequest {
    /// The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/\[ZONE]/instances/[INSTANCE_NAME\].
    #[prost(string, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// InstanceGroupManagers.applyUpdatesToInstances
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersApplyUpdatesRequest {
    /// Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
    #[prost(bool, optional, tag = "403676512")]
    pub all_instances: ::core::option::Option<bool>,
    /// The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/\[ZONE]/instances/[INSTANCE_NAME\].
    #[prost(string, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
    #[prost(string, optional, tag = "270567060")]
    pub minimal_action: ::core::option::Option<::prost::alloc::string::String>,
    /// The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
    #[prost(string, optional, tag = "66103053")]
    pub most_disruptive_allowed_action: ::core::option::Option<::prost::alloc::string::String>,
}
/// InstanceGroupManagers.createInstances
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersCreateInstancesRequest {
    /// \[Required\] List of specifications of per-instance configs.
    #[prost(message, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<PerInstanceConfig>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersDeleteInstancesRequest {
    /// The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/\[ZONE]/instances/[INSTANCE_NAME\].
    #[prost(string, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies whether the request should proceed despite the inclusion of instances that are not members of the group or that are already in the process of being deleted or abandoned. If this field is set to `false` and such an instance is specified in the request, the operation fails. The operation always fails if the request contains a malformed instance URL or a reference to an instance that exists in a zone or region other than the group's zone or region.
    #[prost(bool, optional, tag = "40631073")]
    pub skip_instances_on_validation_error: ::core::option::Option<bool>,
}
/// InstanceGroupManagers.deletePerInstanceConfigs
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersDeletePerInstanceConfigsReq {
    /// The list of instance names for which we want to delete per-instance configs on this managed instance group.
    #[prost(string, repeated, tag = "104585032")]
    pub names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersListErrorsResponse {
    /// [Output Only] The list of errors of the managed instance group.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InstanceManagedByIgmError>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersListManagedInstancesResponse {
    /// [Output Only] The list of instances in the managed instance group.
    #[prost(message, repeated, tag = "336219614")]
    pub managed_instances: ::prost::alloc::vec::Vec<ManagedInstance>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersListPerInstanceConfigsResp {
    /// [Output Only] The list of PerInstanceConfig.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<PerInstanceConfig>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// InstanceGroupManagers.patchPerInstanceConfigs
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersPatchPerInstanceConfigsReq {
    /// The list of per-instance configs to insert or patch on this managed instance group.
    #[prost(message, repeated, tag = "526265001")]
    pub per_instance_configs: ::prost::alloc::vec::Vec<PerInstanceConfig>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersRecreateInstancesRequest {
    /// The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/\[ZONE]/instances/[INSTANCE_NAME\].
    #[prost(string, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersScopedList {
    /// [Output Only] The list of managed instance groups that are contained in the specified project and zone.
    #[prost(message, repeated, tag = "214072592")]
    pub instance_group_managers: ::prost::alloc::vec::Vec<InstanceGroupManager>,
    /// [Output Only] The warning that replaces the list of managed instance groups when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersSetInstanceTemplateRequest {
    /// The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
    #[prost(string, optional, tag = "309248228")]
    pub instance_template: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersSetTargetPoolsRequest {
    /// The fingerprint of the target pools information. Use this optional property to prevent conflicts when multiple users change the target pools settings concurrently. Obtain the fingerprint with the instanceGroupManagers.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// The list of target pool URLs that instances in this managed instance group belong to. The managed instance group applies these target pools to all of the instances in the group. Existing instances and new instances in the group all receive these target pool settings.
    #[prost(string, repeated, tag = "336072617")]
    pub target_pools: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// InstanceGroupManagers.updatePerInstanceConfigs
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupManagersUpdatePerInstanceConfigsReq {
    /// The list of per-instance configs to insert or patch on this managed instance group.
    #[prost(message, repeated, tag = "526265001")]
    pub per_instance_configs: ::prost::alloc::vec::Vec<PerInstanceConfig>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupsAddInstancesRequest {
    /// The list of instances to add to the instance group.
    #[prost(message, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<InstanceReference>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupsListInstances {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InstanceWithNamedPorts resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InstanceWithNamedPorts>,
    /// [Output Only] The resource type, which is always compute#instanceGroupsListInstances for the list of instances in the specified instance group.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupsListInstancesRequest {
    /// A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
    /// Check the InstanceState enum for the list of possible values.
    #[prost(string, optional, tag = "92223591")]
    pub instance_state: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `InstanceGroupsListInstancesRequest`.
pub mod instance_groups_list_instances_request {
    /// A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum InstanceState {
        /// A value indicating that the enum field is not set.
        UndefinedInstanceState = 0,
        /// Includes all instances in the generated list regardless of their state.
        All = 64897,
        /// Includes instances in the generated list only if they have a RUNNING state.
        Running = 121282975,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupsRemoveInstancesRequest {
    /// The list of instances to remove from the instance group.
    #[prost(message, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<InstanceReference>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupsScopedList {
    /// [Output Only] The list of instance groups that are contained in this scope.
    #[prost(message, repeated, tag = "366469310")]
    pub instance_groups: ::prost::alloc::vec::Vec<InstanceGroup>,
    /// [Output Only] An informational warning that replaces the list of instance groups when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceGroupsSetNamedPortsRequest {
    /// The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request. A request with an incorrect fingerprint will fail with error 412 conditionNotMet.
    #[prost(string, optional, tag = "234678500")]
    pub fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    /// The list of named ports to set for this instance group.
    #[prost(message, repeated, tag = "427598732")]
    pub named_ports: ::prost::alloc::vec::Vec<NamedPort>,
}
/// Contains a list of instances.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Instance resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Instance>,
    /// [Output Only] Type of resource. Always compute#instanceList for lists of Instance resources.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Contains a list of instance referrers.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceListReferrers {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Reference resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Reference>,
    /// [Output Only] Type of resource. Always compute#instanceListReferrers for lists of Instance referrers.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceManagedByIgmError {
    /// [Output Only] Contents of the error.
    #[prost(message, optional, tag = "96784904")]
    pub error: ::core::option::Option<InstanceManagedByIgmErrorManagedInstanceError>,
    /// [Output Only] Details of the instance action that triggered this error. May be null, if the error was not caused by an action on an instance. This field is optional.
    #[prost(message, optional, tag = "292224547")]
    pub instance_action_details:
        ::core::option::Option<InstanceManagedByIgmErrorInstanceActionDetails>,
    /// [Output Only] The time that this error occurred. This value is in RFC3339 text format.
    #[prost(string, optional, tag = "55126294")]
    pub timestamp: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceManagedByIgmErrorInstanceActionDetails {
    /// [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
    /// Check the Action enum for the list of possible values.
    #[prost(string, optional, tag = "187661878")]
    pub action: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
    #[prost(string, optional, tag = "18257045")]
    pub instance: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
    #[prost(message, optional, tag = "351608024")]
    pub version: ::core::option::Option<ManagedInstanceVersion>,
}
/// Nested message and enum types in `InstanceManagedByIgmErrorInstanceActionDetails`.
pub mod instance_managed_by_igm_error_instance_action_details {
    /// [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Action {
        /// A value indicating that the enum field is not set.
        UndefinedAction = 0,
        /// The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
        Abandoning = 388244813,
        /// The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
        Creating = 455564985,
        /// The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
        CreatingWithoutRetries = 428843785,
        /// The managed instance group is permanently deleting this instance.
        Deleting = 528602024,
        /// The managed instance group has not scheduled any actions for this instance.
        None = 2402104,
        /// The managed instance group is recreating this instance.
        Recreating = 287278572,
        /// The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
        Refreshing = 163266343,
        /// The managed instance group is restarting this instance.
        Restarting = 320534387,
        /// The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
        Verifying = 16982185,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceManagedByIgmErrorManagedInstanceError {
    /// [Output Only] Error code.
    #[prost(string, optional, tag = "3059181")]
    pub code: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Error message.
    #[prost(string, optional, tag = "418054151")]
    pub message: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceMoveRequest {
    /// The URL of the destination zone to move the instance. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> - projects/project/zones/zone - zones/zone
    #[prost(string, optional, tag = "131854653")]
    pub destination_zone: ::core::option::Option<::prost::alloc::string::String>,
    /// The URL of the target instance to move. This can be a full or partial URL. For example, the following are all valid URLs to an instance: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /instances/instance - projects/project/zones/zone/instances/instance - zones/zone/instances/instance
    #[prost(string, optional, tag = "289769347")]
    pub target_instance: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceProperties {
    /// Controls for advanced machine-related behavior features.
    #[prost(message, optional, tag = "409646002")]
    pub advanced_machine_features: ::core::option::Option<AdvancedMachineFeatures>,
    /// Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
    #[prost(bool, optional, tag = "467731324")]
    pub can_ip_forward: ::core::option::Option<bool>,
    /// Specifies the Confidential Instance options.
    #[prost(message, optional, tag = "490637685")]
    pub confidential_instance_config: ::core::option::Option<ConfidentialInstanceConfig>,
    /// An optional text description for the instances that are created from these properties.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// An array of disks that are associated with the instances that are created from these properties.
    #[prost(message, repeated, tag = "95594102")]
    pub disks: ::prost::alloc::vec::Vec<AttachedDisk>,
    /// A list of guest accelerator cards' type and count to use for instances created from these properties.
    #[prost(message, repeated, tag = "463595119")]
    pub guest_accelerators: ::prost::alloc::vec::Vec<AcceleratorConfig>,
    /// Labels to apply to instances that are created from these properties.
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// The machine type to use for instances that are created from these properties.
    #[prost(string, optional, tag = "227711026")]
    pub machine_type: ::core::option::Option<::prost::alloc::string::String>,
    /// The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
    #[prost(message, optional, tag = "86866735")]
    pub metadata: ::core::option::Option<Metadata>,
    /// Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
    #[prost(string, optional, tag = "242912759")]
    pub min_cpu_platform: ::core::option::Option<::prost::alloc::string::String>,
    /// An array of network access configurations for this interface.
    #[prost(message, repeated, tag = "52735243")]
    pub network_interfaces: ::prost::alloc::vec::Vec<NetworkInterface>,
    /// The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default.
    /// Check the PrivateIpv6GoogleAccess enum for the list of possible values.
    #[prost(string, optional, tag = "48277006")]
    pub private_ipv6_google_access: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies the reservations that instances can consume from.
    #[prost(message, optional, tag = "157850683")]
    pub reservation_affinity: ::core::option::Option<ReservationAffinity>,
    /// Resource policies (names, not ULRs) applied to instances created from these properties.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Specifies the scheduling options for the instances that are created from these properties.
    #[prost(message, optional, tag = "386688404")]
    pub scheduling: ::core::option::Option<Scheduling>,
    /// A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
    #[prost(message, repeated, tag = "277537328")]
    pub service_accounts: ::prost::alloc::vec::Vec<ServiceAccount>,
    #[prost(message, optional, tag = "12862901")]
    pub shielded_instance_config: ::core::option::Option<ShieldedInstanceConfig>,
    /// A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
    #[prost(message, optional, tag = "3552281")]
    pub tags: ::core::option::Option<Tags>,
}
/// Nested message and enum types in `InstanceProperties`.
pub mod instance_properties {
    /// The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PrivateIpv6GoogleAccess {
        /// A value indicating that the enum field is not set.
        UndefinedPrivateIpv6GoogleAccess = 0,
        /// Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
        EnableBidirectionalAccessToGoogle = 427975994,
        /// Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
        EnableOutboundVmAccessToGoogle = 288210263,
        /// Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
        InheritFromSubnetwork = 530256959,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceReference {
    /// The URL for a specific instance. @required compute.instancegroups.addInstances/removeInstances
    #[prost(string, optional, tag = "18257045")]
    pub instance: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents an Instance Template resource. You can use instance templates to create VM instances and managed instance groups. For more information, read Instance Templates.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceTemplate {
    /// [Output Only] The creation timestamp for this instance template in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A unique identifier for this instance template. The server defines this identifier.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] The resource type, which is always compute#instanceTemplate for instance templates.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The instance properties for this instance template.
    #[prost(message, optional, tag = "147688755")]
    pub properties: ::core::option::Option<InstanceProperties>,
    /// [Output Only] The URL for this instance template. The server defines this URL.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// The source instance used to create the template. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - <https://www.googleapis.com/compute/v1/projects/project/zones/zone> /instances/instance - projects/project/zones/zone/instances/instance
    #[prost(string, optional, tag = "396315705")]
    pub source_instance: ::core::option::Option<::prost::alloc::string::String>,
    /// The source instance params to use to create this instance template.
    #[prost(message, optional, tag = "135342156")]
    pub source_instance_params: ::core::option::Option<SourceInstanceParams>,
}
/// A list of instance templates.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceTemplateList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InstanceTemplate resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InstanceTemplate>,
    /// [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for instance template lists.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstanceWithNamedPorts {
    /// [Output Only] The URL of the instance.
    #[prost(string, optional, tag = "18257045")]
    pub instance: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The named ports that belong to this instance group.
    #[prost(message, repeated, tag = "427598732")]
    pub named_ports: ::prost::alloc::vec::Vec<NamedPort>,
    /// [Output Only] The status of the instance.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `InstanceWithNamedPorts`.
pub mod instance_with_named_ports {
    /// [Output Only] The status of the instance.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// The Nanny is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
        Deprovisioning = 428935662,
        /// Resources are being allocated for the instance.
        Provisioning = 290896621,
        /// The instance is in repair.
        Repairing = 413483285,
        /// The instance is running.
        Running = 121282975,
        /// All required resources have been allocated and the instance is being started.
        Staging = 431072283,
        /// The instance has stopped successfully.
        Stopped = 444276141,
        /// The instance is currently stopping (either being deleted or killed).
        Stopping = 350791796,
        /// The instance has suspended.
        Suspended = 51223995,
        /// The instance is suspending.
        Suspending = 514206246,
        /// The instance has stopped (either by explicit action or underlying failure).
        Terminated = 250018339,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesAddResourcePoliciesRequest {
    /// Resource policies to be added to this instance.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesGetEffectiveFirewallsResponse {
    /// Effective firewalls from firewall policies.
    #[prost(message, repeated, tag = "410985794")]
    pub firewall_policys:
        ::prost::alloc::vec::Vec<InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy>,
    /// Effective firewalls on the instance.
    #[prost(message, repeated, tag = "272245619")]
    pub firewalls: ::prost::alloc::vec::Vec<Firewall>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy {
    /// [Output Only] Deprecated, please use short name instead. The display name of the firewall policy.
    #[prost(string, optional, tag = "4473832")]
    pub display_name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The name of the firewall policy.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The rules that apply to the network.
    #[prost(message, repeated, tag = "108873975")]
    pub rules: ::prost::alloc::vec::Vec<FirewallPolicyRule>,
    /// [Output Only] The short name of the firewall policy.
    #[prost(string, optional, tag = "492051566")]
    pub short_name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The type of the firewall policy.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy`.
pub mod instances_get_effective_firewalls_response_effective_firewall_policy {
    /// [Output Only] The type of the firewall policy.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        Hierarchy = 69902869,
        Unspecified = 526786327,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesRemoveResourcePoliciesRequest {
    /// Resource policies to be removed from this instance.
    #[prost(string, repeated, tag = "22220385")]
    pub resource_policies: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesScopedList {
    /// [Output Only] A list of instances contained in this scope.
    #[prost(message, repeated, tag = "29097598")]
    pub instances: ::prost::alloc::vec::Vec<Instance>,
    /// [Output Only] Informational warning which replaces the list of instances when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesSetLabelsRequest {
    /// Fingerprint of the previous set of labels for this resource, used to prevent conflicts. Provide the latest fingerprint value when making a request to add or change labels.
    #[prost(string, optional, tag = "178124825")]
    pub label_fingerprint: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(btree_map = "string, string", tag = "500195327")]
    pub labels: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesSetMachineResourcesRequest {
    /// A list of the type and count of accelerator cards attached to the instance.
    #[prost(message, repeated, tag = "463595119")]
    pub guest_accelerators: ::prost::alloc::vec::Vec<AcceleratorConfig>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesSetMachineTypeRequest {
    /// Full or partial URL of the machine type resource. See Machine Types for a full list of machine types. For example: zones/us-central1-f/machineTypes/n1-standard-1
    #[prost(string, optional, tag = "227711026")]
    pub machine_type: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesSetMinCpuPlatformRequest {
    /// Minimum cpu/platform this instance should be started at.
    #[prost(string, optional, tag = "242912759")]
    pub min_cpu_platform: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesSetServiceAccountRequest {
    /// Email address of the service account.
    #[prost(string, optional, tag = "96619420")]
    pub email: ::core::option::Option<::prost::alloc::string::String>,
    /// The list of scopes to be made available for this service account.
    #[prost(string, repeated, tag = "165973151")]
    pub scopes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstancesStartWithEncryptionKeyRequest {
    /// Array of disks associated with this instance that are protected with a customer-supplied encryption key. In order to start the instance, the disk url and its corresponding key must be provided. If the disk is not protected with a customer-supplied encryption key it should not be specified.
    #[prost(message, repeated, tag = "95594102")]
    pub disks: ::prost::alloc::vec::Vec<CustomerEncryptionKeyProtectedDisk>,
}
/// HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Int64RangeMatch {
    /// The end of the range (exclusive) in signed long integer format.
    #[prost(int64, optional, tag = "322439897")]
    pub range_end: ::core::option::Option<i64>,
    /// The start of the range (inclusive) in signed long integer format.
    #[prost(int64, optional, tag = "103333600")]
    pub range_start: ::core::option::Option<i64>,
}
/// Represents an Interconnect resource. An Interconnect resource is a dedicated connection between the GCP network and your on-premises network. For more information, read the Dedicated Interconnect Overview.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Interconnect {
    /// Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
    #[prost(bool, optional, tag = "445675089")]
    pub admin_enabled: ::core::option::Option<bool>,
    /// [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
    #[prost(message, repeated, tag = "164839855")]
    pub circuit_infos: ::prost::alloc::vec::Vec<InterconnectCircuitInfo>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
    #[prost(string, optional, tag = "3665484")]
    pub customer_name: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional description of this resource. Provide this property when you create the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A list of outages expected for this Interconnect.
    #[prost(message, repeated, tag = "264484123")]
    pub expected_outages: ::prost::alloc::vec::Vec<InterconnectOutageNotification>,
    /// [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
    #[prost(string, optional, tag = "443105954")]
    pub google_ip_address: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
    #[prost(string, optional, tag = "534944469")]
    pub google_reference_id: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
    #[prost(string, repeated, tag = "425388415")]
    pub interconnect_attachments: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
    /// Check the InterconnectType enum for the list of possible values.
    #[prost(string, optional, tag = "515165259")]
    pub interconnect_type: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Type of the resource. Always compute#interconnect for interconnects.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
    /// Check the LinkType enum for the list of possible values.
    #[prost(string, optional, tag = "523207775")]
    pub link_type: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the InterconnectLocation object that represents where this connection is to be provisioned.
    #[prost(string, optional, tag = "290430901")]
    pub location: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
    #[prost(string, optional, tag = "14072832")]
    pub noc_contact_email: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
    /// Check the OperationalStatus enum for the list of possible values.
    #[prost(string, optional, tag = "201070847")]
    pub operational_status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
    #[prost(string, optional, tag = "207735769")]
    pub peer_ip_address: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Number of links actually provisioned in this interconnect.
    #[prost(int32, optional, tag = "410888565")]
    pub provisioned_link_count: ::core::option::Option<i32>,
    /// Target number of physical links in the link bundle, as requested by the customer.
    #[prost(int32, optional, tag = "45051387")]
    pub requested_link_count: ::core::option::Option<i32>,
    /// [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
    #[prost(bool, optional, tag = "480964267")]
    pub satisfies_pzs: ::core::option::Option<bool>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `Interconnect`.
pub mod interconnect {
    /// Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum InterconnectType {
        /// A value indicating that the enum field is not set.
        UndefinedInterconnectType = 0,
        /// A dedicated physical interconnection with the customer.
        Dedicated = 258411983,
        /// \[Deprecated\] A private, physical interconnection with the customer.
        ItPrivate = 335677007,
        /// A partner-managed interconnection shared between customers via partner.
        Partner = 461924520,
    }
    /// Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum LinkType {
        /// A value indicating that the enum field is not set.
        UndefinedLinkType = 0,
        /// 100G Ethernet, LR Optics.
        Ethernet100gLr = 337672551,
        /// 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
        Ethernet10gLr = 236739749,
    }
    /// [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum OperationalStatus {
        /// A value indicating that the enum field is not set.
        UndefinedOperationalStatus = 0,
        /// The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
        OsActive = 55721409,
        /// The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
        OsUnprovisioned = 239771840,
    }
    /// [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        /// The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
        Active = 314733318,
        /// The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
        Unprovisioned = 517333979,
    }
}
/// Represents an Interconnect Attachment (VLAN) resource. You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read Creating VLAN Attachments.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectAttachment {
    /// Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
    #[prost(bool, optional, tag = "445675089")]
    pub admin_enabled: ::core::option::Option<bool>,
    /// Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
    /// Check the Bandwidth enum for the list of possible values.
    #[prost(string, optional, tag = "181715121")]
    pub bandwidth: ::core::option::Option<::prost::alloc::string::String>,
    /// Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
    #[prost(string, repeated, tag = "237842938")]
    pub candidate_subnets: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
    #[prost(string, optional, tag = "287392776")]
    pub cloud_router_ip_address: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
    #[prost(string, optional, tag = "332475761")]
    pub customer_router_ip_address: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Dataplane version for this InterconnectAttachment.
    #[prost(int32, optional, tag = "34920075")]
    pub dataplane_version: ::core::option::Option<i32>,
    /// An optional description of this resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
    /// Check the EdgeAvailabilityDomain enum for the list of possible values.
    #[prost(string, optional, tag = "71289510")]
    pub edge_availability_domain: ::core::option::Option<::prost::alloc::string::String>,
    /// Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *IPsec-encrypted Cloud Interconnect*, the VLAN attachment must be created with this option. Not currently available publicly.
    /// Check the Encryption enum for the list of possible values.
    #[prost(string, optional, tag = "97980291")]
    pub encryption: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. \[Deprecated\] This field is not used.
    #[prost(string, optional, tag = "534944469")]
    pub google_reference_id: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// URL of the underlying Interconnect object that this attachment's traffic will traverse through.
    #[prost(string, optional, tag = "224601230")]
    pub interconnect: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool. Not currently available publicly.
    #[prost(string, repeated, tag = "407648565")]
    pub ipsec_internal_addresses: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
    #[prost(int32, optional, tag = "108462")]
    pub mtu: ::core::option::Option<i32>,
    /// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `\[a-z]([-a-z0-9]*[a-z0-9\])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
    /// Check the OperationalStatus enum for the list of possible values.
    #[prost(string, optional, tag = "201070847")]
    pub operational_status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
    #[prost(string, optional, tag = "439695464")]
    pub pairing_key: ::core::option::Option<::prost::alloc::string::String>,
    /// Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
    #[prost(int64, optional, tag = "438166149")]
    pub partner_asn: ::core::option::Option<i64>,
    /// Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
    #[prost(message, optional, tag = "65908934")]
    pub partner_metadata: ::core::option::Option<InterconnectAttachmentPartnerMetadata>,
    /// [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
    #[prost(message, optional, tag = "237270531")]
    pub private_interconnect_info: ::core::option::Option<InterconnectAttachmentPrivateInfo>,
    /// [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
    #[prost(string, optional, tag = "148608841")]
    pub router: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
    #[prost(bool, optional, tag = "480964267")]
    pub satisfies_pzs: ::core::option::Option<bool>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
    /// The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
    /// Check the Type enum for the list of possible values.
    #[prost(string, optional, tag = "3575610")]
    pub r#type: ::core::option::Option<::prost::alloc::string::String>,
    /// The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
    #[prost(int32, optional, tag = "119927836")]
    pub vlan_tag8021q: ::core::option::Option<i32>,
}
/// Nested message and enum types in `InterconnectAttachment`.
pub mod interconnect_attachment {
    /// Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Bandwidth {
        /// A value indicating that the enum field is not set.
        UndefinedBandwidth = 0,
        /// 100 Mbit/s
        Bps100m = 49547958,
        /// 10 Gbit/s
        Bps10g = 278693006,
        /// 1 Gbit/s
        Bps1g = 355358448,
        /// 200 Mbit/s
        Bps200m = 49577749,
        /// 20 Gbit/s
        Bps20g = 278693967,
        /// 2 Gbit/s
        Bps2g = 355358479,
        /// 300 Mbit/s
        Bps300m = 49607540,
        /// 400 Mbit/s
        Bps400m = 49637331,
        /// 500 Mbit/s
        Bps500m = 49667122,
        /// 50 Gbit/s
        Bps50g = 278696850,
        /// 50 Mbit/s
        Bps50m = 278696856,
        /// 5 Gbit/s
        Bps5g = 355358572,
    }
    /// Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum EdgeAvailabilityDomain {
        /// A value indicating that the enum field is not set.
        UndefinedEdgeAvailabilityDomain = 0,
        AvailabilityDomain1 = 349552090,
        AvailabilityDomain2 = 349552091,
        AvailabilityDomainAny = 375256373,
    }
    /// Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *IPsec-encrypted Cloud Interconnect*, the VLAN attachment must be created with this option. Not currently available publicly.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Encryption {
        /// A value indicating that the enum field is not set.
        UndefinedEncryption = 0,
        /// The interconnect attachment will carry only encrypted traffic that is encrypted by an IPsec device such as HA VPN gateway; VMs cannot directly send traffic to or receive traffic from such an interconnect attachment. To use IPsec-encrypted Cloud Interconnect, the interconnect attachment must be created with this option.
        Ipsec = 69882282,
        /// This is the default value, which means the Interconnect Attachment will carry unencrypted traffic. VMs will be able to send traffic to or receive traffic from such interconnect attachment.
        None = 2402104,
    }
    /// [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum OperationalStatus {
        /// A value indicating that the enum field is not set.
        UndefinedOperationalStatus = 0,
        /// Indicates that attachment has been turned up and is ready to use.
        OsActive = 55721409,
        /// Indicates that attachment is not ready to use yet, because turnup is not complete.
        OsUnprovisioned = 239771840,
    }
    /// [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        /// Indicates that attachment has been turned up and is ready to use.
        Active = 314733318,
        /// The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was wiped out, or because the other side of a Partner attachment was deleted.
        Defunct = 115891759,
        /// A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
        PartnerRequestReceived = 513587304,
        /// PARTNER or PARTNER_PROVIDER attachment that is waiting for the customer to activate.
        PendingCustomer = 167494054,
        /// A newly created PARTNER attachment that has not yet been configured on the Partner side.
        PendingPartner = 387890656,
        Unspecified = 470755401,
        /// Indicates that attachment is not ready to use yet, because turnup is not complete.
        Unprovisioned = 517333979,
    }
    /// The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// A value indicating that the enum field is not set.
        UndefinedType = 0,
        /// Attachment to a dedicated interconnect.
        Dedicated = 258411983,
        /// Attachment to a partner interconnect, created by the customer.
        Partner = 461924520,
        /// Attachment to a partner interconnect, created by the partner.
        PartnerProvider = 483261352,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectAttachmentAggregatedList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InterconnectAttachmentsScopedList resources.
    #[prost(btree_map = "string, message", tag = "100526016")]
    pub items: ::prost::alloc::collections::BTreeMap<
        ::prost::alloc::string::String,
        InterconnectAttachmentsScopedList,
    >,
    /// [Output Only] Type of resource. Always compute#interconnectAttachmentAggregatedList for aggregated lists of interconnect attachments.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Unreachable resources.
    #[prost(string, repeated, tag = "243372063")]
    pub unreachables: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Response to the list request, and contains a list of interconnect attachments.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectAttachmentList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InterconnectAttachment resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InterconnectAttachment>,
    /// [Output Only] Type of resource. Always compute#interconnectAttachmentList for lists of interconnect attachments.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectAttachmentPartnerMetadata {
    /// Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
    #[prost(string, optional, tag = "514963356")]
    pub interconnect_name: ::core::option::Option<::prost::alloc::string::String>,
    /// Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
    #[prost(string, optional, tag = "161747874")]
    pub partner_name: ::core::option::Option<::prost::alloc::string::String>,
    /// URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
    #[prost(string, optional, tag = "269182748")]
    pub portal_url: ::core::option::Option<::prost::alloc::string::String>,
}
/// Information for an interconnect attachment when this belongs to an interconnect of type DEDICATED.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectAttachmentPrivateInfo {
    /// [Output Only] 802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.
    #[prost(uint32, optional, tag = "271820992")]
    pub tag8021q: ::core::option::Option<u32>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectAttachmentsScopedList {
    /// A list of interconnect attachments contained in this scope.
    #[prost(message, repeated, tag = "425388415")]
    pub interconnect_attachments: ::prost::alloc::vec::Vec<InterconnectAttachment>,
    /// Informational warning which replaces the list of addresses when the list is empty.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Describes a single physical circuit between the Customer and Google. CircuitInfo objects are created by Google, so all fields are output only.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectCircuitInfo {
    /// Customer-side demarc ID for this circuit.
    #[prost(string, optional, tag = "28771859")]
    pub customer_demarc_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
    #[prost(string, optional, tag = "262014711")]
    pub google_circuit_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.
    #[prost(string, optional, tag = "448196270")]
    pub google_demarc_id: ::core::option::Option<::prost::alloc::string::String>,
}
/// Diagnostics information about interconnect, contains detailed and current technical information about Google's side of the connection.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectDiagnostics {
    /// A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
    #[prost(message, repeated, tag = "414591761")]
    pub arp_caches: ::prost::alloc::vec::Vec<InterconnectDiagnosticsArpEntry>,
    /// A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
    #[prost(message, repeated, tag = "102977465")]
    pub links: ::prost::alloc::vec::Vec<InterconnectDiagnosticsLinkStatus>,
    /// The MAC address of the Interconnect's bundle interface.
    #[prost(string, optional, tag = "332540164")]
    pub mac_address: ::core::option::Option<::prost::alloc::string::String>,
}
/// Describing the ARP neighbor entries seen on this link
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectDiagnosticsArpEntry {
    /// The IP address of this ARP neighbor.
    #[prost(string, optional, tag = "406272220")]
    pub ip_address: ::core::option::Option<::prost::alloc::string::String>,
    /// The MAC address of this ARP neighbor.
    #[prost(string, optional, tag = "332540164")]
    pub mac_address: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectDiagnosticsLinkLacpStatus {
    /// System ID of the port on Google's side of the LACP exchange.
    #[prost(string, optional, tag = "91210405")]
    pub google_system_id: ::core::option::Option<::prost::alloc::string::String>,
    /// System ID of the port on the neighbor's side of the LACP exchange.
    #[prost(string, optional, tag = "343821342")]
    pub neighbor_system_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The state of a LACP link, which can take one of the following values: - ACTIVE: The link is configured and active within the bundle. - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `InterconnectDiagnosticsLinkLACPStatus`.
pub mod interconnect_diagnostics_link_lacp_status {
    /// The state of a LACP link, which can take one of the following values: - ACTIVE: The link is configured and active within the bundle. - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        /// The link is configured and active within the bundle.
        Active = 314733318,
        /// The link is not configured within the bundle, this means the rest of the object should be empty.
        Detached = 216562546,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectDiagnosticsLinkOpticalPower {
    /// The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning threshold. - LOW_WARNING: The value has crossed below the low warning threshold. - HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high alarm threshold.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
    /// Value of the current receiving or transmitting optical power, read in dBm. Take a known good optical value, give it a 10% margin and trigger warnings relative to that value. In general, a -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
    #[prost(float, optional, tag = "111972721")]
    pub value: ::core::option::Option<f32>,
}
/// Nested message and enum types in `InterconnectDiagnosticsLinkOpticalPower`.
pub mod interconnect_diagnostics_link_optical_power {
    /// The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning threshold. - LOW_WARNING: The value has crossed below the low warning threshold. - HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high alarm threshold.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        /// The value has crossed above the high alarm threshold.
        HighAlarm = 305363284,
        /// The value of the current optical power has crossed above the high warning threshold.
        HighWarning = 220984799,
        /// The value of the current optical power has crossed below the low alarm threshold.
        LowAlarm = 316659046,
        /// The value of the current optical power has crossed below the low warning threshold.
        LowWarning = 338793841,
        /// The value of the current optical power has not crossed a warning threshold.
        Ok = 2524,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectDiagnosticsLinkStatus {
    /// A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
    #[prost(message, repeated, tag = "414591761")]
    pub arp_caches: ::prost::alloc::vec::Vec<InterconnectDiagnosticsArpEntry>,
    /// The unique ID for this link assigned during turn up by Google.
    #[prost(string, optional, tag = "225180977")]
    pub circuit_id: ::core::option::Option<::prost::alloc::string::String>,
    /// The Demarc address assigned by Google and provided in the LoA.
    #[prost(string, optional, tag = "51084")]
    pub google_demarc: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "361210415")]
    pub lacp_status: ::core::option::Option<InterconnectDiagnosticsLinkLacpStatus>,
    /// An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
    #[prost(message, optional, tag = "244717279")]
    pub receiving_optical_power: ::core::option::Option<InterconnectDiagnosticsLinkOpticalPower>,
    /// An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
    #[prost(message, optional, tag = "459431197")]
    pub transmitting_optical_power: ::core::option::Option<InterconnectDiagnosticsLinkOpticalPower>,
}
/// Response to the list request, and contains a list of interconnects.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of Interconnect resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<Interconnect>,
    /// [Output Only] Type of resource. Always compute#interconnectList for lists of interconnects.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Represents an Interconnect Attachment (VLAN) Location resource. You can use this resource to find location details about an Interconnect attachment (VLAN). For more information about interconnect attachments, read Creating VLAN Attachments.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectLocation {
    /// [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
    #[prost(string, optional, tag = "462920692")]
    pub address: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
    #[prost(string, optional, tag = "158459920")]
    pub availability_zone: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
    #[prost(string, optional, tag = "3053931")]
    pub city: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
    /// Check the Continent enum for the list of possible values.
    #[prost(string, optional, tag = "133442996")]
    pub continent: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] An optional description of the resource.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The name of the provider for this facility (e.g., EQUINIX).
    #[prost(string, optional, tag = "533303309")]
    pub facility_provider: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
    #[prost(string, optional, tag = "87269125")]
    pub facility_provider_facility_id: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Name of the resource.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
    #[prost(string, optional, tag = "536567094")]
    pub peeringdb_facility_id: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
    #[prost(message, repeated, tag = "312194170")]
    pub region_infos: ::prost::alloc::vec::Vec<InterconnectLocationRegionInfo>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
    /// Check the Status enum for the list of possible values.
    #[prost(string, optional, tag = "181260274")]
    pub status: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Set to true for locations that support physical zone separation. Defaults to false if the field is not present.
    #[prost(bool, optional, tag = "83983214")]
    pub supports_pzs: ::core::option::Option<bool>,
}
/// Nested message and enum types in `InterconnectLocation`.
pub mod interconnect_location {
    /// [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Continent {
        /// A value indicating that the enum field is not set.
        UndefinedContinent = 0,
        Africa = 317443706,
        AsiaPac = 119782269,
        CAfrica = 71993846,
        CAsiaPac = 465668089,
        CEurope = 200369438,
        CNorthAmerica = 275697048,
        CSouthAmerica = 397149792,
        Europe = 445819298,
        NorthAmerica = 448015508,
        SouthAmerica = 32597340,
    }
    /// [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Status {
        /// A value indicating that the enum field is not set.
        UndefinedStatus = 0,
        /// The InterconnectLocation is available for provisioning new Interconnects.
        Available = 442079913,
        /// The InterconnectLocation is closed for provisioning new Interconnects.
        Closed = 380163436,
    }
}
/// Response to the list request, and contains a list of interconnect locations.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectLocationList {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of InterconnectLocation resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<InterconnectLocation>,
    /// [Output Only] Type of resource. Always compute#interconnectLocationList for lists of interconnect locations.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// Information about any potential InterconnectAttachments between an Interconnect at a specific InterconnectLocation, and a specific Cloud Region.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectLocationRegionInfo {
    /// Expected round-trip time in milliseconds, from this InterconnectLocation to a VM in this region.
    #[prost(int64, optional, tag = "422543866")]
    pub expected_rtt_ms: ::core::option::Option<i64>,
    /// Identifies the network presence of this location.
    /// Check the LocationPresence enum for the list of possible values.
    #[prost(string, optional, tag = "101517893")]
    pub location_presence: ::core::option::Option<::prost::alloc::string::String>,
    /// URL for the region of this location.
    #[prost(string, optional, tag = "138946292")]
    pub region: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `InterconnectLocationRegionInfo`.
pub mod interconnect_location_region_info {
    /// Identifies the network presence of this location.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum LocationPresence {
        /// A value indicating that the enum field is not set.
        UndefinedLocationPresence = 0,
        /// This region is not in any common network presence with this InterconnectLocation.
        Global = 494663587,
        /// This region shares the same regional network presence as this InterconnectLocation.
        LocalRegion = 403535464,
        /// \[Deprecated\] This region is not in any common network presence with this InterconnectLocation.
        LpGlobal = 429584062,
        /// \[Deprecated\] This region shares the same regional network presence as this InterconnectLocation.
        LpLocalRegion = 488598851,
    }
}
/// Description of a planned outage on this Interconnect.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectOutageNotification {
    /// If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
    #[prost(string, repeated, tag = "177717013")]
    pub affected_circuits: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// A description about the purpose of the outage.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// Scheduled end time for the outage (milliseconds since Unix epoch).
    #[prost(int64, optional, tag = "114938801")]
    pub end_time: ::core::option::Option<i64>,
    /// Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
    /// Check the IssueType enum for the list of possible values.
    #[prost(string, optional, tag = "369639136")]
    pub issue_type: ::core::option::Option<::prost::alloc::string::String>,
    /// Unique identifier for this outage notification.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
    /// Check the Source enum for the list of possible values.
    #[prost(string, optional, tag = "177235995")]
    pub source: ::core::option::Option<::prost::alloc::string::String>,
    /// Scheduled start time for the outage (milliseconds since Unix epoch).
    #[prost(int64, optional, tag = "37467274")]
    pub start_time: ::core::option::Option<i64>,
    /// State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `InterconnectOutageNotification`.
pub mod interconnect_outage_notification {
    /// Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum IssueType {
        /// A value indicating that the enum field is not set.
        UndefinedIssueType = 0,
        /// \[Deprecated\] The Interconnect may be completely out of service for some or all of the specified window.
        ItOutage = 175779973,
        /// \[Deprecated\] Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
        ItPartialOutage = 92103971,
        /// The Interconnect may be completely out of service for some or all of the specified window.
        Outage = 195285745,
        /// Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
        PartialOutage = 147053455,
    }
    /// The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Source {
        /// A value indicating that the enum field is not set.
        UndefinedSource = 0,
        /// This notification was generated by Google.
        Google = 497439289,
        /// \[Deprecated\] This notification was generated by Google.
        NsrcGoogle = 510574562,
    }
    /// State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        /// This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
        Active = 314733318,
        /// The outage associated with this notification was cancelled before the outage was due to start.
        Cancelled = 41957681,
        /// The outage associated with this notification is complete.
        Completed = 309921323,
        /// \[Deprecated\] This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
        NsActive = 252563136,
        /// \[Deprecated\] The outage associated with this notification was canceled before the outage was due to start.
        NsCanceled = 506579411,
    }
}
/// Response for the InterconnectsGetDiagnosticsRequest.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterconnectsGetDiagnosticsResponse {
    #[prost(message, optional, tag = "139315229")]
    pub result: ::core::option::Option<InterconnectDiagnostics>,
}
/// A request message for UrlMaps.InvalidateCache. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InvalidateCacheUrlMapRequest {
    /// The body resource for this request
    #[prost(message, optional, tag = "312795565")]
    pub cache_invalidation_rule_resource: ::core::option::Option<CacheInvalidationRule>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
    #[prost(string, optional, tag = "37109963")]
    pub request_id: ::core::option::Option<::prost::alloc::string::String>,
    /// Name of the UrlMap scoping this request.
    #[prost(string, tag = "367020684")]
    pub url_map: ::prost::alloc::string::String,
}
/// Metadata
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Items {
    /// Key for the metadata entry. Keys must conform to the following regexp: \[a-zA-Z0-9-_\]+, and be less than 128 bytes in length. This is reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project.
    #[prost(string, optional, tag = "106079")]
    pub key: ::core::option::Option<::prost::alloc::string::String>,
    /// Value for the metadata entry. These are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on values is that their size must be less than or equal to 262144 bytes (256 KiB).
    #[prost(string, optional, tag = "111972721")]
    pub value: ::core::option::Option<::prost::alloc::string::String>,
}
/// Represents a License resource. A License represents billing and aggregate usage data for public and marketplace images. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct License {
    /// [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
    #[prost(bool, optional, tag = "372412622")]
    pub charges_use_fee: ::core::option::Option<bool>,
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// An optional textual description of the resource; provided by the client when the resource is created.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of resource. Always compute#license for licenses.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique code used to attach this license to images, snapshots, and disks.
    #[prost(uint64, optional, tag = "1467179")]
    pub license_code: ::core::option::Option<u64>,
    /// Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "214292769")]
    pub resource_requirements: ::core::option::Option<LicenseResourceRequirements>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
    #[prost(bool, optional, tag = "4349893")]
    pub transferable: ::core::option::Option<bool>,
}
/// Represents a License Code resource. A License Code is a unique identifier used to represent a license resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LicenseCode {
    /// [Output Only] Creation timestamp in RFC3339 text format.
    #[prost(string, optional, tag = "30525366")]
    pub creation_timestamp: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Description of this License Code.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
    #[prost(uint64, optional, tag = "3355")]
    pub id: ::core::option::Option<u64>,
    /// [Output Only] Type of resource. Always compute#licenseCode for licenses.
    #[prost(string, optional, tag = "3292052")]
    pub kind: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL and description aliases of Licenses with the same License Code.
    #[prost(message, repeated, tag = "43550930")]
    pub license_alias: ::prost::alloc::vec::Vec<LicenseCodeLicenseAlias>,
    /// [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit integer.
    #[prost(string, optional, tag = "3373707")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for the resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Current state of this License Code.
    /// Check the State enum for the list of possible values.
    #[prost(string, optional, tag = "109757585")]
    pub state: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] If true, the license will remain attached when creating images or snapshots from disks. Otherwise, the license is not transferred.
    #[prost(bool, optional, tag = "4349893")]
    pub transferable: ::core::option::Option<bool>,
}
/// Nested message and enum types in `LicenseCode`.
pub mod license_code {
    /// [Output Only] Current state of this License Code.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum State {
        /// A value indicating that the enum field is not set.
        UndefinedState = 0,
        /// Machines are not allowed to attach boot disks with this License Code. Requests to create new resources with this license will be rejected.
        Disabled = 516696700,
        /// Use is allowed for anyone with USE_READ_ONLY access to this License Code.
        Enabled = 182130465,
        /// Use of this license is limited to a project whitelist.
        Restricted = 261551195,
        Unspecified = 470755401,
        /// Reserved state.
        Terminated = 250018339,
    }
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LicenseCodeLicenseAlias {
    /// [Output Only] Description of this License Code.
    #[prost(string, optional, tag = "422937596")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] URL of license corresponding to this License Code.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
}
/// Commitment for a particular license resource.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LicenseResourceCommitment {
    /// The number of licenses purchased.
    #[prost(int64, optional, tag = "196759640")]
    pub amount: ::core::option::Option<i64>,
    /// Specifies the core range of the instance for which this license applies.
    #[prost(string, optional, tag = "32482324")]
    pub cores_per_license: ::core::option::Option<::prost::alloc::string::String>,
    /// Any applicable license URI.
    #[prost(string, optional, tag = "166757441")]
    pub license: ::core::option::Option<::prost::alloc::string::String>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LicenseResourceRequirements {
    /// Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
    #[prost(int32, optional, tag = "477964836")]
    pub min_guest_cpu_count: ::core::option::Option<i32>,
    /// Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
    #[prost(int32, optional, tag = "504785894")]
    pub min_memory_mb: ::core::option::Option<i32>,
}
///
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LicensesListResponse {
    /// [Output Only] Unique identifier for the resource; defined by the server.
    #[prost(string, optional, tag = "3355")]
    pub id: ::core::option::Option<::prost::alloc::string::String>,
    /// A list of License resources.
    #[prost(message, repeated, tag = "100526016")]
    pub items: ::prost::alloc::vec::Vec<License>,
    /// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
    #[prost(string, optional, tag = "79797525")]
    pub next_page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Server-defined URL for this resource.
    #[prost(string, optional, tag = "456214797")]
    pub self_link: ::core::option::Option<::prost::alloc::string::String>,
    /// [Output Only] Informational warning message.
    #[prost(message, optional, tag = "50704284")]
    pub warning: ::core::option::Option<Warning>,
}
/// A request message for AcceleratorTypes.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListAcceleratorTypesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Addresses.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListAddressesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Name of the region for this request.
    #[prost(string, tag = "138946292")]
    pub region: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for FirewallPolicies.ListAssociations. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListAssociationsFirewallPolicyRequest {
    /// The target resource to list associations. It is an organization, or a folder.
    #[prost(string, optional, tag = "467318524")]
    pub target_resource: ::core::option::Option<::prost::alloc::string::String>,
}
/// A request message for Autoscalers.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListAutoscalersRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
    /// Name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for SslPolicies.ListAvailableFeatures. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListAvailableFeaturesSslPoliciesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for BackendBuckets.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListBackendBucketsRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for BackendServices.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListBackendServicesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
}
/// A request message for DiskTypes.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListDiskTypesRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for Disks.List. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListDisksRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
    #[prost(uint32, optional, tag = "54715419")]
    pub max_results: ::core::option::Option<u32>,
    /// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
    #[prost(string, optional, tag = "160562920")]
    pub order_by: ::core::option::Option<::prost::alloc::string::String>,
    /// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
    #[prost(string, optional, tag = "19994697")]
    pub page_token: ::core::option::Option<::prost::alloc::string::String>,
    /// Project ID for this request.
    #[prost(string, tag = "227560217")]
    pub project: ::prost::alloc::string::String,
    /// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
    #[prost(bool, optional, tag = "517198390")]
    pub return_partial_success: ::core::option::Option<bool>,
    /// The name of the zone for this request.
    #[prost(string, tag = "3744684")]
    pub zone: ::prost::alloc::string::String,
}
/// A request message for InstanceGroupManagers.ListErrors. See the method description for details.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListErrorsInstanceGroupManagersRequest {
    /// A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `>`, or `<`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
    #[prost(string, optional, tag = "336120696")]
    pub filter: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the managed instance group. It must be a string that meets the requirements in RFC1035, or an unsigned long integer: must match regexp pattern: (?:\[a-z](?:[-a-z0-9]{0,61}[a-z0-9\])?)|1-9{0,19}.
    #[prost(string, tag = "249363395")]
    pub instance_group_manager: ::prost::alloc::string::String,
    /// The ma