/// A CrawledUrl resource represents a URL that was crawled during a ScanRun. Web
/// Security Scanner Service crawls the web applications, following all links
/// within the scope of sites, to find the URLs to test against.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CrawledUrl {
    /// Output only. The http method of the request that was used to visit the URL, in
    /// uppercase.
    #[prost(string, tag = "1")]
    pub http_method: ::prost::alloc::string::String,
    /// Output only. The URL that was crawled.
    #[prost(string, tag = "2")]
    pub url: ::prost::alloc::string::String,
    /// Output only. The body of the request that was used to visit the URL.
    #[prost(string, tag = "3")]
    pub body: ::prost::alloc::string::String,
}
/// Information reported for an outdated library.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OutdatedLibrary {
    /// The name of the outdated library.
    #[prost(string, tag = "1")]
    pub library_name: ::prost::alloc::string::String,
    /// The version number.
    #[prost(string, tag = "2")]
    pub version: ::prost::alloc::string::String,
    /// URLs to learn more information about the vulnerabilities in the library.
    #[prost(string, repeated, tag = "3")]
    pub learn_more_urls: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Information regarding any resource causing the vulnerability such
/// as JavaScript sources, image, audio files, etc.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViolatingResource {
    /// The MIME type of this resource.
    #[prost(string, tag = "1")]
    pub content_type: ::prost::alloc::string::String,
    /// URL of this violating resource.
    #[prost(string, tag = "2")]
    pub resource_url: ::prost::alloc::string::String,
}
/// Information about vulnerable request parameters.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VulnerableParameters {
    /// The vulnerable parameter names.
    #[prost(string, repeated, tag = "1")]
    pub parameter_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Information about vulnerable or missing HTTP Headers.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VulnerableHeaders {
    /// List of vulnerable headers.
    #[prost(message, repeated, tag = "1")]
    pub headers: ::prost::alloc::vec::Vec<vulnerable_headers::Header>,
    /// List of missing headers.
    #[prost(message, repeated, tag = "2")]
    pub missing_headers: ::prost::alloc::vec::Vec<vulnerable_headers::Header>,
}
/// Nested message and enum types in `VulnerableHeaders`.
pub mod vulnerable_headers {
    /// Describes a HTTP Header.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Header {
        /// Header name.
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        /// Header value.
        #[prost(string, tag = "2")]
        pub value: ::prost::alloc::string::String,
    }
}
/// Information reported for an XSS.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Xss {
    /// Stack traces leading to the point where the XSS occurred.
    #[prost(string, repeated, tag = "1")]
    pub stack_traces: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// An error message generated by a javascript breakage.
    #[prost(string, tag = "2")]
    pub error_message: ::prost::alloc::string::String,
}
/// A Finding resource represents a vulnerability instance identified during a
/// ScanRun.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Finding {
    /// The resource name of the Finding. The name follows the format of
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
    /// The finding IDs are generated by the system.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// The type of the Finding.
    #[prost(enumeration = "finding::FindingType", tag = "2")]
    pub finding_type: i32,
    /// The http method of the request that triggered the vulnerability, in
    /// uppercase.
    #[prost(string, tag = "3")]
    pub http_method: ::prost::alloc::string::String,
    /// The URL produced by the server-side fuzzer and used in the request that
    /// triggered the vulnerability.
    #[prost(string, tag = "4")]
    pub fuzzed_url: ::prost::alloc::string::String,
    /// The body of the request that triggered the vulnerability.
    #[prost(string, tag = "5")]
    pub body: ::prost::alloc::string::String,
    /// The description of the vulnerability.
    #[prost(string, tag = "6")]
    pub description: ::prost::alloc::string::String,
    /// The URL containing human-readable payload that user can leverage to
    /// reproduce the vulnerability.
    #[prost(string, tag = "7")]
    pub reproduction_url: ::prost::alloc::string::String,
    /// If the vulnerability was originated from nested IFrame, the immediate
    /// parent IFrame is reported.
    #[prost(string, tag = "8")]
    pub frame_url: ::prost::alloc::string::String,
    /// The URL where the browser lands when the vulnerability is detected.
    #[prost(string, tag = "9")]
    pub final_url: ::prost::alloc::string::String,
    /// The tracking ID uniquely identifies a vulnerability instance across
    /// multiple ScanRuns.
    #[prost(string, tag = "10")]
    pub tracking_id: ::prost::alloc::string::String,
    /// An addon containing information about outdated libraries.
    #[prost(message, optional, tag = "11")]
    pub outdated_library: ::core::option::Option<OutdatedLibrary>,
    /// An addon containing detailed information regarding any resource causing the
    /// vulnerability such as JavaScript sources, image, audio files, etc.
    #[prost(message, optional, tag = "12")]
    pub violating_resource: ::core::option::Option<ViolatingResource>,
    /// An addon containing information about vulnerable or missing HTTP headers.
    #[prost(message, optional, tag = "15")]
    pub vulnerable_headers: ::core::option::Option<VulnerableHeaders>,
    /// An addon containing information about request parameters which were found
    /// to be vulnerable.
    #[prost(message, optional, tag = "13")]
    pub vulnerable_parameters: ::core::option::Option<VulnerableParameters>,
    /// An addon containing information reported for an XSS, if any.
    #[prost(message, optional, tag = "14")]
    pub xss: ::core::option::Option<Xss>,
}
/// Nested message and enum types in `Finding`.
pub mod finding {
    /// Types of Findings.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum FindingType {
        /// The invalid finding type.
        Unspecified = 0,
        /// A page that was served over HTTPS also resources over HTTP. A
        /// man-in-the-middle attacker could tamper with the HTTP resource and gain
        /// full access to the website that loads the resource or to monitor the
        /// actions taken by the user.
        MixedContent = 1,
        /// The version of an included library is known to contain a security issue.
        /// The scanner checks the version of library in use against a known list of
        /// vulnerable libraries. False positives are possible if the version
        /// detection fails or if the library has been manually patched.
        OutdatedLibrary = 2,
        /// This type of vulnerability occurs when the value of a request parameter
        /// is reflected at the beginning of the response, for example, in requests
        /// using JSONP. Under certain circumstances, an attacker may be able to
        /// supply an alphanumeric-only Flash file in the vulnerable parameter
        /// causing the browser to execute the Flash file as if it originated on the
        /// vulnerable server.
        RosettaFlash = 5,
        /// A cross-site scripting (XSS) bug is found via JavaScript callback. For
        /// detailed explanations on XSS, see
        /// <https://www.google.com/about/appsecurity/learning/xss/.>
        XssCallback = 3,
        /// A potential cross-site scripting (XSS) bug due to JavaScript breakage.
        /// In some circumstances, the application under test might modify the test
        /// string before it is parsed by the browser. When the browser attempts to
        /// runs this modified test string, it will likely break and throw a
        /// JavaScript execution error, thus an injection issue is occurring.
        /// However, it may not be exploitable. Manual verification is needed to see
        /// if the test string modifications can be evaded and confirm that the issue
        /// is in fact an XSS vulnerability. For detailed explanations on XSS, see
        /// <https://www.google.com/about/appsecurity/learning/xss/.>
        XssError = 4,
        /// An application appears to be transmitting a password field in clear text.
        /// An attacker can eavesdrop network traffic and sniff the password field.
        ClearTextPassword = 6,
        /// An application returns sensitive content with an invalid content type,
        /// or without an 'X-Content-Type-Options: nosniff' header.
        InvalidContentType = 7,
        /// A cross-site scripting (XSS) vulnerability in AngularJS module that
        /// occurs when a user-provided string is interpolated by Angular.
        XssAngularCallback = 8,
        /// A malformed or invalid valued header.
        InvalidHeader = 9,
        /// Misspelled security header name.
        MisspelledSecurityHeaderName = 10,
        /// Mismatching values in a duplicate security header.
        MismatchingSecurityHeaderValues = 11,
    }
}
/// A FindingTypeStats resource represents stats regarding a specific FindingType
/// of Findings under a given ScanRun.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FindingTypeStats {
    /// The finding type associated with the stats.
    #[prost(enumeration = "finding::FindingType", tag = "1")]
    pub finding_type: i32,
    /// The count of findings belonging to this finding type.
    #[prost(int32, tag = "2")]
    pub finding_count: i32,
}
/// A ScanRun is a output-only resource representing an actual run of the scan.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScanRun {
    /// The resource name of the ScanRun. The name follows the format of
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
    /// The ScanRun IDs are generated by the system.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// The execution state of the ScanRun.
    #[prost(enumeration = "scan_run::ExecutionState", tag = "2")]
    pub execution_state: i32,
    /// The result state of the ScanRun. This field is only available after the
    /// execution state reaches "FINISHED".
    #[prost(enumeration = "scan_run::ResultState", tag = "3")]
    pub result_state: i32,
    /// The time at which the ScanRun started.
    #[prost(message, optional, tag = "4")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    /// The time at which the ScanRun reached termination state - that the ScanRun
    /// is either finished or stopped by user.
    #[prost(message, optional, tag = "5")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
    /// The number of URLs crawled during this ScanRun. If the scan is in progress,
    /// the value represents the number of URLs crawled up to now.
    #[prost(int64, tag = "6")]
    pub urls_crawled_count: i64,
    /// The number of URLs tested during this ScanRun. If the scan is in progress,
    /// the value represents the number of URLs tested up to now. The number of
    /// URLs tested is usually larger than the number URLS crawled because
    /// typically a crawled URL is tested with multiple test payloads.
    #[prost(int64, tag = "7")]
    pub urls_tested_count: i64,
    /// Whether the scan run has found any vulnerabilities.
    #[prost(bool, tag = "8")]
    pub has_vulnerabilities: bool,
    /// The percentage of total completion ranging from 0 to 100.
    /// If the scan is in queue, the value is 0.
    /// If the scan is running, the value ranges from 0 to 100.
    /// If the scan is finished, the value is 100.
    #[prost(int32, tag = "9")]
    pub progress_percent: i32,
}
/// Nested message and enum types in `ScanRun`.
pub mod scan_run {
    /// Types of ScanRun execution state.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ExecutionState {
        /// Represents an invalid state caused by internal server error. This value
        /// should never be returned.
        Unspecified = 0,
        /// The scan is waiting in the queue.
        Queued = 1,
        /// The scan is in progress.
        Scanning = 2,
        /// The scan is either finished or stopped by user.
        Finished = 3,
    }
    /// Types of ScanRun result state.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ResultState {
        /// Default value. This value is returned when the ScanRun is not yet
        /// finished.
        Unspecified = 0,
        /// The scan finished without errors.
        Success = 1,
        /// The scan finished with errors.
        Error = 2,
        /// The scan was terminated by user.
        Killed = 3,
    }
}
/// A ScanConfig resource contains the configurations to launch a scan.
/// next id: 12
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScanConfig {
    /// The resource name of the ScanConfig. The name follows the format of
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
    /// generated by the system.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// Required. The user provided display name of the ScanConfig.
    #[prost(string, tag = "2")]
    pub display_name: ::prost::alloc::string::String,
    /// The maximum QPS during scanning. A valid value ranges from 5 to 20
    /// inclusively. If the field is unspecified or its value is set 0, server will
    /// default to 15. Other values outside of [5, 20] range will be rejected with
    /// INVALID_ARGUMENT error.
    #[prost(int32, tag = "3")]
    pub max_qps: i32,
    /// Required. The starting URLs from which the scanner finds site pages.
    #[prost(string, repeated, tag = "4")]
    pub starting_urls: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The authentication configuration. If specified, service will use the
    /// authentication configuration during scanning.
    #[prost(message, optional, tag = "5")]
    pub authentication: ::core::option::Option<scan_config::Authentication>,
    /// The user agent used during scanning.
    #[prost(enumeration = "scan_config::UserAgent", tag = "6")]
    pub user_agent: i32,
    /// The blacklist URL patterns as described in
    /// <https://cloud.google.com/security-scanner/docs/excluded-urls>
    #[prost(string, repeated, tag = "7")]
    pub blacklist_patterns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The schedule of the ScanConfig.
    #[prost(message, optional, tag = "8")]
    pub schedule: ::core::option::Option<scan_config::Schedule>,
    /// Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
    /// used as a default.
    #[prost(enumeration = "scan_config::TargetPlatform", repeated, tag = "9")]
    pub target_platforms: ::prost::alloc::vec::Vec<i32>,
    /// Latest ScanRun if available.
    #[prost(message, optional, tag = "11")]
    pub latest_run: ::core::option::Option<ScanRun>,
}
/// Nested message and enum types in `ScanConfig`.
pub mod scan_config {
    /// Scan authentication configuration.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Authentication {
        /// Required.
        /// Authentication configuration
        #[prost(oneof = "authentication::Authentication", tags = "1, 2")]
        pub authentication: ::core::option::Option<authentication::Authentication>,
    }
    /// Nested message and enum types in `Authentication`.
    pub mod authentication {
        /// Describes authentication configuration that uses a Google account.
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct GoogleAccount {
            /// Required. The user name of the Google account.
            #[prost(string, tag = "1")]
            pub username: ::prost::alloc::string::String,
            /// Required. Input only. The password of the Google account. The credential is stored encrypted
            /// and not returned in any response nor included in audit logs.
            #[prost(string, tag = "2")]
            pub password: ::prost::alloc::string::String,
        }
        /// Describes authentication configuration that uses a custom account.
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct CustomAccount {
            /// Required. The user name of the custom account.
            #[prost(string, tag = "1")]
            pub username: ::prost::alloc::string::String,
            /// Required. Input only. The password of the custom account. The credential is stored encrypted
            /// and not returned in any response nor included in audit logs.
            #[prost(string, tag = "2")]
            pub password: ::prost::alloc::string::String,
            /// Required. The login form URL of the website.
            #[prost(string, tag = "3")]
            pub login_url: ::prost::alloc::string::String,
        }
        /// Required.
        /// Authentication configuration
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum Authentication {
            /// Authentication using a Google account.
            #[prost(message, tag = "1")]
            GoogleAccount(GoogleAccount),
            /// Authentication using a custom account.
            #[prost(message, tag = "2")]
            CustomAccount(CustomAccount),
        }
    }
    /// Scan schedule configuration.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Schedule {
        /// A timestamp indicates when the next run will be scheduled. The value is
        /// refreshed by the server after each run. If unspecified, it will default
        /// to current server time, which means the scan will be scheduled to start
        /// immediately.
        #[prost(message, optional, tag = "1")]
        pub schedule_time: ::core::option::Option<::prost_types::Timestamp>,
        /// Required. The duration of time between executions in days.
        #[prost(int32, tag = "2")]
        pub interval_duration_days: i32,
    }
    /// Type of user agents used for scanning.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum UserAgent {
        /// The user agent is unknown. Service will default to CHROME_LINUX.
        Unspecified = 0,
        /// Chrome on Linux. This is the service default if unspecified.
        ChromeLinux = 1,
        /// Chrome on Android.
        ChromeAndroid = 2,
        /// Safari on IPhone.
        SafariIphone = 3,
    }
    /// Cloud platforms supported by Cloud Web Security Scanner.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum TargetPlatform {
        /// The target platform is unknown. Requests with this enum value will be
        /// rejected with INVALID_ARGUMENT error.
        Unspecified = 0,
        /// Google App Engine service.
        AppEngine = 1,
        /// Google Compute Engine service.
        Compute = 2,
    }
}
/// Request for the `CreateScanConfig` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateScanConfigRequest {
    /// Required. The parent resource name where the scan is created, which should be a
    /// project resource name in the format 'projects/{projectId}'.
    #[prost(string, tag = "1")]
    pub parent: ::prost::alloc::string::String,
    /// Required. The ScanConfig to be created.
    #[prost(message, optional, tag = "2")]
    pub scan_config: ::core::option::Option<ScanConfig>,
}
/// Request for the `DeleteScanConfig` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteScanConfigRequest {
    /// Required. The resource name of the ScanConfig to be deleted. The name follows the
    /// format of 'projects/{projectId}/scanConfigs/{scanConfigId}'.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
/// Request for the `GetScanConfig` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetScanConfigRequest {
    /// Required. The resource name of the ScanConfig to be returned. The name follows the
    /// format of 'projects/{projectId}/scanConfigs/{scanConfigId}'.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
/// Request for the `ListScanConfigs` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListScanConfigsRequest {
    /// Required. The parent resource name, which should be a project resource name in the
    /// format 'projects/{projectId}'.
    #[prost(string, tag = "1")]
    pub parent: ::prost::alloc::string::String,
    /// A token identifying a page of results to be returned. This should be a
    /// `next_page_token` value returned from a previous List request.
    /// If unspecified, the first page of results is returned.
    #[prost(string, tag = "2")]
    pub page_token: ::prost::alloc::string::String,
    /// The maximum number of ScanConfigs to return, can be limited by server.
    /// If not specified or not positive, the implementation will select a
    /// reasonable value.
    #[prost(int32, tag = "3")]
    pub page_size: i32,
}
/// Request for the `UpdateScanConfigRequest` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateScanConfigRequest {
    /// Required. The ScanConfig to be updated. The name field must be set to identify the
    /// resource to be updated. The values of fields not covered by the mask
    /// will be ignored.
    #[prost(message, optional, tag = "2")]
    pub scan_config: ::core::option::Option<ScanConfig>,
    /// Required. The update mask applies to the resource. For the `FieldMask` definition,
    /// see
    /// <https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask>
    #[prost(message, optional, tag = "3")]
    pub update_mask: ::core::option::Option<::prost_types::FieldMask>,
}
/// Response for the `ListScanConfigs` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListScanConfigsResponse {
    /// The list of ScanConfigs returned.
    #[prost(message, repeated, tag = "1")]
    pub scan_configs: ::prost::alloc::vec::Vec<ScanConfig>,
    /// Token to retrieve the next page of results, or empty if there are no
    /// more results in the list.
    #[prost(string, tag = "2")]
    pub next_page_token: ::prost::alloc::string::String,
}
/// Request for the `StartScanRun` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StartScanRunRequest {
    /// Required. The resource name of the ScanConfig to be used. The name follows the
    /// format of 'projects/{projectId}/scanConfigs/{scanConfigId}'.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
/// Request for the `GetScanRun` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetScanRunRequest {
    /// Required. The resource name of the ScanRun to be returned. The name follows the
    /// format of
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
/// Request for the `ListScanRuns` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListScanRunsRequest {
    /// Required. The parent resource name, which should be a scan resource name in the
    /// format 'projects/{projectId}/scanConfigs/{scanConfigId}'.
    #[prost(string, tag = "1")]
    pub parent: ::prost::alloc::string::String,
    /// A token identifying a page of results to be returned. This should be a
    /// `next_page_token` value returned from a previous List request.
    /// If unspecified, the first page of results is returned.
    #[prost(string, tag = "2")]
    pub page_token: ::prost::alloc::string::String,
    /// The maximum number of ScanRuns to return, can be limited by server.
    /// If not specified or not positive, the implementation will select a
    /// reasonable value.
    #[prost(int32, tag = "3")]
    pub page_size: i32,
}
/// Response for the `ListScanRuns` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListScanRunsResponse {
    /// The list of ScanRuns returned.
    #[prost(message, repeated, tag = "1")]
    pub scan_runs: ::prost::alloc::vec::Vec<ScanRun>,
    /// Token to retrieve the next page of results, or empty if there are no
    /// more results in the list.
    #[prost(string, tag = "2")]
    pub next_page_token: ::prost::alloc::string::String,
}
/// Request for the `StopScanRun` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StopScanRunRequest {
    /// Required. The resource name of the ScanRun to be stopped. The name follows the
    /// format of
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
/// Request for the `ListCrawledUrls` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListCrawledUrlsRequest {
    /// Required. The parent resource name, which should be a scan run resource name in the
    /// format
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
    #[prost(string, tag = "1")]
    pub parent: ::prost::alloc::string::String,
    /// A token identifying a page of results to be returned. This should be a
    /// `next_page_token` value returned from a previous List request.
    /// If unspecified, the first page of results is returned.
    #[prost(string, tag = "2")]
    pub page_token: ::prost::alloc::string::String,
    /// The maximum number of CrawledUrls to return, can be limited by server.
    /// If not specified or not positive, the implementation will select a
    /// reasonable value.
    #[prost(int32, tag = "3")]
    pub page_size: i32,
}
/// Response for the `ListCrawledUrls` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListCrawledUrlsResponse {
    /// The list of CrawledUrls returned.
    #[prost(message, repeated, tag = "1")]
    pub crawled_urls: ::prost::alloc::vec::Vec<CrawledUrl>,
    /// Token to retrieve the next page of results, or empty if there are no
    /// more results in the list.
    #[prost(string, tag = "2")]
    pub next_page_token: ::prost::alloc::string::String,
}
/// Request for the `GetFinding` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFindingRequest {
    /// Required. The resource name of the Finding to be returned. The name follows the
    /// format of
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}/findings/{findingId}'.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
/// Request for the `ListFindings` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListFindingsRequest {
    /// Required. The parent resource name, which should be a scan run resource name in the
    /// format
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
    #[prost(string, tag = "1")]
    pub parent: ::prost::alloc::string::String,
    /// Required. The filter expression. The expression must be in the format: <field>
    /// <operator> <value>.
    /// Supported field: 'finding_type'.
    /// Supported operator: '='.
    #[prost(string, tag = "2")]
    pub filter: ::prost::alloc::string::String,
    /// A token identifying a page of results to be returned. This should be a
    /// `next_page_token` value returned from a previous List request.
    /// If unspecified, the first page of results is returned.
    #[prost(string, tag = "3")]
    pub page_token: ::prost::alloc::string::String,
    /// The maximum number of Findings to return, can be limited by server.
    /// If not specified or not positive, the implementation will select a
    /// reasonable value.
    #[prost(int32, tag = "4")]
    pub page_size: i32,
}
/// Response for the `ListFindings` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListFindingsResponse {
    /// The list of Findings returned.
    #[prost(message, repeated, tag = "1")]
    pub findings: ::prost::alloc::vec::Vec<Finding>,
    /// Token to retrieve the next page of results, or empty if there are no
    /// more results in the list.
    #[prost(string, tag = "2")]
    pub next_page_token: ::prost::alloc::string::String,
}
/// Request for the `ListFindingTypeStats` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListFindingTypeStatsRequest {
    /// Required. The parent resource name, which should be a scan run resource name in the
    /// format
    /// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
    #[prost(string, tag = "1")]
    pub parent: ::prost::alloc::string::String,
}
/// Response for the `ListFindingTypeStats` method.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListFindingTypeStatsResponse {
    /// The list of FindingTypeStats returned.
    #[prost(message, repeated, tag = "1")]
    pub finding_type_stats: ::prost::alloc::vec::Vec<FindingTypeStats>,
}
#[doc = r" Generated client implementations."]
pub mod web_security_scanner_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    #[doc = " Cloud Web Security Scanner Service identifies security vulnerabilities in web"]
    #[doc = " applications hosted on Google Cloud Platform. It crawls your application, and"]
    #[doc = " attempts to exercise as many user inputs and event handlers as possible."]
    #[derive(Debug, Clone)]
    pub struct WebSecurityScannerClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl<T> WebSecurityScannerClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::ResponseBody: Body + Send + 'static,
        T::Error: Into<StdError>,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> WebSecurityScannerClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<http::Request<tonic::body::BoxBody>>>::Error:
                Into<StdError> + Send + Sync,
        {
            WebSecurityScannerClient::new(InterceptedService::new(inner, interceptor))
        }
        #[doc = r" Compress requests with `gzip`."]
        #[doc = r""]
        #[doc = r" This requires the server to support it otherwise it might respond with an"]
        #[doc = r" error."]
        pub fn send_gzip(mut self) -> Self {
            self.inner = self.inner.send_gzip();
            self
        }
        #[doc = r" Enable decompressing responses with `gzip`."]
        pub fn accept_gzip(mut self) -> Self {
            self.inner = self.inner.accept_gzip();
            self
        }
        #[doc = " Creates a new ScanConfig."]
        pub async fn create_scan_config(
            &mut self,
            request: impl tonic::IntoRequest<super::CreateScanConfigRequest>,
        ) -> Result<tonic::Response<super::ScanConfig>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/CreateScanConfig",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Deletes an existing ScanConfig and its child resources."]
        pub async fn delete_scan_config(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteScanConfigRequest>,
        ) -> Result<tonic::Response<()>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/DeleteScanConfig",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Gets a ScanConfig."]
        pub async fn get_scan_config(
            &mut self,
            request: impl tonic::IntoRequest<super::GetScanConfigRequest>,
        ) -> Result<tonic::Response<super::ScanConfig>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/GetScanConfig",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Lists ScanConfigs under a given project."]
        pub async fn list_scan_configs(
            &mut self,
            request: impl tonic::IntoRequest<super::ListScanConfigsRequest>,
        ) -> Result<tonic::Response<super::ListScanConfigsResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/ListScanConfigs",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Updates a ScanConfig. This method support partial update of a ScanConfig."]
        pub async fn update_scan_config(
            &mut self,
            request: impl tonic::IntoRequest<super::UpdateScanConfigRequest>,
        ) -> Result<tonic::Response<super::ScanConfig>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/UpdateScanConfig",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Start a ScanRun according to the given ScanConfig."]
        pub async fn start_scan_run(
            &mut self,
            request: impl tonic::IntoRequest<super::StartScanRunRequest>,
        ) -> Result<tonic::Response<super::ScanRun>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/StartScanRun",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Gets a ScanRun."]
        pub async fn get_scan_run(
            &mut self,
            request: impl tonic::IntoRequest<super::GetScanRunRequest>,
        ) -> Result<tonic::Response<super::ScanRun>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/GetScanRun",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Lists ScanRuns under a given ScanConfig, in descending order of ScanRun"]
        #[doc = " stop time."]
        pub async fn list_scan_runs(
            &mut self,
            request: impl tonic::IntoRequest<super::ListScanRunsRequest>,
        ) -> Result<tonic::Response<super::ListScanRunsResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/ListScanRuns",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Stops a ScanRun. The stopped ScanRun is returned."]
        pub async fn stop_scan_run(
            &mut self,
            request: impl tonic::IntoRequest<super::StopScanRunRequest>,
        ) -> Result<tonic::Response<super::ScanRun>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/StopScanRun",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " List CrawledUrls under a given ScanRun."]
        pub async fn list_crawled_urls(
            &mut self,
            request: impl tonic::IntoRequest<super::ListCrawledUrlsRequest>,
        ) -> Result<tonic::Response<super::ListCrawledUrlsResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/ListCrawledUrls",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " Gets a Finding."]
        pub async fn get_finding(
            &mut self,
            request: impl tonic::IntoRequest<super::GetFindingRequest>,
        ) -> Result<tonic::Response<super::Finding>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/GetFinding",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " List Findings under a given ScanRun."]
        pub async fn list_findings(
            &mut self,
            request: impl tonic::IntoRequest<super::ListFindingsRequest>,
        ) -> Result<tonic::Response<super::ListFindingsResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/ListFindings",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
        #[doc = " List all FindingTypeStats under a given ScanRun."]
        pub async fn list_finding_type_stats(
            &mut self,
            request: impl tonic::IntoRequest<super::ListFindingTypeStatsRequest>,
        ) -> Result<tonic::Response<super::ListFindingTypeStatsResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.cloud.websecurityscanner.v1alpha.WebSecurityScanner/ListFindingTypeStats",
            );
            self.inner.unary(request.into_request(), path, codec).await
        }
    }
}
