/// Common Vulnerability Scoring System version 3.
/// For details, see https://www.first.org/cvss/specification-document
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CvsSv3 {
    /// The base score is a function of the base metric scores.
    #[prost(float, tag = "1")]
    pub base_score: f32,
    #[prost(float, tag = "2")]
    pub exploitability_score: f32,
    #[prost(float, tag = "3")]
    pub impact_score: f32,
    /// Base Metrics
    /// Represents the intrinsic characteristics of a vulnerability that are
    /// constant over time and across user environments.
    #[prost(enumeration = "cvs_sv3::AttackVector", tag = "5")]
    pub attack_vector: i32,
    #[prost(enumeration = "cvs_sv3::AttackComplexity", tag = "6")]
    pub attack_complexity: i32,
    #[prost(enumeration = "cvs_sv3::PrivilegesRequired", tag = "7")]
    pub privileges_required: i32,
    #[prost(enumeration = "cvs_sv3::UserInteraction", tag = "8")]
    pub user_interaction: i32,
    #[prost(enumeration = "cvs_sv3::Scope", tag = "9")]
    pub scope: i32,
    #[prost(enumeration = "cvs_sv3::Impact", tag = "10")]
    pub confidentiality_impact: i32,
    #[prost(enumeration = "cvs_sv3::Impact", tag = "11")]
    pub integrity_impact: i32,
    #[prost(enumeration = "cvs_sv3::Impact", tag = "12")]
    pub availability_impact: i32,
}
/// Nested message and enum types in `CVSSv3`.
pub mod cvs_sv3 {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum AttackVector {
        Unspecified = 0,
        Network = 1,
        Adjacent = 2,
        Local = 3,
        Physical = 4,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum AttackComplexity {
        Unspecified = 0,
        Low = 1,
        High = 2,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PrivilegesRequired {
        Unspecified = 0,
        None = 1,
        Low = 2,
        High = 3,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum UserInteraction {
        Unspecified = 0,
        None = 1,
        Required = 2,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Scope {
        Unspecified = 0,
        Unchanged = 1,
        Changed = 2,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Impact {
        Unspecified = 0,
        High = 1,
        Low = 2,
        None = 3,
    }
}
/// Vulnerability provides metadata about a security vulnerability in a Note.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Vulnerability {
    /// The CVSS score for this vulnerability.
    #[prost(float, tag = "1")]
    pub cvss_score: f32,
    /// Note provider assigned impact of the vulnerability.
    #[prost(enumeration = "Severity", tag = "2")]
    pub severity: i32,
    /// All information about the package to specifically identify this
    /// vulnerability. One entry per (version range and cpe_uri) the package
    /// vulnerability has manifested in.
    #[prost(message, repeated, tag = "3")]
    pub details: ::prost::alloc::vec::Vec<vulnerability::Detail>,
    /// The full description of the CVSSv3.
    #[prost(message, optional, tag = "4")]
    pub cvss_v3: ::core::option::Option<CvsSv3>,
    /// Windows details get their own format because the information format and
    /// model don't match a normal detail. Specifically Windows updates are done as
    /// patches, thus Windows vulnerabilities really are a missing package, rather
    /// than a package being at an incorrect version.
    #[prost(message, repeated, tag = "5")]
    pub windows_details: ::prost::alloc::vec::Vec<vulnerability::WindowsDetail>,
    /// The time this information was last changed at the source. This is an
    /// upstream timestamp from the underlying information source - e.g. Ubuntu
    /// security tracker.
    #[prost(message, optional, tag = "6")]
    pub source_update_time: ::core::option::Option<::prost_types::Timestamp>,
}
/// Nested message and enum types in `Vulnerability`.
pub mod vulnerability {
    /// Identifies all appearances of this vulnerability in the package for a
    /// specific distro/location. For example: glibc in
    /// cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Detail {
        /// Required. The CPE URI in
        /// [cpe format](https://cpe.mitre.org/specification/) in which the
        /// vulnerability manifests. Examples include distro or storage location for
        /// vulnerable jar.
        #[prost(string, tag = "1")]
        pub cpe_uri: ::prost::alloc::string::String,
        /// Required. The name of the package where the vulnerability was found.
        #[prost(string, tag = "2")]
        pub package: ::prost::alloc::string::String,
        /// The min version of the package in which the vulnerability exists.
        #[prost(message, optional, tag = "3")]
        pub min_affected_version: ::core::option::Option<super::super::package::Version>,
        /// The max version of the package in which the vulnerability exists.
        #[prost(message, optional, tag = "4")]
        pub max_affected_version: ::core::option::Option<super::super::package::Version>,
        /// The severity (eg: distro assigned severity) for this vulnerability.
        #[prost(string, tag = "5")]
        pub severity_name: ::prost::alloc::string::String,
        /// A vendor-specific description of this note.
        #[prost(string, tag = "6")]
        pub description: ::prost::alloc::string::String,
        /// The fix for this specific package version.
        #[prost(message, optional, tag = "7")]
        pub fixed_location: ::core::option::Option<super::VulnerabilityLocation>,
        /// The type of package; whether native or non native(ruby gems, node.js
        /// packages etc).
        #[prost(string, tag = "8")]
        pub package_type: ::prost::alloc::string::String,
        /// Whether this detail is obsolete. Occurrences are expected not to point to
        /// obsolete details.
        #[prost(bool, tag = "9")]
        pub is_obsolete: bool,
        /// The time this information was last changed at the source. This is an
        /// upstream timestamp from the underlying information source - e.g. Ubuntu
        /// security tracker.
        #[prost(message, optional, tag = "10")]
        pub source_update_time: ::core::option::Option<::prost_types::Timestamp>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct WindowsDetail {
        /// Required. The CPE URI in
        /// [cpe format](https://cpe.mitre.org/specification/) in which the
        /// vulnerability manifests. Examples include distro or storage location for
        /// vulnerable jar.
        #[prost(string, tag = "1")]
        pub cpe_uri: ::prost::alloc::string::String,
        /// Required. The name of the vulnerability.
        #[prost(string, tag = "2")]
        pub name: ::prost::alloc::string::String,
        /// The description of the vulnerability.
        #[prost(string, tag = "3")]
        pub description: ::prost::alloc::string::String,
        /// Required. The names of the KBs which have hotfixes to mitigate this
        /// vulnerability. Note that there may be multiple hotfixes (and thus
        /// multiple KBs) that mitigate a given vulnerability. Currently any listed
        /// kb's presence is considered a fix.
        #[prost(message, repeated, tag = "4")]
        pub fixing_kbs: ::prost::alloc::vec::Vec<windows_detail::KnowledgeBase>,
    }
    /// Nested message and enum types in `WindowsDetail`.
    pub mod windows_detail {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct KnowledgeBase {
            /// The KB name (generally of the form KB[0-9]+ i.e. KB123456).
            #[prost(string, tag = "1")]
            pub name: ::prost::alloc::string::String,
            /// A link to the KB in the Windows update catalog -
            /// https://www.catalog.update.microsoft.com/
            #[prost(string, tag = "2")]
            pub url: ::prost::alloc::string::String,
        }
    }
}
/// Details of a vulnerability Occurrence.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Details {
    /// The type of package; whether native or non native(ruby gems, node.js
    /// packages etc)
    #[prost(string, tag = "1")]
    pub r#type: ::prost::alloc::string::String,
    /// Output only. The note provider assigned Severity of the vulnerability.
    #[prost(enumeration = "Severity", tag = "2")]
    pub severity: i32,
    /// Output only. The CVSS score of this vulnerability. CVSS score is on a
    /// scale of 0-10 where 0 indicates low severity and 10 indicates high
    /// severity.
    #[prost(float, tag = "3")]
    pub cvss_score: f32,
    /// Required. The set of affected locations and their fixes (if available)
    /// within the associated resource.
    #[prost(message, repeated, tag = "4")]
    pub package_issue: ::prost::alloc::vec::Vec<PackageIssue>,
    /// Output only. A one sentence description of this vulnerability.
    #[prost(string, tag = "5")]
    pub short_description: ::prost::alloc::string::String,
    /// Output only. A detailed description of this vulnerability.
    #[prost(string, tag = "6")]
    pub long_description: ::prost::alloc::string::String,
    /// Output only. URLs related to this vulnerability.
    #[prost(message, repeated, tag = "7")]
    pub related_urls: ::prost::alloc::vec::Vec<super::RelatedUrl>,
    /// The distro assigned severity for this vulnerability when it is
    /// available, and note provider assigned severity when distro has not yet
    /// assigned a severity for this vulnerability.
    #[prost(enumeration = "Severity", tag = "8")]
    pub effective_severity: i32,
}
/// This message wraps a location affected by a vulnerability and its
/// associated fix (if one is available).
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PackageIssue {
    /// Required. The location of the vulnerability.
    #[prost(message, optional, tag = "1")]
    pub affected_location: ::core::option::Option<VulnerabilityLocation>,
    /// The location of the available fix for vulnerability.
    #[prost(message, optional, tag = "2")]
    pub fixed_location: ::core::option::Option<VulnerabilityLocation>,
    /// Deprecated, use Details.effective_severity instead
    /// The severity (e.g., distro assigned severity) for this vulnerability.
    #[prost(string, tag = "3")]
    pub severity_name: ::prost::alloc::string::String,
}
/// The location of the vulnerability.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VulnerabilityLocation {
    /// Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/)
    /// format. Examples include distro or storage location for vulnerable jar.
    #[prost(string, tag = "1")]
    pub cpe_uri: ::prost::alloc::string::String,
    /// Required. The package being described.
    #[prost(string, tag = "2")]
    pub package: ::prost::alloc::string::String,
    /// Required. The version of the package being described.
    #[prost(message, optional, tag = "3")]
    pub version: ::core::option::Option<super::package::Version>,
}
/// Note provider-assigned severity/impact ranking.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum Severity {
    /// Unknown.
    Unspecified = 0,
    /// Minimal severity.
    Minimal = 1,
    /// Low severity.
    Low = 2,
    /// Medium severity.
    Medium = 3,
    /// High severity.
    High = 4,
    /// Critical severity.
    Critical = 5,
}
