use std::error::Error;

use good_lp::{constraint, default_solver, variables, Solution, SolverModel};

#[test]
fn main() -> Result<(), Box<dyn Error>> {
    variables! {
        vars:
               a <= 1;
          2 <= b <= 4;
    }
    let solution = vars
        .maximise(10 * (a - b / 5) - b)
        .using(default_solver)
        .with(constraint!(a + 2 <= b))
        .with(constraint!(1 + a >= 4 - b))
        .solve()?;
    println!("a={}   b={}", solution.value(a), solution.value(b));
    println!("a + b = {}", solution.eval(a + b));
    Ok(())
}
