use gomez::nalgebra as na;
use gomez::prelude::*;
use gomez::solver::NelderMead;
use gomez::solver::TrustRegion;

use gomez::testing::Brown;
use gomez::testing::Exponential;
use gomez::testing::ExtendedPowell;
use gomez::testing::ExtendedRosenbrock;
use gomez::testing::TestSystem;

// struct Test {
//     a: f64,
//     b: f64,
// }

// impl System for Test {
//     type Scalar = f64;
//     type Dim = na::Dynamic;

//     fn apply<Sx, Sfx>(
//         &self,
//         x: &na::Vector<Self::Scalar, Self::Dim, Sx>,
//         fx: &mut na::Vector<Self::Scalar, Self::Dim, Sfx>,
//     ) -> Result<(), Error>
//     where
//         Sx: na::storage::Storage<Self::Scalar, Self::Dim>,
//         Sfx: na::storage::StorageMut<Self::Scalar, Self::Dim>,
//     {
//         fx[0] = self.a * (1.0 - x[0]);
//         fx[1] = self.b * (x[1] - x[0] * x[0]);

//         Ok(())
//     }

//     fn dim(&self) -> Self::Dim {
//         na::Dynamic::new(2)
//     }
// }

fn main() {
    log::set_logger(&LOGGER).unwrap();
    log::set_max_level(log::LevelFilter::Debug);

    let f = Exponential::new(2);
    let dom = f.domain();

    let mut solver = TrustRegion::new(&f, &dom);

    let mut x = f.initials()[0].clone();
    let mut fx = x.clone();

    for i in 1.. {
        // Do one iteration in the solving process.
        solver
            .next(&f, &dom, &mut x, &mut fx)
            .expect("solver encountered an error");

        println!("iter = {}\t||fx|| = {}", i, fx.norm());

        // Check the termination criteria.
        if fx.norm() < 1e-7 {
            println!("solved");
            break;
        } else if i == 1000 {
            println!("maximum number of iteration exceeded");
            break;
        }
    }
}

use log::{Metadata, Record};

struct Logger;

impl log::Log for Logger {
    fn enabled(&self, _metadata: &Metadata) -> bool {
        true
    }

    fn log(&self, record: &Record) {
        println!("{}: {}", record.level(), record.args());
    }

    fn flush(&self) {}
}

static LOGGER: Logger = Logger;
