# golgi

_The Golgi complex (aka. Golgi apparatus or Golgi body) packages proteins
into membrane-bound vesicles inside the cell before the vesicles are sent
to their destination._

-----

## Introduction

Golgi is an asynchronous, experimental Scuttlebutt client that aims to
facilitate Scuttlebutt application development. It provides a high-level
API for interacting with an sbot instance and uses the
[kuska-ssb](https://github.com/Kuska-ssb) libraries to make RPC calls.
Development efforts are currently oriented towards
[go-sbot](https://github.com/cryptoscope/ssb) interoperability.

## Features

Golgi offers the ability to invoke individual RPC methods while also
providing a number of convenience methods which may involve multiple RPC
calls and / or the processing of data received from those calls. The
`Sbot` `struct` is the primary means of interacting with the library.

Features include the ability to publish messages of various kinds; to
retrieve messages (e.g. `about` and `description` messages) and formulate
queries; to follow, unfollow, block and unblock a peer; to query the social
graph; and to generate pub invite codes.

## Example Usage

Basic usage is demonstrated below. Visit the [examples directory](https://git.coopcloud.tech/golgi-ssb/golgi/src/branch/main/examples) in the `golgi` repository for
more comprehensive examples.

```rust
use golgi::{GolgiError, Sbot};

pub async fn run() -> Result<(), GolgiError> {
    // Attempt to initialise a connection to an sbot instance using the default
    // IP address, port and network key (aka. capabilities key).
    let mut sbot_client = Sbot::init(None, None).await?;

    // Call the `whoami` RPC method to retrieve the public key for the sbot
    // identity.
    let id = sbot_client.whoami().await?;
    
    // Print the public key (identity) to `stdout`.
    println!("{}", id);

    // Compose an SSB post message type.
    let post = SsbMessageContent::Post {
        text: "Biology, eh?!".to_string(),
        mentions: None,
    };

    // Publish the post.
    let post_msg_reference = sbot_client.publish(post).await?;

    // Print the reference (sigil-link) for the published post.
    println!("{}", post_msg_reference);

    Ok(())
}
```

## Authors

 - [notplants](https://mfowler.info/)
 - [glyph](https://mycelial.technology/)

## License

LGPL-3.0.
