use goglob::{glob, GlobPattern};

const PATTERN_01: GlobPattern = glob!("abc");
const PATTERN_02: GlobPattern = glob!("*");
const PATTERN_03: GlobPattern = glob!("*c");
const PATTERN_04: GlobPattern = glob!("a*");
const PATTERN_05: GlobPattern = glob!("a*");
const PATTERN_06: GlobPattern = glob!("a*");
const PATTERN_07: GlobPattern = glob!("a*/b");
const PATTERN_08: GlobPattern = glob!("a*/b");
const PATTERN_09: GlobPattern = glob!("a*b*c*d*e*/f");
const PATTERN_10: GlobPattern = glob!("a*b*c*d*e*/f");
const PATTERN_11: GlobPattern = glob!("a*b*c*d*e*/f");
const PATTERN_12: GlobPattern = glob!("a*b*c*d*e*/f");
const PATTERN_13: GlobPattern = glob!("a*b?c*x");
const PATTERN_14: GlobPattern = glob!("a*b?c*x");
const PATTERN_15: GlobPattern = glob!("ab[c]");
const PATTERN_16: GlobPattern = glob!("ab[b-d]");
const PATTERN_17: GlobPattern = glob!("ab[e-g]");
const PATTERN_18: GlobPattern = glob!("ab[^c]");
const PATTERN_19: GlobPattern = glob!("ab[^b-d]");
const PATTERN_20: GlobPattern = glob!("ab[^e-g]");
const PATTERN_21: GlobPattern = glob!("a\\*b");
const PATTERN_22: GlobPattern = glob!("a\\*b");
const PATTERN_23: GlobPattern = glob!("a?b");
const PATTERN_24: GlobPattern = glob!("a[^a]b");
const PATTERN_25: GlobPattern = glob!("a???b");
const PATTERN_26: GlobPattern = glob!("a[^a][^a][^a]b");
const PATTERN_27: GlobPattern = glob!("[a-ζ]*");
const PATTERN_28: GlobPattern = glob!("*[a-ζ]");
const PATTERN_29: GlobPattern = glob!("a?b");
const PATTERN_30: GlobPattern = glob!("a*b");
const PATTERN_31: GlobPattern = glob!("[\\]a]");
const PATTERN_32: GlobPattern = glob!("[\\-]");
const PATTERN_33: GlobPattern = glob!("[x\\-]");
const PATTERN_34: GlobPattern = glob!("[x\\-]");
const PATTERN_35: GlobPattern = glob!("[x\\-]");
const PATTERN_36: GlobPattern = glob!("[\\-x]");
const PATTERN_37: GlobPattern = glob!("[\\-x]");
const PATTERN_38: GlobPattern = glob!("[\\-x]");
const PATTERN_39: GlobPattern = glob!("*x");

fn main() {
    assert!(PATTERN_01.matches("abc"));
    assert!(PATTERN_02.matches("abc"));
    assert!(PATTERN_03.matches("abc"));
    assert!(PATTERN_04.matches("a"));
    assert!(PATTERN_05.matches("abc"));
    assert!(!PATTERN_06.matches("ab/c"));
    assert!(PATTERN_07.matches("abc/b"));
    assert!(!PATTERN_08.matches("a/c/b"));
    assert!(PATTERN_09.matches("axbxcxdxe/f"));
    assert!(PATTERN_10.matches("axbxcxdxexxx/f"));
    assert!(!PATTERN_11.matches("axbxcxdxe/xxx/f"));
    assert!(!PATTERN_12.matches("axbxcxdxexxx/fff"));
    assert!(PATTERN_13.matches("abxbbxdbxebxczzx"));
    assert!(!PATTERN_14.matches("abxbbxdbxebxczzy"));
    assert!(PATTERN_15.matches("abc"));
    assert!(PATTERN_16.matches("abc"));
    assert!(!PATTERN_17.matches("abc"));
    assert!(!PATTERN_18.matches("abc"));
    assert!(!PATTERN_19.matches("abc"));
    assert!(PATTERN_20.matches("abc"));
    assert!(PATTERN_21.matches("a*b"));
    assert!(!PATTERN_22.matches("ab"));
    assert!(PATTERN_23.matches("a☺b"));
    assert!(PATTERN_24.matches("a☺b"));
    assert!(!PATTERN_25.matches("a☺b"));
    assert!(!PATTERN_26.matches("a☺b"));
    assert!(PATTERN_27.matches("α"));
    assert!(!PATTERN_28.matches("A"));
    assert!(!PATTERN_29.matches("a/b"));
    assert!(!PATTERN_30.matches("a/b"));
    assert!(PATTERN_31.matches("]"));
    assert!(PATTERN_32.matches("-"));
    assert!(PATTERN_33.matches("x"));
    assert!(PATTERN_34.matches("-"));
    assert!(!PATTERN_35.matches("z"));
    assert!(PATTERN_36.matches("x"));
    assert!(PATTERN_37.matches("-"));
    assert!(!PATTERN_38.matches("a"));
    assert!(PATTERN_39.matches("xxx"));
}